/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix.pool;

import java.io.Closeable;
import org.eclipse.jdt.annotation.NonNull;
import org.newsclub.net.unix.ThreadUtil;
import org.newsclub.net.unix.pool.ThreadLocalObjectPool;
import org.newsclub.net.unix.pool.VirtualAwareThreadLocalObjectPool;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public interface ObjectPool<O> {
    public static <O> ObjectPool<O> newThreadLocalPool(ObjectSupplier<@NonNull O> supplier, ObjectSanitizer<@NonNull O> sanitizer) {
        if (ThreadUtil.isVirtualThreadSupported()) {
            return new VirtualAwareThreadLocalObjectPool<O>(supplier, sanitizer);
        }
        return new ThreadLocalObjectPool<O>(supplier, sanitizer);
    }

    public static <O> Lease<O> unpooledLease(final O obj) {
        return new Lease<O>(){

            @Override
            public O get() {
                return obj;
            }

            @Override
            public void close() {
            }

            @Override
            public void discard() {
            }
        };
    }

    public Lease<O> take();

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @FunctionalInterface
    public static interface ObjectSupplier<T> {
        public T get();
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @FunctionalInterface
    public static interface ObjectSanitizer<T> {
        public boolean sanitize(T var1);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static interface Lease<O>
    extends Closeable {
        public O get();

        @Override
        public void close();

        public void discard();
    }
}

