/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.resps;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Map;
import redis.clients.jedis.StreamEntryID;

public class StreamEntryBinary
implements Serializable {
    private static final long serialVersionUID = 1L;
    private StreamEntryID id;
    private Map<byte[], byte[]> fields;
    private Long millisElapsedFromDelivery;
    private Long deliveredCount;

    public StreamEntryBinary(StreamEntryID id, Map<byte[], byte[]> fields) {
        this.id = id;
        this.fields = fields;
    }

    public StreamEntryBinary(StreamEntryID id, Map<byte[], byte[]> fields, Long millisElapsedFromDelivery, Long deliveredCount) {
        this.id = id;
        this.fields = fields;
        this.millisElapsedFromDelivery = millisElapsedFromDelivery;
        this.deliveredCount = deliveredCount;
    }

    public Long getMillisElapsedFromDelivery() {
        return this.millisElapsedFromDelivery;
    }

    public Long getDeliveredCount() {
        return this.deliveredCount;
    }

    public boolean isClaimed() {
        return this.deliveredCount != null && this.deliveredCount > 0L;
    }

    public StreamEntryID getID() {
        return this.id;
    }

    public Map<byte[], byte[]> getFields() {
        return this.fields;
    }

    public String toString() {
        return this.id + " " + this.fields;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeUnshared(this.id);
        out.writeUnshared(this.fields);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.id = (StreamEntryID)in.readUnshared();
        this.fields = (Map)in.readUnshared();
    }
}

