/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.parser.analyzer;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.w3c.css.atrules.css.AtRuleCounterStyle;
import org.w3c.css.atrules.css.AtRuleFontFace;
import org.w3c.css.atrules.css.AtRuleKeyframes;
import org.w3c.css.atrules.css.AtRuleMedia;
import org.w3c.css.atrules.css.AtRulePhoneticAlphabet;
import org.w3c.css.atrules.css.AtRulePreference;
import org.w3c.css.atrules.css.AtRuleSupports;
import org.w3c.css.atrules.css.AtRuleViewport;
import org.w3c.css.atrules.css.media.MediaFeature;
import org.w3c.css.atrules.css.media.MediaRangeFeature;
import org.w3c.css.atrules.css.supports.SupportsFeature;
import org.w3c.css.atrules.css3.AtRulePage;
import org.w3c.css.atrules.svg.AtRuleColorProfile;
import org.w3c.css.parser.AtRule;
import org.w3c.css.parser.CssError;
import org.w3c.css.parser.CssErrorToken;
import org.w3c.css.parser.CssParseException;
import org.w3c.css.parser.CssSelectors;
import org.w3c.css.parser.analyzer.CssParserConstants;
import org.w3c.css.parser.analyzer.CssParserTokenManager;
import org.w3c.css.parser.analyzer.ParseException;
import org.w3c.css.parser.analyzer.SimpleCharStream;
import org.w3c.css.parser.analyzer.Token;
import org.w3c.css.parser.analyzer.TokenMgrError;
import org.w3c.css.properties.css.CssProperty;
import org.w3c.css.selectors.AttributeSelector;
import org.w3c.css.selectors.ClassSelector;
import org.w3c.css.selectors.IdSelector;
import org.w3c.css.selectors.TypeSelector;
import org.w3c.css.selectors.UniversalSelector;
import org.w3c.css.selectors.attributes.AttributeAny;
import org.w3c.css.selectors.attributes.AttributeBegin;
import org.w3c.css.selectors.attributes.AttributeExact;
import org.w3c.css.selectors.attributes.AttributeOneOf;
import org.w3c.css.selectors.attributes.AttributeStart;
import org.w3c.css.selectors.attributes.AttributeSubstr;
import org.w3c.css.selectors.attributes.AttributeSuffix;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.CssProfile;
import org.w3c.css.util.CssVersion;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.util.StringUtils;
import org.w3c.css.util.Util;
import org.w3c.css.util.WarningParamException;
import org.w3c.css.values.CssANPlusB;
import org.w3c.css.values.CssAngle;
import org.w3c.css.values.CssAttr;
import org.w3c.css.values.CssBracket;
import org.w3c.css.values.CssCalc;
import org.w3c.css.values.CssCheckableValue;
import org.w3c.css.values.CssColor;
import org.w3c.css.values.CssComparator;
import org.w3c.css.values.CssExpression;
import org.w3c.css.values.CssFlexibleLength;
import org.w3c.css.values.CssFrequency;
import org.w3c.css.values.CssFunction;
import org.w3c.css.values.CssHashIdent;
import org.w3c.css.values.CssIdent;
import org.w3c.css.values.CssImage;
import org.w3c.css.values.CssLength;
import org.w3c.css.values.CssMathFunction;
import org.w3c.css.values.CssNumber;
import org.w3c.css.values.CssPercentage;
import org.w3c.css.values.CssRatio;
import org.w3c.css.values.CssResolution;
import org.w3c.css.values.CssSemitone;
import org.w3c.css.values.CssString;
import org.w3c.css.values.CssSwitch;
import org.w3c.css.values.CssTime;
import org.w3c.css.values.CssURL;
import org.w3c.css.values.CssUnicodeRange;
import org.w3c.css.values.CssValue;
import org.w3c.css.values.CssVariable;
import org.w3c.css.values.CssVolume;

public abstract class CssParser
implements CssParserConstants {
    private static char[] hexdigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    protected AtRule atRule;
    protected boolean mediaDeclaration = false;
    protected URL url;
    protected ApplContext ac;
    protected boolean incompatible_error;
    protected ArrayList<CssSelectors> currentContext;
    protected String currentProperty;
    protected boolean mode;
    protected boolean markRule;
    private boolean reinited = false;
    private boolean charsetdeclared = false;
    protected boolean validSelector = true;
    public CssParserTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    private int jj_gen;
    private final int[] jj_la1 = new int[334];
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private static int[] jj_la1_2;
    private static int[] jj_la1_3;
    private static int[] jj_la1_4;
    private final JJCalls[] jj_2_rtns = new JJCalls[29];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private final LookaheadSuccess jj_ls = new LookaheadSuccess();
    private List<int[]> jj_expentries = new ArrayList<int[]>();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;
    private int trace_indent = 0;
    private boolean trace_enabled;

    public final void setApplContext(ApplContext ac) {
        this.ac = ac;
    }

    public void setAtRule(AtRule atRule) {
        this.atRule = atRule;
    }

    public void setMediaDeclaration(boolean mediadeclaration) {
        this.mediaDeclaration = mediadeclaration;
    }

    public boolean hasMediaDeclaration() {
        return this.mediaDeclaration;
    }

    public AtRule getAtRule() {
        return this.atRule;
    }

    public void ReInitWithAc(InputStream stream, ApplContext ac, String charset) {
        InputStream is = stream;
        if (charset == null) {
            charset = "iso-8859-1";
        }
        InputStreamReader isr = null;
        try {
            isr = new InputStreamReader(is, charset);
        }
        catch (UnsupportedEncodingException uex) {
            isr = new InputStreamReader(is);
        }
        this.ReInit(isr);
        this.markRule = false;
        this.reinited = true;
        this.setApplContext(ac);
    }

    public abstract void handleImport(URL var1, String var2, boolean var3, AtRuleMedia var4);

    public abstract void handleNamespaceDeclaration(URL var1, String var2, String var3, boolean var4);

    public abstract void handleAtRule(String var1, String var2);

    public abstract void addCharSet(String var1) throws ParseException;

    public abstract void newAtRule(AtRule var1);

    public abstract void endOfAtRule();

    public abstract void setImportant(boolean var1);

    public abstract void setSelectorList(ArrayList<CssSelectors> var1);

    public abstract void addProperty(ArrayList<CssProperty> var1);

    public abstract void endOfRule();

    public abstract void removeThisRule();

    public abstract void removeThisAtRule();

    public abstract CssProperty handleDeclaration(String var1, CssExpression var2, boolean var3) throws InvalidParamException;

    public abstract MediaFeature handleMediaFeature(AtRuleMedia var1, String var2, CssExpression var3) throws InvalidParamException;

    public abstract void handleRule(CssSelectors var1, ArrayList<CssProperty> var2);

    public final String getSourceFile() {
        return this.getURL().toString();
    }

    public final int getLine() {
        return 0;
    }

    public final int getBeginLine() {
        return this.token.beginLine;
    }

    public final int getBeginColumn() {
        return this.token.beginColumn;
    }

    public final int getEndLine() {
        return this.token.endLine;
    }

    public final int getEndColumn() {
        return this.token.endColumn;
    }

    public final void setURL(URL url) {
        this.url = url;
    }

    public final URL getURL() {
        return this.url;
    }

    public CssSelectors parseSelector() throws ParseException {
        return this.externalSelector();
    }

    public AtRuleMedia parseMediaDeclaration() throws ParseException {
        AtRuleMedia newRule = AtRuleMedia.getInstance(this.ac.getCssVersion());
        this.mediaquerylist(newRule);
        return newRule;
    }

    private void setValue(CssValue v, CssExpression expr, char operator, Token n, int token) throws ParseException {
        block24: {
            CssCalc c;
            block23: {
                if (token != 143) break block23;
                switch (v.getType()) {
                    case 11: {
                        CssFunction f = (CssFunction)v;
                        if (f.getParameters().hasVendorExtensions()) {
                            expr.markVendorExtension();
                        }
                        if (f.getParameters().hasCssVariable()) {
                            expr.markCssVariable();
                        }
                        if (f.getParameters().hasCssHack()) {
                            expr.markCssHack();
                            break;
                        }
                        break block24;
                    }
                    case 16: {
                        CssImage im = (CssImage)v;
                        if (im.hasCssVariable()) {
                            expr.markCssVariable();
                            break;
                        }
                        break block24;
                    }
                    case 3: {
                        CssColor co = (CssColor)v;
                        if (co.hasCssVariable()) {
                            expr.markCssVariable();
                            break;
                        }
                        break block24;
                    }
                }
                break block24;
            }
            if (token == 142) {
                if (v.getType() == 25) {
                    expr.markCssVariable();
                }
            } else if (token == 135 && (c = (CssCalc)v).hasCssVariable()) {
                expr.markCssVariable();
            }
        }
        if (n != null) {
            if (this.ac.getCssVersion() == CssVersion.CSS1 && n.image.equals("inherit")) {
                this.incompatible_error = true;
            }
            String val = CssParser.addOperator(operator, n.image);
            if (n.kind == 41) {
                String s = this.convertIdent(val);
                if ('-' == s.charAt(0)) {
                    expr.markVendorExtension();
                }
                if (v.getRawType() == 0) {
                    v = CssIdent.getIdent(s);
                } else {
                    v.set(s, this.ac);
                }
            } else if (n.kind == 39) {
                v.set(val, this.ac);
            } else {
                v.set(val, this.ac);
            }
        }
        expr.addValue(v);
    }

    private void addError(Exception e, String skippedText) {
        if (Util.onDebug) {
            System.err.println(e.getMessage());
            e.printStackTrace();
        }
        CssParseException ex = new CssParseException(e);
        ex.setSkippedString(skippedText);
        ex.setProperty(this.currentProperty);
        ex.setContexts(this.currentContext);
        CssError error = new CssError(this.getSourceFile(), this.getBeginLine(), this.getBeginColumn(), this.getEndLine(), this.getEndColumn(), ex);
        this.ac.getFrame().addError(error);
    }

    private void addError(Exception e, CssExpression exp) {
        if (Util.onDebug) {
            System.err.println(e.getMessage());
            e.printStackTrace();
        }
        CssParseException ex = new CssParseException(e);
        ex.setExp(exp);
        ex.setProperty(this.currentProperty);
        ex.setContexts(this.currentContext);
        CssError error = new CssError(this.getSourceFile(), this.getBeginLine(), this.getBeginColumn(), this.getEndLine(), this.getEndColumn(), ex);
        this.ac.getFrame().addError(error);
    }

    private void addParseError(ParseException e, String skipped) {
        if (Util.onDebug) {
            System.err.println(e.getMessage());
            e.printStackTrace();
        }
        CssErrorToken err = new CssErrorToken(e, skipped);
        this.ac.getFrame().addError(err);
    }

    private static String addOperator(char operator, String value) {
        return ' ' == operator ? value : operator + value;
    }

    public final void parserUnit() throws ParseException {
        Token n = null;
        try {
            block31: {
                block26: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 144: 
                        case 145: {
                            break;
                        }
                        default: {
                            this.jj_la1[0] = this.jj_gen;
                            break block26;
                        }
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 144: {
                            n = this.jj_consume_token(144);
                            break;
                        }
                        case 145: {
                            n = this.jj_consume_token(145);
                            break;
                        }
                        default: {
                            this.jj_la1[1] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                    this.addError((Exception)new ParseException(this.ac.getMsg().getString("generator.dontmixhtml")), n.image);
                }
                block27: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 79: {
                            break;
                        }
                        default: {
                            this.jj_la1[2] = this.jj_gen;
                            break block27;
                        }
                    }
                    this.charset();
                }
                block28: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 21: 
                        case 23: 
                        case 24: {
                            break;
                        }
                        default: {
                            this.jj_la1[3] = this.jj_gen;
                            break block31;
                        }
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 21: {
                            this.jj_consume_token(21);
                            continue block28;
                        }
                        case 23: {
                            this.jj_consume_token(23);
                            continue block28;
                        }
                        case 24: {
                            this.jj_consume_token(24);
                            continue block28;
                        }
                    }
                    break;
                }
                this.jj_la1[4] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            block29: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 97: {
                        break;
                    }
                    default: {
                        this.jj_la1[5] = this.jj_gen;
                        break block29;
                    }
                }
                this.importDeclaration();
                this.ignoreStatement();
            }
            block30: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 98: {
                        break;
                    }
                    default: {
                        this.jj_la1[6] = this.jj_gen;
                        break block30;
                    }
                }
                this.namespaceDeclaration();
                this.ignoreStatement();
            }
            this.afterImportDeclaration();
            this.jj_consume_token(0);
        }
        catch (TokenMgrError err) {
            this.addError((Exception)new ParseException(this.ac.getMsg().getString("generator.unrecognize")), err.getMessage());
        }
    }

    public final Token ident() throws ParseException {
        Token n = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 41: {
                n = this.jj_consume_token(41);
                break;
            }
            case 35: {
                n = this.jj_consume_token(35);
                break;
            }
            case 36: {
                n = this.jj_consume_token(36);
                break;
            }
            case 38: {
                n = this.jj_consume_token(38);
                break;
            }
            case 37: {
                n = this.jj_consume_token(37);
                break;
            }
            default: {
                this.jj_la1[7] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return n;
    }

    public final void charset() throws ParseException {
        Token n = null;
        Token charsetToken = null;
        Token space1Token = null;
        Token space2Token = null;
        Token semicolonToken = null;
        int nb_S = 0;
        CssVersion version = this.ac.getCssVersion();
        try {
            charsetToken = this.jj_consume_token(79);
            block8: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 21: {
                        break;
                    }
                    default: {
                        this.jj_la1[8] = this.jj_gen;
                        break block8;
                    }
                }
                space1Token = this.jj_consume_token(21);
                ++nb_S;
            }
            n = this.jj_consume_token(39);
            block9: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 21: {
                        break;
                    }
                    default: {
                        this.jj_la1[9] = this.jj_gen;
                        break block9;
                    }
                }
                space2Token = this.jj_consume_token(21);
            }
            semicolonToken = this.jj_consume_token(51);
            if (this.charsetdeclared && !this.reinited) {
                throw new ParseException(this.ac.getMsg().getString("parser.charset"));
            }
            if (charsetToken.beginLine != 1 || charsetToken.beginColumn != 1) {
                throw new ParseException(this.ac.getMsg().getString("parser.charset"));
            }
            if (version == CssVersion.CSS1) {
                throw new ParseException(this.ac.getMsg().getString("parser.charsetcss1"));
            }
            if (!(version.compareTo(CssVersion.CSS21) < 0 || nb_S == 1 && "@charset".equals(charsetToken.image) && " ".equals(space1Token.image) && (space2Token == null || "".equals(space2Token.image)) && space1Token.specialToken == null && n.specialToken == null && semicolonToken.specialToken == null && n.image.charAt(0) == '\"')) {
                throw new ParseException(this.ac.getMsg().getString("parser.charsetspecial"));
            }
            if (!this.charsetdeclared) {
                this.addCharSet(n.image.substring(1, n.image.length() - 1));
                this.charsetdeclared = true;
            } else {
                this.reinited = false;
            }
        }
        catch (Exception e) {
            String skip = charsetToken + (space1Token == null ? "" : space1Token.image) + n + (space2Token == null ? "" : space2Token.image) + ";";
            this.addError(e, skip);
        }
    }

    public final void nested_at_rules() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 99: {
                this.media();
                break;
            }
            case 80: {
                this.page();
                break;
            }
            case 100: {
                this.fontFace();
                break;
            }
            case 101: {
                this.keyframes();
                break;
            }
            case 102: {
                this.preference();
                break;
            }
            case 108: {
                this.viewport();
                break;
            }
            case 103: {
                this.colorprofile();
                break;
            }
            case 105: {
                this.counterstyle();
                break;
            }
            case 106: {
                this.phoneticAlphabet();
                break;
            }
            case 107: {
                this.supports();
                break;
            }
            case 109: {
                this.atRuleDeclaration();
                break;
            }
            default: {
                this.jj_la1[10] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void afterImportDeclaration() throws ParseException {
        while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 41: 
                case 42: 
                case 43: 
                case 53: 
                case 55: 
                case 56: 
                case 59: 
                case 61: 
                case 62: 
                case 63: 
                case 65: 
                case 68: 
                case 69: 
                case 70: 
                case 73: 
                case 78: 
                case 153: {
                    this.ruleSet();
                    break;
                }
                case 80: 
                case 99: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 105: 
                case 106: 
                case 107: 
                case 108: 
                case 109: {
                    this.nested_at_rules();
                    break;
                }
                default: {
                    ParseException e;
                    this.jj_la1[11] = this.jj_gen;
                    String ret = this.skipStatement();
                    if (ret == null || ret.length() == 0) {
                        return;
                    }
                    if (ret.startsWith("@charset")) {
                        e = new ParseException(this.ac.getMsg().getString("parser.charset"));
                        this.addError((Exception)e, ret);
                        break;
                    }
                    if (ret.startsWith("@import")) {
                        e = new ParseException(this.ac.getMsg().getString("parser.import_not_allowed"));
                        this.addError((Exception)e, ret);
                        break;
                    }
                    CssVersion version = this.ac.getCssVersion();
                    if (!ret.startsWith("/*") || version.compareTo(CssVersion.CSS3) < 0) {
                        ParseException e2 = new ParseException(this.ac.getMsg().getString("generator.unrecognize"));
                        this.addError((Exception)e2, ret);
                        break;
                    }
                    Token t = this.getToken(0);
                    while (t.kind != 0) {
                        t = this.getNextToken();
                    }
                    break block0;
                }
            }
            this.ignoreStatement();
        }
    }

    public final void ignoreStatement() throws ParseException {
        block10: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 23: 
                case 24: {
                    break;
                }
                default: {
                    this.jj_la1[12] = this.jj_gen;
                    break block10;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 23: {
                    this.jj_consume_token(23);
                    break;
                }
                case 24: {
                    this.jj_consume_token(24);
                    break;
                }
                default: {
                    this.jj_la1[13] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 21: {
                        break;
                    }
                    default: {
                        this.jj_la1[14] = this.jj_gen;
                        continue block10;
                    }
                }
                this.jj_consume_token(21);
            }
            break;
        }
    }

    public final void namespaceDeclaration() throws ParseException {
        String nsname;
        boolean is_url;
        Token n = null;
        Token v = null;
        String prefix = null;
        this.jj_consume_token(98);
        block19: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 21: {
                    break;
                }
                default: {
                    this.jj_la1[15] = this.jj_gen;
                    break block19;
                }
            }
            this.jj_consume_token(21);
        }
        block3 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 41: {
                n = this.ident();
                prefix = this.convertIdent(n.image);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 21: {
                            break;
                        }
                        default: {
                            this.jj_la1[16] = this.jj_gen;
                            break block3;
                        }
                    }
                    this.jj_consume_token(21);
                }
            }
            default: {
                this.jj_la1[17] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 39: {
                v = this.jj_consume_token(39);
                is_url = false;
                nsname = v.image.substring(1, v.image.length() - 1);
                break;
            }
            case 60: {
                v = this.jj_consume_token(60);
                is_url = true;
                CssURL val = new CssURL();
                val.set(v.image, this.ac, this.url);
                nsname = (String)((CssValue)val).get();
                if (nsname.charAt(0) != '\"' && nsname.charAt(0) != '\'') break;
                nsname = nsname.substring(1, nsname.length() - 1);
                break;
            }
            default: {
                this.jj_la1[18] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        block21: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 21: {
                    break;
                }
                default: {
                    this.jj_la1[19] = this.jj_gen;
                    break block21;
                }
            }
            this.jj_consume_token(21);
        }
        this.jj_consume_token(51);
        block22: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 21: {
                    break;
                }
                default: {
                    this.jj_la1[20] = this.jj_gen;
                    break block22;
                }
            }
            this.jj_consume_token(21);
        }
        if (this.ac.getCssVersion().compareTo(CssVersion.CSS3) < 0) {
            this.addError((Exception)new InvalidParamException("at-rule", "@namespace", this.ac), n == null ? "default" : n.toString());
        } else if (v != null) {
            this.handleNamespaceDeclaration(this.getURL(), prefix, nsname, is_url);
        }
    }

    public final void importDeclaration() throws ParseException {
        AtRuleMedia media = AtRuleMedia.getInstance(this.ac.getCssVersion());
        boolean is_url = false;
        try {
            String importFile;
            this.jj_consume_token(97);
            block18: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 21: {
                        break;
                    }
                    default: {
                        this.jj_la1[21] = this.jj_gen;
                        break block18;
                    }
                }
                this.jj_consume_token(21);
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 39: {
                    Token n = this.jj_consume_token(39);
                    importFile = n.image.substring(1, n.image.length() - 1);
                    is_url = false;
                    break;
                }
                case 60: {
                    Token n = this.jj_consume_token(60);
                    CssURL val = new CssURL();
                    val.set(n.image, this.ac, this.url);
                    importFile = (String)((CssValue)val).get();
                    if (importFile.charAt(0) == '\"' || importFile.charAt(0) == '\'') {
                        importFile = importFile.substring(1, importFile.length() - 1);
                    }
                    is_url = true;
                    break;
                }
                default: {
                    this.jj_la1[22] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            block19: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 21: {
                        break;
                    }
                    default: {
                        this.jj_la1[23] = this.jj_gen;
                        break block19;
                    }
                }
                this.jj_consume_token(21);
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 37: 
                case 38: 
                case 41: 
                case 58: {
                    this.mediaquerylist(media);
                    break;
                }
                default: {
                    this.jj_la1[24] = this.jj_gen;
                }
            }
            this.jj_consume_token(51);
            block20: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 21: {
                        break;
                    }
                    default: {
                        this.jj_la1[25] = this.jj_gen;
                        break block20;
                    }
                }
                this.jj_consume_token(21);
            }
            this.handleImport(this.getURL(), importFile, is_url, media);
        }
        catch (ParseException e) {
            this.addError((Exception)e, this.skipStatement());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final AtRuleMedia media() throws ParseException {
        AtRule old = this.getAtRule();
        AtRuleMedia newRule = AtRuleMedia.getInstance(this.ac.getCssVersion());
        this.setAtRule(newRule);
        Object p = null;
        boolean isCss1 = this.ac.getCssVersion() == CssVersion.CSS1;
        boolean emptyList = true;
        int begl = 0;
        int begc = 0;
        int endl = 0;
        int endc = 0;
        try {
            block33: {
                Token n = this.jj_consume_token(99);
                begl = this.getBeginLine();
                begc = this.getBeginColumn();
                block24: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 21: {
                            break;
                        }
                        default: {
                            this.jj_la1[26] = this.jj_gen;
                            break block24;
                        }
                    }
                    this.jj_consume_token(21);
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 37: 
                    case 38: 
                    case 41: 
                    case 58: {
                        this.mediaquerylist(newRule);
                        String media = this.getAtRule().toString();
                        emptyList = false;
                        if (this.ac.getMedium() != null && !media.equals(this.ac.getMedium()) && !this.ac.getMedium().equals("all")) {
                            this.ac.getFrame().addWarning("noothermedium", this.getAtRule().toString());
                        }
                        if (isCss1) {
                            this.skipStatement();
                            this.addError((Exception)new InvalidParamException("noatruleyet", "", this.ac), this.getAtRule().toString());
                            break;
                        }
                        this.newAtRule(this.getAtRule());
                        break;
                    }
                    default: {
                        this.jj_la1[27] = this.jj_gen;
                    }
                }
                this.jj_consume_token(27);
                endl = this.getEndLine();
                endc = this.getEndColumn();
                block25: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 21: {
                            break;
                        }
                        default: {
                            this.jj_la1[28] = this.jj_gen;
                            break block25;
                        }
                    }
                    this.jj_consume_token(21);
                }
                block26: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 35: 
                        case 36: 
                        case 37: 
                        case 38: 
                        case 41: 
                        case 42: 
                        case 43: 
                        case 53: 
                        case 55: 
                        case 56: 
                        case 59: 
                        case 61: 
                        case 62: 
                        case 63: 
                        case 65: 
                        case 68: 
                        case 69: 
                        case 70: 
                        case 73: 
                        case 78: 
                        case 80: 
                        case 99: 
                        case 100: 
                        case 101: 
                        case 102: 
                        case 103: 
                        case 105: 
                        case 106: 
                        case 107: 
                        case 108: 
                        case 109: 
                        case 153: {
                            break;
                        }
                        default: {
                            this.jj_la1[29] = this.jj_gen;
                            break block33;
                        }
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 35: 
                        case 36: 
                        case 37: 
                        case 38: 
                        case 41: 
                        case 42: 
                        case 43: 
                        case 53: 
                        case 55: 
                        case 56: 
                        case 59: 
                        case 61: 
                        case 62: 
                        case 63: 
                        case 65: 
                        case 68: 
                        case 69: 
                        case 70: 
                        case 73: 
                        case 78: 
                        case 153: {
                            this.ruleSet();
                            continue block26;
                        }
                        case 80: 
                        case 99: 
                        case 100: 
                        case 101: 
                        case 102: 
                        case 103: 
                        case 105: 
                        case 106: 
                        case 107: 
                        case 108: 
                        case 109: {
                            this.nested_at_rules();
                            continue block26;
                        }
                    }
                    break;
                }
                this.jj_la1[30] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            this.jj_consume_token(46);
            block27: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 21: {
                        break;
                    }
                    default: {
                        this.jj_la1[31] = this.jj_gen;
                        break block27;
                    }
                }
                this.jj_consume_token(21);
            }
            if (!isCss1) {
                this.endOfAtRule();
            }
        }
        catch (ParseException e) {
            if (!isCss1) {
                this.addError((Exception)e, this.skipStatement());
            }
            newRule = null;
            return newRule;
        }
        finally {
            if (emptyList && this.ac.getCssVersion().compareTo(CssVersion.CSS3) < 0) {
                this.ac.getFrame().addError(new CssError(this.getSourceFile(), begl, begc, endl, endc, new InvalidParamException("emptymedia", this.ac)));
            }
            this.setAtRule(old);
            return newRule;
        }
    }

    public final void ratio(CssExpression exp, char operator) throws ParseException {
        Token w = this.jj_consume_token(75);
        block6: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 21: {
                    break;
                }
                default: {
                    this.jj_la1[32] = this.jj_gen;
                    break block6;
                }
            }
            this.jj_consume_token(21);
        }
        this.jj_consume_token(52);
        block7: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 21: {
                    break;
                }
                default: {
                    this.jj_la1[33] = this.jj_gen;
                    break block7;
                }
            }
            this.jj_consume_token(21);
        }
        Token h = this.jj_consume_token(75);
        StringBuilder sb = new StringBuilder();
        sb.append(w.image).append('/').append(h.image);
        Token n = Token.newToken(w.kind, sb.toString());
        this.setValue(new CssRatio(), exp, operator, n, 75);
    }

    public final void mediaquerylist(AtRuleMedia mediaRule) throws ParseException {
        this.mediaquery(mediaRule);
        block6: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 32: {
                    break;
                }
                default: {
                    this.jj_la1[34] = this.jj_gen;
                    break block6;
                }
            }
            this.jj_consume_token(32);
            block7: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 21: {
                        break;
                    }
                    default: {
                        this.jj_la1[35] = this.jj_gen;
                        break block7;
                    }
                }
                this.jj_consume_token(21);
            }
            this.mediaquery(mediaRule);
        }
    }

    public final void mediaquery(AtRuleMedia mediaRule) throws ParseException {
        String mediarestrictor = null;
        if (this.jj_2_1(3)) {
            this.mediacondition(mediaRule, true, null);
        } else {
            block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 37: 
                case 38: 
                case 41: {
                    Token n;
                    block3 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 37: 
                        case 38: {
                            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                case 38: {
                                    n = this.jj_consume_token(38);
                                    break;
                                }
                                case 37: {
                                    n = this.jj_consume_token(37);
                                    break;
                                }
                                default: {
                                    this.jj_la1[36] = this.jj_gen;
                                    this.jj_consume_token(-1);
                                    throw new ParseException();
                                }
                            }
                            mediarestrictor = this.convertIdent(n.image);
                            while (true) {
                                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                    case 21: {
                                        break;
                                    }
                                    default: {
                                        this.jj_la1[37] = this.jj_gen;
                                        break block3;
                                    }
                                }
                                this.jj_consume_token(21);
                            }
                        }
                        default: {
                            this.jj_la1[38] = this.jj_gen;
                        }
                    }
                    n = this.jj_consume_token(41);
                    mediaRule.addMedia(mediarestrictor, this.convertIdent(n.image), this.ac);
                    block23: while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 21: {
                                break;
                            }
                            default: {
                                this.jj_la1[39] = this.jj_gen;
                                break block23;
                            }
                        }
                        this.jj_consume_token(21);
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 35: {
                            n = this.jj_consume_token(35);
                            mediarestrictor = this.convertIdent(n.image);
                            block24: while (true) {
                                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                    case 21: {
                                        break;
                                    }
                                    default: {
                                        this.jj_la1[40] = this.jj_gen;
                                        break block24;
                                    }
                                }
                                this.jj_consume_token(21);
                            }
                            this.mediaconditionwithoutor(mediaRule, false, mediarestrictor);
                            break block0;
                        }
                    }
                    this.jj_la1[41] = this.jj_gen;
                    break;
                }
                default: {
                    this.jj_la1[42] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
    }

    public final void mediacondition(AtRuleMedia mediaRule, boolean defaultMedia, String comb) throws ParseException {
        String combinator = null;
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 38: {
                Token n = this.jj_consume_token(38);
                combinator = this.convertIdent(n.image);
                block26: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 21: {
                            break;
                        }
                        default: {
                            this.jj_la1[43] = this.jj_gen;
                            break block26;
                        }
                    }
                    this.jj_consume_token(21);
                }
                this.mediainparens(mediaRule, defaultMedia, combinator);
                break;
            }
            case 58: {
                this.mediainparens(mediaRule, defaultMedia, null);
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 35: 
                    case 36: {
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 35: {
                                block27: while (true) {
                                    Token n = this.jj_consume_token(35);
                                    combinator = this.convertIdent(n.image);
                                    block28: while (true) {
                                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                            case 21: {
                                                break;
                                            }
                                            default: {
                                                this.jj_la1[44] = this.jj_gen;
                                                break block28;
                                            }
                                        }
                                        this.jj_consume_token(21);
                                    }
                                    this.mediainparens(mediaRule, false, combinator);
                                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                        case 35: {
                                            continue block27;
                                        }
                                    }
                                    break;
                                }
                                this.jj_la1[45] = this.jj_gen;
                                break block0;
                            }
                            case 36: {
                                block29: while (true) {
                                    Token n = this.jj_consume_token(36);
                                    combinator = this.convertIdent(n.image);
                                    block30: while (true) {
                                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                            case 21: {
                                                break;
                                            }
                                            default: {
                                                this.jj_la1[46] = this.jj_gen;
                                                break block30;
                                            }
                                        }
                                        this.jj_consume_token(21);
                                    }
                                    this.mediainparens(mediaRule, false, combinator);
                                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                        case 36: {
                                            continue block29;
                                        }
                                    }
                                    break;
                                }
                                this.jj_la1[47] = this.jj_gen;
                                break block0;
                            }
                        }
                        this.jj_la1[48] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                this.jj_la1[49] = this.jj_gen;
                break;
            }
            default: {
                this.jj_la1[50] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void mediaconditionwithoutor(AtRuleMedia mediaRule, boolean defaultMedia, String comb) throws ParseException {
        String mediarestrictor = null;
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 38: {
                Token n = this.jj_consume_token(38);
                mediarestrictor = this.convertIdent(n.image);
                block13: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 21: {
                            break;
                        }
                        default: {
                            this.jj_la1[51] = this.jj_gen;
                            break block13;
                        }
                    }
                    this.jj_consume_token(21);
                }
                this.mediainparens(mediaRule, defaultMedia, mediarestrictor);
                break;
            }
            case 58: {
                this.mediainparens(mediaRule, defaultMedia, comb);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 35: {
                            break;
                        }
                        default: {
                            this.jj_la1[52] = this.jj_gen;
                            break block0;
                        }
                    }
                    Token n = this.jj_consume_token(35);
                    mediarestrictor = this.convertIdent(n.image);
                    block15: while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 21: {
                                break;
                            }
                            default: {
                                this.jj_la1[53] = this.jj_gen;
                                break block15;
                            }
                        }
                        this.jj_consume_token(21);
                    }
                    this.mediainparens(mediaRule, defaultMedia, mediarestrictor);
                }
            }
            default: {
                this.jj_la1[54] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void mediainparens(AtRuleMedia mediaRule, boolean defaultMedia, String comb) throws ParseException {
        block14: {
            Object val = null;
            Object mediaFeatureName = null;
            if (this.jj_2_2(4)) {
                this.jj_consume_token(58);
                block9: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 21: {
                            break;
                        }
                        default: {
                            this.jj_la1[55] = this.jj_gen;
                            break block9;
                        }
                    }
                    this.jj_consume_token(21);
                }
                this.mediacondition(mediaRule, defaultMedia, comb);
                this.jj_consume_token(57);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 21: {
                            break;
                        }
                        default: {
                            this.jj_la1[56] = this.jj_gen;
                            break block14;
                        }
                    }
                    this.jj_consume_token(21);
                }
            }
            if (this.jj_2_3(5)) {
                this.mediarange(mediaRule, defaultMedia, comb);
            } else {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 58: {
                        this.mediaexpression(mediaRule, defaultMedia, comb);
                        break;
                    }
                    default: {
                        this.jj_la1[57] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
            }
        }
    }

    public final void mediaexpression(AtRuleMedia mediaRule, boolean defaultMedia, String comb) throws ParseException {
        CssExpression val = null;
        String mediaFeatureName = null;
        this.jj_consume_token(58);
        block15: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 21: {
                    break;
                }
                default: {
                    this.jj_la1[58] = this.jj_gen;
                    break block15;
                }
            }
            this.jj_consume_token(21);
        }
        Token n = this.jj_consume_token(41);
        if (defaultMedia) {
            mediaRule.addMedia(null, null, this.ac);
        }
        mediaFeatureName = this.convertIdent(n.image);
        block16: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 21: {
                    break;
                }
                default: {
                    this.jj_la1[59] = this.jj_gen;
                    break block16;
                }
            }
            this.jj_consume_token(21);
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 59: {
                this.jj_consume_token(59);
                block17: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 21: {
                            break;
                        }
                        default: {
                            this.jj_la1[60] = this.jj_gen;
                            break block17;
                        }
                    }
                    this.jj_consume_token(21);
                }
                val = this.mediaexpr();
                break;
            }
            default: {
                this.jj_la1[61] = this.jj_gen;
            }
        }
        this.jj_consume_token(57);
        block18: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 21: {
                    break;
                }
                default: {
                    this.jj_la1[62] = this.jj_gen;
                    break block18;
                }
            }
            this.jj_consume_token(21);
        }
        MediaFeature mf = this.handleMediaFeature(mediaRule, mediaFeatureName, val);
        if (mf != null) {
            mediaRule.addMediaFeature(mf, this.ac);
            mf.setCombinator(comb);
        } else if (defaultMedia) {
            mediaRule.removeLastMedia();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void supports() throws ParseException {
        AtRule old = this.getAtRule();
        AtRuleSupports newRule = new AtRuleSupports();
        this.setAtRule(newRule);
        Object p = null;
        CssVersion version = this.ac.getCssVersion();
        boolean isCss1 = version == CssVersion.CSS1;
        try {
            block28: {
                Token n = this.jj_consume_token(107);
                block21: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 21: {
                            break;
                        }
                        default: {
                            this.jj_la1[63] = this.jj_gen;
                            break block21;
                        }
                    }
                    this.jj_consume_token(21);
                }
                if (version.compareTo(CssVersion.CSS3) < 0) {
                    this.skipStatement();
                    this.addError((Exception)new InvalidParamException("noatruleyet", "", this.ac), this.getAtRule().toString());
                }
                SupportsFeature sf = this.supports_condition(newRule);
                newRule.addFeature(sf, this.ac);
                this.newAtRule(this.getAtRule());
                this.jj_consume_token(27);
                block22: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 21: {
                            break;
                        }
                        default: {
                            this.jj_la1[64] = this.jj_gen;
                            break block22;
                        }
                    }
                    this.jj_consume_token(21);
                }
                block23: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 35: 
                        case 36: 
                        case 37: 
                        case 38: 
                        case 41: 
                        case 42: 
                        case 43: 
                        case 53: 
                        case 55: 
                        case 56: 
                        case 59: 
                        case 61: 
                        case 62: 
                        case 63: 
                        case 65: 
                        case 68: 
                        case 69: 
                        case 70: 
                        case 73: 
                        case 78: 
                        case 80: 
                        case 99: 
                        case 100: 
                        case 101: 
                        case 102: 
                        case 103: 
                        case 105: 
                        case 106: 
                        case 107: 
                        case 108: 
                        case 109: 
                        case 153: {
                            break;
                        }
                        default: {
                            this.jj_la1[65] = this.jj_gen;
                            break block28;
                        }
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 35: 
                        case 36: 
                        case 37: 
                        case 38: 
                        case 41: 
                        case 42: 
                        case 43: 
                        case 53: 
                        case 55: 
                        case 56: 
                        case 59: 
                        case 61: 
                        case 62: 
                        case 63: 
                        case 65: 
                        case 68: 
                        case 69: 
                        case 70: 
                        case 73: 
                        case 78: 
                        case 153: {
                            this.ruleSet();
                            continue block23;
                        }
                        case 80: 
                        case 99: 
                        case 100: 
                        case 101: 
                        case 102: 
                        case 103: 
                        case 105: 
                        case 106: 
                        case 107: 
                        case 108: 
                        case 109: {
                            this.nested_at_rules();
                            continue block23;
                        }
                    }
                    break;
                }
                this.jj_la1[66] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            this.jj_consume_token(46);
            block24: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 21: {
                        break;
                    }
                    default: {
                        this.jj_la1[67] = this.jj_gen;
                        break block24;
                    }
                }
                this.jj_consume_token(21);
            }
            if (!isCss1) {
                this.endOfAtRule();
            }
        }
        catch (ParseException e) {
            if (!isCss1) {
                this.addError((Exception)e, this.skipStatement());
            }
            newRule = null;
        }
        finally {
            this.setAtRule(old);
        }
    }

    public final SupportsFeature supports_condition(AtRuleSupports supportsRule) throws ParseException {
        SupportsFeature f = null;
        boolean got_multi = false;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 38: {
                this.jj_consume_token(38);
                block26: while (true) {
                    this.jj_consume_token(21);
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 21: {
                            continue block26;
                        }
                    }
                    break;
                }
                this.jj_la1[68] = this.jj_gen;
                SupportsFeature nf = this.supports_condition_in_parens(supportsRule);
                nf.setNot(true);
                return nf;
            }
            case 58: {
                SupportsFeature nf = this.supports_condition_in_parens(supportsRule);
                block7 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 35: 
                    case 36: {
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 35: {
                                block27: while (true) {
                                    this.jj_consume_token(35);
                                    block28: while (true) {
                                        this.jj_consume_token(21);
                                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                            case 21: {
                                                continue block28;
                                            }
                                        }
                                        break;
                                    }
                                    this.jj_la1[69] = this.jj_gen;
                                    SupportsFeature mf = this.supports_condition_in_parens(supportsRule);
                                    if (f == null) {
                                        f = new SupportsFeature();
                                        f.addFeature(nf);
                                    }
                                    mf.setAnd(true);
                                    f.addFeature(mf);
                                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                        case 35: {
                                            continue block27;
                                        }
                                    }
                                    break;
                                }
                                this.jj_la1[70] = this.jj_gen;
                                break block7;
                            }
                            case 36: {
                                block29: while (true) {
                                    this.jj_consume_token(36);
                                    block30: while (true) {
                                        this.jj_consume_token(21);
                                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                            case 21: {
                                                continue block30;
                                            }
                                        }
                                        break;
                                    }
                                    this.jj_la1[71] = this.jj_gen;
                                    SupportsFeature mf = this.supports_condition_in_parens(supportsRule);
                                    if (f == null) {
                                        f = new SupportsFeature();
                                        f.addFeature(nf);
                                    }
                                    mf.setOr(true);
                                    f.addFeature(mf);
                                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                        case 36: {
                                            continue block29;
                                        }
                                    }
                                    break;
                                }
                                this.jj_la1[72] = this.jj_gen;
                                break block7;
                            }
                        }
                        this.jj_la1[73] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                    default: {
                        this.jj_la1[74] = this.jj_gen;
                    }
                }
                if (f == null) {
                    return nf;
                }
                return f;
            }
        }
        this.jj_la1[75] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final SupportsFeature supports_condition_in_parens(AtRuleSupports supportsRule) throws ParseException {
        SupportsFeature f = new SupportsFeature();
        this.jj_consume_token(58);
        block9: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 21: {
                    break;
                }
                default: {
                    this.jj_la1[76] = this.jj_gen;
                    break block9;
                }
            }
            this.jj_consume_token(21);
        }
        if (this.jj_2_4(3)) {
            SupportsFeature nf = this.supports_condition(supportsRule);
            f.addFeature(nf);
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 28: 
                case 30: 
                case 32: 
                case 33: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 41: 
                case 42: 
                case 45: 
                case 50: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 58: 
                case 59: 
                case 109: 
                case 146: 
                case 147: 
                case 148: 
                case 149: 
                case 150: 
                case 151: 
                case 152: 
                case 153: {
                    CssProperty p = this.declaration();
                    f.setProperty(p);
                    break;
                }
                default: {
                    this.jj_la1[77] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        this.jj_consume_token(57);
        block10: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 21: {
                    break;
                }
                default: {
                    this.jj_la1[78] = this.jj_gen;
                    break block10;
                }
            }
            this.jj_consume_token(21);
        }
        return f;
    }

    public final void general_enclosed(AtRuleSupports supportsRule) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 143: {
                this.jj_consume_token(143);
                break;
            }
            case 58: {
                this.jj_consume_token(58);
                break;
            }
            default: {
                this.jj_la1[79] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        block13: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 21: {
                    break;
                }
                default: {
                    this.jj_la1[80] = this.jj_gen;
                    break block13;
                }
            }
            this.jj_consume_token(21);
        }
        block14: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 41: {
                    break;
                }
                default: {
                    this.jj_la1[81] = this.jj_gen;
                    break block14;
                }
            }
            this.ident();
        }
        this.jj_consume_token(57);
        block15: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 21: {
                    break;
                }
                default: {
                    this.jj_la1[82] = this.jj_gen;
                    break block15;
                }
            }
            this.jj_consume_token(21);
        }
    }

    public final void unused_production_generic_syntax() throws ParseException {
        CssExpression values = new CssExpression();
        this.jj_consume_token(58);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 21: {
                    break;
                }
                default: {
                    this.jj_la1[83] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(21);
        }
        this.term(values);
        this.jj_consume_token(57);
    }

    public final void unused_production_definition() throws ParseException {
        CssExpression values = new CssExpression();
        this.jj_consume_token(53);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 21: {
                    break;
                }
                default: {
                    this.jj_la1[84] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(21);
        }
        this.term(values);
        this.jj_consume_token(54);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void page() throws ParseException {
        Object n = null;
        ArrayList collectv = new ArrayList();
        CssSelectors s = new CssSelectors(this.ac);
        AtRule old = this.getAtRule();
        org.w3c.css.atrules.css.AtRulePage newRule = org.w3c.css.atrules.css.AtRulePage.getInstance(this.ac.getCssVersion());
        this.setAtRule(newRule);
        s.setAtRule(this.getAtRule());
        boolean isCss1 = this.ac.getCssVersion() == CssVersion.CSS1;
        boolean gotContent = false;
        try {
            this.jj_consume_token(80);
            if (!isCss1) {
                this.newAtRule(newRule);
            }
            block19: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 21: {
                        break;
                    }
                    default: {
                        this.jj_la1[85] = this.jj_gen;
                        break block19;
                    }
                }
                this.jj_consume_token(21);
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 41: 
                case 59: {
                    this.page_selector_list(newRule);
                    break;
                }
                default: {
                    this.jj_la1[86] = this.jj_gen;
                }
            }
            this.jj_consume_token(27);
            block20: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 21: {
                        break;
                    }
                    default: {
                        this.jj_la1[87] = this.jj_gen;
                        break block20;
                    }
                }
                this.jj_consume_token(21);
            }
            gotContent = this.pageContent();
            this.jj_consume_token(46);
            block21: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 21: {
                        break;
                    }
                    default: {
                        this.jj_la1[88] = this.jj_gen;
                        break block21;
                    }
                }
                this.jj_consume_token(21);
            }
            if (!isCss1) {
                if (gotContent) {
                    this.endOfRule();
                }
                this.endOfAtRule();
            }
        }
        catch (InvalidParamException ie) {
            if (!isCss1) {
                this.skipStatement();
                this.removeThisAtRule();
                this.ac.getFrame().addError(new CssError(this.getSourceFile(), this.getBeginLine(), this.getBeginColumn(), this.getEndLine(), this.getEndColumn(), ie));
            }
        }
        catch (ParseException e) {
            if (!isCss1) {
                this.removeThisAtRule();
                this.addError((Exception)e, this.skipStatement());
            }
        }
        finally {
            this.setAtRule(old);
        }
    }

    public final boolean pageContent() throws ParseException {
        ArrayList<CssProperty> v = null;
        ArrayList<CssProperty> allv = new ArrayList<CssProperty>();
        CssSelectors s = new CssSelectors(this.ac);
        boolean gotContent = false;
        v = this.declarations();
        if (v != null) {
            gotContent = true;
            allv.addAll(v);
        }
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 86: 
                case 87: 
                case 88: 
                case 89: 
                case 90: 
                case 91: 
                case 92: 
                case 93: 
                case 94: 
                case 95: 
                case 96: {
                    break;
                }
                default: {
                    this.jj_la1[89] = this.jj_gen;
                    break block3;
                }
            }
            this.prefAtRule();
            gotContent = true;
            v = this.declarations();
            if (v == null) continue;
            allv.addAll(v);
        }
        if (allv.isEmpty()) {
            if (!gotContent) {
                this.ac.getFrame().addWarning("no-declaration");
            }
        } else {
            this.addProperty(allv);
            this.handleRule(s, allv);
        }
        return gotContent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ArrayList<CssProperty> prefAtRule() throws ParseException {
        org.w3c.css.atrules.css.AtRulePage newRule = org.w3c.css.atrules.css.AtRulePage.getInstance(this.ac.getCssVersion());
        AtRule old = this.getAtRule();
        CssSelectors s = new CssSelectors(this.ac);
        try {
            Token n;
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 81: {
                    n = this.jj_consume_token(81);
                    break;
                }
                case 82: {
                    n = this.jj_consume_token(82);
                    break;
                }
                case 83: {
                    n = this.jj_consume_token(83);
                    break;
                }
                case 84: {
                    n = this.jj_consume_token(84);
                    break;
                }
                case 85: {
                    n = this.jj_consume_token(85);
                    break;
                }
                case 86: {
                    n = this.jj_consume_token(86);
                    break;
                }
                case 87: {
                    n = this.jj_consume_token(87);
                    break;
                }
                case 88: {
                    n = this.jj_consume_token(88);
                    break;
                }
                case 89: {
                    n = this.jj_consume_token(89);
                    break;
                }
                case 90: {
                    n = this.jj_consume_token(90);
                    break;
                }
                case 91: {
                    n = this.jj_consume_token(91);
                    break;
                }
                case 92: {
                    n = this.jj_consume_token(92);
                    break;
                }
                case 93: {
                    n = this.jj_consume_token(93);
                    break;
                }
                case 94: {
                    n = this.jj_consume_token(94);
                    break;
                }
                case 95: {
                    n = this.jj_consume_token(95);
                    break;
                }
                case 96: {
                    n = this.jj_consume_token(96);
                    break;
                }
                default: {
                    this.jj_la1[90] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            ((AtRulePage)newRule).setKeyword(this.convertIdent(n.image).substring(1));
            this.setAtRule(newRule);
            s.setAtRule(this.getAtRule());
            this.newAtRule(this.getAtRule());
            block32: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 21: {
                        break;
                    }
                    default: {
                        this.jj_la1[91] = this.jj_gen;
                        break block32;
                    }
                }
                this.jj_consume_token(21);
            }
            this.jj_consume_token(27);
            block33: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 21: {
                        break;
                    }
                    default: {
                        this.jj_la1[92] = this.jj_gen;
                        break block33;
                    }
                }
                this.jj_consume_token(21);
            }
            ArrayList<CssProperty> v = this.declarations();
            this.jj_consume_token(46);
            if (v == null) {
                this.ac.getFrame().addWarning("no-declaration");
            } else {
                this.addProperty(v);
                this.handleRule(s, v);
            }
            this.endOfRule();
            this.endOfAtRule();
            block34: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 21: {
                        break;
                    }
                    default: {
                        this.jj_la1[93] = this.jj_gen;
                        break block34;
                    }
                }
                this.jj_consume_token(21);
            }
            ArrayList<CssProperty> arrayList = v;
            return arrayList;
        }
        catch (ParseException e) {
            this.addError((Exception)e, this.skipStatement());
        }
        finally {
            this.setAtRule(old);
        }
        throw new Error("Missing return statement in function");
    }

    public final void page_selector_list(org.w3c.css.atrules.css.AtRulePage pageRule) throws ParseException {
        Token n = null;
        Token p = null;
        Object o = null;
        boolean gotFirst = false;
        String ns = null;
        ArrayList<String> ps = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 41: {
                n = this.ident();
                ns = this.convertIdent(n.image);
                block32: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 59: {
                            break;
                        }
                        default: {
                            this.jj_la1[94] = this.jj_gen;
                            break block32;
                        }
                    }
                    this.jj_consume_token(59);
                    p = this.ident();
                    if (ps == null) {
                        ps = new ArrayList();
                    }
                    ps.add(":" + this.convertIdent(p.image));
                }
                pageRule.addSelector(ns, ps, this.ac);
                ns = null;
                ps = null;
                break;
            }
            case 59: {
                block33: while (true) {
                    this.jj_consume_token(59);
                    p = this.ident();
                    if (ps == null) {
                        ps = new ArrayList<String>();
                    }
                    ps.add(":" + this.convertIdent(p.image));
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 59: {
                            continue block33;
                        }
                    }
                    break;
                }
                this.jj_la1[95] = this.jj_gen;
                pageRule.addSelector(null, ps, this.ac);
                ps = null;
                break;
            }
            default: {
                this.jj_la1[96] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        block34: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 21: {
                    break;
                }
                default: {
                    this.jj_la1[97] = this.jj_gen;
                    break block34;
                }
            }
            this.jj_consume_token(21);
        }
        block35: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 32: {
                    break;
                }
                default: {
                    this.jj_la1[98] = this.jj_gen;
                    break block35;
                }
            }
            this.jj_consume_token(32);
            block36: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 21: {
                        break;
                    }
                    default: {
                        this.jj_la1[99] = this.jj_gen;
                        break block36;
                    }
                }
                this.jj_consume_token(21);
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 41: {
                    n = this.ident();
                    ns = this.convertIdent(n.image);
                    block37: while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 59: {
                                break;
                            }
                            default: {
                                this.jj_la1[100] = this.jj_gen;
                                break block37;
                            }
                        }
                        this.jj_consume_token(59);
                        p = this.ident();
                        if (ps == null) {
                            ps = new ArrayList();
                        }
                        ps.add(":" + this.convertIdent(p.image));
                    }
                    pageRule.addSelector(ns, ps, this.ac);
                    ns = null;
                    ps = null;
                    break;
                }
                case 59: {
                    block38: while (true) {
                        this.jj_consume_token(59);
                        p = this.ident();
                        if (ps == null) {
                            ps = new ArrayList();
                        }
                        ps.add(":" + this.convertIdent(p.image));
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 59: {
                                continue block38;
                            }
                        }
                        break;
                    }
                    this.jj_la1[101] = this.jj_gen;
                    pageRule.addSelector(null, ps, this.ac);
                    ps = null;
                    break;
                }
                default: {
                    this.jj_la1[102] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 21: {
                        break;
                    }
                    default: {
                        this.jj_la1[103] = this.jj_gen;
                        continue block35;
                    }
                }
                this.jj_consume_token(21);
            }
            break;
        }
    }

    public final CssSelectors keyframe_selector(CssSelectors next) throws ParseException {
        CssSelectors selector = new CssSelectors(this.ac, next);
        selector.setAtRule(this.getAtRule());
        Token op = null;
        try {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 41: {
                    Token n = this.ident();
                    CssIdent ident = new CssIdent();
                    ident.set(this.convertIdent(n.image), this.ac);
                    AtRuleKeyframes.checkSelectorValue(ident, this.ac);
                    selector.addType(new TypeSelector(ident.toString()));
                    break;
                }
                case 28: 
                case 29: 
                case 74: {
                    block5 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 28: 
                        case 29: {
                            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                case 28: {
                                    op = this.jj_consume_token(28);
                                    break block5;
                                }
                                case 29: {
                                    op = this.jj_consume_token(29);
                                    break block5;
                                }
                            }
                            this.jj_la1[104] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                        default: {
                            this.jj_la1[105] = this.jj_gen;
                        }
                    }
                    Token n = this.jj_consume_token(74);
                    CssPercentage p = new CssPercentage();
                    if (op == null) {
                        p.set(n.image, this.ac);
                    } else {
                        p.set(op.image + n.image, this.ac);
                    }
                    AtRuleKeyframes.checkSelectorValue(p, this.ac);
                    selector.addType(new TypeSelector(n.image));
                    break;
                }
                default: {
                    this.jj_la1[106] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            block17: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 21: {
                        break;
                    }
                    default: {
                        this.jj_la1[107] = this.jj_gen;
                        break block17;
                    }
                }
                this.jj_consume_token(21);
            }
            return selector;
        }
        catch (InvalidParamException ie) {
            this.ac.getFrame().addError(new CssError(this.getSourceFile(), this.getBeginLine(), this.getBeginColumn(), this.getEndLine(), this.getEndColumn(), ie));
            Token t = this.getToken(1);
            StringBuilder s = new StringBuilder();
            s.append(this.getToken((int)0).image);
            while (t.kind != 32 && t.kind != 27 && t.kind != 0) {
                s.append(t.image);
                this.getNextToken();
                t = this.getToken(1);
            }
            return null;
        }
        catch (ParseException e) {
            Token t = this.getToken(1);
            int _line = t.beginLine;
            int _col = t.beginColumn;
            StringBuilder s = new StringBuilder();
            s.append(" [");
            s.append(this.getToken((int)0).image);
            while (t.kind != 32 && t.kind != 27 && t.kind != 0) {
                s.append(t.image);
                this.getNextToken();
                t = this.getToken(1);
            }
            s.append(']');
            this.addParseError(e, s.toString());
            this.validSelector = true;
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void keyframes() throws ParseException {
        AtRule old = this.getAtRule();
        AtRuleKeyframes krule = new AtRuleKeyframes("-internal-");
        this.setAtRule(krule);
        CssVersion version = this.ac.getCssVersion();
        try {
            this.jj_consume_token(101);
            block32: while (true) {
                this.jj_consume_token(21);
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 21: {
                        continue block32;
                    }
                }
                break;
            }
            this.jj_la1[108] = this.jj_gen;
            Token n = this.ident();
            block33: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 21: {
                        break;
                    }
                    default: {
                        this.jj_la1[109] = this.jj_gen;
                        break block33;
                    }
                }
                this.jj_consume_token(21);
            }
            krule.setName(this.convertIdent(n.image));
            if (version.compareTo(CssVersion.CSS3) < 0) {
                this.skipStatement();
                this.addError((Exception)new InvalidParamException("noatruleyet", "", this.ac), this.getAtRule().toString());
            } else {
                this.newAtRule(this.getAtRule());
            }
            this.jj_consume_token(27);
            block34: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 21: {
                        break;
                    }
                    default: {
                        this.jj_la1[110] = this.jj_gen;
                        break block34;
                    }
                }
                this.jj_consume_token(21);
            }
            block35: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 28: 
                    case 29: 
                    case 35: 
                    case 36: 
                    case 37: 
                    case 38: 
                    case 41: 
                    case 74: {
                        break;
                    }
                    default: {
                        this.jj_la1[111] = this.jj_gen;
                        break block35;
                    }
                }
                CssSelectors s = this.keyframe_selector(null);
                ArrayList<CssSelectors> sl = new ArrayList<CssSelectors>();
                if (s != null) {
                    s.setAtRule(this.getAtRule());
                    sl.add(s);
                }
                block36: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 32: {
                            break;
                        }
                        default: {
                            this.jj_la1[112] = this.jj_gen;
                            break block36;
                        }
                    }
                    this.jj_consume_token(32);
                    block37: while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 21: {
                                break;
                            }
                            default: {
                                this.jj_la1[113] = this.jj_gen;
                                break block37;
                            }
                        }
                        this.jj_consume_token(21);
                    }
                    s = this.keyframe_selector(null);
                    if (s == null) continue;
                    s.setAtRule(this.getAtRule());
                    sl.add(s);
                }
                this.jj_consume_token(27);
                block38: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 21: {
                            break;
                        }
                        default: {
                            this.jj_la1[114] = this.jj_gen;
                            break block38;
                        }
                    }
                    this.jj_consume_token(21);
                }
                ArrayList<CssProperty> v = this.declarations();
                this.jj_consume_token(46);
                block39: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 21: {
                            break;
                        }
                        default: {
                            this.jj_la1[115] = this.jj_gen;
                            break block39;
                        }
                    }
                    this.jj_consume_token(21);
                }
                boolean bl = this.validSelector = sl.size() != 0;
                if (!this.validSelector) continue;
                if (v == null) {
                    this.ac.getFrame().addWarning("no-declaration");
                } else {
                    boolean first = true;
                    for (CssSelectors _s : sl) {
                        if (first) {
                            this.handleRule(_s, v);
                            first = false;
                            continue;
                        }
                        ArrayList<CssProperty> vcopy = new ArrayList<CssProperty>(v.size());
                        for (CssProperty p : v) {
                            vcopy.add(p.duplicate());
                        }
                        this.handleRule(_s, vcopy);
                    }
                }
                this.setSelectorList(sl);
                this.endOfRule();
            }
            this.jj_consume_token(46);
            block42: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 21: {
                        break;
                    }
                    default: {
                        this.jj_la1[116] = this.jj_gen;
                        break block42;
                    }
                }
                this.jj_consume_token(21);
            }
            this.endOfAtRule();
        }
        catch (ParseException e) {
            this.addError((Exception)e, this.skipStatement());
        }
        finally {
            this.setAtRule(old);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void fontFace() throws ParseException {
        AtRule old = this.getAtRule();
        this.setAtRule(new AtRuleFontFace());
        CssSelectors s = new CssSelectors(this.ac);
        s.setAtRule(this.getAtRule());
        boolean isCss1 = this.ac.getCssVersion() == CssVersion.CSS1;
        try {
            this.jj_consume_token(100);
            block14: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 21: {
                        break;
                    }
                    default: {
                        this.jj_la1[117] = this.jj_gen;
                        break block14;
                    }
                }
                this.jj_consume_token(21);
            }
            if (isCss1) {
                this.skipStatement();
                this.addError((Exception)new InvalidParamException("noatruleyet", "", this.ac), this.getAtRule().toString());
            } else {
                this.newAtRule(this.getAtRule());
            }
            this.jj_consume_token(27);
            block15: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 21: {
                        break;
                    }
                    default: {
                        this.jj_la1[118] = this.jj_gen;
                        break block15;
                    }
                }
                this.jj_consume_token(21);
            }
            ArrayList<CssProperty> v = this.declarations();
            this.jj_consume_token(46);
            block16: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 21: {
                        break;
                    }
                    default: {
                        this.jj_la1[119] = this.jj_gen;
                        break block16;
                    }
                }
                this.jj_consume_token(21);
            }
            if (!isCss1) {
                this.addProperty(v);
                this.endOfRule();
                this.endOfAtRule();
            }
            if (v == null) {
                this.ac.getFrame().addWarning("no-declaration");
            } else {
                this.handleRule(s, v);
            }
        }
        catch (ParseException e) {
            if (!isCss1) {
                this.addError((Exception)e, this.skipStatement());
            }
        }
        finally {
            this.setAtRule(old);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void colorprofile() throws ParseException {
        AtRule old = this.getAtRule();
        this.setAtRule(new AtRuleColorProfile());
        CssSelectors s = new CssSelectors(this.ac);
        s.setAtRule(this.getAtRule());
        CssProfile profile = this.ac.getCssProfile();
        boolean isSVG = profile == CssProfile.SVG || profile == CssProfile.SVGBASIC || profile == CssProfile.SVGTINY;
        try {
            this.jj_consume_token(103);
            block14: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 21: {
                        break;
                    }
                    default: {
                        this.jj_la1[120] = this.jj_gen;
                        break block14;
                    }
                }
                this.jj_consume_token(21);
            }
            if (!isSVG) {
                this.skipStatement();
                this.addError((Exception)new InvalidParamException("onlysvg", "", this.ac), this.getAtRule().toString());
            } else {
                this.newAtRule(this.getAtRule());
            }
            this.jj_consume_token(27);
            block15: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 21: {
                        break;
                    }
                    default: {
                        this.jj_la1[121] = this.jj_gen;
                        break block15;
                    }
                }
                this.jj_consume_token(21);
            }
            ArrayList<CssProperty> v = this.declarations();
            this.jj_consume_token(46);
            block16: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 21: {
                        break;
                    }
                    default: {
                        this.jj_la1[122] = this.jj_gen;
                        break block16;
                    }
                }
                this.jj_consume_token(21);
            }
            if (isSVG) {
                this.addProperty(v);
                this.endOfRule();
                this.endOfAtRule();
            }
            if (v == null) {
            } else {
                this.handleRule(s, v);
            }
        }
        catch (ParseException e) {
            if (isSVG) {
                this.addError((Exception)e, this.skipStatement());
            }
        }
        finally {
            this.setAtRule(old);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void viewport() throws ParseException {
        AtRule old = this.getAtRule();
        this.setAtRule(new AtRuleViewport());
        CssSelectors s = new CssSelectors(this.ac);
        s.setAtRule(this.getAtRule());
        CssVersion version = this.ac.getCssVersion();
        try {
            this.jj_consume_token(108);
            block14: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 21: {
                        break;
                    }
                    default: {
                        this.jj_la1[123] = this.jj_gen;
                        break block14;
                    }
                }
                this.jj_consume_token(21);
            }
            if (version.compareTo(CssVersion.CSS3) < 0) {
                this.skipStatement();
                this.addError((Exception)new InvalidParamException("noatruleyet", "", this.ac), this.getAtRule().toString());
            } else {
                this.newAtRule(this.getAtRule());
            }
            this.jj_consume_token(27);
            block15: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 21: {
                        break;
                    }
                    default: {
                        this.jj_la1[124] = this.jj_gen;
                        break block15;
                    }
                }
                this.jj_consume_token(21);
            }
            ArrayList<CssProperty> v = this.declarations();
            this.jj_consume_token(46);
            block16: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 21: {
                        break;
                    }
                    default: {
                        this.jj_la1[125] = this.jj_gen;
                        break block16;
                    }
                }
                this.jj_consume_token(21);
            }
            if (version.compareTo(CssVersion.CSS3) >= 0) {
                this.addProperty(v);
                this.endOfRule();
                this.endOfAtRule();
            }
            if (v == null) {
                this.ac.getFrame().addWarning("no-declaration");
            } else {
                this.handleRule(s, v);
            }
        }
        catch (ParseException e) {
            if (version.compareTo(CssVersion.CSS3) < 0) {
                this.addError((Exception)e, this.skipStatement());
            }
        }
        finally {
            this.setAtRule(old);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void counterstyle() throws ParseException {
        AtRule old = this.getAtRule();
        AtRuleCounterStyle csrule = new AtRuleCounterStyle();
        this.setAtRule(csrule);
        CssSelectors s = new CssSelectors(this.ac);
        CssVersion version = this.ac.getCssVersion();
        try {
            this.jj_consume_token(105);
            block17: while (true) {
                this.jj_consume_token(21);
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 21: {
                        continue block17;
                    }
                }
                break;
            }
            this.jj_la1[126] = this.jj_gen;
            Token n = this.ident();
            block18: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 21: {
                        break;
                    }
                    default: {
                        this.jj_la1[127] = this.jj_gen;
                        break block18;
                    }
                }
                this.jj_consume_token(21);
            }
            csrule.setName(this.convertIdent(n.image));
            if (version.compareTo(CssVersion.CSS3) < 0) {
                this.skipStatement();
                this.addError((Exception)new InvalidParamException("noatruleyet", "", this.ac), this.getAtRule().toString());
            } else {
                this.newAtRule(this.getAtRule());
            }
            this.jj_consume_token(27);
            block19: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 21: {
                        break;
                    }
                    default: {
                        this.jj_la1[128] = this.jj_gen;
                        break block19;
                    }
                }
                this.jj_consume_token(21);
            }
            ArrayList<CssProperty> v = this.declarations();
            this.jj_consume_token(46);
            block20: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 21: {
                        break;
                    }
                    default: {
                        this.jj_la1[129] = this.jj_gen;
                        break block20;
                    }
                }
                this.jj_consume_token(21);
            }
            if (version.compareTo(CssVersion.CSS3) >= 0) {
                this.addProperty(v);
                this.endOfRule();
                this.endOfAtRule();
            }
            if (v == null) {
                this.ac.getFrame().addWarning("no-declaration");
            } else {
                this.handleRule(s, v);
            }
        }
        catch (ParseException e) {
            this.addError((Exception)e, this.skipStatement());
        }
        finally {
            this.setAtRule(old);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void preference() throws ParseException {
        AtRule old = this.getAtRule();
        this.setAtRule(new AtRulePreference());
        CssSelectors s = new CssSelectors(this.ac);
        s.setAtRule(this.getAtRule());
        boolean isCSS1 = this.ac.getCssVersion() == CssVersion.CSS1;
        try {
            this.jj_consume_token(102);
            block14: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 21: {
                        break;
                    }
                    default: {
                        this.jj_la1[130] = this.jj_gen;
                        break block14;
                    }
                }
                this.jj_consume_token(21);
            }
            if (isCSS1) {
                this.skipStatement();
                this.addError((Exception)new InvalidParamException("noatruleyet", "", this.ac), this.getAtRule().toString());
            } else {
                this.newAtRule(this.getAtRule());
            }
            this.jj_consume_token(27);
            block15: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 21: {
                        break;
                    }
                    default: {
                        this.jj_la1[131] = this.jj_gen;
                        break block15;
                    }
                }
                this.jj_consume_token(21);
            }
            ArrayList<CssProperty> v = this.declarations();
            this.jj_consume_token(46);
            block16: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 21: {
                        break;
                    }
                    default: {
                        this.jj_la1[132] = this.jj_gen;
                        break block16;
                    }
                }
                this.jj_consume_token(21);
            }
            if (!isCSS1) {
                this.addProperty(v);
                this.endOfRule();
                this.endOfAtRule();
            }
            if (v == null) {
                this.ac.getFrame().addWarning("medialist");
            } else {
                this.handleRule(s, v);
            }
        }
        catch (ParseException e) {
            if (!isCSS1) {
                this.addError((Exception)e, this.skipStatement());
            }
        }
        finally {
            this.setAtRule(old);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void phoneticAlphabet() throws ParseException {
        AtRule old = this.getAtRule();
        AtRulePhoneticAlphabet alphabetrule = new AtRulePhoneticAlphabet();
        this.setAtRule(alphabetrule);
        CssVersion version = this.ac.getCssVersion();
        try {
            this.jj_consume_token(106);
            block11: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 21: {
                        break;
                    }
                    default: {
                        this.jj_la1[133] = this.jj_gen;
                        break block11;
                    }
                }
                this.jj_consume_token(21);
            }
            Token n = this.jj_consume_token(39);
            block12: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 21: {
                        break;
                    }
                    default: {
                        this.jj_la1[134] = this.jj_gen;
                        break block12;
                    }
                }
                this.jj_consume_token(21);
            }
            this.jj_consume_token(51);
            if (version.compareTo(CssVersion.CSS3) < 0) {
                this.skipStatement();
                this.addError((Exception)new InvalidParamException("noatruleyet", "", this.ac), this.getAtRule().toString());
            }
            alphabetrule.addAlphabet(this.convertIdent(n.image), this.ac);
            if (version != CssVersion.CSS1 && version != CssVersion.CSS2) {
                this.newAtRule(this.getAtRule());
            }
        }
        catch (ParseException e) {
            if (version != CssVersion.CSS1) {
                this.addError((Exception)e, this.skipStatement());
            }
        }
        finally {
            this.setAtRule(old);
        }
    }

    public final void atRuleDeclaration() throws ParseException {
        Token n = this.jj_consume_token(109);
        if (n.toString().charAt(1) == '-' && this.ac.getTreatVendorExtensionsAsWarnings()) {
            this.ac.getFrame().addWarning("at-rule", n.toString());
        } else {
            this.addAtRuleError();
        }
        this.skipStatement();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 21: {
                    break;
                }
                default: {
                    this.jj_la1[135] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(21);
        }
    }

    void addAtRuleError() throws ParseException {
        this.ac.getFrame().addError(new CssError(this.getSourceFile(), this.getBeginLine(), this.getBeginColumn(), this.getEndLine(), this.getEndColumn(), new InvalidParamException("at-rule", this.token, this.ac)));
    }

    public final void operator(CssExpression expr) throws ParseException {
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 32: {
                this.jj_consume_token(32);
                if (expr.getCount() > 0) {
                    expr.setOperator(',');
                }
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 21: {
                            break;
                        }
                        default: {
                            this.jj_la1[136] = this.jj_gen;
                            break block0;
                        }
                    }
                    this.jj_consume_token(21);
                }
            }
            default: {
                this.jj_la1[137] = this.jj_gen;
            }
        }
    }

    public final String combinator() throws ParseException {
        String connector = " ";
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 28: 
            case 30: 
            case 33: 
            case 34: {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 28: {
                        this.jj_consume_token(28);
                        connector = "+";
                        break;
                    }
                    case 30: {
                        this.jj_consume_token(30);
                        connector = ">";
                        break;
                    }
                    case 33: {
                        this.jj_consume_token(33);
                        connector = "~";
                        break;
                    }
                    case 34: {
                        this.jj_consume_token(34);
                        connector = "||";
                        break;
                    }
                    default: {
                        this.jj_la1[138] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 21: {
                            break;
                        }
                        default: {
                            this.jj_la1[139] = this.jj_gen;
                            break block0;
                        }
                    }
                    this.jj_consume_token(21);
                }
            }
            case 21: {
                block17: while (true) {
                    this.jj_consume_token(21);
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 21: {
                            continue block17;
                        }
                    }
                    break;
                }
                this.jj_la1[140] = this.jj_gen;
                connector = " ";
                break;
            }
            default: {
                this.jj_la1[141] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return connector;
    }

    public final char unaryOperator() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 29: {
                this.jj_consume_token(29);
                return '-';
            }
            case 28: {
                this.jj_consume_token(28);
                return '+';
            }
        }
        this.jj_la1[142] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final CssANPlusB anplusb() throws ParseException {
        Token n = null;
        Token b = null;
        char op = ' ';
        char pb = ' ';
        CssANPlusB anpb = new CssANPlusB();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 41: {
                n = this.ident();
                if (this.jj_2_5(2)) {
                    block36: while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 21: {
                                break;
                            }
                            default: {
                                this.jj_la1[143] = this.jj_gen;
                                break block36;
                            }
                        }
                        this.jj_consume_token(21);
                    }
                    block6 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 28: 
                        case 29: {
                            pb = this.unaryOperator();
                            while (true) {
                                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                    case 21: {
                                        break;
                                    }
                                    default: {
                                        this.jj_la1[144] = this.jj_gen;
                                        break block6;
                                    }
                                }
                                this.jj_consume_token(21);
                            }
                        }
                        default: {
                            this.jj_la1[145] = this.jj_gen;
                        }
                    }
                    b = this.jj_consume_token(75);
                }
                anpb.set(n.image, pb, b != null ? b.image : null, "An+B", this.ac);
                return anpb;
            }
        }
        this.jj_la1[153] = this.jj_gen;
        if (this.jj_2_8(2)) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 28: 
                case 29: {
                    op = this.unaryOperator();
                    break;
                }
                default: {
                    this.jj_la1[146] = this.jj_gen;
                }
            }
            b = this.jj_consume_token(75);
            if (op == ' ') {
                anpb.set(b.image, this.ac);
            } else {
                anpb.set("" + op + b.image, this.ac);
            }
            return anpb;
        }
        if (this.jj_2_9(2)) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 28: 
                case 29: {
                    op = this.unaryOperator();
                    break;
                }
                default: {
                    this.jj_la1[147] = this.jj_gen;
                }
            }
            n = this.jj_consume_token(71);
            if (this.jj_2_6(2)) {
                block38: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 21: {
                            break;
                        }
                        default: {
                            this.jj_la1[148] = this.jj_gen;
                            break block38;
                        }
                    }
                    this.jj_consume_token(21);
                }
                block21 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 28: 
                    case 29: {
                        pb = this.unaryOperator();
                        while (true) {
                            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                case 21: {
                                    break;
                                }
                                default: {
                                    this.jj_la1[149] = this.jj_gen;
                                    break block21;
                                }
                            }
                            this.jj_consume_token(21);
                        }
                    }
                    default: {
                        this.jj_la1[150] = this.jj_gen;
                    }
                }
                b = this.jj_consume_token(75);
            }
            anpb.set(op, n.image, pb, b != null ? b.image : null, "An+B", this.ac);
            return anpb;
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 28: 
            case 29: 
            case 73: {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 28: 
                    case 29: {
                        op = this.unaryOperator();
                        break;
                    }
                    default: {
                        this.jj_la1[151] = this.jj_gen;
                    }
                }
                n = this.jj_consume_token(73);
                if (this.jj_2_7(2)) {
                    block40: while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 21: {
                                break;
                            }
                            default: {
                                this.jj_la1[152] = this.jj_gen;
                                break block40;
                            }
                        }
                        this.jj_consume_token(21);
                    }
                    b = this.jj_consume_token(75);
                }
                anpb.set(op, n.image, b != null ? b.image : null, "An+B", this.ac);
                return anpb;
            }
        }
        this.jj_la1[154] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final String property() throws ParseException {
        Token hack = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 28: 
            case 30: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 41: 
            case 45: 
            case 50: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 57: 
            case 58: 
            case 59: 
            case 146: 
            case 147: 
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 152: 
            case 153: {
                Token n;
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 28: 
                    case 30: 
                    case 32: 
                    case 33: 
                    case 35: 
                    case 36: 
                    case 37: 
                    case 38: 
                    case 41: 
                    case 50: 
                    case 52: 
                    case 53: 
                    case 54: 
                    case 55: 
                    case 57: 
                    case 58: 
                    case 59: 
                    case 146: 
                    case 147: 
                    case 148: 
                    case 149: 
                    case 150: 
                    case 151: 
                    case 152: 
                    case 153: {
                        block8 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 28: 
                            case 30: 
                            case 32: 
                            case 33: 
                            case 50: 
                            case 52: 
                            case 53: 
                            case 54: 
                            case 55: 
                            case 57: 
                            case 58: 
                            case 59: 
                            case 146: 
                            case 147: 
                            case 148: 
                            case 149: 
                            case 150: 
                            case 151: 
                            case 152: 
                            case 153: {
                                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                    case 146: {
                                        hack = this.jj_consume_token(146);
                                        break block8;
                                    }
                                    case 147: {
                                        hack = this.jj_consume_token(147);
                                        break block8;
                                    }
                                    case 148: {
                                        hack = this.jj_consume_token(148);
                                        break block8;
                                    }
                                    case 149: {
                                        hack = this.jj_consume_token(149);
                                        break block8;
                                    }
                                    case 150: {
                                        hack = this.jj_consume_token(150);
                                        break block8;
                                    }
                                    case 151: {
                                        hack = this.jj_consume_token(151);
                                        break block8;
                                    }
                                    case 152: {
                                        hack = this.jj_consume_token(152);
                                        break block8;
                                    }
                                    case 153: {
                                        hack = this.jj_consume_token(153);
                                        break block8;
                                    }
                                    case 55: {
                                        hack = this.jj_consume_token(55);
                                        break block8;
                                    }
                                    case 50: {
                                        hack = this.jj_consume_token(50);
                                        break block8;
                                    }
                                    case 54: {
                                        hack = this.jj_consume_token(54);
                                        break block8;
                                    }
                                    case 53: {
                                        hack = this.jj_consume_token(53);
                                        break block8;
                                    }
                                    case 57: {
                                        hack = this.jj_consume_token(57);
                                        break block8;
                                    }
                                    case 58: {
                                        hack = this.jj_consume_token(58);
                                        break block8;
                                    }
                                    case 59: {
                                        hack = this.jj_consume_token(59);
                                        break block8;
                                    }
                                    case 33: {
                                        hack = this.jj_consume_token(33);
                                        break block8;
                                    }
                                    case 28: {
                                        hack = this.jj_consume_token(28);
                                        break block8;
                                    }
                                    case 32: {
                                        hack = this.jj_consume_token(32);
                                        break block8;
                                    }
                                    case 30: {
                                        hack = this.jj_consume_token(30);
                                        break block8;
                                    }
                                    case 52: {
                                        hack = this.jj_consume_token(52);
                                        break block8;
                                    }
                                }
                                this.jj_la1[155] = this.jj_gen;
                                this.jj_consume_token(-1);
                                throw new ParseException();
                            }
                            default: {
                                this.jj_la1[156] = this.jj_gen;
                            }
                        }
                        n = this.ident();
                        break;
                    }
                    case 45: {
                        n = this.jj_consume_token(45);
                        break;
                    }
                    default: {
                        this.jj_la1[157] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                block41: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 21: {
                            break;
                        }
                        default: {
                            this.jj_la1[158] = this.jj_gen;
                            break block41;
                        }
                    }
                    this.jj_consume_token(21);
                }
                this.currentProperty = this.convertIdent(n.image);
                if (hack != null && !"".equals(hack)) {
                    String hackp = hack.image + this.currentProperty;
                    if (this.ac.getTreatCssHacksAsWarnings()) {
                        this.ac.getFrame().addWarning("css-hack", hackp);
                        return null;
                    }
                    throw new ParseException(String.format(this.ac.getMsg().getString("warning.css-hack"), hackp));
                }
                return this.currentProperty;
            }
            case 42: 
            case 56: 
            case 109: {
                Token n;
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 42: {
                        n = this.jj_consume_token(42);
                        break;
                    }
                    case 56: {
                        this.jj_consume_token(56);
                        n = this.ident();
                        break;
                    }
                    case 109: {
                        n = this.jj_consume_token(109);
                        break;
                    }
                    default: {
                        this.jj_la1[159] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                if (this.ac.getTreatCssHacksAsWarnings()) {
                    this.ac.getFrame().addWarning("css-hack", n.image);
                    this.currentProperty = this.convertIdent(n.image).substring(1);
                    return null;
                }
                throw new ParseException(String.format(this.ac.getMsg().getString("warning.css-hack"), n.image));
            }
        }
        this.jj_la1[161] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ArrayList<CssSelectors> selector_list() throws ParseException {
        ArrayList<CssSelectors> context_set = new ArrayList<CssSelectors>();
        CssSelectors selector = this.complex_selector(null);
        if (selector != null) {
            context_set.add(selector);
        }
        block6: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 32: {
                    break;
                }
                default: {
                    this.jj_la1[162] = this.jj_gen;
                    break block6;
                }
            }
            this.jj_consume_token(32);
            block7: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 21: {
                        break;
                    }
                    default: {
                        this.jj_la1[163] = this.jj_gen;
                        break block7;
                    }
                }
                this.jj_consume_token(21);
            }
            selector = this.complex_selector(null);
            if (selector == null) continue;
            context_set.add(selector);
        }
        return context_set;
    }

    public final ArrayList<CssSelectors> relative_selector_list() throws ParseException {
        ArrayList<CssSelectors> context_set = new ArrayList<CssSelectors>();
        CssSelectors selector = this.relative_selector();
        if (selector != null) {
            context_set.add(selector);
        }
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 32: {
                    break;
                }
                default: {
                    this.jj_la1[164] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(32);
            selector = this.relative_selector();
            if (selector == null) continue;
            context_set.add(selector);
        }
        return context_set;
    }

    public final void ruleSet() throws ParseException {
        ArrayList<CssSelectors> context_set = null;
        ArrayList<CssProperty> value_set = null;
        this.currentContext = context_set;
        try {
            context_set = this.selector_list();
            this.jj_consume_token(27);
            boolean bl = this.validSelector = context_set.size() > 0;
            if (this.validSelector) {
                this.currentContext = context_set;
            }
            block9: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 21: {
                        break;
                    }
                    default: {
                        this.jj_la1[165] = this.jj_gen;
                        break block9;
                    }
                }
                this.jj_consume_token(21);
            }
            value_set = this.declarations();
            this.jj_consume_token(46);
            block10: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 21: {
                        break;
                    }
                    default: {
                        this.jj_la1[166] = this.jj_gen;
                        break block10;
                    }
                }
                this.jj_consume_token(21);
            }
            this.markRule = true;
            if (value_set != null) {
                boolean first = true;
                for (CssSelectors sel : context_set) {
                    if (first) {
                        this.handleRule(sel, value_set);
                        first = false;
                        continue;
                    }
                    int vsize = value_set.size();
                    ArrayList<CssProperty> v = new ArrayList<CssProperty>(vsize);
                    for (CssProperty p : value_set) {
                        v.add(p.duplicate());
                    }
                    this.handleRule(sel, v);
                }
                this.setSelectorList(context_set);
                this.endOfRule();
            }
            this.currentContext = null;
        }
        catch (ParseException e) {
            if (this.ac.getCssProfile() != CssProfile.MOBILE && !context_set.isEmpty()) {
                String ret = this.skipStatement();
                CssVersion version = this.ac.getCssVersion();
                Token t1 = this.getToken(0);
                if (version.compareTo(CssVersion.CSS3) < 0) {
                    this.addError((Exception)e, ret);
                } else if (ret != null && !ret.contains("/*") && t1 != null && t1.kind != 0) {
                    this.addError((Exception)e, ret);
                } else if (!context_set.isEmpty() && value_set == null) {
                    this.addError((Exception)e, ret);
                } else {
                    if (version.compareTo(CssVersion.CSS3) >= 0) {
                        this.markRule = true;
                        if (value_set != null) {
                            boolean first = true;
                            for (CssSelectors sel : context_set) {
                                if (first) {
                                    this.handleRule(sel, value_set);
                                    first = false;
                                    continue;
                                }
                                int vsize = value_set.size();
                                ArrayList<CssProperty> v = new ArrayList<CssProperty>(vsize);
                                for (CssProperty p : value_set) {
                                    v.add(p.duplicate());
                                }
                                this.handleRule(sel, v);
                            }
                            this.setSelectorList(context_set);
                            this.endOfRule();
                        } else {
                            this.addError((Exception)e, ret);
                        }
                    }
                    this.currentContext = null;
                }
            }
        }
        catch (TokenMgrError e) {
            this.addError((Exception)new ParseException(e.getMessage()), this.skipStatement());
        }
    }

    public final ArrayList<CssProperty> declarations() throws ParseException {
        CssProperty values;
        if (!this.validSelector) {
            this.validSelector = true;
            this.skip_to_matching_brace();
            return null;
        }
        ArrayList<CssProperty> value_set = new ArrayList<CssProperty>();
        boolean wrong_value = true;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 28: 
            case 30: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 41: 
            case 42: 
            case 45: 
            case 50: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 109: 
            case 146: 
            case 147: 
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 152: 
            case 153: {
                values = this.declaration();
                if (values != null) {
                    value_set.add(values);
                    wrong_value = false;
                }
                this.currentProperty = null;
                break;
            }
            default: {
                this.jj_la1[167] = this.jj_gen;
            }
        }
        block12: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 51: {
                    break;
                }
                default: {
                    this.jj_la1[168] = this.jj_gen;
                    break block12;
                }
            }
            this.jj_consume_token(51);
            block13: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 21: {
                        break;
                    }
                    default: {
                        this.jj_la1[169] = this.jj_gen;
                        break block13;
                    }
                }
                this.jj_consume_token(21);
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 28: 
                case 30: 
                case 32: 
                case 33: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 41: 
                case 42: 
                case 45: 
                case 50: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 58: 
                case 59: 
                case 109: 
                case 146: 
                case 147: 
                case 148: 
                case 149: 
                case 150: 
                case 151: 
                case 152: 
                case 153: {
                    values = this.declaration();
                    if (values != null) {
                        value_set.add(values);
                        wrong_value = false;
                    }
                    this.currentProperty = null;
                    continue block12;
                }
            }
            this.jj_la1[170] = this.jj_gen;
        }
        if (!wrong_value) {
            this.addProperty(value_set);
            return value_set;
        }
        return null;
    }

    public final ArrayList<CssProperty> attributeDeclarations() throws ParseException {
        ArrayList<CssProperty> p = null;
        try {
            block5: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 21: {
                        break;
                    }
                    default: {
                        this.jj_la1[171] = this.jj_gen;
                        break block5;
                    }
                }
                this.jj_consume_token(21);
            }
            p = this.declarations();
            return p;
        }
        catch (TokenMgrError tokenerror) {
            throw new ParseException(this.ac.getMsg().getString("generator.unrecognize"));
        }
    }

    public final CssSelectors relative_selector() throws ParseException {
        String comb = "*none*";
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 21: 
            case 28: 
            case 30: 
            case 33: 
            case 34: {
                comb = this.combinator();
                break;
            }
            default: {
                this.jj_la1[172] = this.jj_gen;
            }
        }
        CssSelectors current = new CssSelectors(this.ac);
        switch (comb) {
            case "+": {
                current.addNextSiblingCombinator();
                break;
            }
            case ">": {
                current.addChildCombinator();
                break;
            }
            case "~": {
                current.addSubsequentSiblingCombinator();
                break;
            }
            case "||": {
                current.addColumnCombinator();
                break;
            }
            case "*none*": {
                break;
            }
            default: {
                current.addDescendantCombinator();
            }
        }
        current = this.complex_selector(current);
        return current;
    }

    public final CssSelectors externalSelector() throws ParseException {
        CssSelectors current = this.simple_selector(null);
        block6: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 21: {
                    break;
                }
                default: {
                    this.jj_la1[173] = this.jj_gen;
                    break block6;
                }
            }
            block7: while (true) {
                this.jj_consume_token(21);
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 21: {
                        continue block7;
                    }
                }
                break;
            }
            this.jj_la1[174] = this.jj_gen;
            current = this.simple_selector(current);
        }
        return current;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final CssSelectors simple_selector(CssSelectors next) throws ParseException {
        CssSelectors selector = new CssSelectors(this.ac, next);
        selector.setAtRule(this.getAtRule());
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 41: 
            case 55: 
            case 153: {
                this.type_selector(selector);
                block22: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 42: 
                        case 43: 
                        case 53: 
                        case 56: 
                        case 59: 
                        case 61: 
                        case 62: 
                        case 63: 
                        case 65: 
                        case 68: 
                        case 69: 
                        case 70: 
                        case 73: 
                        case 78: {
                            break;
                        }
                        default: {
                            this.jj_la1[175] = this.jj_gen;
                            return selector;
                        }
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 42: 
                        case 43: {
                            this.id_selector(selector);
                            continue block22;
                        }
                        case 56: 
                        case 61: 
                        case 62: 
                        case 63: 
                        case 65: 
                        case 68: 
                        case 69: 
                        case 70: 
                        case 73: {
                            this.class_selector(selector);
                            continue block22;
                        }
                        case 53: {
                            this.attribute_selector(selector);
                            continue block22;
                        }
                        case 59: 
                        case 78: {
                            this.pseudo(selector);
                            continue block22;
                        }
                    }
                    break;
                }
                this.jj_la1[176] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            case 42: 
            case 43: 
            case 53: 
            case 56: 
            case 59: 
            case 61: 
            case 62: 
            case 63: 
            case 65: 
            case 68: 
            case 69: 
            case 70: 
            case 73: 
            case 78: {
                block23: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 42: 
                        case 43: {
                            this.id_selector(selector);
                            break;
                        }
                        case 56: 
                        case 61: 
                        case 62: 
                        case 63: 
                        case 65: 
                        case 68: 
                        case 69: 
                        case 70: 
                        case 73: {
                            this.class_selector(selector);
                            break;
                        }
                        case 53: {
                            this.attribute_selector(selector);
                            break;
                        }
                        case 59: 
                        case 78: {
                            this.pseudo(selector);
                            break;
                        }
                        default: {
                            this.jj_la1[177] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 42: 
                        case 43: 
                        case 53: 
                        case 56: 
                        case 59: 
                        case 61: 
                        case 62: 
                        case 63: 
                        case 65: 
                        case 68: 
                        case 69: 
                        case 70: 
                        case 73: 
                        case 78: {
                            continue block23;
                        }
                    }
                    break;
                }
                this.jj_la1[178] = this.jj_gen;
                return selector;
            }
        }
        this.jj_la1[179] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final CssSelectors subclass_selector(CssSelectors selector) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 42: 
            case 43: {
                this.id_selector(selector);
                break;
            }
            case 56: 
            case 61: 
            case 62: 
            case 63: 
            case 65: 
            case 68: 
            case 69: 
            case 70: 
            case 73: {
                this.class_selector(selector);
                break;
            }
            case 53: {
                this.attribute_selector(selector);
                break;
            }
            case 59: {
                this.pseudo_class_selector(selector);
                break;
            }
            default: {
                this.jj_la1[180] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return selector;
    }

    public final CssSelectors complex_selector(CssSelectors sel) throws ParseException {
        String comb = "*none*";
        try {
            CssSelectors current = this.compound_selector(sel);
            while (this.jj_2_10(2)) {
                block1 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 21: 
                    case 28: 
                    case 30: 
                    case 33: 
                    case 34: {
                        comb = this.combinator();
                        if (this.ac.getCssProfile() == CssProfile.MOBILE || this.getAtRule().toString().equals("@media atsc-tv") || this.ac.getCssVersion() == CssVersion.CSS1 ? comb.equals("+") || comb.equals(">") : this.ac.getCssProfile() == CssProfile.TV && comb.equals("+")) {
                            throw new InvalidParamException("nocomb", comb, this.ac);
                        }
                        if (this.ac.getCssVersion().compareTo(CssVersion.CSS3) < 0 && (comb.equals("~") || comb.equals("||"))) {
                            throw new InvalidParamException("nocomb", comb, this.ac);
                        }
                        switch (comb) {
                            case "+": {
                                current.addNextSiblingCombinator();
                                break block1;
                            }
                            case ">": {
                                current.addChildCombinator();
                                break block1;
                            }
                            case "~": {
                                current.addSubsequentSiblingCombinator();
                                break block1;
                            }
                            case "||": {
                                current.addColumnCombinator();
                                break block1;
                            }
                            case "*none*": {
                                break block1;
                            }
                        }
                        current.addDescendantCombinator();
                        break;
                    }
                    default: {
                        this.jj_la1[181] = this.jj_gen;
                    }
                }
                current = this.compound_selector(current);
            }
            return current;
        }
        catch (InvalidParamException ie) {
            this.ac.getFrame().addError(new CssError(this.getSourceFile(), this.getBeginLine(), this.getBeginColumn(), this.getEndLine(), this.getEndColumn(), ie));
            Token t = this.getToken(1);
            StringBuilder s = new StringBuilder();
            s.append(this.getToken((int)0).image);
            while (t.kind != 32 && t.kind != 27 && t.kind != 0) {
                s.append(t.image);
                this.getNextToken();
                t = this.getToken(1);
            }
            return null;
        }
        catch (ParseException e) {
            Token t = this.getToken(1);
            StringBuilder s = new StringBuilder("[");
            s.append(this.getToken((int)0).image);
            while (t.kind != 32 && t.kind != 27 && t.kind != 0) {
                s.append(t.image);
                this.getNextToken();
                t = this.getToken(1);
            }
            s.append(']');
            this.addError((Exception)e, s.toString());
            this.validSelector = true;
            return null;
        }
    }

    public final CssSelectors compound_selector(CssSelectors next) throws ParseException {
        CssSelectors selector;
        block24: {
            selector = new CssSelectors(this.ac, next);
            selector.setAtRule(this.getAtRule());
            if (this.jj_2_15(4)) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 35: 
                    case 36: 
                    case 37: 
                    case 38: 
                    case 41: 
                    case 55: 
                    case 153: {
                        this.type_selector(selector);
                        break;
                    }
                    default: {
                        this.jj_la1[182] = this.jj_gen;
                    }
                }
                block16: while (true) {
                    this.subclass_selector(selector);
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 42: 
                        case 43: 
                        case 53: 
                        case 56: 
                        case 59: 
                        case 61: 
                        case 62: 
                        case 63: 
                        case 65: 
                        case 68: 
                        case 69: 
                        case 70: 
                        case 73: {
                            continue block16;
                        }
                    }
                    break;
                }
                this.jj_la1[183] = this.jj_gen;
                block17: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 78: {
                            break;
                        }
                        default: {
                            this.jj_la1[184] = this.jj_gen;
                            break block24;
                        }
                    }
                    this.pseudo_element_selector(selector);
                    while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 59: {
                                break;
                            }
                            default: {
                                this.jj_la1[185] = this.jj_gen;
                                continue block17;
                            }
                        }
                        this.pseudo_class_selector(selector);
                    }
                    break;
                }
            }
            block12 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 41: 
                case 55: 
                case 153: {
                    this.type_selector(selector);
                    while (this.jj_2_11(2)) {
                        this.pseudo_element_selector(selector);
                        while (this.jj_2_12(2)) {
                            this.pseudo_class_selector(selector);
                        }
                    }
                    break;
                }
                case 78: {
                    while (true) {
                        this.pseudo_element_selector(selector);
                        while (this.jj_2_13(2)) {
                            this.pseudo_class_selector(selector);
                        }
                        if (!this.jj_2_14(2)) break block12;
                    }
                }
                default: {
                    this.jj_la1[186] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        return selector;
    }

    public final void class_selector(CssSelectors s) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 56: {
                this.jj_consume_token(56);
                Token n = this.ident();
                try {
                    s.addClass(new ClassSelector(this.convertClassIdent(n.image)));
                    break;
                }
                catch (InvalidParamException e) {
                    this.ac.getFrame().addError(new CssError(this.getSourceFile(), this.getBeginLine(), this.getBeginColumn(), this.getEndLine(), this.getEndColumn(), e));
                    throw new ParseException(e.getMessage());
                }
            }
            case 61: 
            case 62: 
            case 63: 
            case 65: 
            case 68: 
            case 69: 
            case 70: 
            case 73: {
                Token n = this.deprecated_class();
                if (n.image.charAt(0) == '.') {
                    n.image = n.image.substring(1);
                    String cl = "." + this.hexEscapeFirst(n.image);
                    CssVersion version = this.ac.getCssVersion();
                    if (version != CssVersion.CSS1) {
                        StringBuilder sb = new StringBuilder();
                        ArrayList<String> param_err = new ArrayList<String>(2);
                        param_err.add(n.image);
                        param_err.add(cl);
                        sb.append(this.ac.getMsg().getString("parser.old_class", param_err));
                        throw new ParseException(sb.toString());
                    }
                    CssLength length = new CssLength();
                    boolean isLength = false;
                    try {
                        length.set(n.image, this.ac);
                        isLength = true;
                    }
                    catch (Exception e) {
                        isLength = false;
                    }
                    if (isLength) {
                        StringBuilder sb = new StringBuilder();
                        sb.append(this.ac.getMsg().getString("parser.class_dim"));
                        sb.append(n.image);
                        throw new ParseException(sb.toString());
                    }
                    try {
                        s.addClass(new ClassSelector(n.image));
                        this.ac.getFrame().addWarning("old_class");
                        break;
                    }
                    catch (InvalidParamException e) {
                        throw new ParseException(e.getMessage());
                    }
                }
                throw new ParseException("Unrecognized ");
            }
            default: {
                this.jj_la1[187] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final Token deprecated_class() throws ParseException {
        Token n;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 61: {
                n = this.jj_consume_token(61);
                break;
            }
            case 62: {
                n = this.jj_consume_token(62);
                break;
            }
            case 63: {
                n = this.jj_consume_token(63);
                break;
            }
            case 65: {
                n = this.jj_consume_token(65);
                break;
            }
            case 68: {
                n = this.jj_consume_token(68);
                break;
            }
            case 69: {
                n = this.jj_consume_token(69);
                break;
            }
            case 70: {
                n = this.jj_consume_token(70);
                break;
            }
            case 73: {
                n = this.jj_consume_token(73);
                break;
            }
            default: {
                this.jj_la1[188] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return n;
    }

    public final void type_selector(CssSelectors s) throws ParseException {
        Token n = null;
        Token p = null;
        String prefix = null;
        if (this.jj_2_16(2)) {
            block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 41: 
                case 55: {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 35: 
                        case 36: 
                        case 37: 
                        case 38: 
                        case 41: {
                            n = this.ident();
                            break block0;
                        }
                        case 55: {
                            n = this.jj_consume_token(55);
                            break block0;
                        }
                    }
                    this.jj_la1[189] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
                default: {
                    this.jj_la1[190] = this.jj_gen;
                }
            }
            p = this.jj_consume_token(153);
        }
        if (p != null) {
            if (this.ac.getCssVersion().compareTo(CssVersion.CSS3) < 0) {
                StringBuilder sb = new StringBuilder("namespace \"");
                if (n != null) {
                    sb.append(n.toString());
                }
                sb.append("\"");
                this.ac.getFrame().addError(new CssError(this.getSourceFile(), this.getBeginLine(), this.getBeginColumn(), this.getEndLine(), this.getEndColumn(), new InvalidParamException("notversion", sb.toString(), this.ac.getCssVersionString(), this.ac)));
                this.removeThisRule();
            } else if (n != null) {
                prefix = this.convertIdent(n.image);
                if (!this.ac.isNamespaceDefined(this.getURL(), prefix)) {
                    this.addError((Exception)new ParseException("Undefined namespace"), ": The namespace \"" + prefix + "\" is not defined. " + prefix);
                    this.removeThisRule();
                }
            } else {
                prefix = "";
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 41: {
                n = this.ident();
                s.addType(new TypeSelector(prefix, this.convertIdent(n.image)));
                break;
            }
            case 55: {
                this.jj_consume_token(55);
                if (this.ac.getCssVersion() != CssVersion.CSS1) {
                    s.addUniversal(new UniversalSelector(prefix));
                    break;
                }
                this.ac.getFrame().addError(new CssError(this.getSourceFile(), this.getBeginLine(), this.getBeginColumn(), this.getEndLine(), this.getEndColumn(), new InvalidParamException("notversion", "*", this.ac.getCssVersionString(), this.ac)));
                break;
            }
            default: {
                this.jj_la1[191] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void attribute_selector(CssSelectors s) throws ParseException {
        CharSequence reason;
        Token att = null;
        Token val = null;
        Token mod = null;
        Token pre = null;
        int selectorType = -1;
        this.jj_consume_token(53);
        block49: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 21: {
                    break;
                }
                default: {
                    this.jj_la1[192] = this.jj_gen;
                    break block49;
                }
            }
            this.jj_consume_token(21);
        }
        if (this.jj_2_17(2)) {
            block5 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 41: 
                case 55: {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 35: 
                        case 36: 
                        case 37: 
                        case 38: 
                        case 41: {
                            pre = this.ident();
                            break block5;
                        }
                        case 55: {
                            pre = this.jj_consume_token(55);
                            break block5;
                        }
                    }
                    this.jj_la1[193] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
                default: {
                    this.jj_la1[194] = this.jj_gen;
                }
            }
            this.jj_consume_token(153);
        }
        att = this.ident();
        block50: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 21: {
                    break;
                }
                default: {
                    this.jj_la1[195] = this.jj_gen;
                    break block50;
                }
            }
            this.jj_consume_token(21);
        }
        block15 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 25: 
            case 26: 
            case 47: 
            case 48: 
            case 49: 
            case 50: {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 50: {
                        this.jj_consume_token(50);
                        selectorType = 32;
                        break;
                    }
                    case 25: {
                        this.jj_consume_token(25);
                        selectorType = 126;
                        break;
                    }
                    case 26: {
                        this.jj_consume_token(26);
                        selectorType = 124;
                        break;
                    }
                    case 47: {
                        this.jj_consume_token(47);
                        selectorType = 94;
                        break;
                    }
                    case 48: {
                        this.jj_consume_token(48);
                        selectorType = 36;
                        break;
                    }
                    case 49: {
                        this.jj_consume_token(49);
                        selectorType = 42;
                        break;
                    }
                    default: {
                        this.jj_la1[196] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                block51: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 21: {
                            break;
                        }
                        default: {
                            this.jj_la1[197] = this.jj_gen;
                            break block51;
                        }
                    }
                    this.jj_consume_token(21);
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 35: 
                    case 36: 
                    case 37: 
                    case 38: 
                    case 41: {
                        val = this.ident();
                        val.image = this.convertIdent(val.image);
                        break;
                    }
                    case 39: {
                        val = this.jj_consume_token(39);
                        val.image = this.convertStringIndex(val.image, 1, val.image.length() - 1, false);
                        break;
                    }
                    default: {
                        this.jj_la1[198] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                if (this.jj_2_18(2)) {
                    block52: while (true) {
                        this.jj_consume_token(21);
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 21: {
                                continue block52;
                            }
                        }
                        break;
                    }
                    this.jj_la1[199] = this.jj_gen;
                    mod = this.ident();
                }
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 21: {
                            break;
                        }
                        default: {
                            this.jj_la1[200] = this.jj_gen;
                            break block15;
                        }
                    }
                    this.jj_consume_token(21);
                }
            }
            default: {
                this.jj_la1[201] = this.jj_gen;
            }
        }
        this.jj_consume_token(54);
        if (this.ac.getCssVersion() == CssVersion.CSS1) {
            reason = new StringBuilder(" [");
            if (att != null) {
                ((StringBuilder)reason).append(this.convertIdent(att.image));
            }
            if (val != null) {
                ((StringBuilder)reason).append('=').append(val.image);
            }
            ((StringBuilder)reason).append(']');
            ParseException p = new ParseException(this.ac.getMsg().getString("parser.attrcss1") + ((StringBuilder)reason).toString());
            CssParseException cp = new CssParseException(p);
            this.ac.getFrame().addError(new CssError(this.getSourceFile(), this.getBeginLine(), this.getBeginColumn(), this.getEndLine(), this.getEndColumn(), cp));
            this.removeThisRule();
        }
        if (mod != null && this.ac.getCssVersion().compareTo(CssVersion.CSS3) < 0) {
            reason = mod.image;
            this.ac.getFrame().addError(new CssError(this.getSourceFile(), this.getBeginLine(), this.getBeginColumn(), this.getEndLine(), this.getEndColumn(), new InvalidParamException("notversion", reason, this.ac.getCssVersionString(), this.ac)));
            this.removeThisRule();
        }
        if (pre != null && this.ac.getCssVersion().compareTo(CssVersion.CSS3) < 0) {
            StringBuilder sb = new StringBuilder("namespace \"").append(pre.image).append('\"');
            this.ac.getFrame().addError(new CssError(this.getSourceFile(), this.getBeginLine(), this.getBeginColumn(), this.getEndLine(), this.getEndColumn(), new InvalidParamException("notversion", sb.toString(), this.ac.getCssVersionString(), this.ac)));
            this.removeThisRule();
        }
        if (selectorType == -1) {
            try {
                AttributeAny as = new AttributeAny(att.image.toLowerCase());
                if (pre != null) {
                    as.setPrefix(pre.image);
                }
                if (mod != null) {
                    as.setModifier(mod.image, this.ac);
                }
                s.addAttribute(as);
            }
            catch (InvalidParamException e) {
                this.removeThisRule();
                this.ac.getFrame().addError(new CssError(this.getSourceFile(), this.getBeginLine(), this.getBeginColumn(), this.getEndLine(), this.getEndColumn(), e));
            }
        } else {
            AttributeSelector attribute;
            switch (selectorType) {
                case 124: {
                    attribute = new AttributeBegin(att.image.toLowerCase(), val.image);
                    break;
                }
                case 32: {
                    attribute = new AttributeExact(att.image.toLowerCase(), val.image);
                    break;
                }
                case 126: {
                    attribute = new AttributeOneOf(this.ac, att.image.toLowerCase(), val.image);
                    break;
                }
                case 94: {
                    attribute = new AttributeStart(att.image.toLowerCase(), val.image);
                    break;
                }
                case 42: {
                    attribute = new AttributeSubstr(att.image.toLowerCase(), val.image);
                    break;
                }
                case 36: {
                    attribute = new AttributeSuffix(att.image.toLowerCase(), val.image);
                    break;
                }
                default: {
                    attribute = new AttributeExact(att.image.toLowerCase(), val.image);
                }
            }
            try {
                if (pre != null) {
                    attribute.setPrefix(pre.image);
                }
                if (mod != null) {
                    attribute.setModifier(mod.image, this.ac);
                }
                s.addAttribute(attribute);
            }
            catch (InvalidParamException e) {
                this.removeThisRule();
                this.ac.getFrame().addError(new CssError(this.getSourceFile(), this.getBeginLine(), this.getBeginColumn(), this.getEndLine(), this.getEndColumn(), e));
            }
        }
    }

    public final void pseudo_element_selector(CssSelectors s) throws ParseException {
        CssSelectors sel = null;
        this.jj_consume_token(78);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 41: {
                Token n = this.ident();
                try {
                    if (this.ac.getCssVersion().compareTo(CssVersion.CSS3) < 0) {
                        throw new InvalidParamException("pseudo-element", "::" + this.convertIdent(n.image).toLowerCase(), this.ac.getCssVersionString(), this.ac);
                    }
                    s.addPseudoElement(this.convertIdent(n.image).toLowerCase());
                    break;
                }
                catch (InvalidParamException e) {
                    this.validSelector = false;
                    throw new ParseException(e.getMessage());
                }
            }
            case 125: {
                Token n = this.jj_consume_token(125);
                block14: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 21: {
                            break;
                        }
                        default: {
                            this.jj_la1[202] = this.jj_gen;
                            break block14;
                        }
                    }
                    this.jj_consume_token(21);
                }
                sel = this.compound_selector(null);
                block15: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 21: {
                            break;
                        }
                        default: {
                            this.jj_la1[203] = this.jj_gen;
                            break block15;
                        }
                    }
                    this.jj_consume_token(21);
                }
                this.jj_consume_token(57);
                try {
                    ArrayList<CssSelectors> list = new ArrayList<CssSelectors>();
                    list.add(sel);
                    s.setPseudoFun(this.ac, this.convertStringIndex(n.image, 0, n.image.length() - 1, false).toLowerCase(), list);
                }
                catch (InvalidParamException e) {
                    this.removeThisRule();
                    this.ac.getFrame().addError(new CssError(this.getSourceFile(), this.getBeginLine(), this.getBeginColumn(), this.getEndLine(), this.getEndColumn(), e));
                }
                break;
            }
            default: {
                this.jj_la1[204] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void pseudo(CssSelectors s) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 78: {
                this.pseudo_element_selector(s);
                break;
            }
            case 59: {
                this.pseudo_class_selector(s);
                break;
            }
            default: {
                this.jj_la1[205] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public final void pseudo_class_selector(CssSelectors s) throws ParseException {
        id = null;
        language = null;
        param = null;
        selector_list = null;
        sel = null;
        error_str = null;
        prefix = null;
        exp = new CssExpression();
        anpb = null;
        this.jj_consume_token(59);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 41: {
                n = this.ident();
                try {
                    s.addPseudoClass(this.convertIdent(n.image).toLowerCase());
                }
                catch (InvalidParamException e) {
                    this.removeThisRule();
                    this.ac.getFrame().addError(new CssError(this.getSourceFile(), this.getBeginLine(), this.getBeginColumn(), this.getEndLine(), this.getEndColumn(), e));
                }
                break;
            }
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 143: {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 120: 
                    case 121: {
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 121: {
                                n = this.jj_consume_token(121);
                                break;
                            }
                            case 120: {
                                n = this.jj_consume_token(120);
                                break;
                            }
                            default: {
                                this.jj_la1[206] = this.jj_gen;
                                this.jj_consume_token(-1);
                                throw new ParseException();
                            }
                        }
                        block110: while (true) {
                            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                case 21: {
                                    break;
                                }
                                default: {
                                    this.jj_la1[207] = this.jj_gen;
                                    break block110;
                                }
                            }
                            this.jj_consume_token(21);
                        }
                        this.term(exp);
                        try {
                            s.setPseudoFun(this.ac, this.convertStringIndex(n.image, 0, n.image.length() - 1, false).toLowerCase(), exp);
                        }
                        catch (InvalidParamException e) {
                            this.removeThisRule();
                            this.ac.getFrame().addError(new CssError(this.getSourceFile(), this.getBeginLine(), this.getBeginColumn(), this.getEndLine(), this.getEndColumn(), e));
                        }
                        break;
                    }
                    case 122: 
                    case 134: {
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 122: {
                                n = this.jj_consume_token(122);
                                break;
                            }
                            case 134: {
                                n = this.jj_consume_token(134);
                                break;
                            }
                            default: {
                                this.jj_la1[208] = this.jj_gen;
                                this.jj_consume_token(-1);
                                throw new ParseException();
                            }
                        }
                        block111: while (true) {
                            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                case 21: {
                                    break;
                                }
                                default: {
                                    this.jj_la1[209] = this.jj_gen;
                                    break block111;
                                }
                            }
                            this.jj_consume_token(21);
                        }
                        selector_list = this.selector_list();
                        block112: while (true) {
                            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                case 21: {
                                    break;
                                }
                                default: {
                                    this.jj_la1[210] = this.jj_gen;
                                    break block112;
                                }
                            }
                            this.jj_consume_token(21);
                        }
                        try {
                            s.setPseudoFun(this.ac, this.convertStringIndex(n.image, 0, n.image.length() - 1, false).toLowerCase(), selector_list);
                        }
                        catch (InvalidParamException e) {
                            this.removeThisRule();
                            this.ac.getFrame().addError(new CssError(this.getSourceFile(), this.getBeginLine(), this.getBeginColumn(), this.getEndLine(), this.getEndColumn(), e));
                        }
                        break;
                    }
                    case 123: {
                        n = this.jj_consume_token(123);
                        block113: while (true) {
                            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                case 21: {
                                    break;
                                }
                                default: {
                                    this.jj_la1[211] = this.jj_gen;
                                    break block113;
                                }
                            }
                            this.jj_consume_token(21);
                        }
                        try {
                            selector_list = this.selector_list();
                            while (true) {
                                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                    case 21: {
                                        break;
                                    }
                                    default: {
                                        this.jj_la1[212] = this.jj_gen;
                                        ** GOTO lbl122
                                    }
                                }
                                this.jj_consume_token(21);
                            }
                        }
                        catch (ParseException ignored) {
                            s.setPseudoFun(this.ac, this.convertStringIndex(n.image, 0, n.image.length() - 1, false).toLowerCase(), this.skip_to_matching_paren());
                        }
lbl122:
                        // 2 sources

                        try {
                            s.setPseudoFun(this.ac, this.convertStringIndex(n.image, 0, n.image.length() - 1, false).toLowerCase(), selector_list);
                        }
                        catch (InvalidParamException e) {
                            this.removeThisRule();
                            this.ac.getFrame().addError(new CssError(this.getSourceFile(), this.getBeginLine(), this.getBeginColumn(), this.getEndLine(), this.getEndColumn(), e));
                        }
                        break;
                    }
                    case 124: {
                        n = this.jj_consume_token(124);
                        selector_list = this.relative_selector_list();
                        block115: while (true) {
                            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                case 21: {
                                    break;
                                }
                                default: {
                                    this.jj_la1[213] = this.jj_gen;
                                    break block115;
                                }
                            }
                            this.jj_consume_token(21);
                        }
                        try {
                            s.setPseudoFun(this.ac, this.convertStringIndex(n.image, 0, n.image.length() - 1, false).toLowerCase(), selector_list);
                        }
                        catch (InvalidParamException e) {
                            this.removeThisRule();
                            this.ac.getFrame().addError(new CssError(this.getSourceFile(), this.getBeginLine(), this.getBeginColumn(), this.getEndLine(), this.getEndColumn(), e));
                        }
                        break;
                    }
                    case 126: 
                    case 127: {
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 126: {
                                n = this.jj_consume_token(126);
                                break;
                            }
                            case 127: {
                                n = this.jj_consume_token(127);
                                break;
                            }
                            default: {
                                this.jj_la1[214] = this.jj_gen;
                                this.jj_consume_token(-1);
                                throw new ParseException();
                            }
                        }
                        block116: while (true) {
                            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                case 21: {
                                    break;
                                }
                                default: {
                                    this.jj_la1[215] = this.jj_gen;
                                    break block116;
                                }
                            }
                            this.jj_consume_token(21);
                        }
                        sel = this.compound_selector(null);
                        block117: while (true) {
                            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                case 21: {
                                    break;
                                }
                                default: {
                                    this.jj_la1[216] = this.jj_gen;
                                    break block117;
                                }
                            }
                            this.jj_consume_token(21);
                        }
                        try {
                            list = new ArrayList<CssSelectors>();
                            list.add(sel);
                            s.setPseudoFun(this.ac, this.convertStringIndex(n.image, 0, n.image.length() - 1, false).toLowerCase(), list);
                        }
                        catch (InvalidParamException e) {
                            this.removeThisRule();
                            this.ac.getFrame().addError(new CssError(this.getSourceFile(), this.getBeginLine(), this.getBeginColumn(), this.getEndLine(), this.getEndColumn(), e));
                        }
                        break;
                    }
                    case 128: 
                    case 129: 
                    case 132: 
                    case 133: {
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 128: {
                                n = this.jj_consume_token(128);
                                break;
                            }
                            case 129: {
                                n = this.jj_consume_token(129);
                                break;
                            }
                            case 132: {
                                n = this.jj_consume_token(132);
                                break;
                            }
                            case 133: {
                                n = this.jj_consume_token(133);
                                break;
                            }
                            default: {
                                this.jj_la1[217] = this.jj_gen;
                                this.jj_consume_token(-1);
                                throw new ParseException();
                            }
                        }
                        block118: while (true) {
                            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                case 21: {
                                    break;
                                }
                                default: {
                                    this.jj_la1[218] = this.jj_gen;
                                    break block118;
                                }
                            }
                            this.jj_consume_token(21);
                        }
                        block69 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 28: 
                            case 29: 
                            case 35: 
                            case 36: 
                            case 37: 
                            case 38: 
                            case 41: 
                            case 71: 
                            case 73: 
                            case 75: {
                                anpb = this.anplusb();
                                block119: while (true) {
                                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                        case 21: {
                                            break;
                                        }
                                        default: {
                                            this.jj_la1[219] = this.jj_gen;
                                            break block119;
                                        }
                                    }
                                    this.jj_consume_token(21);
                                }
                                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                    case 35: 
                                    case 36: 
                                    case 37: 
                                    case 38: 
                                    case 41: {
                                        id = this.ident();
                                        block120: while (true) {
                                            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                                case 21: {
                                                    break;
                                                }
                                                default: {
                                                    this.jj_la1[220] = this.jj_gen;
                                                    break block120;
                                                }
                                            }
                                            this.jj_consume_token(21);
                                        }
                                        selector_list = this.selector_list();
                                        while (true) {
                                            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                                case 21: {
                                                    break;
                                                }
                                                default: {
                                                    this.jj_la1[221] = this.jj_gen;
                                                    break block69;
                                                }
                                            }
                                            this.jj_consume_token(21);
                                        }
                                    }
                                }
                                this.jj_la1[222] = this.jj_gen;
                                break;
                            }
                            default: {
                                this.jj_la1[223] = this.jj_gen;
                                error_str = this.skip_to_matching_paren();
                            }
                        }
                        try {
                            exp.addValue(anpb);
                            if (id != null) {
                                this.setValue(new CssIdent(), exp, ' ', id, 41);
                            }
                            s.setPseudoFun(this.ac, this.convertStringIndex(n.image, 0, n.image.length() - 1, false).toLowerCase(), exp, selector_list);
                        }
                        catch (InvalidParamException e) {
                            this.removeThisRule();
                            this.ac.getFrame().addError(new CssError(this.getSourceFile(), this.getBeginLine(), this.getBeginColumn(), this.getEndLine(), this.getEndColumn(), e));
                        }
                        break;
                    }
                    case 130: 
                    case 131: {
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 130: {
                                n = this.jj_consume_token(130);
                                break;
                            }
                            case 131: {
                                n = this.jj_consume_token(131);
                                break;
                            }
                            default: {
                                this.jj_la1[224] = this.jj_gen;
                                this.jj_consume_token(-1);
                                throw new ParseException();
                            }
                        }
                        block122: while (true) {
                            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                case 21: {
                                    break;
                                }
                                default: {
                                    this.jj_la1[225] = this.jj_gen;
                                    break block122;
                                }
                            }
                            this.jj_consume_token(21);
                        }
                        block91 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 28: 
                            case 29: 
                            case 35: 
                            case 36: 
                            case 37: 
                            case 38: 
                            case 41: 
                            case 71: 
                            case 73: 
                            case 75: {
                                anpb = this.anplusb();
                                while (true) {
                                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                        case 21: {
                                            break;
                                        }
                                        default: {
                                            this.jj_la1[226] = this.jj_gen;
                                            break block91;
                                        }
                                    }
                                    this.jj_consume_token(21);
                                }
                            }
                            default: {
                                this.jj_la1[227] = this.jj_gen;
                                error_str = this.skip_to_matching_paren();
                            }
                        }
                        try {
                            exp.addValue(anpb);
                            s.setPseudoFun(this.ac, this.convertStringIndex(n.image, 0, n.image.length() - 1, false).toLowerCase(), exp);
                        }
                        catch (InvalidParamException e) {
                            this.removeThisRule();
                            this.ac.getFrame().addError(new CssError(this.getSourceFile(), this.getBeginLine(), this.getBeginColumn(), this.getEndLine(), this.getEndColumn(), e));
                        }
                        break;
                    }
                    case 143: {
                        n = this.jj_consume_token(143);
                        block124: while (true) {
                            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                case 21: {
                                    break;
                                }
                                default: {
                                    this.jj_la1[228] = this.jj_gen;
                                    break block124;
                                }
                            }
                            this.jj_consume_token(21);
                        }
                        param = this.expression();
                        try {
                            s.setPseudoFun(this.ac, this.convertStringIndex(n.image, 0, n.image.length() - 1, false).toLowerCase(), param.toString());
                        }
                        catch (InvalidParamException e) {
                            this.removeThisRule();
                            this.ac.getFrame().addError(new CssError(this.getSourceFile(), this.getBeginLine(), this.getBeginColumn(), this.getEndLine(), this.getEndColumn(), e));
                        }
                        break;
                    }
                    default: {
                        this.jj_la1[229] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                this.jj_consume_token(57);
                break;
            }
            default: {
                this.jj_la1[230] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void id_selector(CssSelectors s) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 42: {
                Token n = this.jj_consume_token(42);
                n.image = n.image.substring(1);
                if (Character.isDigit(n.image.charAt(0))) {
                    CssVersion version = this.ac.getCssVersion();
                    if (version != CssVersion.CSS1) {
                        String cl = "\\" + Integer.toString(n.image.charAt(0), 16);
                        cl = cl + n.image.substring(1);
                        this.addError((Exception)new ParseException(this.ac.getMsg().getString("parser.old_id")), "To make \"." + n.image + "\" a valid id, CSS2 requires the first digit to be escaped (\"#" + cl + "\")");
                        s.addId(new IdSelector(n.image));
                        this.removeThisRule();
                        break;
                    }
                    CssLength length = new CssLength();
                    boolean isLength = false;
                    try {
                        length.set(n.image, this.ac);
                        isLength = true;
                    }
                    catch (Exception e) {
                        isLength = false;
                    }
                    if (isLength) {
                        this.addError((Exception)new ParseException(this.ac.getMsg().getString("parser.id_dim")), n.image);
                        s.addId(new IdSelector(n.image));
                        this.removeThisRule();
                        break;
                    }
                    try {
                        s.addId(new IdSelector(n.image));
                        this.ac.getFrame().addWarning("old_id");
                    }
                    catch (InvalidParamException e) {
                        this.ac.getFrame().addError(new CssError(this.getSourceFile(), this.getBeginLine(), this.getBeginColumn(), this.getEndLine(), this.getEndColumn(), e));
                        this.removeThisRule();
                    }
                    break;
                }
                try {
                    s.addId(new IdSelector(n.image));
                }
                catch (InvalidParamException e) {
                    this.ac.getFrame().addError(new CssError(this.getSourceFile(), this.getBeginLine(), this.getBeginColumn(), this.getEndLine(), this.getEndColumn(), e));
                    this.removeThisRule();
                }
                break;
            }
            case 43: {
                Token n = this.jj_consume_token(43);
                throw new ParseException(this.ac.getMsg().getString("parser.invalid_id_selector"));
            }
            default: {
                this.jj_la1[231] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final CssProperty mediadeclaration() throws ParseException {
        CssExpression values = null;
        boolean important = false;
        this.setMediaDeclaration(true);
        try {
            CssProperty p;
            String string_property;
            block23: {
                string_property = this.property();
                block6 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 59: {
                        this.jj_consume_token(59);
                        block20: while (true) {
                            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                case 21: {
                                    break;
                                }
                                default: {
                                    this.jj_la1[232] = this.jj_gen;
                                    break block20;
                                }
                            }
                            this.jj_consume_token(21);
                        }
                        values = this.expr();
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 76: {
                                important = this.prio();
                                break block6;
                            }
                        }
                        this.jj_la1[233] = this.jj_gen;
                        break;
                    }
                    default: {
                        this.jj_la1[234] = this.jj_gen;
                    }
                }
                try {
                    if (string_property == null) {
                        CssProperty cssProperty = null;
                        return cssProperty;
                    }
                    this.setImportant(important);
                    if (!this.incompatible_error) break block23;
                }
                catch (InvalidParamException e2) {
                    this.incompatible_error = false;
                    if (null != values) {
                        values.starts();
                    }
                    this.addError((Exception)e2, values);
                    CssProperty e2 = null;
                    return e2;
                }
                throw new InvalidParamException("notforcss1", "inherit", this.ac);
            }
            CssProperty cssProperty = p = this.handleDeclaration(string_property.toLowerCase(), values, important);
            return cssProperty;
        }
        catch (NumberFormatException e) {
            this.skipAfterExpression(e);
            CssProperty cssProperty = null;
            return cssProperty;
        }
        catch (ParseException e) {
            this.skipAfterExpression(e);
            CssProperty cssProperty = null;
            return cssProperty;
        }
        finally {
            this.setMediaDeclaration(false);
        }
    }

    public final CssProperty declaration() throws ParseException {
        CssExpression values = null;
        boolean important = false;
        try {
            block23: {
                String string_property = this.property();
                this.jj_consume_token(59);
                block15: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 21: {
                            break;
                        }
                        default: {
                            this.jj_la1[235] = this.jj_gen;
                            break block15;
                        }
                    }
                    this.jj_consume_token(21);
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 28: 
                    case 29: 
                    case 35: 
                    case 36: 
                    case 37: 
                    case 38: 
                    case 39: 
                    case 41: 
                    case 42: 
                    case 43: 
                    case 44: 
                    case 52: 
                    case 53: 
                    case 54: 
                    case 60: 
                    case 61: 
                    case 62: 
                    case 63: 
                    case 64: 
                    case 65: 
                    case 66: 
                    case 67: 
                    case 68: 
                    case 69: 
                    case 70: 
                    case 72: 
                    case 73: 
                    case 74: 
                    case 75: 
                    case 77: 
                    case 119: 
                    case 135: 
                    case 136: 
                    case 137: 
                    case 138: 
                    case 139: 
                    case 140: 
                    case 141: 
                    case 142: 
                    case 143: {
                        values = this.expr();
                        break;
                    }
                    default: {
                        this.jj_la1[236] = this.jj_gen;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 76: {
                        important = this.prio();
                        break;
                    }
                    default: {
                        this.jj_la1[237] = this.jj_gen;
                    }
                }
                try {
                    if (string_property == null) {
                        return null;
                    }
                    this.setImportant(important);
                    if (this.incompatible_error) {
                        throw new InvalidParamException("notforcss1", "inherit", this.ac);
                    }
                    if (values == null) {
                        if (string_property.startsWith("--")) {
                            values = new CssExpression();
                        } else {
                            throw new ParseException();
                        }
                    }
                    if (values.getCount() == 0 && !string_property.startsWith("--")) break block23;
                    CssProperty p = this.handleDeclaration(string_property.toLowerCase(), values, important);
                    if (!values.end() && this.ac.getMedium() == null) {
                        this.addError((Exception)new InvalidParamException("unrecognize", "", this.ac), values);
                        break block23;
                    }
                    return p;
                }
                catch (InvalidParamException e) {
                    this.incompatible_error = false;
                    if (e instanceof WarningParamException) {
                        WarningParamException warningException = (WarningParamException)e;
                        this.ac.getFrame().addWarning(warningException.getMessage(), warningException.getMessageArgs());
                    }
                    values.starts();
                    this.addError((Exception)e, values);
                }
            }
            return null;
        }
        catch (NumberFormatException e) {
            this.skipAfterExpression(e);
            return null;
        }
        catch (ParseException e) {
            this.skipAfterExpression(e);
            return null;
        }
        catch (NullPointerException e) {
            this.skipAfterExpression(e);
            return null;
        }
    }

    public final boolean prio() throws ParseException {
        this.jj_consume_token(76);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 21: {
                    break;
                }
                default: {
                    this.jj_la1[238] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(21);
        }
        return true;
    }

    public final CssExpression expression() throws ParseException {
        CssExpression exp = new CssExpression();
        char operator = ' ';
        Token n = null;
        block15: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 28: {
                    this.jj_consume_token(28);
                    operator = '+';
                    break;
                }
                case 29: {
                    this.jj_consume_token(29);
                    operator = '-';
                    break;
                }
                case 75: {
                    n = this.jj_consume_token(75);
                    this.setValue(new CssNumber(), exp, operator, n, 75);
                    break;
                }
                case 74: {
                    n = this.jj_consume_token(74);
                    this.setValue(new CssPercentage(), exp, operator, n, 74);
                    break;
                }
                case 73: {
                    n = this.jj_consume_token(73);
                    this.setValue(new CssIdent(), exp, operator, n, 41);
                    break;
                }
                case 39: {
                    n = this.jj_consume_token(39);
                    this.setValue(new CssString(), exp, operator, n, 39);
                    break;
                }
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 41: {
                    n = this.ident();
                    this.setValue(new CssIdent(), exp, operator, n, 41);
                    break;
                }
                default: {
                    this.jj_la1[239] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            block16: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 21: {
                        break;
                    }
                    default: {
                        this.jj_la1[240] = this.jj_gen;
                        break block16;
                    }
                }
                this.jj_consume_token(21);
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 28: 
                case 29: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 41: 
                case 73: 
                case 74: 
                case 75: {
                    continue block15;
                }
            }
            break;
        }
        this.jj_la1[241] = this.jj_gen;
        return exp;
    }

    public final CssExpression expr() throws ParseException {
        CssExpression values = new CssExpression();
        try {
            this.term(values);
            while (this.jj_2_19(2)) {
                this.operator(values);
                this.term(values);
            }
        }
        catch (WarningParamException e) {
            this.ac.getFrame().addWarning(e.getMessage(), e.getMessageArgs());
        }
        return values;
    }

    public final void mediarange(AtRuleMedia mediaRule, boolean defaultMedia, String combinator) throws ParseException {
        Token n;
        Token c1 = null;
        Token c2 = null;
        CssExpression val1 = null;
        CssExpression val2 = null;
        CssComparator comp1 = null;
        CssComparator comp2 = null;
        boolean nameIsFirst = false;
        this.jj_consume_token(58);
        block48: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 21: {
                    break;
                }
                default: {
                    this.jj_la1[242] = this.jj_gen;
                    break block48;
                }
            }
            this.jj_consume_token(21);
        }
        if (this.jj_2_20(3)) {
            n = this.ident();
            nameIsFirst = true;
            block49: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 21: {
                        break;
                    }
                    default: {
                        this.jj_la1[243] = this.jj_gen;
                        break block49;
                    }
                }
                this.jj_consume_token(21);
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 30: {
                    c1 = this.jj_consume_token(30);
                    break;
                }
                case 31: {
                    c1 = this.jj_consume_token(31);
                    break;
                }
                case 50: {
                    c1 = this.jj_consume_token(50);
                    break;
                }
                case 152: {
                    c1 = this.jj_consume_token(152);
                    break;
                }
                case 154: {
                    c1 = this.jj_consume_token(154);
                    break;
                }
                default: {
                    this.jj_la1[244] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            block50: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 21: {
                        break;
                    }
                    default: {
                        this.jj_la1[245] = this.jj_gen;
                        break block50;
                    }
                }
                this.jj_consume_token(21);
            }
            val1 = this.mediaexpr();
        } else {
            block16 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 28: 
                case 29: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 41: 
                case 42: 
                case 43: 
                case 60: 
                case 61: 
                case 62: 
                case 63: 
                case 64: 
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 72: 
                case 73: 
                case 74: 
                case 75: 
                case 77: 
                case 119: 
                case 135: 
                case 136: 
                case 137: 
                case 138: 
                case 139: 
                case 140: 
                case 143: {
                    val1 = this.mediaexpr();
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 30: {
                            c1 = this.jj_consume_token(30);
                            break;
                        }
                        case 31: {
                            c1 = this.jj_consume_token(31);
                            break;
                        }
                        case 50: {
                            c1 = this.jj_consume_token(50);
                            break;
                        }
                        case 152: {
                            c1 = this.jj_consume_token(152);
                            break;
                        }
                        case 154: {
                            c1 = this.jj_consume_token(154);
                            break;
                        }
                        default: {
                            this.jj_la1[246] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                    block51: while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 21: {
                                break;
                            }
                            default: {
                                this.jj_la1[247] = this.jj_gen;
                                break block51;
                            }
                        }
                        this.jj_consume_token(21);
                    }
                    n = this.ident();
                    block52: while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 21: {
                                break;
                            }
                            default: {
                                this.jj_la1[248] = this.jj_gen;
                                break block52;
                            }
                        }
                        this.jj_consume_token(21);
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 30: 
                        case 31: 
                        case 50: 
                        case 152: 
                        case 154: {
                            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                case 30: {
                                    c2 = this.jj_consume_token(30);
                                    break;
                                }
                                case 31: {
                                    c2 = this.jj_consume_token(31);
                                    break;
                                }
                                case 50: {
                                    c2 = this.jj_consume_token(50);
                                    break;
                                }
                                case 152: {
                                    c2 = this.jj_consume_token(152);
                                    break;
                                }
                                case 154: {
                                    c2 = this.jj_consume_token(154);
                                    break;
                                }
                                default: {
                                    this.jj_la1[249] = this.jj_gen;
                                    this.jj_consume_token(-1);
                                    throw new ParseException();
                                }
                            }
                            block53: while (true) {
                                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                    case 21: {
                                        break;
                                    }
                                    default: {
                                        this.jj_la1[250] = this.jj_gen;
                                        break block53;
                                    }
                                }
                                this.jj_consume_token(21);
                            }
                            val2 = this.mediaexpr();
                            break block16;
                        }
                    }
                    this.jj_la1[251] = this.jj_gen;
                    break;
                }
                default: {
                    this.jj_la1[252] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        this.jj_consume_token(57);
        block54: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 21: {
                    break;
                }
                default: {
                    this.jj_la1[253] = this.jj_gen;
                    break block54;
                }
            }
            this.jj_consume_token(21);
        }
        if (defaultMedia) {
            mediaRule.addMedia(null, null, this.ac);
        }
        String mediaFeatureName = this.convertIdent(n.image);
        if (c1 != null) {
            comp1 = new CssComparator();
            comp1.set(c1.image, val1, this.ac);
        }
        if (c2 != null) {
            comp2 = new CssComparator();
            comp2.set(c2.image, val2, this.ac);
        }
        CssExpression nex = new CssExpression();
        nex.addValue(comp1);
        if (comp2 != null) {
            nex.addValue(comp2);
        }
        MediaFeature mf = this.handleMediaFeature(mediaRule, mediaFeatureName, nex);
        ((MediaRangeFeature)mf).comparatorNameFirst = nameIsFirst;
        if (mf != null) {
            mediaRule.addMediaFeature(mf, this.ac);
            mf.setCombinator(combinator);
        }
    }

    public final CssExpression mediaexpr() throws ParseException {
        CssExpression values = new CssExpression();
        this.mediaterm(values);
        while (this.jj_2_21(2)) {
            this.operator(values);
            this.mediaterm(values);
        }
        return values;
    }

    public final void term(CssExpression exp) throws ParseException {
        char operator = ' ';
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 28: 
            case 29: 
            case 44: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 77: {
                Token n;
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 28: 
                    case 29: {
                        operator = this.unaryOperator();
                        break;
                    }
                    default: {
                        this.jj_la1[254] = this.jj_gen;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 75: {
                        n = this.jj_consume_token(75);
                        this.setValue(new CssNumber(), exp, operator, n, 75);
                        break block0;
                    }
                    case 74: {
                        n = this.jj_consume_token(74);
                        this.setValue(new CssPercentage(), exp, operator, n, 74);
                        break block0;
                    }
                    case 61: {
                        n = this.jj_consume_token(61);
                        this.setValue(new CssLength(), exp, operator, n, 61);
                        break block0;
                    }
                    case 62: {
                        n = this.jj_consume_token(62);
                        this.setValue(new CssLength(), exp, operator, n, 62);
                        break block0;
                    }
                    case 63: {
                        n = this.jj_consume_token(63);
                        this.setValue(new CssLength(), exp, operator, n, 63);
                        break block0;
                    }
                    case 64: {
                        n = this.jj_consume_token(64);
                        this.setValue(new CssFlexibleLength(), exp, operator, n, 64);
                        break block0;
                    }
                    case 65: {
                        n = this.jj_consume_token(65);
                        this.setValue(new CssAngle(), exp, operator, n, 65);
                        break block0;
                    }
                    case 68: {
                        n = this.jj_consume_token(68);
                        this.setValue(new CssTime(), exp, operator, n, 68);
                        break block0;
                    }
                    case 69: {
                        n = this.jj_consume_token(69);
                        this.setValue(new CssFrequency(), exp, operator, n, 69);
                        break block0;
                    }
                    case 70: {
                        n = this.jj_consume_token(70);
                        this.setValue(new CssResolution(), exp, operator, n, 70);
                        break block0;
                    }
                    case 67: {
                        n = this.jj_consume_token(67);
                        this.setValue(new CssSemitone(), exp, operator, n, 67);
                        break block0;
                    }
                    case 66: {
                        n = this.jj_consume_token(66);
                        this.setValue(new CssVolume(), exp, operator, n, 66);
                        break block0;
                    }
                    case 73: {
                        n = this.jj_consume_token(73);
                        String dimen = n.image.trim();
                        if ("0\\0".equals(dimen) && this.ac.getTreatCssHacksAsWarnings()) {
                            exp.markCssHack();
                            this.ac.getFrame().addWarning("css-hack", dimen);
                            break block0;
                        }
                        this.addError((Exception)new ParseException(this.ac.getMsg().getString("parser.unknown-dimension")), dimen);
                        break block0;
                    }
                    case 44: {
                        Token n2 = this.jj_consume_token(44);
                        if (this.ac.getTreatVendorExtensionsAsWarnings()) {
                            throw new WarningParamException("vendor-extension", n2.image);
                        }
                        throw new ParseException(String.format(this.ac.getMsg().getString("warning.vendor-extension"), n2.image));
                    }
                    case 77: {
                        Token n3 = this.jj_consume_token(77);
                        if (this.ac.getTreatCssHacksAsWarnings()) {
                            throw new WarningParamException("css-hack", n3.image.trim());
                        }
                        throw new ParseException(String.format(this.ac.getMsg().getString("warning.css-hack"), n3.image.trim()));
                    }
                    case 72: {
                        n = this.jj_consume_token(72);
                        if (this.ac.getTreatCssHacksAsWarnings()) {
                            this.ac.getFrame().addWarning("css-hack", n.image.trim());
                            exp.markCssHack();
                            break block0;
                        }
                        this.addError((Exception)new ParseException(this.ac.getMsg().getString("parser.unknown-dimension")), n.image);
                        break block0;
                    }
                }
                this.jj_la1[255] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 41: 
            case 42: 
            case 43: 
            case 52: 
            case 53: 
            case 54: 
            case 60: 
            case 119: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 142: 
            case 143: {
                Token n;
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 135: {
                        CssValue func = this.mathcalc();
                        this.setValue(func, exp, operator, null, 135);
                        break block0;
                    }
                    case 136: 
                    case 137: 
                    case 138: 
                    case 139: {
                        CssValue func = this.mathfunction();
                        this.setValue(func, exp, operator, null, 143);
                        break block0;
                    }
                    case 140: {
                        CssValue func = this.mathclamp();
                        this.setValue(func, exp, operator, null, 143);
                        break block0;
                    }
                    case 141: {
                        CssValue func = this.attr();
                        this.setValue(func, exp, operator, null, 143);
                        break block0;
                    }
                    case 142: {
                        CssValue func = this.functionvar();
                        this.setValue(func, exp, operator, null, 142);
                        break block0;
                    }
                    case 143: {
                        CssValue func = this.function();
                        this.setValue(func, exp, operator, null, 143);
                        break block0;
                    }
                    case 39: {
                        n = this.jj_consume_token(39);
                        this.setValue(new CssString(), exp, operator, n, 39);
                        break block0;
                    }
                    case 52: {
                        n = this.jj_consume_token(52);
                        this.setValue(new CssSwitch(), exp, operator, n, 52);
                        break block0;
                    }
                    case 53: 
                    case 54: {
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 54: {
                                n = this.jj_consume_token(54);
                                break;
                            }
                            case 53: {
                                n = this.jj_consume_token(53);
                                break;
                            }
                            default: {
                                this.jj_la1[256] = this.jj_gen;
                                this.jj_consume_token(-1);
                                throw new ParseException();
                            }
                        }
                        this.setValue(new CssBracket(), exp, operator, n, 54);
                        break block0;
                    }
                    case 35: 
                    case 36: 
                    case 37: 
                    case 38: 
                    case 41: {
                        n = this.ident();
                        Token t = this.getToken(1);
                        Token semicolon = new Token();
                        semicolon.kind = 51;
                        semicolon.image = ";";
                        if (t.kind == 59) {
                            this.addError((Exception)new ParseException(String.format(this.ac.getMsg().getString("parser.semi-colon"), n)), (CssExpression)null);
                            this.rejectToken(semicolon);
                            break block0;
                        }
                        this.setValue(new CssIdent(), exp, operator, n, 41);
                        break block0;
                    }
                    case 42: 
                    case 43: {
                        this.hashident(exp);
                        break block0;
                    }
                    case 60: {
                        n = this.jj_consume_token(60);
                        CssURL _u = new CssURL();
                        _u.set(n.image, this.ac, this.url);
                        exp.addValue(_u);
                        break block0;
                    }
                    case 119: {
                        n = this.jj_consume_token(119);
                        this.setValue(new CssUnicodeRange(), exp, operator, n, 119);
                        break block0;
                    }
                }
                this.jj_la1[257] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[258] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        while (this.jj_2_22(2)) {
            this.jj_consume_token(21);
        }
    }

    public final void mediaterm(CssExpression exp) throws ParseException {
        char operator = ' ';
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 28: 
            case 29: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 77: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 143: {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 28: 
                    case 29: {
                        operator = this.unaryOperator();
                        break;
                    }
                    default: {
                        this.jj_la1[259] = this.jj_gen;
                    }
                }
                block7 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 75: {
                        Token n;
                        if (this.jj_2_23(Integer.MAX_VALUE)) {
                            this.ratio(exp, operator);
                            break;
                        }
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 75: {
                                n = this.jj_consume_token(75);
                                this.setValue(new CssNumber(), exp, operator, n, 75);
                                break block7;
                            }
                        }
                        this.jj_la1[260] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                    case 74: {
                        Token n = this.jj_consume_token(74);
                        this.setValue(new CssPercentage(), exp, operator, n, 74);
                        break;
                    }
                    case 61: {
                        Token n = this.jj_consume_token(61);
                        this.setValue(new CssLength(), exp, operator, n, 61);
                        break;
                    }
                    case 62: {
                        Token n = this.jj_consume_token(62);
                        this.setValue(new CssLength(), exp, operator, n, 62);
                        break;
                    }
                    case 63: {
                        Token n = this.jj_consume_token(63);
                        this.setValue(new CssLength(), exp, operator, n, 63);
                        break;
                    }
                    case 64: {
                        Token n = this.jj_consume_token(64);
                        this.setValue(new CssFlexibleLength(), exp, operator, n, 64);
                        break;
                    }
                    case 65: {
                        Token n = this.jj_consume_token(65);
                        this.setValue(new CssAngle(), exp, operator, n, 65);
                        break;
                    }
                    case 68: {
                        Token n = this.jj_consume_token(68);
                        this.setValue(new CssTime(), exp, operator, n, 68);
                        break;
                    }
                    case 69: {
                        Token n = this.jj_consume_token(69);
                        this.setValue(new CssFrequency(), exp, operator, n, 69);
                        break;
                    }
                    case 70: {
                        Token n = this.jj_consume_token(70);
                        this.setValue(new CssResolution(), exp, operator, n, 70);
                        break;
                    }
                    case 67: {
                        Token n = this.jj_consume_token(67);
                        this.setValue(new CssSemitone(), exp, operator, n, 67);
                        break;
                    }
                    case 66: {
                        Token n = this.jj_consume_token(66);
                        this.setValue(new CssVolume(), exp, operator, n, 66);
                        break;
                    }
                    case 73: {
                        Token n = this.jj_consume_token(73);
                        String dimen = n.image.trim();
                        if ("0\\0".equals(dimen) && this.ac.getTreatCssHacksAsWarnings()) {
                            exp.markCssHack();
                            this.ac.getFrame().addWarning("css-hack", dimen);
                            break;
                        }
                        this.addError((Exception)new ParseException(this.ac.getMsg().getString("parser.unknown-dimension")), dimen);
                        break;
                    }
                    case 77: {
                        Token n = this.jj_consume_token(77);
                        if (this.ac.getTreatCssHacksAsWarnings()) {
                            throw new WarningParamException("css-hack", n.image.trim());
                        }
                        throw new ParseException(String.format(this.ac.getMsg().getString("warning.css-hack"), n.image.trim()));
                    }
                    case 72: {
                        Token n = this.jj_consume_token(72);
                        if (this.ac.getTreatCssHacksAsWarnings()) {
                            exp.markCssHack();
                            this.ac.getFrame().addWarning("css-hack", n.image.trim());
                            break;
                        }
                        this.addError((Exception)new ParseException(this.ac.getMsg().getString("parser.unknown-dimension")), n.image.trim());
                        break;
                    }
                    case 135: 
                    case 136: 
                    case 137: 
                    case 138: 
                    case 139: 
                    case 140: 
                    case 143: {
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 143: {
                                CssValue func = this.function();
                                this.setValue(func, exp, operator, null, 143);
                                break block7;
                            }
                            case 135: {
                                CssValue func = this.mathcalc();
                                this.setValue(func, exp, operator, null, 135);
                                break block7;
                            }
                            case 136: 
                            case 137: 
                            case 138: 
                            case 139: {
                                CssValue func = this.mathfunction();
                                this.setValue(func, exp, operator, null, 143);
                                break block7;
                            }
                            case 140: {
                                CssValue func = this.mathclamp();
                                this.setValue(func, exp, operator, null, 143);
                                break block7;
                            }
                        }
                        this.jj_la1[261] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                    default: {
                        this.jj_la1[262] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 21: {
                            break;
                        }
                        default: {
                            this.jj_la1[263] = this.jj_gen;
                            break block0;
                        }
                    }
                    this.jj_consume_token(21);
                }
            }
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 41: 
            case 42: 
            case 43: 
            case 60: 
            case 119: {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 39: {
                        Token n = this.jj_consume_token(39);
                        this.setValue(new CssString(), exp, operator, n, 39);
                        break;
                    }
                    case 35: 
                    case 36: 
                    case 37: 
                    case 38: 
                    case 41: {
                        Token n = this.ident();
                        Token t = this.getToken(1);
                        Token semicolon = new Token();
                        semicolon.kind = 51;
                        semicolon.image = ";";
                        if (t.kind == 59) {
                            this.addError((Exception)new ParseException(String.format(this.ac.getMsg().getString("parser.semi-colon"), n)), (CssExpression)null);
                            this.rejectToken(semicolon);
                            break;
                        }
                        this.setValue(new CssIdent(), exp, operator, n, 41);
                        break;
                    }
                    case 42: 
                    case 43: {
                        this.hashident(exp);
                        break;
                    }
                    case 60: {
                        Token n = this.jj_consume_token(60);
                        CssURL _u = new CssURL();
                        _u.set(n.image, this.ac, this.url);
                        exp.addValue(_u);
                        break;
                    }
                    case 119: {
                        Token n = this.jj_consume_token(119);
                        this.setValue(new CssUnicodeRange(), exp, operator, n, 119);
                        break;
                    }
                    default: {
                        this.jj_la1[264] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 21: {
                            break;
                        }
                        default: {
                            this.jj_la1[265] = this.jj_gen;
                            break block0;
                        }
                    }
                    this.jj_consume_token(21);
                }
            }
            default: {
                this.jj_la1[266] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final CssCheckableValue mathfunction() throws ParseException {
        CssCheckableValue v;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 137: {
                v = this.mathfunction1();
                break;
            }
            case 138: {
                v = this.mathfunction2();
                break;
            }
            case 136: {
                v = this.mathfunctionn();
                break;
            }
            case 139: {
                v = this.mathfunctionround();
                break;
            }
            default: {
                this.jj_la1[267] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return v;
    }

    public final CssCheckableValue mathfunctionn() throws ParseException {
        Token n = this.jj_consume_token(136);
        block15: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 21: {
                    break;
                }
                default: {
                    this.jj_la1[268] = this.jj_gen;
                    break block15;
                }
            }
            this.jj_consume_token(21);
        }
        CssCheckableValue v = this.mathsum();
        CssMathFunction c = new CssMathFunction(this.ac, n.image, v);
        block16: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 21: {
                    break;
                }
                default: {
                    this.jj_la1[269] = this.jj_gen;
                    break block16;
                }
            }
            this.jj_consume_token(21);
        }
        block17: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 32: {
                    break;
                }
                default: {
                    this.jj_la1[270] = this.jj_gen;
                    break block17;
                }
            }
            this.jj_consume_token(32);
            block18: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 21: {
                        break;
                    }
                    default: {
                        this.jj_la1[271] = this.jj_gen;
                        break block18;
                    }
                }
                this.jj_consume_token(21);
            }
            v = this.mathsum();
            c.addValue(v);
            while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 21: {
                        break;
                    }
                    default: {
                        this.jj_la1[272] = this.jj_gen;
                        continue block17;
                    }
                }
                this.jj_consume_token(21);
            }
            break;
        }
        this.jj_consume_token(57);
        c.validate();
        return c;
    }

    public final CssCheckableValue mathfunctionround() throws ParseException {
        CssCheckableValue v;
        Token n = this.jj_consume_token(139);
        CssMathFunction c = new CssMathFunction(this.ac, n.image);
        block18: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 21: {
                    break;
                }
                default: {
                    this.jj_la1[273] = this.jj_gen;
                    break block18;
                }
            }
            this.jj_consume_token(21);
        }
        if (this.jj_2_24(2)) {
            n = this.jj_consume_token(41);
            c.addValue(CssIdent.getIdent(this.convertIdent(n.image)));
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 28: 
                case 29: 
                case 41: 
                case 58: 
                case 61: 
                case 62: 
                case 63: 
                case 64: 
                case 65: 
                case 68: 
                case 69: 
                case 74: 
                case 75: 
                case 135: 
                case 136: 
                case 137: 
                case 138: 
                case 139: 
                case 140: 
                case 141: 
                case 142: {
                    v = this.mathsum();
                    c.addValue(v);
                    break;
                }
                default: {
                    this.jj_la1[274] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        block19: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 21: {
                    break;
                }
                default: {
                    this.jj_la1[275] = this.jj_gen;
                    break block19;
                }
            }
            this.jj_consume_token(21);
        }
        block20: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 32: {
                    break;
                }
                default: {
                    this.jj_la1[276] = this.jj_gen;
                    break block20;
                }
            }
            this.jj_consume_token(32);
            block21: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 21: {
                        break;
                    }
                    default: {
                        this.jj_la1[277] = this.jj_gen;
                        break block21;
                    }
                }
                this.jj_consume_token(21);
            }
            v = this.mathsum();
            c.addValue(v);
            while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 21: {
                        break;
                    }
                    default: {
                        this.jj_la1[278] = this.jj_gen;
                        continue block20;
                    }
                }
                this.jj_consume_token(21);
            }
            break;
        }
        this.jj_consume_token(57);
        c.validate();
        return c;
    }

    public final CssCheckableValue mathfunction1() throws ParseException {
        Token n = this.jj_consume_token(137);
        block6: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 21: {
                    break;
                }
                default: {
                    this.jj_la1[279] = this.jj_gen;
                    break block6;
                }
            }
            this.jj_consume_token(21);
        }
        CssCheckableValue v = this.mathsum();
        CssMathFunction c = new CssMathFunction(this.ac, n.image, v);
        block7: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 21: {
                    break;
                }
                default: {
                    this.jj_la1[280] = this.jj_gen;
                    break block7;
                }
            }
            this.jj_consume_token(21);
        }
        this.jj_consume_token(57);
        c.validate();
        return c;
    }

    public final CssCheckableValue mathfunction2() throws ParseException {
        Token n = this.jj_consume_token(138);
        block15: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 21: {
                    break;
                }
                default: {
                    this.jj_la1[281] = this.jj_gen;
                    break block15;
                }
            }
            this.jj_consume_token(21);
        }
        CssCheckableValue v = this.mathsum();
        CssMathFunction c = new CssMathFunction(this.ac, n.image, v);
        block16: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 21: {
                    break;
                }
                default: {
                    this.jj_la1[282] = this.jj_gen;
                    break block16;
                }
            }
            this.jj_consume_token(21);
        }
        block6 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 32: {
                this.jj_consume_token(32);
                block17: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 21: {
                            break;
                        }
                        default: {
                            this.jj_la1[283] = this.jj_gen;
                            break block17;
                        }
                    }
                    this.jj_consume_token(21);
                }
                v = this.mathsum();
                c.addValue(v);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 21: {
                            break;
                        }
                        default: {
                            this.jj_la1[284] = this.jj_gen;
                            break block6;
                        }
                    }
                    this.jj_consume_token(21);
                }
            }
            default: {
                this.jj_la1[285] = this.jj_gen;
            }
        }
        this.jj_consume_token(57);
        c.validate();
        return c;
    }

    public final CssCheckableValue mathclamp() throws ParseException {
        Token n = this.jj_consume_token(140);
        block18: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 21: {
                    break;
                }
                default: {
                    this.jj_la1[286] = this.jj_gen;
                    break block18;
                }
            }
            this.jj_consume_token(21);
        }
        CssCheckableValue v1 = this.mathsum();
        block19: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 21: {
                    break;
                }
                default: {
                    this.jj_la1[287] = this.jj_gen;
                    break block19;
                }
            }
            this.jj_consume_token(21);
        }
        this.jj_consume_token(32);
        block20: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 21: {
                    break;
                }
                default: {
                    this.jj_la1[288] = this.jj_gen;
                    break block20;
                }
            }
            this.jj_consume_token(21);
        }
        CssCheckableValue v2 = this.mathsum();
        block21: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 21: {
                    break;
                }
                default: {
                    this.jj_la1[289] = this.jj_gen;
                    break block21;
                }
            }
            this.jj_consume_token(21);
        }
        this.jj_consume_token(32);
        block22: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 21: {
                    break;
                }
                default: {
                    this.jj_la1[290] = this.jj_gen;
                    break block22;
                }
            }
            this.jj_consume_token(21);
        }
        CssCheckableValue v3 = this.mathsum();
        block23: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 21: {
                    break;
                }
                default: {
                    this.jj_la1[291] = this.jj_gen;
                    break block23;
                }
            }
            this.jj_consume_token(21);
        }
        this.jj_consume_token(57);
        CssMathFunction c = new CssMathFunction(this.ac, n.image);
        c.addValue(v1);
        c.addValue(v2);
        c.addValue(v3);
        c.validate();
        return c;
    }

    public final CssCheckableValue mathcalc() throws ParseException {
        Token n = this.jj_consume_token(135);
        block6: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 21: {
                    break;
                }
                default: {
                    this.jj_la1[292] = this.jj_gen;
                    break block6;
                }
            }
            this.jj_consume_token(21);
        }
        CssCheckableValue v = this.mathsum();
        block7: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 21: {
                    break;
                }
                default: {
                    this.jj_la1[293] = this.jj_gen;
                    break block7;
                }
            }
            this.jj_consume_token(21);
        }
        this.jj_consume_token(57);
        String funcname = n.image.toLowerCase();
        if (funcname.charAt(0) == '-') {
            if (this.ac.getTreatVendorExtensionsAsWarnings()) {
                this.ac.getFrame().addWarning("vendor-extension", funcname.substring(0, funcname.length() - 1));
            } else {
                this.addError((Exception)new ParseException(this.ac.getMsg().getString("warning.vendor-extension")), funcname);
            }
        }
        CssCalc c = v.getRawType() != 19 ? new CssCalc(v) : (CssCalc)v;
        c.validate();
        c.setImplicitFunction(false);
        return c;
    }

    public final CssCheckableValue mathsum() throws ParseException {
        CssCheckableValue v1 = null;
        CssCheckableValue v2 = null;
        boolean concat = false;
        v1 = this.mathproduct();
        CssCalc c = new CssCalc(this.ac, v1);
        int nb_pre_sp = 0;
        while (this.jj_2_25(2)) {
            Token o;
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 28: {
                    o = this.jj_consume_token(28);
                    break;
                }
                case 21: 
                case 29: {
                    block11: while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 21: {
                                break;
                            }
                            default: {
                                this.jj_la1[294] = this.jj_gen;
                                break block11;
                            }
                        }
                        this.jj_consume_token(21);
                        ++nb_pre_sp;
                    }
                    o = this.jj_consume_token(29);
                    break;
                }
                default: {
                    this.jj_la1[295] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            if (o.image.length() < 2 && nb_pre_sp == 0) {
                throw new ParseException(this.ac.getMsg().getString("parser.calcwhitespace"));
            }
            block12: while (true) {
                this.jj_consume_token(21);
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 21: {
                        continue block12;
                    }
                }
                break;
            }
            this.jj_la1[296] = this.jj_gen;
            v2 = this.mathproduct();
            nb_pre_sp = 0;
            if (concat) {
                CssCalc nc = new CssCalc(this.ac, c);
                if (c.hasCssVariable()) {
                    nc.markCssVariable();
                }
                nc.addRightSide(o.image.trim(), v2);
                c = nc;
                continue;
            }
            c.addRightSide(o.image.trim(), v2);
            concat = true;
        }
        return c;
    }

    public final CssCheckableValue mathproduct() throws ParseException {
        CssCheckableValue v1 = null;
        CssCheckableValue v2 = null;
        int operator = 32;
        boolean concat = false;
        v1 = this.mathunit();
        CssCalc c = new CssCalc(this.ac, v1);
        while (this.jj_2_26(2)) {
            Token o;
            block18: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 21: {
                        break;
                    }
                    default: {
                        this.jj_la1[297] = this.jj_gen;
                        break block18;
                    }
                }
                this.jj_consume_token(21);
            }
            block3 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 55: {
                    o = this.jj_consume_token(55);
                    block19: while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 21: {
                                break;
                            }
                            default: {
                                this.jj_la1[298] = this.jj_gen;
                                break block19;
                            }
                        }
                        this.jj_consume_token(21);
                    }
                    v2 = this.mathunit();
                    break;
                }
                case 52: {
                    o = this.jj_consume_token(52);
                    block20: while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 21: {
                                break;
                            }
                            default: {
                                this.jj_la1[299] = this.jj_gen;
                                break block20;
                            }
                        }
                        this.jj_consume_token(21);
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 28: 
                        case 29: 
                        case 41: 
                        case 58: 
                        case 75: {
                            v2 = this.calcnumbervalue();
                            break block3;
                        }
                        case 142: {
                            v2 = this.functionvar();
                            if (v2.getType() != 25) break block3;
                            c.markCssVariable();
                            break block3;
                        }
                        default: {
                            this.jj_la1[300] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                }
                default: {
                    this.jj_la1[301] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            if (concat) {
                CssCalc nc = new CssCalc(this.ac, c);
                if (c.hasCssVariable()) {
                    nc.markCssVariable();
                }
                nc.addRightSide(o.image, v2);
                c = nc;
                continue;
            }
            c.addRightSide(o.image, v2);
            concat = true;
        }
        return c;
    }

    public final CssCheckableValue calcnumbervalue() throws ParseException {
        CssCheckableValue v = null;
        char operator = ' ';
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 28: 
            case 29: 
            case 41: 
            case 75: {
                Token n;
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 28: 
                    case 29: {
                        operator = this.unaryOperator();
                        break;
                    }
                    default: {
                        this.jj_la1[302] = this.jj_gen;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 75: {
                        n = this.jj_consume_token(75);
                        break;
                    }
                    case 41: {
                        n = this.jj_consume_token(41);
                        break;
                    }
                    default: {
                        this.jj_la1[303] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                v = new CssNumber();
                v.set(CssParser.addOperator(operator, n.image), this.ac);
                break;
            }
            case 58: {
                this.jj_consume_token(58);
                block19: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 21: {
                            break;
                        }
                        default: {
                            this.jj_la1[304] = this.jj_gen;
                            break block19;
                        }
                    }
                    this.jj_consume_token(21);
                }
                v = this.calcnumbersum();
                block20: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 21: {
                            break;
                        }
                        default: {
                            this.jj_la1[305] = this.jj_gen;
                            break block20;
                        }
                    }
                    this.jj_consume_token(21);
                }
                this.jj_consume_token(57);
                try {
                    ((CssCalc)v).setParenthesis();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                break;
            }
            default: {
                this.jj_la1[306] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return v;
    }

    public final CssCheckableValue calcnumbersum() throws ParseException {
        CssCheckableValue v1 = null;
        CssCheckableValue v2 = null;
        int operator = 32;
        boolean concat = false;
        v1 = this.calcnumberproduct();
        CssCalc c = new CssCalc(this.ac, v1);
        int nb_pre_sp = 0;
        while (this.jj_2_27(2)) {
            Token o;
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 28: {
                    o = this.jj_consume_token(28);
                    break;
                }
                case 21: 
                case 29: {
                    block11: while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 21: {
                                break;
                            }
                            default: {
                                this.jj_la1[307] = this.jj_gen;
                                break block11;
                            }
                        }
                        this.jj_consume_token(21);
                        ++nb_pre_sp;
                    }
                    o = this.jj_consume_token(29);
                    break;
                }
                default: {
                    this.jj_la1[308] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            if (o.image.length() < 2 && nb_pre_sp == 0) {
                throw new ParseException(this.ac.getMsg().getString("parser.calcwhitespace"));
            }
            block12: while (true) {
                this.jj_consume_token(21);
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 21: {
                        continue block12;
                    }
                }
                break;
            }
            this.jj_la1[309] = this.jj_gen;
            v2 = this.calcnumberproduct();
            nb_pre_sp = 0;
            if (concat) {
                CssCalc nc = new CssCalc(this.ac, c);
                nc.addRightSide(o.image.trim(), v2);
                c = nc;
                continue;
            }
            c.addRightSide(o.image.trim(), v2);
            concat = true;
        }
        return c;
    }

    public final CssCheckableValue calcnumberproduct() throws ParseException {
        CssCheckableValue v1 = null;
        CssCheckableValue v2 = null;
        int operator = 32;
        boolean concat = false;
        v1 = this.calcnumbervalue();
        CssCalc c = new CssCalc(this.ac, v1);
        while (this.jj_2_28(2)) {
            Token o;
            block11: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 21: {
                        break;
                    }
                    default: {
                        this.jj_la1[310] = this.jj_gen;
                        break block11;
                    }
                }
                this.jj_consume_token(21);
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 52: {
                    o = this.jj_consume_token(52);
                    break;
                }
                case 55: {
                    o = this.jj_consume_token(55);
                    break;
                }
                default: {
                    this.jj_la1[311] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            block12: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 21: {
                        break;
                    }
                    default: {
                        this.jj_la1[312] = this.jj_gen;
                        break block12;
                    }
                }
                this.jj_consume_token(21);
            }
            v2 = this.calcnumbervalue();
            if (concat) {
                CssCalc nc = new CssCalc(this.ac, c);
                nc.addRightSide(o.image, v2);
                c = nc;
                continue;
            }
            c.addRightSide(o.image, v2);
            concat = true;
        }
        return c;
    }

    public final CssCheckableValue mathunit() throws ParseException {
        CssCheckableValue v = null;
        char operator = ' ';
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 28: 
            case 29: 
            case 41: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 68: 
            case 69: 
            case 74: 
            case 75: {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 28: 
                    case 29: {
                        operator = this.unaryOperator();
                        break;
                    }
                    default: {
                        this.jj_la1[313] = this.jj_gen;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 41: 
                    case 75: {
                        Token n;
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 75: {
                                n = this.jj_consume_token(75);
                                break;
                            }
                            case 41: {
                                n = this.jj_consume_token(41);
                                break;
                            }
                            default: {
                                this.jj_la1[314] = this.jj_gen;
                                this.jj_consume_token(-1);
                                throw new ParseException();
                            }
                        }
                        v = new CssNumber();
                        v.set(CssParser.addOperator(operator, n.image), this.ac);
                        break block0;
                    }
                    case 74: {
                        Token n = this.jj_consume_token(74);
                        v = new CssPercentage();
                        v.set(CssParser.addOperator(operator, n.image), this.ac);
                        break block0;
                    }
                    case 61: {
                        Token n = this.jj_consume_token(61);
                        v = new CssLength();
                        v.set(CssParser.addOperator(operator, n.image), this.ac);
                        break block0;
                    }
                    case 62: {
                        Token n = this.jj_consume_token(62);
                        v = new CssLength();
                        v.set(CssParser.addOperator(operator, n.image), this.ac);
                        break block0;
                    }
                    case 63: {
                        Token n = this.jj_consume_token(63);
                        v = new CssLength();
                        v.set(CssParser.addOperator(operator, n.image), this.ac);
                        break block0;
                    }
                    case 64: {
                        Token n = this.jj_consume_token(64);
                        v = new CssFlexibleLength();
                        v.set(CssParser.addOperator(operator, n.image), this.ac);
                        break block0;
                    }
                    case 65: {
                        Token n = this.jj_consume_token(65);
                        v = new CssAngle();
                        v.set(CssParser.addOperator(operator, n.image), this.ac);
                        break block0;
                    }
                    case 68: {
                        Token n = this.jj_consume_token(68);
                        v = new CssTime();
                        v.set(CssParser.addOperator(operator, n.image), this.ac);
                        break block0;
                    }
                    case 69: {
                        Token n = this.jj_consume_token(69);
                        v = new CssFrequency();
                        v.set(CssParser.addOperator(operator, n.image), this.ac);
                        break block0;
                    }
                }
                this.jj_la1[315] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            case 58: {
                this.jj_consume_token(58);
                block33: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 21: {
                            break;
                        }
                        default: {
                            this.jj_la1[316] = this.jj_gen;
                            break block33;
                        }
                    }
                    this.jj_consume_token(21);
                }
                v = this.mathsum();
                block34: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 21: {
                            break;
                        }
                        default: {
                            this.jj_la1[317] = this.jj_gen;
                            break block34;
                        }
                    }
                    this.jj_consume_token(21);
                }
                this.jj_consume_token(57);
                ((CssCalc)v).setParenthesis();
                break;
            }
            case 135: {
                v = this.mathcalc();
                break;
            }
            case 136: 
            case 137: 
            case 138: 
            case 139: {
                v = this.mathfunction();
                break;
            }
            case 140: {
                v = this.mathclamp();
                break;
            }
            case 141: {
                v = this.attr();
                break;
            }
            case 142: {
                v = this.functionvar();
                break;
            }
            default: {
                this.jj_la1[318] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return v;
    }

    public final CssCheckableValue attr() throws ParseException {
        CssAttr v = null;
        Token n = null;
        CssExpression exp = null;
        this.jj_consume_token(141);
        block22: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 21: {
                    break;
                }
                default: {
                    this.jj_la1[319] = this.jj_gen;
                    break block22;
                }
            }
            this.jj_consume_token(21);
        }
        n = this.ident();
        block23: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 21: {
                    break;
                }
                default: {
                    this.jj_la1[320] = this.jj_gen;
                    break block23;
                }
            }
            this.jj_consume_token(21);
        }
        exp = new CssExpression();
        this.setValue(new CssIdent(), exp, ' ', n, 41);
        block6 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 41: 
            case 148: {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 35: 
                    case 36: 
                    case 37: 
                    case 38: 
                    case 41: {
                        n = this.ident();
                        break;
                    }
                    case 148: {
                        n = this.jj_consume_token(148);
                        break;
                    }
                    default: {
                        this.jj_la1[321] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                this.setValue(new CssIdent(), exp, ' ', n, 41);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 21: {
                            break;
                        }
                        default: {
                            this.jj_la1[322] = this.jj_gen;
                            break block6;
                        }
                    }
                    this.jj_consume_token(21);
                }
            }
            default: {
                this.jj_la1[323] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 32: {
                this.jj_consume_token(32);
                exp.setOperator(',');
                block25: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 21: {
                            break;
                        }
                        default: {
                            this.jj_la1[324] = this.jj_gen;
                            break block25;
                        }
                    }
                    this.jj_consume_token(21);
                }
                this.term(exp);
                break;
            }
            default: {
                this.jj_la1[325] = this.jj_gen;
            }
        }
        this.jj_consume_token(57);
        v = new CssAttr();
        v.setValue(exp, this.ac);
        return v;
    }

    /*
     * Unable to fully structure code
     */
    public final CssCheckableValue functionvar() throws ParseException {
        exp = null;
        this.jj_consume_token(142);
        block14: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 21: {
                    break;
                }
                default: {
                    this.jj_la1[326] = this.jj_gen;
                    break block14;
                }
            }
            this.jj_consume_token(21);
        }
        n = this.jj_consume_token(45);
        var = new CssVariable(this.ac, this.convertIdent(n.image));
        block15: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 32: {
                    break;
                }
                default: {
                    this.jj_la1[327] = this.jj_gen;
                    break block15;
                }
            }
            this.jj_consume_token(32);
            block16: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 21: {
                        break;
                    }
                    default: {
                        this.jj_la1[328] = this.jj_gen;
                        break block16;
                    }
                }
                this.jj_consume_token(21);
            }
            try {
                e = this.expr();
            }
            catch (ParseException pe) {
                s = this.skip_to_matching_paren();
                e = null;
            }
            if (e == null) continue;
            if (exp == null) {
                exp = e;
                continue;
            }
            exp.setOperator(',');
            while (true) {
                if (!e.end()) ** break;
                continue block15;
                exp.addValue(e.getValue());
                exp.setOperator(e.getOperator());
                e.next();
            }
            break;
        }
        block18: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 21: {
                    break;
                }
                default: {
                    this.jj_la1[329] = this.jj_gen;
                    break block18;
                }
            }
            this.jj_consume_token(21);
        }
        this.jj_consume_token(57);
        if (exp != null) {
            var.set(exp);
        }
        return var;
    }

    public final CssValue function() throws ParseException {
        Token p = null;
        Token q = null;
        CssExpression exp = new CssExpression();
        CssColor color = new CssColor();
        Token n = this.jj_consume_token(143);
        block9: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 21: {
                    break;
                }
                default: {
                    this.jj_la1[330] = this.jj_gen;
                    break block9;
                }
            }
            this.jj_consume_token(21);
        }
        if (this.jj_2_29(2)) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 28: 
                case 29: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 52: 
                case 53: 
                case 54: 
                case 60: 
                case 61: 
                case 62: 
                case 63: 
                case 64: 
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 72: 
                case 73: 
                case 74: 
                case 75: 
                case 77: 
                case 119: 
                case 135: 
                case 136: 
                case 137: 
                case 138: 
                case 139: 
                case 140: 
                case 141: 
                case 142: 
                case 143: {
                    exp = this.expr();
                    break;
                }
                default: {
                    this.jj_la1[331] = this.jj_gen;
                }
            }
            this.jj_consume_token(57);
            String funcname = n.image.toLowerCase();
            if (funcname.equals("rgb(")) {
                color.setRGBColor(this.ac, exp);
                return color;
            }
            if (funcname.equals("rgba(")) {
                color.setRGBAColor(this.ac, exp);
                return color;
            }
            if (funcname.equals("hsl(")) {
                color.setHSLColor(this.ac, exp);
                return color;
            }
            if (funcname.equals("hsla(")) {
                color.setHSLColor(this.ac, exp);
                return color;
            }
            if (funcname.equals("hwb(")) {
                color.setHWBColor(this.ac, exp);
                return color;
            }
            if (funcname.equals("lab(")) {
                color.setLABColor(this.ac, exp);
                return color;
            }
            if (funcname.equals("lch(")) {
                color.setLCHColor(this.ac, exp);
                return color;
            }
            if (funcname.equals("device-cmyk(")) {
                color.setDeviceCMYKColor(this.ac, exp);
                return color;
            }
            if (funcname.equals("light-dark(")) {
                color.setLightDark(this.ac, exp);
                return color;
            }
            if (funcname.equals("color-mix(")) {
                color.setColorMix(this.ac, exp);
                return color;
            }
            if (funcname.equals("image(")) {
                CssImage img = new CssImage();
                img.setImageList(exp, this.ac);
                return img;
            }
            if (funcname.equals("linear-gradient(")) {
                CssImage img = new CssImage();
                img.setLinearGradient(exp, this.ac);
                return img;
            }
            if (funcname.equals("repeating-linear-gradient(")) {
                CssImage img = new CssImage();
                img.setRepeatingLinearGradient(exp, this.ac);
                return img;
            }
            if (funcname.equals("radial-gradient(")) {
                CssImage img = new CssImage();
                img.setRadialGradient(exp, this.ac);
                return img;
            }
            if (funcname.equals("repeating-radial-gradient(")) {
                CssImage img = new CssImage();
                img.setRepeatingRadialGradient(exp, this.ac);
                return img;
            }
            if (funcname.equals("conic-gradient(")) {
                CssImage img = new CssImage();
                img.setConicGradient(exp, this.ac);
                return img;
            }
            if (funcname.equals("repeating-conic-gradient(")) {
                CssImage img = new CssImage();
                img.setRepeatingConicGradient(exp, this.ac);
                return img;
            }
            if (funcname.equals("atsc-rgba(")) {
                if (this.getAtRule().toString().equals("@media atsc-tv")) {
                    color.setATSCRGBAColor(this.ac, exp);
                    return color;
                }
                this.addError((Exception)new InvalidParamException("onlyATSC", "", this.ac), this.getAtRule().toString());
                return null;
            }
            CssFunction f = new CssFunction();
            f.set(n.image.substring(0, n.image.length() - 1), exp);
            if (funcname.charAt(0) == '-') {
                exp.markVendorExtension();
            }
            return f;
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 41: {
                p = this.ident();
                this.jj_consume_token(50);
                q = this.jj_consume_token(75);
                this.jj_consume_token(57);
                break;
            }
            default: {
                this.jj_la1[332] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        exp = new CssExpression();
        this.setValue(new CssIdent(), exp, ' ', p, 41);
        exp.setOperator('=');
        this.setValue(new CssNumber(), exp, ' ', q, 75);
        exp.markVendorExtension();
        CssFunction f = new CssFunction();
        f.set(n.image.substring(0, n.image.length() - 1), exp);
        return f;
    }

    public final void hashident(CssExpression exp) throws ParseException {
        Token n;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 42: {
                n = this.jj_consume_token(42);
                break;
            }
            case 43: {
                n = this.jj_consume_token(43);
                break;
            }
            default: {
                this.jj_la1[333] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        n.image = Util.strip(n.image);
        this.setValue(new CssHashIdent(), exp, ' ', n, 43);
    }

    String skipStatement() throws ParseException {
        StringBuilder s = new StringBuilder();
        Token tok = this.getToken(0);
        boolean first = true;
        if (tok.image != null) {
            s.append(tok.image);
        }
        while (true) {
            try {
                tok = this.getToken(1);
                if (tok.kind == 0) {
                    if (!first) break;
                    return null;
                }
                if (tok.kind == 27) {
                    s.append(tok.image);
                    this.getNextToken();
                    s.append(this.skip_to_matching_brace());
                    this.getNextToken();
                    tok = this.getToken(1);
                    break;
                }
                if (tok.kind == 46 || tok.kind == 51) {
                    s.append(tok.image);
                    this.getNextToken();
                    tok = this.getToken(1);
                    break;
                }
                if (tok.kind == 22 && this.ac.getCssVersion().compareTo(CssVersion.CSS3) >= 0) {
                    do {
                        tok = this.getNextToken();
                    } while (tok.kind != 0);
                    break;
                }
                s.append(tok.image);
                this.getNextToken();
            }
            catch (TokenMgrError tokenerror) {
                try {
                    s.append(this.jj_input_stream.readChar());
                    continue;
                }
                catch (IOException ioex) {
                    return s.toString().trim();
                }
            }
            first = false;
        }
        while (tok.kind == 21) {
            this.getNextToken();
            tok = this.getToken(1);
        }
        String statement = s.toString().trim();
        return statement;
    }

    String skip_to_matching_brace() throws ParseException {
        StringBuilder s = new StringBuilder();
        int nesting = 1;
        while (true) {
            Token tok = this.getToken(1);
            if (tok.kind == 0) break;
            if (tok.kind == 27) {
                ++nesting;
            } else if (tok.kind == 46 && --nesting == 0) {
                s.append(tok.image);
                break;
            }
            s.append(tok.image);
            this.getNextToken();
        }
        return s.toString();
    }

    String skip_to_matching_paren() throws ParseException {
        StringBuilder s = new StringBuilder();
        int nesting = 1;
        block4: while (nesting > 0) {
            Token tok = this.getToken(1);
            if (tok.kind == 0) break;
            switch (tok.kind) {
                case 58: 
                case 120: 
                case 121: 
                case 122: 
                case 123: 
                case 124: 
                case 125: 
                case 126: 
                case 127: 
                case 128: 
                case 129: 
                case 130: 
                case 131: 
                case 132: 
                case 133: 
                case 134: 
                case 135: 
                case 136: 
                case 137: 
                case 138: 
                case 139: 
                case 140: 
                case 141: 
                case 142: 
                case 143: {
                    s.append(tok.image);
                    ++nesting;
                    this.getNextToken();
                    continue block4;
                }
                case 57: {
                    if (--nesting != 0) break;
                    continue block4;
                }
            }
            s.append(tok.image);
            this.getNextToken();
        }
        return s.toString();
    }

    void rejectToken(Token t) throws ParseException {
        Token fakeToken = new Token();
        t.next = this.token;
        fakeToken.next = t;
        this.token = fakeToken;
    }

    void skipAfterExpression(Exception e) throws ParseException {
        StringBuilder s = new StringBuilder();
        s.append(this.getToken((int)0).image);
        block4: while (true) {
            try {
                while (true) {
                    Token t = this.getToken(1);
                    if (t.kind == 27) {
                        s.append(t.image);
                        this.getNextToken();
                        s.append(this.skip_to_matching_brace());
                        this.getNextToken();
                        t = this.getToken(1);
                        continue;
                    }
                    if (t.kind == 51 || t.kind == 46 || t.kind == 0) break block4;
                    s.append(t.image);
                    this.getNextToken();
                    t = this.getToken(1);
                }
            }
            catch (TokenMgrError tmerr) {
                try {
                    s.append(this.jj_input_stream.readChar());
                }
                catch (IOException ioex) {
                    ioex.printStackTrace();
                    break;
                }
            }
        }
        String statement = s.toString().trim();
        this.addError(e, s.toString());
    }

    public String convertStringIndex(String s, int start, int len, boolean escapeFirst) throws ParseException {
        try {
            return StringUtils.convertStringIndex(s, start, len, escapeFirst, this.ac);
        }
        catch (InvalidParamException nex) {
            throw new ParseException("invalid string");
        }
    }

    String convertIdent(String s) throws ParseException, ParseException {
        try {
            return StringUtils.convertIdent(s, this.ac);
        }
        catch (InvalidParamException nex) {
            throw new ParseException("invalid string");
        }
    }

    String convertClassIdent(String s) throws ParseException {
        try {
            return StringUtils.convertClassIdent(s, this.ac);
        }
        catch (InvalidParamException nex) {
            throw new ParseException("invalid string");
        }
    }

    String convertString(String s) throws ParseException {
        try {
            return StringUtils.convertString(s, this.ac);
        }
        catch (InvalidParamException nex) {
            throw new ParseException("invalid string");
        }
    }

    String hexEscapeFirst(String s) throws ParseException {
        StringBuilder sb = new StringBuilder();
        sb.append('\\').append(Integer.toString(s.charAt(0), 16));
        char c = s.charAt(1);
        if (c >= '0' && c <= '9' || c >= 'A' && c <= 'F' || c >= 'a' && c <= 'f') {
            sb.append(' ');
        }
        sb.append(s.substring(1));
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_1(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_1();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(0, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_2(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_2();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(1, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_3(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_3();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(2, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_4(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_4();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(3, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_5(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_5();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(4, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_6(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_6();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(5, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_7(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_7();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(6, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_8(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_8();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(7, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_9(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_9();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(8, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_10(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_10();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(9, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_11(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_11();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(10, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_12(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_12();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(11, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_13(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_13();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(12, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_14(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_14();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(13, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_15(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_15();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(14, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_16(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_16();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(15, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_17(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_17();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(16, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_18(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_18();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(17, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_19(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_19();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(18, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_20(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_20();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(19, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_21(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_21();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(20, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_22(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_22();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(21, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_23(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_23();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(22, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_24(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_24();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(23, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_25(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_25();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(24, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_26(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_26();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(25, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_27(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_27();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(26, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_28(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_28();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(27, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_29(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_29();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(28, xla);
        }
    }

    private boolean jj_3R_452() {
        return this.jj_3R_238();
    }

    private boolean jj_3R_300() {
        return this.jj_3R_232();
    }

    private boolean jj_3R_451() {
        return this.jj_scan_token(39);
    }

    private boolean jj_3R_299() {
        return this.jj_3R_370();
    }

    private boolean jj_3R_450() {
        return this.jj_scan_token(73);
    }

    private boolean jj_3R_298() {
        return this.jj_3R_369();
    }

    private boolean jj_3R_297() {
        return this.jj_3R_368();
    }

    private boolean jj_3R_449() {
        return this.jj_scan_token(74);
    }

    private boolean jj_3R_448() {
        return this.jj_scan_token(75);
    }

    private boolean jj_3R_263() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_297()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_298()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_299()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_300()) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_447() {
        return this.jj_scan_token(29);
    }

    private boolean jj_3R_446() {
        return this.jj_scan_token(28);
    }

    private boolean jj_3R_441() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_446()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_447()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_448()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_449()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_450()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3R_451()) {
                                this.jj_scanpos = xsp;
                                if (this.jj_3R_452()) {
                                    return true;
                                }
                            }
                        }
                    }
                }
            }
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_scan_token(21));
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_431() {
        Token xsp;
        if (this.jj_3R_441()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_441());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_376() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(42)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(43)) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_405() {
        if (this.jj_3R_238()) {
            return true;
        }
        if (this.jj_scan_token(50)) {
            return true;
        }
        return this.jj_scan_token(75);
    }

    private boolean jj_3R_443() {
        return this.jj_3R_255();
    }

    private boolean jj_3R_437() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_443()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_3R_435();
    }

    private boolean jj_3R_248() {
        return this.jj_3R_279();
    }

    private boolean jj_3R_394() {
        if (this.jj_3R_408()) {
            return true;
        }
        return this.jj_scan_token(59);
    }

    private boolean jj_3_29() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_248()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(57);
    }

    private boolean jj_3R_375() {
        Token xsp;
        if (this.jj_scan_token(143)) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_scan_token(21));
        xsp = this.jj_scanpos = xsp;
        if (this.jj_3_29()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_405()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_428() {
        this.jj_la = 0;
        this.jj_scanpos = this.jj_lastpos;
        return false;
    }

    private boolean jj_3R_396() {
        return this.jj_scan_token(43);
    }

    private boolean jj_3R_458() {
        return this.jj_scan_token(32);
    }

    private boolean jj_3R_459() {
        return this.jj_scan_token(32);
    }

    private boolean jj_3R_360() {
        Token xsp;
        if (this.jj_scan_token(142)) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_scan_token(21));
        this.jj_scanpos = xsp;
        if (this.jj_scan_token(45)) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_459());
        this.jj_scanpos = xsp;
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_scan_token(21));
        this.jj_scanpos = xsp;
        return this.jj_scan_token(57);
    }

    private boolean jj_3R_460() {
        return this.jj_3R_238();
    }

    private boolean jj_3R_457() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_460()) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(148)) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_384() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(75)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(41)) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_374() {
        Token xsp;
        if (this.jj_scan_token(141)) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_scan_token(21));
        this.jj_scanpos = xsp;
        if (this.jj_3R_238()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_scan_token(21));
        xsp = this.jj_scanpos = xsp;
        if (this.jj_3R_457()) {
            this.jj_scanpos = xsp;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3R_458()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(57);
    }

    private boolean jj_3R_362() {
        return this.jj_3R_393();
    }

    private boolean jj_3R_359() {
        return this.jj_3R_360();
    }

    private boolean jj_3R_358() {
        return this.jj_3R_374();
    }

    private boolean jj_3R_357() {
        return this.jj_3R_373();
    }

    private boolean jj_3R_356() {
        return this.jj_3R_372();
    }

    private boolean jj_3R_430() {
        this.jj_la = 0;
        this.jj_scanpos = this.jj_lastpos;
        return false;
    }

    private boolean jj_3R_355() {
        return this.jj_3R_371();
    }

    private boolean jj_3R_354() {
        Token xsp;
        if (this.jj_scan_token(58)) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_scan_token(21));
        this.jj_scanpos = xsp;
        if (this.jj_3R_400()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_scan_token(21));
        this.jj_scanpos = xsp;
        return this.jj_scan_token(57);
    }

    private boolean jj_3R_392() {
        return this.jj_scan_token(69);
    }

    private boolean jj_3R_391() {
        return this.jj_scan_token(68);
    }

    private boolean jj_3R_390() {
        return this.jj_scan_token(65);
    }

    private boolean jj_3R_389() {
        return this.jj_scan_token(64);
    }

    private boolean jj_3R_388() {
        return this.jj_scan_token(63);
    }

    private boolean jj_3R_387() {
        return this.jj_scan_token(62);
    }

    private boolean jj_3R_383() {
        return this.jj_3R_254();
    }

    private boolean jj_3R_386() {
        return this.jj_scan_token(61);
    }

    private boolean jj_3R_385() {
        return this.jj_scan_token(74);
    }

    private boolean jj_3R_353() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_383()) {
            this.jj_scanpos = xsp;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3R_384()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_385()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_386()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_387()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_388()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3R_389()) {
                                this.jj_scanpos = xsp;
                                if (this.jj_3R_390()) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_3R_391()) {
                                        this.jj_scanpos = xsp;
                                        if (this.jj_3R_392()) {
                                            return true;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_273() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_353()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_354()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_355()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_356()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_357()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3R_358()) {
                                this.jj_scanpos = xsp;
                                if (this.jj_3R_359()) {
                                    return true;
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_368() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_395()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_396()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_395() {
        return this.jj_scan_token(42);
    }

    private boolean jj_3R_440() {
        return this.jj_3R_238();
    }

    private boolean jj_3R_294() {
        Token xsp;
        if (this.jj_scan_token(143)) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_scan_token(21));
        this.jj_scanpos = xsp;
        return this.jj_3R_431();
    }

    private boolean jj_3R_363() {
        return this.jj_3R_394();
    }

    private boolean jj_3R_276() {
        return this.jj_scan_token(21);
    }

    private boolean jj_3_4() {
        return this.jj_3R_224();
    }

    private boolean jj_3R_429() {
        Token xsp;
        if (this.jj_3R_439()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_scan_token(21));
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_246() {
        Token xsp;
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_276());
        this.jj_scanpos = xsp;
        return this.jj_scan_token(29);
    }

    private boolean jj_3R_282() {
        Token xsp;
        if (this.jj_scan_token(58)) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_scan_token(21));
        xsp = this.jj_scanpos = xsp;
        if (this.jj_3_4()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_363()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3_28() {
        Token xsp;
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_scan_token(21));
        xsp = this.jj_scanpos = xsp;
        if (this.jj_scan_token(52)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(55)) {
                return true;
            }
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_scan_token(21));
        this.jj_scanpos = xsp;
        return this.jj_3R_247();
    }

    private boolean jj_3R_293() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(130)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(131)) {
                return true;
            }
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_scan_token(21));
        xsp = this.jj_scanpos = xsp;
        if (this.jj_3R_429()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_430()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_438() {
        return this.jj_scan_token(32);
    }

    private boolean jj_3_3() {
        return this.jj_3R_223();
    }

    private boolean jj_3R_427() {
        Token xsp;
        if (this.jj_3R_439()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_scan_token(21));
        xsp = this.jj_scanpos = xsp;
        if (this.jj_3R_440()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_226() {
        Token xsp;
        if (this.jj_3R_254()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_scan_token(21));
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_426() {
        Token xsp;
        if (this.jj_3R_437()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_438());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_292() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(128)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(129)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(132)) {
                    this.jj_scanpos = xsp;
                    if (this.jj_scan_token(133)) {
                        return true;
                    }
                }
            }
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_scan_token(21));
        xsp = this.jj_scanpos = xsp;
        if (this.jj_3R_427()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_428()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3_27() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(28)) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_246()) {
                return true;
            }
        }
        if (this.jj_scan_token(21)) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_scan_token(21));
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_291() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(126)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(127)) {
                return true;
            }
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_scan_token(21));
        this.jj_scanpos = xsp;
        if (this.jj_3R_230()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_scan_token(21));
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_253() {
        return this.jj_3R_282();
    }

    private boolean jj_3R_436() {
        return this.jj_scan_token(32);
    }

    private boolean jj_3R_224() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_252()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_253()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_252() {
        Token xsp;
        if (this.jj_scan_token(38)) {
            return true;
        }
        if (this.jj_scan_token(21)) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_scan_token(21));
        this.jj_scanpos = xsp;
        return this.jj_3R_282();
    }

    private boolean jj_3R_425() {
        Token xsp;
        if (this.jj_3R_435()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_436());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_290() {
        Token xsp;
        if (this.jj_scan_token(124)) {
            return true;
        }
        if (this.jj_3R_426()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_scan_token(21));
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3_6() {
        Token xsp;
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_scan_token(21));
        xsp = this.jj_scanpos = xsp;
        if (this.jj_3R_226()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(75);
    }

    private boolean jj_3R_434() {
        if (this.jj_scan_token(56)) {
            return true;
        }
        return this.jj_3R_238();
    }

    private boolean jj_3_7() {
        Token xsp;
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_scan_token(21));
        this.jj_scanpos = xsp;
        return this.jj_scan_token(75);
    }

    private boolean jj_3R_361() {
        return this.jj_3R_254();
    }

    private boolean jj_3R_289() {
        Token xsp;
        if (this.jj_scan_token(123)) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_scan_token(21));
        this.jj_scanpos = xsp;
        if (this.jj_3R_425()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_scan_token(21));
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_278() {
        return this.jj_scan_token(58);
    }

    private boolean jj_3R_277() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_361()) {
            this.jj_scanpos = xsp;
        }
        xsp = this.jj_scanpos;
        if (this.jj_scan_token(75)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(41)) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_247() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_277()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_278()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_424() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(42)) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_434()) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(109)) {
                    return true;
                }
            }
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_scan_token(21));
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_288() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(122)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(134)) {
                return true;
            }
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_scan_token(21));
        this.jj_scanpos = xsp;
        if (this.jj_3R_425()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_scan_token(21));
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_225() {
        Token xsp;
        if (this.jj_3R_254()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_scan_token(21));
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_287() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(121)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(120)) {
                return true;
            }
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_scan_token(21));
        this.jj_scanpos = xsp;
        return this.jj_3R_240();
    }

    private boolean jj_3R_275() {
        return this.jj_3R_360();
    }

    private boolean jj_3R_228() {
        return this.jj_3R_254();
    }

    private boolean jj_3R_442() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(146)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(147)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(148)) {
                    this.jj_scanpos = xsp;
                    if (this.jj_scan_token(149)) {
                        this.jj_scanpos = xsp;
                        if (this.jj_scan_token(150)) {
                            this.jj_scanpos = xsp;
                            if (this.jj_scan_token(151)) {
                                this.jj_scanpos = xsp;
                                if (this.jj_scan_token(152)) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_scan_token(153)) {
                                        this.jj_scanpos = xsp;
                                        if (this.jj_scan_token(55)) {
                                            this.jj_scanpos = xsp;
                                            if (this.jj_scan_token(50)) {
                                                this.jj_scanpos = xsp;
                                                if (this.jj_scan_token(54)) {
                                                    this.jj_scanpos = xsp;
                                                    if (this.jj_scan_token(53)) {
                                                        this.jj_scanpos = xsp;
                                                        if (this.jj_scan_token(57)) {
                                                            this.jj_scanpos = xsp;
                                                            if (this.jj_scan_token(58)) {
                                                                this.jj_scanpos = xsp;
                                                                if (this.jj_scan_token(59)) {
                                                                    this.jj_scanpos = xsp;
                                                                    if (this.jj_scan_token(33)) {
                                                                        this.jj_scanpos = xsp;
                                                                        if (this.jj_scan_token(28)) {
                                                                            this.jj_scanpos = xsp;
                                                                            if (this.jj_scan_token(32)) {
                                                                                this.jj_scanpos = xsp;
                                                                                if (this.jj_scan_token(30)) {
                                                                                    this.jj_scanpos = xsp;
                                                                                    if (this.jj_scan_token(52)) {
                                                                                        return true;
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_261() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_287()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_288()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_289()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_290()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_291()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3R_292()) {
                                this.jj_scanpos = xsp;
                                if (this.jj_3R_293()) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_3R_294()) {
                                        return true;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return this.jj_scan_token(57);
    }

    private boolean jj_3R_274() {
        return this.jj_3R_247();
    }

    private boolean jj_3R_433() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_442()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_3R_238();
    }

    private boolean jj_3R_408() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_423()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_424()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_423() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_433()) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(45)) {
                return true;
            }
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_scan_token(21));
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_453() {
        return this.jj_3R_254();
    }

    private boolean jj_3R_260() {
        return this.jj_3R_238();
    }

    private boolean jj_3R_245() {
        Token xsp;
        if (this.jj_scan_token(52)) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_scan_token(21));
        xsp = this.jj_scanpos = xsp;
        if (this.jj_3R_274()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_275()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_227() {
        return this.jj_3R_254();
    }

    private boolean jj_3R_244() {
        Token xsp;
        if (this.jj_scan_token(55)) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_scan_token(21));
        this.jj_scanpos = xsp;
        return this.jj_3R_273();
    }

    private boolean jj_3R_445() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_453()) {
            this.jj_scanpos = xsp;
        }
        if (this.jj_scan_token(73)) {
            return true;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3_7()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3_26() {
        Token xsp;
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_scan_token(21));
        xsp = this.jj_scanpos = xsp;
        if (this.jj_3R_244()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_245()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_272() {
        return this.jj_scan_token(21);
    }

    private boolean jj_3_9() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_228()) {
            this.jj_scanpos = xsp;
        }
        if (this.jj_scan_token(71)) {
            return true;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3_6()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_232() {
        if (this.jj_scan_token(59)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_260()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_261()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3_5() {
        Token xsp;
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_scan_token(21));
        xsp = this.jj_scanpos = xsp;
        if (this.jj_3R_225()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(75);
    }

    private boolean jj_3R_243() {
        Token xsp;
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_272());
        this.jj_scanpos = xsp;
        return this.jj_scan_token(29);
    }

    private boolean jj_3R_418() {
        Token xsp;
        if (this.jj_3R_273()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3_26());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3_8() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_227()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(75);
    }

    private boolean jj_3R_407() {
        return this.jj_scan_token(59);
    }

    private boolean jj_3R_444() {
        if (this.jj_3R_238()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3_5()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_439() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_444()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_8()) {
                this.jj_scanpos = xsp;
                if (this.jj_3_9()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_445()) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_393() {
        Token xsp;
        if (this.jj_scan_token(58)) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_scan_token(21));
        this.jj_scanpos = xsp;
        if (this.jj_scan_token(41)) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_scan_token(21));
        xsp = this.jj_scanpos = xsp;
        if (this.jj_3R_407()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(57);
    }

    private boolean jj_3_2() {
        Token xsp;
        if (this.jj_scan_token(58)) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_scan_token(21));
        this.jj_scanpos = xsp;
        return this.jj_3R_222();
    }

    private boolean jj_3R_280() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_2()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_3()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_362()) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean jj_3_25() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(28)) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_243()) {
                return true;
            }
        }
        if (this.jj_scan_token(21)) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_scan_token(21));
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_284() {
        return this.jj_scan_token(28);
    }

    private boolean jj_3R_258() {
        return this.jj_3R_238();
    }

    private boolean jj_3R_283() {
        return this.jj_scan_token(29);
    }

    private boolean jj_3R_254() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_283()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_284()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_259() {
        Token xsp;
        if (this.jj_scan_token(125)) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_scan_token(21));
        this.jj_scanpos = xsp;
        return this.jj_3R_230();
    }

    private boolean jj_3R_400() {
        Token xsp;
        if (this.jj_3R_418()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3_25());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_367() {
        return this.jj_scan_token(34);
    }

    private boolean jj_3R_250() {
        return this.jj_3R_280();
    }

    private boolean jj_3R_366() {
        return this.jj_scan_token(33);
    }

    private boolean jj_3R_286() {
        Token xsp;
        if (this.jj_scan_token(21)) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_scan_token(21));
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_365() {
        return this.jj_scan_token(30);
    }

    private boolean jj_3R_364() {
        return this.jj_scan_token(28);
    }

    private boolean jj_3R_222() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_249()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_250()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_249() {
        Token xsp;
        if (this.jj_scan_token(38)) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_scan_token(21));
        this.jj_scanpos = xsp;
        return this.jj_3R_280();
    }

    private boolean jj_3R_285() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_364()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_365()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_366()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_367()) {
                        return true;
                    }
                }
            }
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_scan_token(21));
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_255() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_285()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_286()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_231() {
        if (this.jj_scan_token(78)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_258()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_259()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3_1() {
        return this.jj_3R_222();
    }

    private boolean jj_3R_267() {
        Token xsp;
        if (this.jj_scan_token(32)) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_scan_token(21));
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_239() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_267()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_371() {
        Token xsp;
        if (this.jj_scan_token(135)) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_scan_token(21));
        this.jj_scanpos = xsp;
        if (this.jj_3R_400()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_scan_token(21));
        this.jj_scanpos = xsp;
        return this.jj_scan_token(57);
    }

    private boolean jj_3R_406() {
        Token xsp;
        if (this.jj_scan_token(75)) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_scan_token(21));
        this.jj_scanpos = xsp;
        if (this.jj_scan_token(52)) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_scan_token(21));
        this.jj_scanpos = xsp;
        return this.jj_scan_token(75);
    }

    private boolean jj_3R_373() {
        Token xsp;
        if (this.jj_scan_token(140)) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_scan_token(21));
        this.jj_scanpos = xsp;
        if (this.jj_3R_400()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_scan_token(21));
        this.jj_scanpos = xsp;
        if (this.jj_scan_token(32)) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_scan_token(21));
        this.jj_scanpos = xsp;
        return this.jj_3R_400();
    }

    private boolean jj_3R_454() {
        Token xsp;
        if (this.jj_scan_token(32)) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_scan_token(21));
        this.jj_scanpos = xsp;
        return this.jj_3R_400();
    }

    private boolean jj_3R_404() {
        return this.jj_3R_422();
    }

    private boolean jj_3R_420() {
        Token xsp;
        if (this.jj_scan_token(138)) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_scan_token(21));
        this.jj_scanpos = xsp;
        if (this.jj_3R_400()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_scan_token(21));
        xsp = this.jj_scanpos = xsp;
        if (this.jj_3R_454()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(57);
    }

    private boolean jj_3R_419() {
        Token xsp;
        if (this.jj_scan_token(137)) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_scan_token(21));
        this.jj_scanpos = xsp;
        if (this.jj_3R_400()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_scan_token(21));
        this.jj_scanpos = xsp;
        return this.jj_scan_token(57);
    }

    private boolean jj_3R_456() {
        Token xsp;
        if (this.jj_scan_token(32)) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_scan_token(21));
        this.jj_scanpos = xsp;
        return this.jj_3R_400();
    }

    private boolean jj_3_24() {
        return this.jj_scan_token(41);
    }

    private boolean jj_3R_403() {
        return this.jj_3R_421();
    }

    private boolean jj_3R_432() {
        return this.jj_3R_400();
    }

    private boolean jj_3R_266() {
        return this.jj_3R_238();
    }

    private boolean jj_3R_237() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_266()) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(55)) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_455() {
        Token xsp;
        if (this.jj_scan_token(32)) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_scan_token(21));
        this.jj_scanpos = xsp;
        return this.jj_3R_400();
    }

    private boolean jj_3R_422() {
        Token xsp;
        if (this.jj_scan_token(139)) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_scan_token(21));
        xsp = this.jj_scanpos = xsp;
        if (this.jj_3_24()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_432()) {
                return true;
            }
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_scan_token(21));
        this.jj_scanpos = xsp;
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_456());
        this.jj_scanpos = xsp;
        return this.jj_scan_token(57);
    }

    private boolean jj_3R_402() {
        return this.jj_3R_420();
    }

    private boolean jj_3_18() {
        Token xsp;
        if (this.jj_scan_token(21)) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_scan_token(21));
        this.jj_scanpos = xsp;
        return this.jj_3R_238();
    }

    private boolean jj_3_17() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_237()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(153);
    }

    private boolean jj_3R_417() {
        return this.jj_scan_token(39);
    }

    private boolean jj_3R_416() {
        return this.jj_3R_238();
    }

    private boolean jj_3R_421() {
        Token xsp;
        if (this.jj_scan_token(136)) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_scan_token(21));
        this.jj_scanpos = xsp;
        if (this.jj_3R_400()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_scan_token(21));
        this.jj_scanpos = xsp;
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_455());
        this.jj_scanpos = xsp;
        return this.jj_scan_token(57);
    }

    private boolean jj_3R_415() {
        return this.jj_scan_token(49);
    }

    private boolean jj_3R_414() {
        return this.jj_scan_token(48);
    }

    private boolean jj_3R_413() {
        return this.jj_scan_token(47);
    }

    private boolean jj_3R_412() {
        return this.jj_scan_token(26);
    }

    private boolean jj_3R_410() {
        return this.jj_scan_token(50);
    }

    private boolean jj_3R_411() {
        return this.jj_scan_token(25);
    }

    private boolean jj_3R_399() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_410()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_411()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_412()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_413()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_414()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3R_415()) {
                                return true;
                            }
                        }
                    }
                }
            }
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_scan_token(21));
        xsp = this.jj_scanpos = xsp;
        if (this.jj_3R_416()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_417()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_401() {
        return this.jj_3R_419();
    }

    private boolean jj_3R_372() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_401()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_402()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_403()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_404()) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_370() {
        Token xsp;
        if (this.jj_scan_token(53)) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_scan_token(21));
        xsp = this.jj_scanpos = xsp;
        if (this.jj_3_17()) {
            this.jj_scanpos = xsp;
        }
        if (this.jj_3R_238()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_scan_token(21));
        xsp = this.jj_scanpos = xsp;
        if (this.jj_3R_399()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(54);
    }

    private boolean jj_3R_352() {
        return this.jj_scan_token(119);
    }

    private boolean jj_3R_351() {
        return this.jj_scan_token(60);
    }

    private boolean jj_3R_350() {
        return this.jj_3R_376();
    }

    private boolean jj_3R_264() {
        return this.jj_3R_232();
    }

    private boolean jj_3R_296() {
        return this.jj_scan_token(55);
    }

    private boolean jj_3R_295() {
        return this.jj_3R_238();
    }

    private boolean jj_3R_348() {
        return this.jj_scan_token(39);
    }

    private boolean jj_3R_349() {
        return this.jj_3R_238();
    }

    private boolean jj_3R_382() {
        return this.jj_3R_373();
    }

    private boolean jj_3R_271() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_348()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_349()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_350()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_351()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_352()) {
                            return true;
                        }
                    }
                }
            }
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_scan_token(21));
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_381() {
        return this.jj_3R_372();
    }

    private boolean jj_3R_380() {
        return this.jj_3R_371();
    }

    private boolean jj_3R_379() {
        return this.jj_3R_375();
    }

    private boolean jj_3R_265() {
        return this.jj_3R_238();
    }

    private boolean jj_3R_236() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_265()) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(55)) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_347() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_379()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_380()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_381()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_382()) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_346() {
        return this.jj_scan_token(72);
    }

    private boolean jj_3_16() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_236()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(153);
    }

    private boolean jj_3R_262() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_16()) {
            this.jj_scanpos = xsp;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3R_295()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_296()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_345() {
        return this.jj_scan_token(77);
    }

    private boolean jj_3R_344() {
        return this.jj_scan_token(73);
    }

    private boolean jj_3R_235() {
        Token xsp;
        if (this.jj_3R_231()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_264());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3_23() {
        Token xsp;
        if (this.jj_scan_token(75)) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_scan_token(21));
        this.jj_scanpos = xsp;
        return this.jj_scan_token(52);
    }

    private boolean jj_3R_343() {
        return this.jj_scan_token(66);
    }

    private boolean jj_3R_342() {
        return this.jj_scan_token(67);
    }

    private boolean jj_3R_341() {
        return this.jj_scan_token(70);
    }

    private boolean jj_3R_340() {
        return this.jj_scan_token(69);
    }

    private boolean jj_3R_339() {
        return this.jj_scan_token(68);
    }

    private boolean jj_3R_338() {
        return this.jj_scan_token(65);
    }

    private boolean jj_3R_337() {
        return this.jj_scan_token(64);
    }

    private boolean jj_3R_336() {
        return this.jj_scan_token(63);
    }

    private boolean jj_3R_335() {
        return this.jj_scan_token(62);
    }

    private boolean jj_3R_334() {
        return this.jj_scan_token(61);
    }

    private boolean jj_3R_333() {
        return this.jj_scan_token(74);
    }

    private boolean jj_3R_377() {
        return this.jj_3R_406();
    }

    private boolean jj_3R_378() {
        return this.jj_scan_token(75);
    }

    private boolean jj_3R_409() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(61)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(62)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(63)) {
                    this.jj_scanpos = xsp;
                    if (this.jj_scan_token(65)) {
                        this.jj_scanpos = xsp;
                        if (this.jj_scan_token(68)) {
                            this.jj_scanpos = xsp;
                            if (this.jj_scan_token(69)) {
                                this.jj_scanpos = xsp;
                                if (this.jj_scan_token(70)) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_scan_token(73)) {
                                        return true;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_332() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_377()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_378()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_331() {
        return this.jj_3R_254();
    }

    private boolean jj_3_12() {
        return this.jj_3R_232();
    }

    private boolean jj_3R_270() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_331()) {
            this.jj_scanpos = xsp;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3R_332()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_333()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_334()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_335()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_336()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3R_337()) {
                                this.jj_scanpos = xsp;
                                if (this.jj_3R_338()) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_3R_339()) {
                                        this.jj_scanpos = xsp;
                                        if (this.jj_3R_340()) {
                                            this.jj_scanpos = xsp;
                                            if (this.jj_3R_341()) {
                                                this.jj_scanpos = xsp;
                                                if (this.jj_3R_342()) {
                                                    this.jj_scanpos = xsp;
                                                    if (this.jj_3R_343()) {
                                                        this.jj_scanpos = xsp;
                                                        if (this.jj_3R_344()) {
                                                            this.jj_scanpos = xsp;
                                                            if (this.jj_3R_345()) {
                                                                this.jj_scanpos = xsp;
                                                                if (this.jj_3R_346()) {
                                                                    this.jj_scanpos = xsp;
                                                                    if (this.jj_3R_347()) {
                                                                        return true;
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_scan_token(21));
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_242() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_270()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_271()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3_22() {
        return this.jj_scan_token(21);
    }

    private boolean jj_3R_330() {
        return this.jj_scan_token(119);
    }

    private boolean jj_3R_329() {
        return this.jj_scan_token(60);
    }

    private boolean jj_3R_328() {
        return this.jj_3R_376();
    }

    private boolean jj_3_13() {
        return this.jj_3R_232();
    }

    private boolean jj_3R_234() {
        return this.jj_3R_263();
    }

    private boolean jj_3R_281() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(30)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(31)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(50)) {
                    this.jj_scanpos = xsp;
                    if (this.jj_scan_token(152)) {
                        this.jj_scanpos = xsp;
                        if (this.jj_scan_token(154)) {
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_327() {
        return this.jj_3R_238();
    }

    private boolean jj_3R_326() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(54)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(53)) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_325() {
        return this.jj_scan_token(52);
    }

    private boolean jj_3R_324() {
        return this.jj_scan_token(39);
    }

    private boolean jj_3R_323() {
        return this.jj_3R_375();
    }

    private boolean jj_3R_322() {
        return this.jj_3R_360();
    }

    private boolean jj_3R_321() {
        return this.jj_3R_374();
    }

    private boolean jj_3R_320() {
        return this.jj_3R_373();
    }

    private boolean jj_3R_319() {
        return this.jj_3R_372();
    }

    private boolean jj_3R_318() {
        return this.jj_3R_371();
    }

    private boolean jj_3R_269() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_318()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_319()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_320()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_321()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_322()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3R_323()) {
                                this.jj_scanpos = xsp;
                                if (this.jj_3R_324()) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_3R_325()) {
                                        this.jj_scanpos = xsp;
                                        if (this.jj_3R_326()) {
                                            this.jj_scanpos = xsp;
                                            if (this.jj_3R_327()) {
                                                this.jj_scanpos = xsp;
                                                if (this.jj_3R_328()) {
                                                    this.jj_scanpos = xsp;
                                                    if (this.jj_3R_329()) {
                                                        this.jj_scanpos = xsp;
                                                        if (this.jj_3R_330()) {
                                                            return true;
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3_11() {
        return this.jj_3R_231();
    }

    private boolean jj_3R_317() {
        return this.jj_scan_token(72);
    }

    private boolean jj_3R_398() {
        return this.jj_3R_409();
    }

    private boolean jj_3R_233() {
        return this.jj_3R_262();
    }

    private boolean jj_3R_316() {
        return this.jj_scan_token(77);
    }

    private boolean jj_3R_315() {
        return this.jj_scan_token(44);
    }

    private boolean jj_3R_369() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_397()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_398()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_397() {
        if (this.jj_scan_token(56)) {
            return true;
        }
        return this.jj_3R_238();
    }

    private boolean jj_3_14() {
        return this.jj_3R_231();
    }

    private boolean jj_3R_257() {
        Token xsp;
        if (this.jj_3_14()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3_14());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_256() {
        Token xsp;
        if (this.jj_3R_262()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3_11());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3_15() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_233()) {
            this.jj_scanpos = xsp;
        }
        if (this.jj_3R_234()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_234());
        this.jj_scanpos = xsp;
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_235());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_314() {
        return this.jj_scan_token(73);
    }

    private boolean jj_3R_313() {
        return this.jj_scan_token(66);
    }

    private boolean jj_3R_230() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_15()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_256()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_257()) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean jj_3R_312() {
        return this.jj_scan_token(67);
    }

    private boolean jj_3R_311() {
        return this.jj_scan_token(70);
    }

    private boolean jj_3R_310() {
        return this.jj_scan_token(69);
    }

    private boolean jj_3R_309() {
        return this.jj_scan_token(68);
    }

    private boolean jj_3R_308() {
        return this.jj_scan_token(65);
    }

    private boolean jj_3R_307() {
        return this.jj_scan_token(64);
    }

    private boolean jj_3R_306() {
        return this.jj_scan_token(63);
    }

    private boolean jj_3R_305() {
        return this.jj_scan_token(62);
    }

    private boolean jj_3R_304() {
        return this.jj_scan_token(61);
    }

    private boolean jj_3R_303() {
        return this.jj_scan_token(74);
    }

    private boolean jj_3R_302() {
        return this.jj_scan_token(75);
    }

    private boolean jj_3_21() {
        if (this.jj_3R_239()) {
            return true;
        }
        return this.jj_3R_242();
    }

    private boolean jj_3R_301() {
        return this.jj_3R_254();
    }

    private boolean jj_3R_238() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(41)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(35)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(36)) {
                    this.jj_scanpos = xsp;
                    if (this.jj_scan_token(38)) {
                        this.jj_scanpos = xsp;
                        if (this.jj_scan_token(37)) {
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_268() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_301()) {
            this.jj_scanpos = xsp;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3R_302()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_303()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_304()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_305()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_306()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3R_307()) {
                                this.jj_scanpos = xsp;
                                if (this.jj_3R_308()) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_3R_309()) {
                                        this.jj_scanpos = xsp;
                                        if (this.jj_3R_310()) {
                                            this.jj_scanpos = xsp;
                                            if (this.jj_3R_311()) {
                                                this.jj_scanpos = xsp;
                                                if (this.jj_3R_312()) {
                                                    this.jj_scanpos = xsp;
                                                    if (this.jj_3R_313()) {
                                                        this.jj_scanpos = xsp;
                                                        if (this.jj_3R_314()) {
                                                            this.jj_scanpos = xsp;
                                                            if (this.jj_3R_315()) {
                                                                this.jj_scanpos = xsp;
                                                                if (this.jj_3R_316()) {
                                                                    this.jj_scanpos = xsp;
                                                                    if (this.jj_3R_317()) {
                                                                        return true;
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_240() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_268()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_269()) {
                return true;
            }
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3_22());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_241() {
        Token xsp;
        if (this.jj_3R_242()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3_21());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3_20() {
        Token xsp;
        if (this.jj_3R_238()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_scan_token(21));
        xsp = this.jj_scanpos = xsp;
        if (this.jj_scan_token(30)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(31)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(50)) {
                    this.jj_scanpos = xsp;
                    if (this.jj_scan_token(152)) {
                        this.jj_scanpos = xsp;
                        if (this.jj_scan_token(154)) {
                            return true;
                        }
                    }
                }
            }
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_scan_token(21));
        this.jj_scanpos = xsp;
        return this.jj_3R_241();
    }

    private boolean jj_3R_229() {
        return this.jj_3R_255();
    }

    private boolean jj_3R_251() {
        if (this.jj_3R_241()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(30)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(31)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(50)) {
                    this.jj_scanpos = xsp;
                    if (this.jj_scan_token(152)) {
                        this.jj_scanpos = xsp;
                        if (this.jj_scan_token(154)) {
                            return true;
                        }
                    }
                }
            }
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_scan_token(21));
        this.jj_scanpos = xsp;
        if (this.jj_3R_238()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_scan_token(21));
        xsp = this.jj_scanpos = xsp;
        if (this.jj_3R_281()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_223() {
        Token xsp;
        if (this.jj_scan_token(58)) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_scan_token(21));
        xsp = this.jj_scanpos = xsp;
        if (this.jj_3_20()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_251()) {
                return true;
            }
        }
        return this.jj_scan_token(57);
    }

    private boolean jj_3_10() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_229()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_3R_230();
    }

    private boolean jj_3_19() {
        if (this.jj_3R_239()) {
            return true;
        }
        return this.jj_3R_240();
    }

    private boolean jj_3R_435() {
        Token xsp;
        if (this.jj_3R_230()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3_10());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_279() {
        Token xsp;
        if (this.jj_3R_240()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3_19());
        this.jj_scanpos = xsp;
        return false;
    }

    private static void jj_la1_init_0() {
        jj_la1_0 = new int[]{0, 0, 0, 0x1A00000, 0x1A00000, 0, 0, 0, 0x200000, 0x200000, 0, 0, 0x1800000, 0x1800000, 0x200000, 0x200000, 0x200000, 0, 0, 0x200000, 0x200000, 0x200000, 0, 0x200000, 0, 0x200000, 0x200000, 0, 0x200000, 0, 0, 0x200000, 0x200000, 0x200000, 0, 0x200000, 0, 0x200000, 0, 0x200000, 0x200000, 0, 0, 0x200000, 0x200000, 0, 0x200000, 0, 0, 0, 0, 0x200000, 0, 0x200000, 0, 0x200000, 0x200000, 0, 0x200000, 0x200000, 0x200000, 0, 0x200000, 0x200000, 0x200000, 0, 0, 0x200000, 0x200000, 0x200000, 0, 0x200000, 0, 0, 0, 0, 0x200000, 0x50000000, 0x200000, 0, 0x200000, 0, 0x200000, 0x200000, 0x200000, 0x200000, 0, 0x200000, 0x200000, 0, 0, 0x200000, 0x200000, 0x200000, 0, 0, 0, 0x200000, 0, 0x200000, 0, 0, 0, 0x200000, 0x30000000, 0x30000000, 0x30000000, 0x200000, 0x200000, 0x200000, 0x200000, 0x30000000, 0, 0x200000, 0x200000, 0x200000, 0x200000, 0x200000, 0x200000, 0x200000, 0x200000, 0x200000, 0x200000, 0x200000, 0x200000, 0x200000, 0x200000, 0x200000, 0x200000, 0x200000, 0x200000, 0x200000, 0x200000, 0x200000, 0x200000, 0x200000, 0x200000, 0, 0x50000000, 0x200000, 0x200000, 0x50200000, 0x30000000, 0x200000, 0x200000, 0x30000000, 0x30000000, 0x30000000, 0x200000, 0x200000, 0x30000000, 0x30000000, 0x200000, 0, 0x30000000, 0x50000000, 0x50000000, 0x50000000, 0x200000, 0, 0x200000, 0x50000000, 0, 0x200000, 0, 0x200000, 0x200000, 0x50000000, 0, 0x200000, 0x50000000, 0x200000, 0x50200000, 0x200000, 0x200000, 0, 0, 0, 0, 0, 0, 0x50200000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x200000, 0, 0, 0x200000, 0x6000000, 0x200000, 0, 0x200000, 0x200000, 0x6000000, 0x200000, 0x200000, 0, 0, 0, 0x200000, 0, 0x200000, 0x200000, 0x200000, 0x200000, 0x200000, 0, 0x200000, 0x200000, 0, 0x200000, 0x200000, 0x200000, 0x200000, 0, 0x30000000, 0, 0x200000, 0x200000, 0x30000000, 0x200000, 0, 0, 0, 0x200000, 0, 0, 0x200000, 0x30000000, 0, 0x200000, 0x30000000, 0x200000, 0x30000000, 0x200000, 0x200000, -1073741824, 0x200000, -1073741824, 0x200000, 0x200000, -1073741824, 0x200000, -1073741824, 0x30000000, 0x200000, 0x30000000, 0, 0, 0, 0x30000000, 0x30000000, 0, 0, 0, 0x200000, 0, 0x200000, 0x30000000, 0, 0x200000, 0x200000, 0, 0x200000, 0x200000, 0x200000, 0x30000000, 0x200000, 0, 0x200000, 0x200000, 0x200000, 0x200000, 0x200000, 0x200000, 0x200000, 0x200000, 0, 0x200000, 0x200000, 0x200000, 0x200000, 0x200000, 0x200000, 0x200000, 0x200000, 0x200000, 0x30200000, 0x200000, 0x200000, 0x200000, 0x200000, 0x30000000, 0, 0x30000000, 0, 0x200000, 0x200000, 0x30000000, 0x200000, 0x30200000, 0x200000, 0x200000, 0, 0x200000, 0x30000000, 0, 0, 0x200000, 0x200000, 0x30000000, 0x200000, 0x200000, 0, 0x200000, 0, 0x200000, 0, 0x200000, 0, 0x200000, 0x200000, 0x200000, 0x30000000, 0, 0};
    }

    private static void jj_la1_init_1() {
        jj_la1_1 = new int[]{0, 0, 0, 0, 0, 0, 0, 632, 0, 0, 0, -375386504, 0, 0, 0, 0, 0, 632, 0x10000080, 0, 0, 0, 0x10000080, 0, 67109472, 0, 0, 67109472, 0, -375386504, -375386504, 0, 0, 0, 1, 0, 96, 0, 96, 0, 0, 8, 608, 0, 0, 8, 0, 16, 24, 24, 0x4000040, 0, 8, 0, 0x4000040, 0, 0, 0x4000000, 0, 0, 0, 0x8000000, 0, 0, 0, -375386504, -375386504, 0, 0, 0, 8, 0, 16, 24, 24, 0x4000040, 0, 267658875, 0, 0x4000000, 0, 632, 0, 0, 0, 0, 134218360, 0, 0, 0, 0, 0, 0, 0, 0x8000000, 0x8000000, 134218360, 0, 1, 0, 0x8000000, 0x8000000, 134218360, 0, 0, 0, 632, 0, 0, 0, 0, 632, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 6, 0, 0, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 632, 0, 250871811, 250871811, 250880635, 0, 0x1000400, 0, 267658875, 1, 0, 1, 0, 0, 267658875, 524288, 0, 267658875, 0, 6, 0, 0, -383775744, -383775744, -383775744, -383775744, -375386504, -383775744, 6, 8389240, -383775744, 0, 0x8000000, 8389240, -520093696, -536870912, 8389240, 8389240, 8389240, 0, 8389240, 8389240, 0, 491520, 0, 760, 0, 0, 491520, 0, 0, 632, 0x8000000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 632, 632, 0, 0, 0, 632, 0, 0, 632, 3072, 0, 0, 0x8000000, 0, -261087496, 0, 0, 760, 0, 760, 0, 0, 262144, 0, 262144, 0, 0, 262144, 0, 262144, -268431624, 0, 0, -536866816, 0x600000, 275779320, -261087496, 0, 0, 0, -536870912, 0, 268439288, 0, -268431624, 0, 0, 0, 1, 0, 0, 0, -469761536, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x4000200, 0x900000, 0, 512, 0, 0, 0x4000200, 0, 0, 0, 0, 0x900000, 0, 0, 512, -536870400, 0, 0, -469761536, 0, 0, 632, 0, 632, 0, 1, 0, 1, 0, 0, 0, -261087496, 632, 3072};
    }

    private static void jj_la1_init_2() {
        jj_la1_2 = new int[]{0, 0, 32768, 0, 0, 0, 0, 0, 0, 0, 65536, 82546, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 82546, 82546, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 82546, 82546, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -131072, -131072, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1024, 0, 0, 0, 0, 1024, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 512, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 17010, 17010, 17010, 17010, 17010, 626, 0, 0, 626, 16384, 0, 16384, 626, 626, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16384, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2688, 0, 0, 0, 2688, 0, 0, 0, 0, 0, 4096, 0, 0, 12159, 4096, 0, 3584, 0, 3584, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 12159, 0, 0, 12159, 0, 0, 12159, 0, 2048, 0, 12159, 0, 0, 0, 12159, 0, 0, 0, 0, 0, 0, 0, 3123, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2048, 0, 0, 2048, 0, 0, 2048, 0, 0, 0, 0, 0, 0, 0, 2048, 3123, 0, 0, 3123, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 12159, 0, 0};
    }

    private static void jj_la1_init_3() {
        jj_la1_3 = new int[]{0, 0, 0, 0, 0, 2, 4, 0, 0, 0, 16120, 16120, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16120, 16120, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16120, 16120, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8192, 0, 8192, 0, 0, 0, 0, 0, 8192, 0, 0, 8192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x20000000, 0, 0x3000000, 0, 0x4000000, 0, 0, 0, 0, 0, -1073741824, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -553648128, -553648128, 0, 0, 0, 0, 0, 0x800000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x800000, 0, 0, 0, 0, 0x800000, 0x800000, 0, 0, 0, 0, 0, 0x800000, 0, 0x800000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x800000, 0, 0};
    }

    private static void jj_la1_init_4() {
        jj_la1_4 = new int[]{196608, 196608, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x2000000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x2000000, 0x2000000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x2000000, 0x2000000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 66846720, 0, 32768, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 66846720, 66846720, 66846720, 0, 0, 0, 66846720, 0, 0, 0, 0, 0, 66846720, 0, 0, 66846720, 0, 0, 0, 0, 0, 0, 0, 0, 0x2000000, 0, 0, 0x2000000, 0, 0, 0, 0x2000000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 64, 0, 0, 0, 0, 0, 0, 0, 0, 51, 0, 0, 0, 0, 0, 0, 12, 0, 0, 0, 0, 32895, 32895, 0, 0, 0, 0, 0, 65408, 0, 0, 0, 0, 0, 0, 0, 0x5000000, 0, 0x5000000, 0, 0, 0x5000000, 0, 0x5000000, 40832, 0, 0, 0, 0, 65408, 65408, 0, 0, 40832, 40832, 0, 0, 0, 40832, 3840, 0, 0, 0, 0, 0, 0, 32640, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16384, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32640, 0, 0, 0x100000, 0, 0x100000, 0, 0, 0, 0, 0, 0, 0, 65408, 0, 0};
    }

    public CssParser(InputStream stream) {
        this(stream, null);
    }

    public CssParser(InputStream stream, String encoding) {
        int i;
        try {
            this.jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source = new CssParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 334; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(InputStream stream) {
        this.ReInit(stream, null);
    }

    public void ReInit(InputStream stream, String encoding) {
        int i;
        try {
            this.jj_input_stream.ReInit(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 334; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public CssParser(Reader stream) {
        int i;
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new CssParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 334; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(Reader stream) {
        int i;
        if (this.jj_input_stream == null) {
            this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        } else {
            this.jj_input_stream.ReInit(stream, 1, 1);
        }
        if (this.token_source == null) {
            this.token_source = new CssParserTokenManager(this.jj_input_stream);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 334; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public CssParser(CssParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 334; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(CssParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 334; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    private Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                for (int i = 0; i < this.jj_2_rtns.length; ++i) {
                    JJCalls c = this.jj_2_rtns[i];
                    while (c != null) {
                        if (c.gen < this.jj_gen) {
                            c.first = null;
                        }
                        c = c.next;
                    }
                }
            }
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    private boolean jj_scan_token(int kind) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int i = 0;
            Token tok = this.token;
            while (tok != null && tok != this.jj_scanpos) {
                ++i;
                tok = tok.next;
            }
            if (tok != null) {
                this.jj_add_error_token(kind, i);
            }
        }
        if (this.jj_scanpos.kind != kind) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            throw this.jj_ls;
        }
        return false;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private int jj_ntk_f() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    private void jj_add_error_token(int kind, int pos) {
        if (pos >= 100) {
            return;
        }
        if (pos == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = kind;
        } else if (this.jj_endpos != 0) {
            this.jj_expentry = new int[this.jj_endpos];
            for (int i = 0; i < this.jj_endpos; ++i) {
                this.jj_expentry[i] = this.jj_lasttokens[i];
            }
            for (int[] oldentry : this.jj_expentries) {
                if (oldentry.length != this.jj_expentry.length) continue;
                boolean isMatched = true;
                for (int i = 0; i < this.jj_expentry.length; ++i) {
                    if (oldentry[i] == this.jj_expentry[i]) continue;
                    isMatched = false;
                    break;
                }
                if (!isMatched) continue;
                this.jj_expentries.add(this.jj_expentry);
                break;
            }
            if (pos != 0) {
                this.jj_endpos = pos;
                this.jj_lasttokens[this.jj_endpos - 1] = kind;
            }
        }
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.clear();
        boolean[] la1tokens = new boolean[155];
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 334; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) != 0) {
                    la1tokens[j] = true;
                }
                if ((jj_la1_1[i] & 1 << j) != 0) {
                    la1tokens[32 + j] = true;
                }
                if ((jj_la1_2[i] & 1 << j) != 0) {
                    la1tokens[64 + j] = true;
                }
                if ((jj_la1_3[i] & 1 << j) != 0) {
                    la1tokens[96 + j] = true;
                }
                if ((jj_la1_4[i] & 1 << j) == 0) continue;
                la1tokens[128 + j] = true;
            }
        }
        for (i = 0; i < 155; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.add(this.jj_expentry);
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = this.jj_expentries.get(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final boolean trace_enabled() {
        return this.trace_enabled;
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private void jj_rescan_token() {
        this.jj_rescan = true;
        for (int i = 0; i < 29; ++i) {
            try {
                JJCalls p = this.jj_2_rtns[i];
                do {
                    if (p.gen <= this.jj_gen) continue;
                    this.jj_la = p.arg;
                    this.jj_lastpos = this.jj_scanpos = p.first;
                    switch (i) {
                        case 0: {
                            this.jj_3_1();
                            break;
                        }
                        case 1: {
                            this.jj_3_2();
                            break;
                        }
                        case 2: {
                            this.jj_3_3();
                            break;
                        }
                        case 3: {
                            this.jj_3_4();
                            break;
                        }
                        case 4: {
                            this.jj_3_5();
                            break;
                        }
                        case 5: {
                            this.jj_3_6();
                            break;
                        }
                        case 6: {
                            this.jj_3_7();
                            break;
                        }
                        case 7: {
                            this.jj_3_8();
                            break;
                        }
                        case 8: {
                            this.jj_3_9();
                            break;
                        }
                        case 9: {
                            this.jj_3_10();
                            break;
                        }
                        case 10: {
                            this.jj_3_11();
                            break;
                        }
                        case 11: {
                            this.jj_3_12();
                            break;
                        }
                        case 12: {
                            this.jj_3_13();
                            break;
                        }
                        case 13: {
                            this.jj_3_14();
                            break;
                        }
                        case 14: {
                            this.jj_3_15();
                            break;
                        }
                        case 15: {
                            this.jj_3_16();
                            break;
                        }
                        case 16: {
                            this.jj_3_17();
                            break;
                        }
                        case 17: {
                            this.jj_3_18();
                            break;
                        }
                        case 18: {
                            this.jj_3_19();
                            break;
                        }
                        case 19: {
                            this.jj_3_20();
                            break;
                        }
                        case 20: {
                            this.jj_3_21();
                            break;
                        }
                        case 21: {
                            this.jj_3_22();
                            break;
                        }
                        case 22: {
                            this.jj_3_23();
                            break;
                        }
                        case 23: {
                            this.jj_3_24();
                            break;
                        }
                        case 24: {
                            this.jj_3_25();
                            break;
                        }
                        case 25: {
                            this.jj_3_26();
                            break;
                        }
                        case 26: {
                            this.jj_3_27();
                            break;
                        }
                        case 27: {
                            this.jj_3_28();
                            break;
                        }
                        case 28: {
                            this.jj_3_29();
                        }
                    }
                } while ((p = p.next) != null);
                continue;
            }
            catch (LookaheadSuccess lookaheadSuccess) {
                // empty catch block
            }
        }
        this.jj_rescan = false;
    }

    private void jj_save(int index, int xla) {
        JJCalls p = this.jj_2_rtns[index];
        while (p.gen > this.jj_gen) {
            if (p.next == null) {
                p = p.next = new JJCalls();
                break;
            }
            p = p.next;
        }
        p.gen = this.jj_gen + xla - this.jj_la;
        p.first = this.token;
        p.arg = xla;
    }

    static {
        CssParser.jj_la1_init_0();
        CssParser.jj_la1_init_1();
        CssParser.jj_la1_init_2();
        CssParser.jj_la1_init_3();
        CssParser.jj_la1_init_4();
    }

    private static final class LookaheadSuccess
    extends Error {
        private LookaheadSuccess() {
        }
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }
}

