/*
 * Decompiled with CFR 0.152.
 */
package jalview;

import jalview.ClustalFile;
import jalview.FileParse;
import jalview.Format;
import jalview.Sequence;
import java.io.IOException;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class PfamFile
extends FileParse {
    int noSeqs;
    int maxLength;
    Hashtable myHash;
    Vector seqs;
    Vector headers;
    Vector ids;
    Vector words = new Vector();
    long start;
    long end;

    public PfamFile(String string) {
        this.myHash = new Hashtable();
        this.seqs = new Vector();
        this.headers = new Vector();
        this.ids = new Vector();
        this.readLines(string);
        System.out.println(this.noLines);
        System.out.println(this.lineArray.size());
        this.parse();
    }

    public PfamFile(String string, String string2) throws IOException {
        super(string, string2);
        this.myHash = new Hashtable();
        this.seqs = new Vector();
        this.headers = new Vector();
        this.ids = new Vector();
        System.out.print("Reading file....");
        this.start = System.currentTimeMillis();
        this.readLines();
        this.end = System.currentTimeMillis();
        System.out.println("done");
        System.out.println("Total time taken = " + (this.end - this.start) + "ms");
        System.out.println("Parsing file....");
        this.start = System.currentTimeMillis();
        this.parse();
    }

    public void parse() {
        Object object;
        int n = 0;
        n = 0;
        while (n < this.noLines) {
            if (this.lineArray.elementAt(n).toString().indexOf(" ") != 0 && this.lineArray.elementAt(n).toString().indexOf("#") != 0) {
                object = new StringTokenizer(this.lineArray.elementAt(n).toString(), " ");
                String string = "";
                if (((StringTokenizer)object).hasMoreTokens()) {
                    string = ((StringTokenizer)object).nextToken();
                    StringBuffer stringBuffer = new StringBuffer();
                    if (this.myHash.containsKey(string)) {
                        stringBuffer = new StringBuffer(this.myHash.get(string).toString());
                    }
                    if (!this.headers.contains(string)) {
                        this.headers.addElement(string);
                    }
                    stringBuffer.append(((StringTokenizer)object).nextToken());
                    this.myHash.put(string, stringBuffer.toString());
                }
            }
            ++n;
        }
        this.noSeqs = this.headers.size();
        n = 0;
        while (n < this.headers.size()) {
            if (this.myHash.get(this.headers.elementAt(n)) != null) {
                Object object2;
                if (this.maxLength < this.myHash.get(this.headers.elementAt(n)).toString().length()) {
                    this.maxLength = this.myHash.get(this.headers.elementAt(n)).toString().length();
                }
                object = this.headers.elementAt(n).toString();
                int n2 = 1;
                int n3 = this.myHash.get(this.headers.elementAt(n)).toString().length();
                if (((String)object).indexOf("/") > 0) {
                    object2 = new StringTokenizer((String)object, "/");
                    if (((StringTokenizer)object2).countTokens() == 2) {
                        this.ids.addElement(((StringTokenizer)object2).nextToken());
                        String string = ((StringTokenizer)object2).nextToken();
                        object2 = new StringTokenizer(string, "-");
                        if (((StringTokenizer)object2).countTokens() == 2) {
                            n2 = Integer.valueOf(((StringTokenizer)object2).nextToken());
                            n3 = Integer.valueOf(((StringTokenizer)object2).nextToken());
                        } else {
                            n2 = -1;
                            n3 = -1;
                        }
                    } else {
                        this.ids.addElement(this.headers.elementAt(n));
                    }
                } else {
                    this.ids.addElement(this.headers.elementAt(n));
                }
                if (n2 != -1 && n3 != -1) {
                    object2 = new Sequence(this.ids.elementAt(n).toString(), this.myHash.get(this.headers.elementAt(n).toString()).toString(), n2, n3);
                    this.seqs.addElement(object2);
                } else {
                    object2 = new Sequence(this.ids.elementAt(n).toString(), this.myHash.get(this.headers.elementAt(n).toString()).toString(), 1, this.myHash.get(this.headers.elementAt(n).toString()).toString().length());
                    this.seqs.addElement(object2);
                }
            } else {
                System.out.println("Can't find sequence for " + this.headers.elementAt(n));
            }
            ++n;
        }
        this.end = System.currentTimeMillis();
        System.out.println("done");
        System.out.println("Total time taken = " + (this.end - this.start) + "ms");
    }

    public static String print(Sequence[] sequenceArray) {
        StringBuffer stringBuffer = new StringBuffer("");
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n3 < sequenceArray.length && sequenceArray[n3] != null) {
            String string = String.valueOf(sequenceArray[n3].getName()) + "/" + sequenceArray[n3].start + "-" + sequenceArray[n3].end;
            if (sequenceArray[n3].getSequence().length() > n) {
                n = sequenceArray[n3].getSequence().length();
            }
            if (string.length() > n2) {
                n2 = string.length();
            }
            ++n3;
        }
        if (n2 < 15) {
            n2 = 15;
        }
        int n4 = 0;
        while (n4 < sequenceArray.length && sequenceArray[n4] != null) {
            stringBuffer.append(String.valueOf(new Format("%-" + n2 + "s").form(String.valueOf(sequenceArray[n4].getName()) + "/" + sequenceArray[n4].start + "-" + sequenceArray[n4].end)) + " ");
            stringBuffer.append(String.valueOf(sequenceArray[n4].getSequence()) + "\n");
            ++n4;
        }
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        String string = "CLUSTAL\n\nt1  GTGASAAATGGNNTGATTCTGTACCTTGTGGAGACTGGCGTGATGTGCAG\nt2  AAATGATTCTGTACCTTGTGGATGGACTGGCGTGATGTGCAGCAACTATT\n\nt1  CAACTATTCGANNGTGATCCAGTGGTTTTGTCGTTGAATCTGTCTTCGAT\nt2  CGAGTGATCCAGAGGTTTTGTCCTTGAATCTGTCTTCGATGGTTCTCTCG\n\nt1  GGTTCTCGGGTAAGCTATCACCAAGCATAGGTGGATTGGTTCATCTGAAG\nt2  GGTAAGATCCACCAAGCATATGCTAGCT\n ";
        ClustalFile clustalFile = new ClustalFile(string);
        Sequence[] sequenceArray = new Sequence[clustalFile.seqs.size() + 1];
        int n = 0;
        while (n < clustalFile.seqs.size()) {
            sequenceArray[n] = (Sequence)clustalFile.seqs.elementAt(n);
            ++n;
        }
        String string2 = ClustalFile.print(sequenceArray);
        System.out.println(string2);
    }
}

