# stringprep_data.tcl --
#
#	Declarations of Unicode character information tables.  This file is
#	automatically generated by the gen_stringprep_data.tcl script.  Do not
#	modify this file by hand.
#
# Copyright (c) 1998 Scriptics Corporation.
# Copyright (c) 2007 Alexey Shchepin
# Copyright (c) 2008 Sergei Golovan
#

package provide stringprep::data 1.0.3

namespace eval ::stringprep::data {

#
# A 16-bit Unicode character is split into two parts in order to index
# into the following tables.  The lower OFFSET_BITS comprise an offset
# into a page of characters.  The upper bits comprise the page number.
#

variable OFFSET_BITS 7

#
# The pageMap is indexed by page number and returns an alternate page number
# that identifies a unique page of characters.  Many Unicode characters map
# to the same alternate page number.
#

variable pageMap
array unset pageMap
array set pageMap [list \
    0 0 1 1 2 2 3 3 4 4 5 5 6 6 7 7 8 8 9 9 10 10 11 11 12 12 13 13 14 14 \
    15 15 18 17 19 18 20 19 21 20 22 21 23 22 24 23 25 24 26 25 27 26 28 27 \
    29 28 30 29 31 30 32 31 33 32 34 33 35 34 36 35 37 36 38 37 39 38 40 39 \
    41 40 42 40 43 40 44 41 45 42 46 43 47 44 48 45 49 46 60 47 61 48 62 49 \
    63 50 64 51 65 52 66 53 67 54 68 55 69 55 70 56 71 57 72 58 73 59 74 55 \
    75 55 76 60 77 61 78 62 79 63 80 55 81 55 82 55 83 55 84 55 85 55 93 64 \
    94 55 95 65 96 66 97 67 98 68 99 69 100 70 101 71 102 72 103 73 104 40 \
    105 40 106 40 107 40 108 40 109 40 110 40 111 40 112 40 113 40 114 40 \
    115 40 116 40 117 40 118 40 119 40 120 40 121 40 122 40 123 40 124 40 \
    125 40 126 40 127 40 128 40 129 40 130 40 131 40 132 40 133 40 134 40 \
    135 40 136 40 137 40 138 40 139 40 140 40 141 40 142 40 143 40 144 40 \
    145 40 146 40 147 40 148 40 149 40 150 40 151 40 152 40 153 40 154 40 \
    155 74 156 40 157 40 158 40 159 40 160 40 161 40 162 40 163 40 164 40 \
    165 40 166 40 167 40 168 40 169 40 170 40 171 40 172 40 173 40 174 40 \
    175 40 176 40 177 40 178 40 179 40 180 40 181 40 182 40 183 40 184 40 \
    185 40 186 40 187 40 188 40 189 40 190 40 191 40 192 40 193 40 194 40 \
    195 40 196 40 197 40 198 40 199 40 200 40 201 40 202 40 203 40 204 40 \
    205 40 206 40 207 40 208 40 209 40 210 40 211 40 212 40 213 40 214 40 \
    215 40 216 40 217 40 218 40 219 40 220 40 221 40 222 40 223 40 224 40 \
    225 40 226 40 227 40 228 40 229 40 230 40 231 40 232 40 233 40 234 40 \
    235 40 236 40 237 40 238 40 239 40 240 40 241 40 242 40 243 40 244 40 \
    245 40 246 40 247 40 248 40 249 40 250 40 251 40 252 40 253 40 254 40 \
    255 40 256 40 257 40 258 40 259 40 260 40 261 40 262 40 263 40 264 40 \
    265 40 266 40 267 40 268 40 269 40 270 40 271 40 272 40 273 40 274 40 \
    275 40 276 40 277 40 278 40 279 40 280 40 281 40 282 40 283 40 284 40 \
    285 40 286 40 287 40 288 40 289 40 290 40 291 40 292 40 293 40 294 40 \
    295 40 296 40 297 40 298 40 299 40 300 40 301 40 302 40 303 40 304 40 \
    305 40 306 40 307 40 308 40 309 40 310 40 311 40 312 40 313 40 314 40 \
    315 40 316 40 317 40 318 40 319 75 320 40 321 40 322 40 323 40 324 40 \
    325 40 326 40 327 40 328 40 329 76 344 40 345 40 346 40 347 40 348 40 \
    349 40 350 40 351 40 352 40 353 40 354 40 355 40 356 40 357 40 358 40 \
    359 40 360 40 361 40 362 40 363 40 364 40 365 40 366 40 367 40 368 40 \
    369 40 370 40 371 40 372 40 373 40 374 40 375 40 376 40 377 40 378 40 \
    379 40 380 40 381 40 382 40 383 40 384 40 385 40 386 40 387 40 388 40 \
    389 40 390 40 391 40 392 40 393 40 394 40 395 40 396 40 397 40 398 40 \
    399 40 400 40 401 40 402 40 403 40 404 40 405 40 406 40 407 40 408 40 \
    409 40 410 40 411 40 412 40 413 40 414 40 415 40 416 40 417 40 418 40 \
    419 40 420 40 421 40 422 40 423 40 424 40 425 40 426 40 427 40 428 40 \
    429 40 430 40 431 77 432 78 433 78 434 78 435 78 436 78 437 78 438 78 \
    439 78 440 78 441 78 442 78 443 78 444 78 445 78 446 78 447 78 448 78 \
    449 78 450 78 451 78 452 78 453 78 454 78 455 78 456 78 457 78 458 78 \
    459 78 460 78 461 78 462 78 463 78 464 78 465 78 466 78 467 78 468 78 \
    469 78 470 78 471 78 472 78 473 78 474 78 475 78 476 78 477 78 478 78 \
    479 78 480 78 481 78 482 78 483 78 484 78 485 78 486 78 487 78 488 78 \
    489 78 490 78 491 78 492 78 493 78 494 78 495 78 496 78 497 78 498 40 \
    499 40 500 79 502 80 503 81 504 82 505 82 506 83 507 84 508 85 509 86 \
    510 87 511 88 518 89 520 90 928 40 929 91 930 92 931 93 936 94 937 95 \
    938 96 939 97 940 98 941 99 942 100 943 101 1023 102 1024 40 1025 40 \
    1026 40 1027 40 1028 40 1029 40 1030 40 1031 40 1032 40 1033 40 1034 40 \
    1035 40 1036 40 1037 40 1038 40 1039 40 1040 40 1041 40 1042 40 1043 40 \
    1044 40 1045 40 1046 40 1047 40 1048 40 1049 40 1050 40 1051 40 1052 40 \
    1053 40 1054 40 1055 40 1056 40 1057 40 1058 40 1059 40 1060 40 1061 40 \
    1062 40 1063 40 1064 40 1065 40 1066 40 1067 40 1068 40 1069 40 1070 40 \
    1071 40 1072 40 1073 40 1074 40 1075 40 1076 40 1077 40 1078 40 1079 40 \
    1080 40 1081 40 1082 40 1083 40 1084 40 1085 40 1086 40 1087 40 1088 40 \
    1089 40 1090 40 1091 40 1092 40 1093 40 1094 40 1095 40 1096 40 1097 40 \
    1098 40 1099 40 1100 40 1101 40 1102 40 1103 40 1104 40 1105 40 1106 40 \
    1107 40 1108 40 1109 40 1110 40 1111 40 1112 40 1113 40 1114 40 1115 40 \
    1116 40 1117 40 1118 40 1119 40 1120 40 1121 40 1122 40 1123 40 1124 40 \
    1125 40 1126 40 1127 40 1128 40 1129 40 1130 40 1131 40 1132 40 1133 40 \
    1134 40 1135 40 1136 40 1137 40 1138 40 1139 40 1140 40 1141 40 1142 40 \
    1143 40 1144 40 1145 40 1146 40 1147 40 1148 40 1149 40 1150 40 1151 40 \
    1152 40 1153 40 1154 40 1155 40 1156 40 1157 40 1158 40 1159 40 1160 40 \
    1161 40 1162 40 1163 40 1164 40 1165 40 1166 40 1167 40 1168 40 1169 40 \
    1170 40 1171 40 1172 40 1173 40 1174 40 1175 40 1176 40 1177 40 1178 40 \
    1179 40 1180 40 1181 40 1182 40 1183 40 1184 40 1185 40 1186 40 1187 40 \
    1188 40 1189 40 1190 40 1191 40 1192 40 1193 40 1194 40 1195 40 1196 40 \
    1197 40 1198 40 1199 40 1200 40 1201 40 1202 40 1203 40 1204 40 1205 40 \
    1206 40 1207 40 1208 40 1209 40 1210 40 1211 40 1212 40 1213 40 1214 40 \
    1215 40 1216 40 1217 40 1218 40 1219 40 1220 40 1221 40 1222 40 1223 40 \
    1224 40 1225 40 1226 40 1227 40 1228 40 1229 40 1230 40 1231 40 1232 40 \
    1233 40 1234 40 1235 40 1236 40 1237 40 1238 40 1239 40 1240 40 1241 40 \
    1242 40 1243 40 1244 40 1245 40 1246 40 1247 40 1248 40 1249 40 1250 40 \
    1251 40 1252 40 1253 40 1254 40 1255 40 1256 40 1257 40 1258 40 1259 40 \
    1260 40 1261 40 1262 40 1263 40 1264 40 1265 40 1266 40 1267 40 1268 40 \
    1269 40 1270 40 1271 40 1272 40 1273 40 1274 40 1275 40 1276 40 1277 40 \
    1278 40 1279 40 1280 40 1281 40 1282 40 1283 40 1284 40 1285 40 1286 40 \
    1287 40 1288 40 1289 40 1290 40 1291 40 1292 40 1293 40 1294 40 1295 40 \
    1296 40 1297 40 1298 40 1299 40 1300 40 1301 40 1302 40 1303 40 1304 40 \
    1305 40 1306 40 1307 40 1308 40 1309 40 1310 40 1311 40 1312 40 1313 40 \
    1314 40 1315 40 1316 40 1317 40 1318 40 1319 40 1320 40 1321 40 1322 40 \
    1323 40 1324 40 1325 40 1326 40 1327 40 1328 40 1329 40 1330 40 1331 40 \
    1332 40 1333 40 1334 40 1335 40 1336 40 1337 40 1338 40 1339 40 1340 40 \
    1341 40 1342 40 1343 40 1344 40 1345 40 1346 40 1347 40 1348 40 1349 40 \
    1350 40 1351 40 1352 40 1353 40 1354 40 1355 40 1356 40 1357 103 1520 40 \
    1521 40 1522 40 1523 40 1524 104 1535 102 2047 102 2559 102 3071 102 \
    3583 102 4095 102 4607 102 5119 102 5631 102 6143 102 6655 102 7167 102 \
    7168 105 7679 102 7680 78 7681 78 7682 78 7683 78 7684 78 7685 78 7686 78 \
    7687 78 7688 78 7689 78 7690 78 7691 78 7692 78 7693 78 7694 78 7695 78 \
    7696 78 7697 78 7698 78 7699 78 7700 78 7701 78 7702 78 7703 78 7704 78 \
    7705 78 7706 78 7707 78 7708 78 7709 78 7710 78 7711 78 7712 78 7713 78 \
    7714 78 7715 78 7716 78 7717 78 7718 78 7719 78 7720 78 7721 78 7722 78 \
    7723 78 7724 78 7725 78 7726 78 7727 78 7728 78 7729 78 7730 78 7731 78 \
    7732 78 7733 78 7734 78 7735 78 7736 78 7737 78 7738 78 7739 78 7740 78 \
    7741 78 7742 78 7743 78 7744 78 7745 78 7746 78 7747 78 7748 78 7749 78 \
    7750 78 7751 78 7752 78 7753 78 7754 78 7755 78 7756 78 7757 78 7758 78 \
    7759 78 7760 78 7761 78 7762 78 7763 78 7764 78 7765 78 7766 78 7767 78 \
    7768 78 7769 78 7770 78 7771 78 7772 78 7773 78 7774 78 7775 78 7776 78 \
    7777 78 7778 78 7779 78 7780 78 7781 78 7782 78 7783 78 7784 78 7785 78 \
    7786 78 7787 78 7788 78 7789 78 7790 78 7791 78 7792 78 7793 78 7794 78 \
    7795 78 7796 78 7797 78 7798 78 7799 78 7800 78 7801 78 7802 78 7803 78 \
    7804 78 7805 78 7806 78 7807 78 7808 78 7809 78 7810 78 7811 78 7812 78 \
    7813 78 7814 78 7815 78 7816 78 7817 78 7818 78 7819 78 7820 78 7821 78 \
    7822 78 7823 78 7824 78 7825 78 7826 78 7827 78 7828 78 7829 78 7830 78 \
    7831 78 7832 78 7833 78 7834 78 7835 78 7836 78 7837 78 7838 78 7839 78 \
    7840 78 7841 78 7842 78 7843 78 7844 78 7845 78 7846 78 7847 78 7848 78 \
    7849 78 7850 78 7851 78 7852 78 7853 78 7854 78 7855 78 7856 78 7857 78 \
    7858 78 7859 78 7860 78 7861 78 7862 78 7863 78 7864 78 7865 78 7866 78 \
    7867 78 7868 78 7869 78 7870 78 7871 78 7872 78 7873 78 7874 78 7875 78 \
    7876 78 7877 78 7878 78 7879 78 7880 78 7881 78 7882 78 7883 78 7884 78 \
    7885 78 7886 78 7887 78 7888 78 7889 78 7890 78 7891 78 7892 78 7893 78 \
    7894 78 7895 78 7896 78 7897 78 7898 78 7899 78 7900 78 7901 78 7902 78 \
    7903 78 7904 78 7905 78 7906 78 7907 78 7908 78 7909 78 7910 78 7911 78 \
    7912 78 7913 78 7914 78 7915 78 7916 78 7917 78 7918 78 7919 78 7920 78 \
    7921 78 7922 78 7923 78 7924 78 7925 78 7926 78 7927 78 7928 78 7929 78 \
    7930 78 7931 78 7932 78 7933 78 7934 78 7935 78 7936 78 7937 78 7938 78 \
    7939 78 7940 78 7941 78 7942 78 7943 78 7944 78 7945 78 7946 78 7947 78 \
    7948 78 7949 78 7950 78 7951 78 7952 78 7953 78 7954 78 7955 78 7956 78 \
    7957 78 7958 78 7959 78 7960 78 7961 78 7962 78 7963 78 7964 78 7965 78 \
    7966 78 7967 78 7968 78 7969 78 7970 78 7971 78 7972 78 7973 78 7974 78 \
    7975 78 7976 78 7977 78 7978 78 7979 78 7980 78 7981 78 7982 78 7983 78 \
    7984 78 7985 78 7986 78 7987 78 7988 78 7989 78 7990 78 7991 78 7992 78 \
    7993 78 7994 78 7995 78 7996 78 7997 78 7998 78 7999 78 8000 78 8001 78 \
    8002 78 8003 78 8004 78 8005 78 8006 78 8007 78 8008 78 8009 78 8010 78 \
    8011 78 8012 78 8013 78 8014 78 8015 78 8016 78 8017 78 8018 78 8019 78 \
    8020 78 8021 78 8022 78 8023 78 8024 78 8025 78 8026 78 8027 78 8028 78 \
    8029 78 8030 78 8031 78 8032 78 8033 78 8034 78 8035 78 8036 78 8037 78 \
    8038 78 8039 78 8040 78 8041 78 8042 78 8043 78 8044 78 8045 78 8046 78 \
    8047 78 8048 78 8049 78 8050 78 8051 78 8052 78 8053 78 8054 78 8055 78 \
    8056 78 8057 78 8058 78 8059 78 8060 78 8061 78 8062 78 8063 78 8064 78 \
    8065 78 8066 78 8067 78 8068 78 8069 78 8070 78 8071 78 8072 78 8073 78 \
    8074 78 8075 78 8076 78 8077 78 8078 78 8079 78 8080 78 8081 78 8082 78 \
    8083 78 8084 78 8085 78 8086 78 8087 78 8088 78 8089 78 8090 78 8091 78 \
    8092 78 8093 78 8094 78 8095 78 8096 78 8097 78 8098 78 8099 78 8100 78 \
    8101 78 8102 78 8103 78 8104 78 8105 78 8106 78 8107 78 8108 78 8109 78 \
    8110 78 8111 78 8112 78 8113 78 8114 78 8115 78 8116 78 8117 78 8118 78 \
    8119 78 8120 78 8121 78 8122 78 8123 78 8124 78 8125 78 8126 78 8127 78 \
    8128 78 8129 78 8130 78 8131 78 8132 78 8133 78 8134 78 8135 78 8136 78 \
    8137 78 8138 78 8139 78 8140 78 8141 78 8142 78 8143 78 8144 78 8145 78 \
    8146 78 8147 78 8148 78 8149 78 8150 78 8151 78 8152 78 8153 78 8154 78 \
    8155 78 8156 78 8157 78 8158 78 8159 78 8160 78 8161 78 8162 78 8163 78 \
    8164 78 8165 78 8166 78 8167 78 8168 78 8169 78 8170 78 8171 78 8172 78 \
    8173 78 8174 78 8175 78 8176 78 8177 78 8178 78 8179 78 8180 78 8181 78 \
    8182 78 8183 78 8184 78 8185 78 8186 78 8187 78 8188 78 8189 78 8190 78 \
    8191 106 8192 78 8193 78 8194 78 8195 78 8196 78 8197 78 8198 78 8199 78 \
    8200 78 8201 78 8202 78 8203 78 8204 78 8205 78 8206 78 8207 78 8208 78 \
    8209 78 8210 78 8211 78 8212 78 8213 78 8214 78 8215 78 8216 78 8217 78 \
    8218 78 8219 78 8220 78 8221 78 8222 78 8223 78 8224 78 8225 78 8226 78 \
    8227 78 8228 78 8229 78 8230 78 8231 78 8232 78 8233 78 8234 78 8235 78 \
    8236 78 8237 78 8238 78 8239 78 8240 78 8241 78 8242 78 8243 78 8244 78 \
    8245 78 8246 78 8247 78 8248 78 8249 78 8250 78 8251 78 8252 78 8253 78 \
    8254 78 8255 78 8256 78 8257 78 8258 78 8259 78 8260 78 8261 78 8262 78 \
    8263 78 8264 78 8265 78 8266 78 8267 78 8268 78 8269 78 8270 78 8271 78 \
    8272 78 8273 78 8274 78 8275 78 8276 78 8277 78 8278 78 8279 78 8280 78 \
    8281 78 8282 78 8283 78 8284 78 8285 78 8286 78 8287 78 8288 78 8289 78 \
    8290 78 8291 78 8292 78 8293 78 8294 78 8295 78 8296 78 8297 78 8298 78 \
    8299 78 8300 78 8301 78 8302 78 8303 78 8304 78 8305 78 8306 78 8307 78 \
    8308 78 8309 78 8310 78 8311 78 8312 78 8313 78 8314 78 8315 78 8316 78 \
    8317 78 8318 78 8319 78 8320 78 8321 78 8322 78 8323 78 8324 78 8325 78 \
    8326 78 8327 78 8328 78 8329 78 8330 78 8331 78 8332 78 8333 78 8334 78 \
    8335 78 8336 78 8337 78 8338 78 8339 78 8340 78 8341 78 8342 78 8343 78 \
    8344 78 8345 78 8346 78 8347 78 8348 78 8349 78 8350 78 8351 78 8352 78 \
    8353 78 8354 78 8355 78 8356 78 8357 78 8358 78 8359 78 8360 78 8361 78 \
    8362 78 8363 78 8364 78 8365 78 8366 78 8367 78 8368 78 8369 78 8370 78 \
    8371 78 8372 78 8373 78 8374 78 8375 78 8376 78 8377 78 8378 78 8379 78 \
    8380 78 8381 78 8382 78 8383 78 8384 78 8385 78 8386 78 8387 78 8388 78 \
    8389 78 8390 78 8391 78 8392 78 8393 78 8394 78 8395 78 8396 78 8397 78 \
    8398 78 8399 78 8400 78 8401 78 8402 78 8403 78 8404 78 8405 78 8406 78 \
    8407 78 8408 78 8409 78 8410 78 8411 78 8412 78 8413 78 8414 78 8415 78 \
    8416 78 8417 78 8418 78 8419 78 8420 78 8421 78 8422 78 8423 78 8424 78 \
    8425 78 8426 78 8427 78 8428 78 8429 78 8430 78 8431 78 8432 78 8433 78 \
    8434 78 8435 78 8436 78 8437 78 8438 78 8439 78 8440 78 8441 78 8442 78 \
    8443 78 8444 78 8445 78 8446 78 8447 78 8448 78 8449 78 8450 78 8451 78 \
    8452 78 8453 78 8454 78 8455 78 8456 78 8457 78 8458 78 8459 78 8460 78 \
    8461 78 8462 78 8463 78 8464 78 8465 78 8466 78 8467 78 8468 78 8469 78 \
    8470 78 8471 78 8472 78 8473 78 8474 78 8475 78 8476 78 8477 78 8478 78 \
    8479 78 8480 78 8481 78 8482 78 8483 78 8484 78 8485 78 8486 78 8487 78 \
    8488 78 8489 78 8490 78 8491 78 8492 78 8493 78 8494 78 8495 78 8496 78 \
    8497 78 8498 78 8499 78 8500 78 8501 78 8502 78 8503 78 8504 78 8505 78 \
    8506 78 8507 78 8508 78 8509 78 8510 78 8511 78 8512 78 8513 78 8514 78 \
    8515 78 8516 78 8517 78 8518 78 8519 78 8520 78 8521 78 8522 78 8523 78 \
    8524 78 8525 78 8526 78 8527 78 8528 78 8529 78 8530 78 8531 78 8532 78 \
    8533 78 8534 78 8535 78 8536 78 8537 78 8538 78 8539 78 8540 78 8541 78 \
    8542 78 8543 78 8544 78 8545 78 8546 78 8547 78 8548 78 8549 78 8550 78 \
    8551 78 8552 78 8553 78 8554 78 8555 78 8556 78 8557 78 8558 78 8559 78 \
    8560 78 8561 78 8562 78 8563 78 8564 78 8565 78 8566 78 8567 78 8568 78 \
    8569 78 8570 78 8571 78 8572 78 8573 78 8574 78 8575 78 8576 78 8577 78 \
    8578 78 8579 78 8580 78 8581 78 8582 78 8583 78 8584 78 8585 78 8586 78 \
    8587 78 8588 78 8589 78 8590 78 8591 78 8592 78 8593 78 8594 78 8595 78 \
    8596 78 8597 78 8598 78 8599 78 8600 78 8601 78 8602 78 8603 78 8604 78 \
    8605 78 8606 78 8607 78 8608 78 8609 78 8610 78 8611 78 8612 78 8613 78 \
    8614 78 8615 78 8616 78 8617 78 8618 78 8619 78 8620 78 8621 78 8622 78 \
    8623 78 8624 78 8625 78 8626 78 8627 78 8628 78 8629 78 8630 78 8631 78 \
    8632 78 8633 78 8634 78 8635 78 8636 78 8637 78 8638 78 8639 78 8640 78 \
    8641 78 8642 78 8643 78 8644 78 8645 78 8646 78 8647 78 8648 78 8649 78 \
    8650 78 8651 78 8652 78 8653 78 8654 78 8655 78 8656 78 8657 78 8658 78 \
    8659 78 8660 78 8661 78 8662 78 8663 78 8664 78 8665 78 8666 78 8667 78 \
    8668 78 8669 78 8670 78 8671 78 8672 78 8673 78 8674 78 8675 78 8676 78 \
    8677 78 8678 78 8679 78 8680 78 8681 78 8682 78 8683 78 8684 78 8685 78 \
    8686 78 8687 78 8688 78 8689 78 8690 78 8691 78 8692 78 8693 78 8694 78 \
    8695 78 8696 78 8697 78 8698 78 8699 78 8700 78 8701 78 8702 78 8703 106 \
   ]

variable COMMON_PAGE_MAP 16

#
# The groupMap is indexed by combining the alternate page number with
# the page offset and returns a group number that identifies a unique
# set of character attributes.
#

variable groupMap [list \
    0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 2 \
    2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 3 3 3 \
    3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 2 2 2 2 2 2 4 4 4 4 4 \
    4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 2 2 2 2 0 5 5 5 5 5 5 5 5 \
    5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 6 2 2 2 2 2 2 2 2 2 \
    4 2 2 7 2 2 2 2 2 2 2 8 2 2 2 2 4 2 2 2 2 2 3 3 3 3 3 3 3 3 3 3 3 3 \
    3 3 3 3 3 3 3 3 3 3 3 2 3 3 3 3 3 3 3 9 4 4 4 4 4 4 4 4 4 4 4 4 4 4 \
    4 4 4 4 4 4 4 4 4 2 4 4 4 4 4 4 4 4 10 4 10 4 10 4 10 4 10 4 10 4 10 \
    4 10 4 10 4 10 4 10 4 10 4 10 4 10 4 10 4 10 4 10 4 10 4 10 4 10 4 \
    10 4 10 4 10 4 10 4 11 4 10 4 10 4 10 4 4 10 4 10 4 10 4 10 4 10 4 \
    10 4 10 4 10 4 12 10 4 10 4 10 4 10 4 10 4 10 4 10 4 10 4 10 4 10 4 \
    10 4 10 4 10 4 10 4 10 4 10 4 10 4 10 4 10 4 10 4 10 4 10 4 10 4 13 \
    10 4 10 4 10 4 14 4 15 10 4 10 4 16 10 4 17 17 10 4 4 18 19 20 10 4 \
    17 21 4 22 23 10 4 4 4 22 24 4 25 10 4 10 4 10 4 26 10 4 26 4 4 10 \
    4 26 10 4 27 27 10 4 10 4 28 10 4 4 4 10 4 4 4 4 4 4 4 29 10 4 29 10 \
    4 29 10 4 10 4 10 4 10 4 10 4 10 4 10 4 10 4 10 4 4 10 4 10 4 10 4 \
    10 4 10 4 10 4 10 4 10 4 10 4 30 29 10 4 10 4 31 32 10 4 10 4 10 4 \
    10 4 10 4 10 4 10 4 10 4 10 4 10 4 10 4 10 4 10 4 10 4 10 4 10 4 10 \
    4 10 4 10 4 10 4 33 34 10 4 10 4 10 4 10 4 10 4 10 4 10 4 10 4 10 4 \
    34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 \
    34 34 34 34 34 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 \
    4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 \
    4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 \
    34 34 4 4 4 4 4 4 4 4 4 2 2 4 4 4 4 4 4 4 2 2 2 2 2 2 2 2 2 2 2 2 2 \
    2 4 4 2 2 2 2 2 2 2 2 2 2 2 2 2 2 4 4 4 4 4 2 2 2 2 2 2 2 2 2 4 34 \
    34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 2 2 2 2 2 2 2 2 2 2 \
    2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 \
    2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 35 35 2 2 2 36 2 2 2 2 2 2 \
    2 2 2 7 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 2 2 2 2 2 2 \
    2 2 2 2 2 2 2 2 2 2 34 34 34 34 2 2 34 34 34 34 37 34 34 34 2 34 34 \
    34 34 34 2 2 38 2 39 39 39 34 40 34 41 41 42 3 3 3 3 3 3 3 3 3 3 3 \
    3 3 3 3 3 3 34 3 3 3 3 3 3 3 3 3 4 4 4 4 43 4 4 4 4 4 4 4 4 4 4 4 4 \
    4 4 4 4 4 10 4 4 4 4 4 4 4 4 4 4 4 4 34 44 45 46 47 48 49 50 4 10 4 \
    10 4 10 4 10 4 10 4 10 4 10 4 10 4 10 4 10 4 10 4 10 4 51 52 53 4 54 \
    55 2 34 34 34 34 34 34 34 34 34 56 56 56 56 56 56 56 56 56 56 56 56 \
    56 56 56 56 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 \
    3 3 3 3 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 \
    4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 10 4 10 4 10 4 10 4 10 4 10 4 10 \
    4 10 4 10 4 10 4 10 4 10 4 10 4 10 4 10 4 10 4 10 4 4 2 2 2 2 34 2 \
    2 10 4 10 4 10 4 10 4 10 4 10 4 10 4 10 4 10 4 10 4 10 4 10 4 10 4 \
    10 4 10 4 10 4 10 4 10 4 10 4 10 4 10 4 10 4 10 4 10 4 10 4 10 4 10 \
    4 4 10 4 10 4 10 4 10 4 10 4 10 4 10 4 34 10 4 10 4 10 4 10 4 10 4 \
    10 4 10 4 10 4 10 4 10 4 10 4 10 4 10 4 10 4 10 4 10 4 10 4 10 4 10 \
    4 34 34 10 4 34 34 34 34 34 34 10 4 10 4 10 4 10 4 10 4 10 4 10 4 10 \
    4 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 \
    34 34 34 34 34 34 34 34 34 34 34 57 57 57 57 57 57 57 57 57 57 57 57 \
    57 57 57 57 57 57 57 57 57 57 57 57 57 57 57 57 57 57 57 57 57 57 57 \
    57 57 57 34 34 4 4 4 4 4 4 4 34 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 \
    4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 58 34 4 2 34 34 34 34 34 34 \
    2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 34 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 \
    2 2 2 2 2 2 2 2 34 2 2 2 59 2 59 2 2 59 2 34 34 34 34 34 34 34 34 34 \
    34 34 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 \
    59 59 59 59 59 59 34 34 34 34 34 59 59 59 59 59 34 34 34 34 34 34 34 \
    34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 2 34 34 34 34 34 34 \
    34 34 34 34 34 34 34 34 59 34 34 34 59 34 59 59 59 59 59 59 59 59 59 \
    59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 34 34 34 34 34 59 \
    59 59 59 59 59 59 59 59 59 59 2 2 2 2 2 2 2 2 2 2 2 34 34 34 34 34 \
    34 34 34 34 34 2 2 2 2 2 2 2 2 2 2 2 2 2 59 59 59 2 59 59 59 59 59 \
    59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 \
    59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 \
    59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 \
    59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 \
    59 59 59 59 2 2 2 2 2 2 2 60 2 2 2 2 2 2 2 59 59 2 2 2 2 2 2 2 34 34 \
    2 2 2 2 2 2 2 2 2 2 59 59 59 59 59 34 59 59 59 59 59 59 59 59 59 59 \
    59 59 59 59 34 5 59 2 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 \
    59 59 59 59 59 59 59 59 59 59 59 59 34 34 34 2 2 2 2 2 2 2 2 2 2 2 \
    2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 34 34 34 34 34 34 34 34 34 34 34 34 \
    34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 \
    34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 59 59 59 59 59 \
    59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 \
    59 59 59 59 59 59 59 59 59 59 2 2 2 2 2 2 2 2 2 2 2 59 34 34 34 34 \
    34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 \
    34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 \
    34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 \
    34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 \
    34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 \
    34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 \
    34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 \
    34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 \
    34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 2 2 4 34 4 \
    4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 \
    4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 34 34 2 4 4 4 4 2 2 2 2 2 2 2 2 \
    4 4 4 4 2 34 34 4 2 2 2 2 34 34 34 4 4 4 4 4 4 4 4 4 4 2 2 4 4 4 4 \
    4 4 4 4 4 4 4 4 4 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 2 \
    4 4 34 4 4 4 4 4 4 4 4 34 34 4 4 34 34 4 4 4 4 4 4 4 4 4 4 4 4 4 4 \
    4 4 4 4 4 4 4 4 34 4 4 4 4 4 4 4 34 4 34 34 34 4 4 4 4 34 34 2 34 4 \
    4 4 2 2 2 2 34 34 4 4 34 34 4 4 2 34 34 34 34 34 34 34 34 34 4 34 34 \
    34 34 4 4 34 4 4 4 2 2 34 34 4 4 4 4 4 4 4 4 4 4 4 4 2 2 4 4 4 4 4 \
    4 4 34 34 34 34 34 34 34 2 34 34 4 4 4 4 4 4 34 34 34 34 4 4 34 34 \
    4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 34 4 4 4 4 4 4 4 34 4 4 \
    34 4 4 34 4 4 34 34 2 34 4 4 4 2 2 34 34 34 34 2 2 34 34 2 2 2 34 34 \
    34 34 34 34 34 34 34 34 34 4 4 4 4 34 4 34 34 34 34 34 34 34 4 4 4 \
    4 4 4 4 4 4 4 2 2 4 4 4 34 34 34 34 34 34 34 34 34 34 34 34 2 2 4 34 \
    4 4 4 4 4 4 4 34 4 34 4 4 4 34 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 \
    4 4 4 4 34 4 4 4 4 4 4 4 34 4 4 34 4 4 4 4 4 34 34 2 4 4 4 4 2 2 2 \
    2 2 34 2 2 4 34 4 4 2 34 34 4 34 34 34 34 34 34 34 34 34 34 34 34 34 \
    34 34 4 34 34 34 34 34 4 4 4 4 4 4 4 4 4 4 34 34 34 34 34 34 34 34 \
    34 34 34 34 34 34 34 34 34 2 4 4 34 4 4 4 4 4 4 4 4 34 34 4 4 34 34 \
    4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 34 4 4 4 4 4 4 4 34 4 4 \
    34 34 4 4 4 4 34 34 2 4 4 2 4 2 2 2 34 34 34 4 4 34 34 4 4 2 34 34 \
    34 34 34 34 34 34 2 4 34 34 34 34 4 4 34 4 4 4 34 34 34 34 4 4 4 4 \
    4 4 4 4 4 4 4 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 2 \
    4 34 4 4 4 4 4 4 34 34 34 4 4 4 34 4 4 4 4 34 34 34 4 4 34 4 34 4 4 \
    34 34 34 4 4 34 34 34 4 4 4 34 34 34 4 4 4 4 4 4 4 4 34 4 4 4 34 34 \
    34 34 4 4 2 4 4 34 34 34 4 4 4 34 4 4 4 2 34 34 34 34 34 34 34 34 34 \
    4 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 4 4 4 4 4 4 4 4 4 4 \
    4 4 34 34 34 34 34 34 34 34 34 34 34 34 34 34 4 4 4 34 4 4 4 4 4 4 \
    4 4 34 4 4 4 34 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 34 4 \
    4 4 4 4 4 4 4 4 4 34 4 4 4 4 4 34 34 34 34 2 2 2 4 4 4 4 34 2 2 2 34 \
    2 2 2 2 34 34 34 34 34 34 34 2 2 34 34 34 34 34 34 34 34 34 4 4 34 \
    34 34 34 4 4 4 4 4 4 4 4 4 4 34 34 34 34 34 34 34 34 34 34 34 34 34 \
    34 34 34 34 34 4 4 34 4 4 4 4 4 4 4 4 34 4 4 4 34 4 4 4 4 4 4 4 4 4 \
    4 4 4 4 4 4 4 4 4 4 4 4 4 4 34 4 4 4 4 4 4 4 4 4 4 34 4 4 4 4 4 34 \
    34 34 34 4 2 4 4 4 4 4 34 2 4 4 34 4 4 2 2 34 34 34 34 34 34 34 4 4 \
    34 34 34 34 34 34 34 4 34 4 4 34 34 34 34 4 4 4 4 4 4 4 4 4 4 34 34 \
    34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 4 4 34 4 4 4 4 4 4 \
    4 4 34 4 4 4 34 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 34 4 \
    4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 34 34 34 34 4 4 4 2 2 2 34 34 4 4 4 34 \
    4 4 4 2 34 34 34 34 34 34 34 34 34 4 34 34 34 34 34 34 34 34 4 4 34 \
    34 34 34 4 4 4 4 4 4 4 4 4 4 34 34 34 34 34 34 34 34 34 34 34 34 34 \
    34 34 34 34 34 4 4 34 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 34 34 34 \
    4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 34 4 4 4 4 4 4 4 4 \
    4 34 4 34 34 4 4 4 4 4 4 4 34 34 34 2 34 34 34 34 4 4 4 2 2 2 34 2 \
    34 4 4 4 4 4 4 4 4 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 \
    34 34 4 4 4 34 34 34 34 34 34 34 34 34 34 34 34 4 4 4 4 4 4 4 4 4 4 \
    4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 \
    4 4 4 4 2 4 4 2 2 2 2 2 2 2 34 34 34 34 2 4 4 4 4 4 4 4 2 2 2 2 2 2 \
    2 2 4 4 4 4 4 4 4 4 4 4 4 4 4 34 34 34 34 34 34 34 34 34 34 34 34 34 \
    34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 \
    34 4 4 34 4 34 34 4 4 34 4 34 34 4 34 34 34 34 34 34 4 4 4 4 34 4 4 \
    4 4 4 4 4 34 4 4 4 34 4 34 4 34 34 4 4 34 4 4 4 4 2 4 4 2 2 2 2 2 2 \
    34 2 2 4 34 34 4 4 4 4 4 34 4 34 2 2 2 2 2 2 34 34 4 4 4 4 4 4 4 4 \
    4 4 34 34 4 4 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 \
    34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 4 4 4 4 4 4 4 4 4 4 \
    4 4 4 4 4 4 4 4 4 4 4 4 4 4 2 2 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 \
    4 4 4 4 4 4 4 4 4 2 4 2 4 2 2 2 2 2 4 4 4 4 4 4 4 4 4 4 34 4 4 4 4 \
    4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 34 34 34 \
    34 34 34 2 2 2 2 2 2 2 2 2 2 2 2 2 2 4 2 2 2 2 2 4 2 2 4 4 4 4 34 34 \
    34 34 2 2 2 2 2 2 2 2 34 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 \
    2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 34 4 4 4 4 4 4 4 4 2 4 4 4 4 4 4 34 34 \
    4 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 \
    34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 \
    34 34 34 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 \
    4 4 4 4 4 34 4 4 4 4 4 34 4 4 34 4 2 2 2 2 4 2 34 34 34 2 2 4 2 34 \
    34 34 34 34 34 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 2 2 \
    34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 \
    34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 \
    34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 \
    34 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 \
    4 4 4 4 4 4 34 34 34 34 34 34 34 34 34 34 4 4 4 4 4 4 4 4 4 4 4 4 4 \
    4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 34 34 4 34 \
    34 34 34 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 \
    4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 \
    4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 34 34 34 34 34 \
    4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 \
    4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 \
    34 34 34 34 34 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 \
    4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 \
    4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 34 34 34 34 34 34 4 4 4 \
    4 4 4 4 34 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 \
    4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 \
    4 34 4 34 4 4 4 4 34 34 4 4 4 4 4 4 4 34 4 34 4 4 4 4 34 34 4 4 4 4 \
    4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 \
    4 34 4 34 4 4 4 4 34 34 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 \
    4 4 4 4 4 4 4 4 4 34 4 34 4 4 4 4 34 34 4 4 4 4 4 4 4 34 4 34 4 4 4 \
    4 34 34 4 4 4 4 4 4 4 34 4 4 4 4 4 4 4 34 4 4 4 4 4 4 4 4 4 4 4 4 4 \
    4 4 4 4 4 4 4 4 4 4 34 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 \
    4 4 4 4 4 4 4 4 4 34 4 34 4 4 4 4 34 34 4 4 4 4 4 4 4 34 4 4 4 4 4 \
    4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 \
    34 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 34 34 34 34 34 34 4 4 4 4 \
    4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 34 34 34 34 34 34 34 \
    34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 \
    34 34 34 34 34 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 \
    4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 \
    4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 34 34 34 34 34 34 \
    34 34 34 34 34 34 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 \
    4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 \
    4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 \
    4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 \
    4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 \
    4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 \
    4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 \
    4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 \
    4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 \
    4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 \
    4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 \
    4 4 4 4 4 4 4 4 4 34 34 34 34 34 34 34 34 34 6 4 4 4 4 4 4 4 4 4 4 \
    4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 2 2 34 34 34 4 4 4 4 4 4 4 4 4 4 4 \
    4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 \
    4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 \
    4 4 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 4 4 4 4 4 4 4 4 4 \
    4 4 4 4 34 4 4 4 4 2 2 2 34 34 34 34 34 34 34 34 34 34 34 4 4 4 4 4 \
    4 4 4 4 4 4 4 4 4 4 4 4 4 2 2 2 4 4 34 34 34 34 34 34 34 34 34 4 4 \
    4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 2 2 34 34 34 34 34 34 34 34 34 34 34 \
    34 4 4 4 4 4 4 4 4 4 4 4 4 4 34 4 4 4 34 2 2 34 34 34 34 34 34 34 34 \
    34 34 34 34 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 \
    4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 2 2 2 2 2 2 2 \
    4 4 4 4 4 4 4 4 2 4 4 2 2 2 2 2 2 2 2 2 2 2 4 4 4 4 4 4 4 2 4 34 34 \
    34 4 4 4 4 4 4 4 4 4 4 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 \
    34 34 34 34 34 34 34 2 2 2 2 2 2 7 2 2 2 2 7 7 7 5 34 4 4 4 4 4 4 4 \
    4 4 4 34 34 34 34 34 34 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 \
    4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 \
    4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 34 \
    34 34 34 34 34 34 34 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 \
    4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 2 34 34 34 34 34 34 34 34 34 34 \
    34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 \
    34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 \
    34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 \
    34 34 34 34 34 34 34 10 4 10 4 10 4 10 4 10 4 10 4 10 4 10 4 10 4 10 \
    4 10 4 10 4 10 4 10 4 10 4 10 4 10 4 10 4 10 4 10 4 10 4 10 4 10 4 \
    10 4 10 4 10 4 10 4 10 4 10 4 10 4 10 4 10 4 10 4 10 4 10 4 10 4 10 \
    4 10 4 10 4 10 4 10 4 10 4 10 4 10 4 10 4 10 4 10 4 10 4 10 4 10 4 \
    10 4 10 4 10 4 10 4 10 4 10 4 10 4 10 4 10 4 10 4 10 4 10 4 10 4 10 \
    4 10 4 10 4 10 4 10 4 10 4 10 4 10 4 10 4 10 4 10 4 10 4 61 62 63 64 \
    65 66 34 34 34 34 10 4 10 4 10 4 10 4 10 4 10 4 10 4 10 4 10 4 10 4 \
    10 4 10 4 10 4 10 4 10 4 10 4 10 4 10 4 10 4 10 4 10 4 10 4 10 4 10 \
    4 10 4 10 4 10 4 10 4 10 4 10 4 10 4 10 4 10 4 10 4 10 4 10 4 10 4 \
    10 4 10 4 10 4 10 4 10 4 10 4 10 4 10 4 34 34 34 34 34 34 4 4 4 4 4 \
    4 4 4 67 67 67 67 67 67 67 67 4 4 4 4 4 4 34 34 67 67 67 67 67 67 34 \
    34 4 4 4 4 4 4 4 4 67 67 67 67 67 67 67 67 4 4 4 4 4 4 4 4 67 67 67 \
    67 67 67 67 67 4 4 4 4 4 4 34 34 67 67 67 67 67 67 34 34 68 4 69 4 \
    70 4 71 4 34 67 34 67 34 67 34 67 4 4 4 4 4 4 4 4 67 67 67 67 67 67 \
    67 67 4 4 4 4 4 4 4 4 4 4 4 4 4 4 34 34 72 73 74 75 76 77 78 79 80 \
    81 82 83 84 85 86 87 88 89 90 91 92 93 94 95 96 97 98 99 100 101 102 \
    103 104 105 106 107 108 109 110 111 112 113 114 115 116 117 118 119 \
    4 4 120 121 122 34 123 124 67 67 125 125 126 2 127 2 2 2 128 129 130 \
    34 131 132 133 133 133 133 134 2 2 2 4 4 135 136 34 34 137 138 67 67 \
    139 139 34 2 2 2 4 4 140 141 142 4 143 144 67 67 145 145 146 2 2 2 \
    34 34 147 148 149 34 150 151 152 152 153 153 154 2 2 34 6 6 6 6 6 6 \
    6 6 6 6 6 155 156 156 157 158 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 \
    2 2 2 2 2 5 5 35 35 35 35 35 6 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 \
    2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 34 34 34 34 2 34 34 34 34 34 34 34 \
    6 156 5 5 5 34 34 34 34 34 34 159 159 159 159 159 159 2 4 34 34 2 2 \
    2 2 2 2 2 2 2 2 2 4 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 34 34 34 34 34 34 \
    34 34 34 34 34 34 34 34 34 34 34 2 2 2 2 2 2 2 2 160 2 2 2 2 2 2 2 \
    2 2 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 \
    34 34 34 34 34 34 34 34 34 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 \
    2 2 2 2 2 2 2 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 \
    34 34 34 2 2 161 162 2 2 2 163 2 164 4 165 166 167 4 4 168 169 170 \
    4 2 168 171 2 2 172 172 172 173 174 2 2 175 176 177 2 173 2 178 2 179 \
    2 180 181 182 182 2 4 183 183 2 184 4 4 4 4 4 4 2 34 34 4 185 186 2 \
    2 2 2 2 187 4 4 4 4 2 2 34 34 34 34 34 34 34 2 2 2 2 2 2 2 2 2 2 2 \
    2 2 188 188 188 188 188 188 188 188 188 188 188 188 188 188 188 188 \
    4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 34 34 34 34 34 34 34 34 34 \
    34 34 34 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 \
    2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 \
    2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 \
    2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 \
    2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 \
    2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 \
    2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 \
    2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 \
    2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 4 4 4 4 4 4 4 \
    4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 \
    4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 2 2 2 2 2 2 \
    2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 4 2 2 2 2 2 2 2 2 2 2 2 2 2 \
    2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 \
    2 2 2 2 2 2 2 2 2 2 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 \
    34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 \
    34 34 34 34 34 34 34 34 34 34 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 \
    2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 34 34 34 34 34 34 34 34 34 \
    34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 2 2 2 2 2 2 2 2 2 2 \
    2 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 2 \
    2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 \
    2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 4 4 4 4 4 4 4 4 4 \
    4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 189 189 189 189 189 189 189 189 189 \
    189 189 189 189 189 189 189 189 189 189 189 189 189 189 189 189 189 \
    4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 2 2 2 2 2 2 2 2 \
    2 2 2 2 2 2 2 2 2 2 2 2 2 34 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 \
    2 34 34 2 2 34 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 \
    2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 \
    2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 \
    2 2 2 2 2 2 2 34 34 2 2 2 2 2 2 2 2 2 2 34 34 34 34 34 34 34 34 34 \
    34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 \
    34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 \
    34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 \
    34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 \
    34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 2 2 2 2 34 2 \
    2 2 2 34 34 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 \
    34 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 \
    2 2 2 34 2 34 2 2 2 2 34 34 34 2 34 2 2 2 2 2 2 2 34 34 2 2 2 2 2 2 \
    2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 \
    2 2 2 2 2 2 2 2 2 2 2 2 34 34 34 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 \
    2 2 2 2 2 2 2 34 2 2 2 2 2 2 2 2 2 2 2 2 2 2 34 34 34 34 34 34 34 34 \
    34 34 34 34 34 34 34 34 34 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 \
    2 2 2 2 2 2 2 2 34 34 34 34 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 \
    2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 34 2 2 2 2 2 2 2 2 2 2 \
    2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 \
    2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 \
    2 2 2 2 2 2 2 2 2 2 2 34 34 34 34 34 34 34 34 34 34 34 34 2 2 2 2 2 \
    2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 \
    2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 \
    2 2 2 2 2 2 2 2 2 2 2 2 2 34 34 34 34 34 34 34 34 34 34 34 34 34 34 \
    34 34 34 34 34 34 34 34 34 34 34 34 35 35 35 35 35 35 35 35 35 35 35 \
    35 34 34 34 34 6 2 2 2 2 4 4 4 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 \
    2 2 2 2 2 2 2 4 4 4 4 4 4 4 4 4 2 2 2 2 2 2 2 4 4 4 4 4 2 2 4 4 4 4 \
    4 2 2 2 34 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 \
    4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 \
    4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 34 34 2 2 2 2 4 4 4 \
    2 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 \
    4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 \
    4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 2 4 4 4 4 34 34 34 34 \
    34 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 \
    4 4 4 4 4 4 4 4 34 34 34 34 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 \
    4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 \
    4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 \
    4 4 4 4 4 4 34 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 \
    4 4 4 4 4 4 4 4 4 4 4 4 4 4 34 34 34 34 34 34 34 34 34 34 34 34 34 \
    34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 \
    34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 4 4 4 4 \
    4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 \
    4 4 4 4 4 4 4 34 34 34 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 \
    4 4 4 4 4 4 4 4 4 4 4 4 4 4 34 34 34 34 34 34 34 34 34 34 34 34 34 \
    2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 \
    4 4 4 4 4 4 4 4 4 34 34 34 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 \
    4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 2 2 2 2 \
    2 2 2 2 2 2 2 2 2 2 2 4 4 4 4 4 4 4 4 4 4 4 4 34 34 34 34 4 4 4 4 4 \
    4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 \
    4 4 4 4 4 4 4 4 34 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 \
    4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 \
    4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 \
    4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 190 4 191 4 192 4 34 34 34 \
    34 4 4 4 4 4 193 194 195 196 197 198 199 200 4 4 201 202 203 4 4 4 \
    204 205 206 207 208 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 209 210 \
    211 212 4 4 4 4 4 4 4 213 214 215 216 217 218 219 220 221 222 223 224 \
    225 226 4 227 4 4 228 229 230 231 4 232 4 233 234 4 4 4 4 4 4 4 4 235 \
    4 236 237 4 238 239 34 34 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 \
    4 4 4 4 4 4 4 4 4 4 34 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 \
    4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 34 \
    34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 \
    34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 \
    34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 \
    34 34 34 34 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 \
    4 4 4 4 4 4 4 4 4 4 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 \
    34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 \
    34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 \
    34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 \
    34 34 34 34 34 4 4 4 4 4 4 4 4 4 4 4 4 4 34 34 34 2 2 2 2 2 2 2 2 2 \
    2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 \
    2 2 2 2 2 2 2 2 2 2 2 2 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 \
    34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 \
    34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 4 4 4 4 4 \
    4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 34 34 \
    34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 \
    34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 \
    34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 \
    34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 157 \
    157 157 157 157 157 157 157 157 157 157 157 157 157 157 157 157 157 \
    157 157 157 157 157 157 157 157 157 157 157 157 157 157 157 157 157 \
    157 157 157 157 157 157 157 157 157 157 157 157 157 157 157 157 157 \
    157 157 157 157 157 157 157 157 157 157 157 157 157 157 157 157 157 \
    157 157 157 157 157 157 157 157 157 157 157 157 157 157 157 157 157 \
    157 157 157 157 157 157 157 157 157 157 157 157 157 157 157 157 157 \
    157 157 157 157 157 157 157 157 157 157 157 157 157 157 157 157 157 \
    157 157 157 157 157 157 157 157 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 \
    4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 34 34 4 4 4 \
    4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 \
    4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 34 34 34 34 34 34 34 34 \
    34 34 34 34 34 34 34 34 34 34 34 34 34 240 241 242 243 244 245 246 \
    34 34 34 34 34 34 34 34 34 34 34 34 247 248 249 250 251 34 34 34 34 \
    34 59 2 59 59 59 59 59 59 59 59 59 59 2 59 59 59 59 59 59 59 59 59 \
    59 59 59 59 34 59 59 59 59 59 34 59 34 59 59 34 59 59 34 59 59 59 59 \
    59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 \
    59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 \
    59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 \
    59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 \
    59 59 59 59 59 59 59 59 59 59 59 59 34 34 34 34 34 34 34 34 34 34 34 \
    34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 59 \
    59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 \
    59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 \
    59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 \
    59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 \
    59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 \
    59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 \
    59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 \
    59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 \
    59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 \
    59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 \
    59 59 59 59 2 2 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 59 \
    59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 \
    59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 \
    59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 34 34 59 59 59 59 \
    59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 \
    59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 \
    59 59 59 59 34 34 34 34 34 34 34 34 35 35 35 35 35 35 35 35 35 35 35 \
    35 35 35 35 35 35 35 35 35 35 35 35 35 35 35 35 35 35 35 35 35 59 59 \
    59 59 59 59 59 59 59 59 59 59 59 34 34 34 7 7 7 7 7 7 7 7 7 7 7 7 7 \
    7 7 7 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 2 2 2 2 34 34 \
    34 34 34 34 34 34 34 34 34 34 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 \
    2 2 2 2 34 34 2 2 2 2 2 2 2 2 2 2 34 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 \
    2 2 2 2 34 2 2 2 2 34 34 34 34 59 59 59 59 59 34 59 59 59 59 59 59 \
    59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 \
    59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 \
    59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 \
    59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 \
    59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 59 \
    59 59 59 59 59 59 59 59 59 59 59 59 59 59 34 34 156 34 2 2 2 2 2 2 \
    2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 3 3 3 3 3 3 3 3 \
    3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 2 2 2 2 2 2 4 4 4 4 4 4 4 4 4 4 \
    4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 2 2 2 2 2 2 2 2 2 2 2 4 4 4 4 4 4 4 \
    4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 \
    4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 \
    4 4 4 4 4 4 4 4 4 4 4 4 4 4 34 34 34 4 4 4 4 4 4 34 34 4 4 4 4 4 4 \
    34 34 4 4 4 4 4 4 34 34 4 4 4 34 34 34 2 2 2 2 2 2 2 34 2 2 2 2 2 2 \
    2 34 34 34 34 34 34 34 34 34 34 159 159 159 159 35 35 35 4 4 4 4 4 \
    4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 34 4 4 4 4 34 34 \
    34 34 34 34 34 34 34 34 34 34 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 \
    4 4 4 4 4 4 4 4 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 \
    34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 \
    34 34 34 34 34 34 34 34 34 34 34 34 34 252 252 252 252 252 252 252 \
    252 252 252 252 252 252 252 252 252 252 252 252 252 252 252 252 252 \
    252 252 252 252 252 252 252 252 252 252 252 252 252 252 34 34 4 4 4 \
    4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 \
    4 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 \
    34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 \
    34 34 34 34 34 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 \
    4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 \
    4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 \
    4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 34 34 34 34 34 34 34 \
    34 34 34 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 \
    4 4 4 4 4 4 4 4 4 4 34 34 34 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 \
    4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 \
    4 4 4 4 4 4 4 4 2 2 2 4 4 4 4 4 4 4 4 4 5 5 5 5 5 5 5 5 2 2 2 2 2 2 \
    2 2 4 4 2 2 2 2 2 2 2 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 \
    4 4 4 4 4 4 4 2 2 2 2 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 \
    4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 34 34 34 34 34 34 \
    34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 \
    34 34 34 34 34 253 253 253 253 253 253 253 253 253 253 253 253 253 \
    253 253 253 253 253 253 253 253 253 253 253 253 253 4 4 4 4 4 4 4 4 \
    4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 254 254 254 254 254 254 254 254 \
    254 254 254 254 254 254 254 254 254 254 254 254 254 254 254 254 254 \
    254 4 4 4 4 4 4 4 34 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 255 255 255 \
    255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 \
    255 255 255 255 255 255 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 \
    4 4 4 4 256 34 256 256 34 34 256 34 34 256 256 34 34 256 256 256 256 \
    34 256 256 256 256 256 256 256 256 4 4 4 4 34 4 34 4 4 4 4 34 4 4 34 \
    4 4 4 4 4 4 4 4 4 4 4 257 257 257 257 257 257 257 257 257 257 257 257 \
    257 257 257 257 257 257 257 257 257 257 257 257 257 257 4 4 4 4 4 4 \
    4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 258 258 34 258 258 258 258 \
    34 34 258 258 258 258 258 258 258 258 34 258 258 258 258 258 258 258 \
    34 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 259 259 34 259 \
    259 259 259 34 259 259 259 259 259 34 259 34 34 34 259 259 259 259 \
    259 259 259 34 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 \
    260 260 260 260 260 260 260 260 260 260 260 260 260 260 260 260 260 \
    260 260 260 260 260 260 260 260 260 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 \
    4 4 4 4 4 4 4 4 4 4 261 261 261 261 261 261 261 261 261 261 261 261 \
    261 261 261 261 261 261 261 261 261 261 261 261 261 261 4 4 4 4 4 4 \
    4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 262 262 262 262 262 262 262 \
    262 262 262 262 262 262 262 262 262 262 262 262 262 262 262 262 262 \
    262 262 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 263 263 \
    263 263 263 263 263 263 263 263 263 263 263 263 263 263 263 263 263 \
    263 263 263 263 263 263 263 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 \
    4 4 4 4 4 4 264 264 264 264 264 264 264 264 264 264 264 264 264 264 \
    264 264 264 264 264 264 264 264 264 264 264 264 4 4 4 4 4 4 4 4 4 4 \
    4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 265 265 265 265 265 265 265 265 265 \
    265 265 265 265 265 265 265 265 265 265 265 265 265 265 265 265 265 \
    4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 34 34 34 34 266 \
    266 266 266 266 266 266 266 266 266 266 266 266 266 266 266 266 267 \
    266 266 266 266 266 266 266 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 268 \
    4 4 4 4 4 4 4 4 4 4 4 4 4 4 269 269 269 269 269 269 269 269 269 269 \
    269 269 269 269 269 269 269 270 269 269 269 269 269 269 269 4 4 4 4 \
    4 4 4 4 4 4 4 4 4 4 4 4 4 4 271 4 4 4 4 4 4 4 4 4 4 4 4 4 4 272 272 \
    272 272 272 272 272 272 272 272 272 272 272 272 272 272 272 273 272 \
    272 272 272 272 272 272 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 274 4 4 \
    4 4 4 4 4 4 4 4 4 4 4 4 275 275 275 275 275 275 275 275 275 275 275 \
    275 275 275 275 275 275 276 275 275 275 275 275 275 275 4 4 4 4 4 4 \
    4 4 4 4 4 4 4 4 4 4 4 4 277 4 4 4 4 4 4 4 4 4 4 4 4 4 4 278 278 278 \
    278 278 278 278 278 278 278 278 278 278 278 278 278 278 279 278 278 \
    278 278 278 278 278 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 280 4 4 4 4 \
    4 4 4 4 4 4 4 4 4 4 34 34 34 34 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 \
    2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 34 \
    34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 \
    34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 \
    34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 \
    34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 \
    34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 \
    34 34 34 34 34 34 34 34 34 34 35 35 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 \
    4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 \
    4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 \
    4 4 4 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 \
    34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 4 4 4 4 \
    4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 34 34 34 34 34 \
    34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 \
    34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 \
    34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 \
    34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 \
    34 34 35 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 34 \
    34 34 34 34 34 34 34 34 34 34 35 35 35 35 35 35 35 35 35 35 35 35 35 \
    35 35 35 35 35 35 35 35 35 35 35 35 35 35 35 35 35 35 35 35 35 35 35 \
    35 35 35 35 35 35 35 35 35 35 35 35 35 35 35 35 35 35 35 35 35 35 35 \
    35 35 35 35 35 35 35 35 35 35 35 35 35 35 35 35 35 35 35 35 35 35 35 \
    35 35 35 35 35 35 35 35 35 35 35 35 35 35 157 157 157 157 157 157 157 \
    157 157 157 157 157 157 157 157 157 157 157 157 157 157 157 157 157 \
    157 157 157 157 157 157 157 157 157 157 157 157 157 157 157 157 157 \
    157 157 157 157 157 157 157 157 157 157 157 157 157 157 157 157 157 \
    157 157 157 157 157 157 157 157 157 157 157 157 157 157 157 157 157 \
    157 157 157 157 157 157 157 157 157 157 157 157 157 157 157 157 157 \
    157 157 157 157 157 157 157 157 157 157 157 157 157 157 157 157 157 \
    157 157 157 157 157 157 157 157 157 157 157 157 157 157 157 157 157 \
    35 35]

#
# Each group represents a unique set of character attributes.  The attributes
# are encoded into a 32-bit value as follows:
#
# Bit  0	A.1
#
# Bit  1	B.1
#
# Bit  2	B.3
#
# Bit  3	C.1.1
#
# Bit  4	C.1.2
#
# Bit  5	C.2.1
#
# Bit  6	C.2.2
#
# Bit  7	C.3--C.9
#
# Bit  8	D.1
#
# Bit  9	D.2
#
# Bit  10	Case maps to several characters
#
# Bits 11-31	Case delta: delta for case conversions.  This should be the
#		highest field so we can easily sign extend.
#

variable groups [list \
    32 8 0 66052 512 64 16 2 1587716 1540 2564 3588 5636 -247292 -548348 \
    430596 422404 420356 162308 414212 416260 424452 432644 428548 \
    436740 438788 446980 444932 449028 4612 7684 -198140 -114172 -265724 \
    1 128 237572 9728 78340 76292 131588 129540 11780 13828 -60924 \
    -50684 -26112 -11776 -17920 -30204 -44540 -110076 -97788 -95740 \
    -122364 -130556 164356 98820 15876 256 320 17924 19972 22020 24068 \
    26116 -118268 -15868 28164 30212 32260 34308 36356 38404 40452 \
    42500 44548 46596 48644 50692 52740 54788 56836 58884 60932 62980 \
    65028 67076 69124 71172 73220 75268 77316 79364 81412 83460 85508 \
    87556 89604 91652 93700 95748 97796 99844 101892 103940 105988 \
    108036 110084 112132 114180 116228 118276 120324 122372 124420 \
    126468 128516 130564 132612 134660 136708 138756 140804 142852 \
    -151036 144900 -14689788 146948 148996 151044 153092 155140 -175612 \
    157188 159236 161284 163332 165380 -204284 167428 169476 171524 \
    173572 175620 -228860 -13820 177668 179716 181764 183812 185860 \
    -261628 -257532 187908 18 66 640 384 192 189440 -17102336 191488 \
    -16080384 193536 -17110528 -17112576 -17114624 -17118720 -17120768 \
    -17116672 195584 -17122816 -17124864 -17126912 197632 199680 201728 \
    -15394300 -17133056 -17167868 -16920060 -17190400 -17192448 -17182208 \
    -15488512 -15463936 -17237504 33284 53764 204288 206336 208384 \
    210432 212480 214528 216576 218624 220672 222720 224768 226816 \
    228864 230912 232960 235008 237056 239104 241152 243200 245248 \
    247296 249344 251392 253440 255488 257536 259584 261632 263680 \
    265728 267776 269824 271872 273920 275968 278016 280064 282112 \
    284160 286208 288256 290304 292352 294400 296448 298496 300544 \
    302592 304640 306692 308740 310788 312836 314884 316932 318980 \
    321028 323076 325124 327172 329220 82436 -245167616 -245274112 \
    -245380608 -245487104 -245593600 -245700096 -245806592 -245913088 \
    -246019584 -246126080 -246232576 -246339072 -246445568 -244823552 \
    -244844032 -244874752 -244942336 -244962816 -244993536 -245061120 \
    -245081600 -245112320 -245179904 -245200384 -245231104 -245298688 \
    -245319168 -245349888]

#
# Table for characters that lowercased to multiple ones
#

variable multiCaseTable [list \
    {115 115} \
    {105 775} \
    {700 110} \
    {106 780} \
    {32 953} \
    {953 776 769} \
    {965 776 769} \
    {1381 1410} \
    {104 817} \
    {116 776} \
    {119 778} \
    {121 778} \
    {97 702} \
    {965 787} \
    {965 787 768} \
    {965 787 769} \
    {965 787 834} \
    {7936 953} \
    {7937 953} \
    {7938 953} \
    {7939 953} \
    {7940 953} \
    {7941 953} \
    {7942 953} \
    {7943 953} \
    {7936 953} \
    {7937 953} \
    {7938 953} \
    {7939 953} \
    {7940 953} \
    {7941 953} \
    {7942 953} \
    {7943 953} \
    {7968 953} \
    {7969 953} \
    {7970 953} \
    {7971 953} \
    {7972 953} \
    {7973 953} \
    {7974 953} \
    {7975 953} \
    {7968 953} \
    {7969 953} \
    {7970 953} \
    {7971 953} \
    {7972 953} \
    {7973 953} \
    {7974 953} \
    {7975 953} \
    {8032 953} \
    {8033 953} \
    {8034 953} \
    {8035 953} \
    {8036 953} \
    {8037 953} \
    {8038 953} \
    {8039 953} \
    {8032 953} \
    {8033 953} \
    {8034 953} \
    {8035 953} \
    {8036 953} \
    {8037 953} \
    {8038 953} \
    {8039 953} \
    {8048 953} \
    {945 953} \
    {940 953} \
    {945 834} \
    {945 834 953} \
    {945 953} \
    {8052 953} \
    {951 953} \
    {942 953} \
    {951 834} \
    {951 834 953} \
    {951 953} \
    {953 776 768} \
    {953 776 769} \
    {953 834} \
    {953 776 834} \
    {965 776 768} \
    {965 776 769} \
    {961 787} \
    {965 834} \
    {965 776 834} \
    {8060 953} \
    {969 953} \
    {974 953} \
    {969 834} \
    {969 834 953} \
    {969 953} \
    {114 115} \
    {176 99} \
    {176 102} \
    {110 111} \
    {115 109} \
    {116 101 108} \
    {116 109} \
    {104 112 97} \
    {97 117} \
    {111 118} \
    {112 97} \
    {110 97} \
    {956 97} \
    {109 97} \
    {107 97} \
    {107 98} \
    {109 98} \
    {103 98} \
    {112 102} \
    {110 102} \
    {956 102} \
    {104 122} \
    {107 104 122} \
    {109 104 122} \
    {103 104 122} \
    {116 104 122} \
    {112 97} \
    {107 112 97} \
    {109 112 97} \
    {103 112 97} \
    {112 118} \
    {110 118} \
    {956 118} \
    {109 118} \
    {107 118} \
    {109 118} \
    {112 119} \
    {110 119} \
    {956 119} \
    {109 119} \
    {107 119} \
    {109 119} \
    {107 969} \
    {109 969} \
    {98 113} \
    {99 8725 107 103} \
    {99 111 46} \
    {100 98} \
    {103 121} \
    {104 112} \
    {107 107} \
    {107 109} \
    {112 104} \
    {112 112 109} \
    {112 114} \
    {115 118} \
    {119 98} \
    {102 102} \
    {102 105} \
    {102 108} \
    {102 102 105} \
    {102 102 108} \
    {115 116} \
    {115 116} \
    {1396 1398} \
    {1396 1381} \
    {1396 1387} \
    {1406 1398} \
    {1396 1389} \
]

#
# The following constants are used to determine the category of a
# Unicode character.
#

variable A1Mask  [expr {1 << 0}]
variable B1Mask  [expr {1 << 1}]
variable B3Mask  [expr {1 << 2}]
variable C11Mask [expr {1 << 3}]
variable C12Mask [expr {1 << 4}]
variable C21Mask [expr {1 << 5}]
variable C22Mask [expr {1 << 6}]
variable C39Mask [expr {1 << 7}]
variable D1Mask  [expr {1 << 8}]
variable D2Mask  [expr {1 << 9}]
variable MCMask  [expr {1 << 10}]

#
# The following procs extract the fields of the character info.
#

proc GetCaseType {info} {expr {($info & 0xE0) >> 5}}
proc GetCategory {info} {expr {$info & 0x1F}}
proc GetDelta {info} {expr {$info >> 11}}
proc GetMC {info} {
    variable multiCaseTable
    lindex $multiCaseTable [GetDelta $info]
}

#
# This proc extracts the information about a character from the
# Unicode character tables.
#

proc GetUniCharInfo {uc} {
    variable OFFSET_BITS
    variable COMMON_PAGE_MAP
    variable pageMap
    variable groupMap
    variable groups

    set page [expr {($uc & 0x1fffff) >> $OFFSET_BITS}]
    if {[info exists pageMap($page)]} {
	set apage $pageMap($page)
    } else {
	set apage $COMMON_PAGE_MAP
    }

    lindex $groups \
	   [lindex $groupMap \
		   [expr {($apage << $OFFSET_BITS) | \
			   ($uc & ((1 << $OFFSET_BITS) - 1))}]]
}

} ; # namespace eval ::stringprep::data

