"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.flowFrameworkPlugin = flowFrameworkPlugin;
var _common = require("../../common");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

/**
 * Used during the plugin's setup() lifecycle phase to register various client actions
 * representing Flow Framework plugin APIs. These are then exposed and used on the
 * server-side when processing node APIs - see server/routes/flow_framework_routes_service
 * for examples.
 */
function flowFrameworkPlugin(Client, config, components) {
  const ca = components.clientAction.factory;
  Client.prototype.flowFramework = components.clientAction.namespaceFactory();
  const flowFramework = Client.prototype.flowFramework.prototype;
  flowFramework.getWorkflow = ca({
    url: {
      fmt: `${_common.FLOW_FRAMEWORK_WORKFLOW_ROUTE_PREFIX}/<%=workflow_id%>`,
      req: {
        workflow_id: {
          type: 'string',
          required: true
        }
      }
    },
    method: 'GET'
  });
  flowFramework.searchWorkflows = ca({
    url: {
      fmt: _common.FLOW_FRAMEWORK_SEARCH_WORKFLOWS_ROUTE
    },
    needBody: true,
    // Exposed client rejects making GET requests with a body. So, we use POST
    method: 'POST'
  });
  flowFramework.getWorkflowState = ca({
    url: {
      fmt: `${_common.FLOW_FRAMEWORK_WORKFLOW_ROUTE_PREFIX}/<%=workflow_id%>/_status`,
      req: {
        workflow_id: {
          type: 'string',
          required: true
        }
      }
    },
    method: 'GET'
  });
  flowFramework.searchWorkflowState = ca({
    url: {
      fmt: _common.FLOW_FRAMEWORK_SEARCH_WORKFLOW_STATE_ROUTE
    },
    needBody: true,
    // Exposed client rejects making GET requests with a body. So, we use POST
    method: 'POST'
  });
  flowFramework.createWorkflow = ca({
    url: {
      fmt: `${_common.FLOW_FRAMEWORK_WORKFLOW_ROUTE_PREFIX}?provision=false`
    },
    needBody: true,
    method: 'POST'
  });
  flowFramework.updateWorkflow = ca({
    url: {
      fmt: `${_common.FLOW_FRAMEWORK_WORKFLOW_ROUTE_PREFIX}/<%=workflow_id%>?update_fields=<%=update_fields%>`,
      req: {
        workflow_id: {
          type: 'string',
          required: true
        },
        update_fields: {
          type: 'boolean',
          required: true
        }
      }
    },
    needBody: true,
    method: 'PUT'
  });
  flowFramework.updateAndReprovisionWorkflow = ca({
    url: {
      fmt: `${_common.FLOW_FRAMEWORK_WORKFLOW_ROUTE_PREFIX}/<%=workflow_id%>?update_fields=<%=update_fields%>&reprovision=true&wait_for_completion_timeout=${_common.PROVISION_TIMEOUT}`,
      req: {
        workflow_id: {
          type: 'string',
          required: true
        },
        update_fields: {
          type: 'boolean',
          required: true
        }
      }
    },
    needBody: true,
    method: 'PUT'
  });
  flowFramework.updateAndReprovisionWorkflowAsync = ca({
    url: {
      fmt: `${_common.FLOW_FRAMEWORK_WORKFLOW_ROUTE_PREFIX}/<%=workflow_id%>?update_fields=<%=update_fields%>&reprovision=true`,
      req: {
        workflow_id: {
          type: 'string',
          required: true
        },
        update_fields: {
          type: 'boolean',
          required: true
        }
      }
    },
    needBody: true,
    method: 'PUT'
  });
  flowFramework.provisionWorkflow = ca({
    url: {
      fmt: `${_common.FLOW_FRAMEWORK_WORKFLOW_ROUTE_PREFIX}/<%=workflow_id%>/_provision?wait_for_completion_timeout=${_common.PROVISION_TIMEOUT}`,
      req: {
        workflow_id: {
          type: 'string',
          required: true
        }
      }
    },
    method: 'POST'
  });
  flowFramework.provisionWorkflowAsync = ca({
    url: {
      fmt: `${_common.FLOW_FRAMEWORK_WORKFLOW_ROUTE_PREFIX}/<%=workflow_id%>/_provision`,
      req: {
        workflow_id: {
          type: 'string',
          required: true
        }
      }
    },
    method: 'POST'
  });
  flowFramework.deprovisionWorkflow = ca({
    url: {
      fmt: `${_common.FLOW_FRAMEWORK_WORKFLOW_ROUTE_PREFIX}/<%=workflow_id%>/_deprovision`,
      req: {
        workflow_id: {
          type: 'string',
          required: true
        }
      }
    },
    method: 'POST'
  });
  flowFramework.forceDeprovisionWorkflow = ca({
    url: {
      fmt: `${_common.FLOW_FRAMEWORK_WORKFLOW_ROUTE_PREFIX}/<%=workflow_id%>/_deprovision?allow_delete=<%=resource_ids%>`,
      req: {
        workflow_id: {
          type: 'string',
          required: true
        },
        resource_ids: {
          type: 'string',
          required: true
        }
      }
    },
    method: 'POST'
  });
  flowFramework.deleteWorkflow = ca({
    url: {
      fmt: `${_common.FLOW_FRAMEWORK_WORKFLOW_ROUTE_PREFIX}/<%=workflow_id%>`,
      req: {
        workflow_id: {
          type: 'string',
          required: true
        }
      }
    },
    method: 'DELETE'
  });
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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