/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entries.mail;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.activation.URLDataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.SendFailedException;
import javax.mail.Session;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.apache.commons.vfs.FileObject;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.ResultFile;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.encryption.Encr;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.gui.JobTracker;
import org.pentaho.di.core.logging.LogWriter;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.job.Job;
import org.pentaho.di.job.JobEntryResult;
import org.pentaho.di.job.JobEntryType;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entries.mail.Messages;
import org.pentaho.di.job.entry.JobEntryBase;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.job.entry.validator.AndValidator;
import org.pentaho.di.job.entry.validator.JobEntryValidatorUtils;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.resource.ResourceEntry;
import org.pentaho.di.resource.ResourceReference;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobEntryMail
extends JobEntryBase
implements Cloneable,
JobEntryInterface {
    private String server;
    private String destination;
    private String destinationCc;
    private String destinationBCc;
    private String replyAddress;
    private String replyName;
    private String subject;
    private boolean includeDate;
    private String contactPerson;
    private String contactPhone;
    private String comment;
    private boolean includingFiles;
    private int[] fileType;
    private boolean zipFiles;
    private String zipFilename;
    private boolean usingAuthentication;
    private String authenticationUser;
    private String authenticationPassword;
    private boolean onlySendComment;
    private boolean useHTML;
    private boolean usingSecureAuthentication;
    private boolean usePriority;
    private String port;
    private String priority;
    private String importance;
    private String secureConnectionType;
    private String encoding;
    private String replyToAddresses;

    public JobEntryMail(String n) {
        super(n, "");
        this.setJobEntryType(JobEntryType.MAIL);
        this.allocate(0);
    }

    public JobEntryMail() {
        this("");
        this.allocate(0);
    }

    public JobEntryMail(JobEntryBase jeb) {
        super(jeb);
        this.allocate(0);
    }

    @Override
    public Object clone() {
        JobEntryMail je = (JobEntryMail)super.clone();
        return je;
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer(300);
        retval.append(super.getXML());
        retval.append("      ").append(XMLHandler.addTagValue((String)"server", (String)this.server));
        retval.append("      ").append(XMLHandler.addTagValue((String)"port", (String)this.port));
        retval.append("      ").append(XMLHandler.addTagValue((String)"destination", (String)this.destination));
        retval.append("      ").append(XMLHandler.addTagValue((String)"destinationCc", (String)this.destinationCc));
        retval.append("      ").append(XMLHandler.addTagValue((String)"destinationBCc", (String)this.destinationBCc));
        retval.append("      ").append(XMLHandler.addTagValue((String)"replyto", (String)this.replyAddress));
        retval.append("      ").append(XMLHandler.addTagValue((String)"replytoname", (String)this.replyName));
        retval.append("      ").append(XMLHandler.addTagValue((String)"subject", (String)this.subject));
        retval.append("      ").append(XMLHandler.addTagValue((String)"include_date", (boolean)this.includeDate));
        retval.append("      ").append(XMLHandler.addTagValue((String)"contact_person", (String)this.contactPerson));
        retval.append("      ").append(XMLHandler.addTagValue((String)"contact_phone", (String)this.contactPhone));
        retval.append("      ").append(XMLHandler.addTagValue((String)"comment", (String)this.comment));
        retval.append("      ").append(XMLHandler.addTagValue((String)"include_files", (boolean)this.includingFiles));
        retval.append("      ").append(XMLHandler.addTagValue((String)"zip_files", (boolean)this.zipFiles));
        retval.append("      ").append(XMLHandler.addTagValue((String)"zip_name", (String)this.zipFilename));
        retval.append("      ").append(XMLHandler.addTagValue((String)"use_auth", (boolean)this.usingAuthentication));
        retval.append("      ").append(XMLHandler.addTagValue((String)"use_secure_auth", (boolean)this.usingSecureAuthentication));
        retval.append("      ").append(XMLHandler.addTagValue((String)"auth_user", (String)this.authenticationUser));
        retval.append("      ").append(XMLHandler.addTagValue((String)"auth_password", (String)Encr.encryptPasswordIfNotUsingVariables((String)this.authenticationPassword)));
        retval.append("      ").append(XMLHandler.addTagValue((String)"only_comment", (boolean)this.onlySendComment));
        retval.append("      ").append(XMLHandler.addTagValue((String)"use_HTML", (boolean)this.useHTML));
        retval.append("      ").append(XMLHandler.addTagValue((String)"use_Priority", (boolean)this.usePriority));
        retval.append("      ").append(XMLHandler.addTagValue((String)"encoding", (String)this.encoding));
        retval.append("      ").append(XMLHandler.addTagValue((String)"priority", (String)this.priority));
        retval.append("      ").append(XMLHandler.addTagValue((String)"importance", (String)this.importance));
        retval.append("      ").append(XMLHandler.addTagValue((String)"secureconnectiontype", (String)this.secureConnectionType));
        retval.append("      ").append(XMLHandler.addTagValue((String)"replyToAddresses", (String)this.replyToAddresses));
        retval.append("      <filetypes>");
        if (this.fileType != null) {
            for (int i = 0; i < this.fileType.length; ++i) {
                retval.append("        ").append(XMLHandler.addTagValue((String)"filetype", (String)ResultFile.getTypeCode((int)this.fileType[i])));
            }
        }
        retval.append("      </filetypes>");
        return retval.toString();
    }

    public void allocate(int nrFileTypes) {
        this.fileType = new int[nrFileTypes];
    }

    @Override
    public void loadXML(Node entrynode, List<DatabaseMeta> databases, List<SlaveServer> slaveServers, Repository rep) throws KettleXMLException {
        try {
            super.loadXML(entrynode, databases, slaveServers);
            this.setServer(XMLHandler.getTagValue((Node)entrynode, (String)"server"));
            this.setPort(XMLHandler.getTagValue((Node)entrynode, (String)"port"));
            this.setDestination(XMLHandler.getTagValue((Node)entrynode, (String)"destination"));
            this.setDestinationCc(XMLHandler.getTagValue((Node)entrynode, (String)"destinationCc"));
            this.setDestinationBCc(XMLHandler.getTagValue((Node)entrynode, (String)"destinationBCc"));
            this.setReplyAddress(XMLHandler.getTagValue((Node)entrynode, (String)"replyto"));
            this.setReplyName(XMLHandler.getTagValue((Node)entrynode, (String)"replytoname"));
            this.setSubject(XMLHandler.getTagValue((Node)entrynode, (String)"subject"));
            this.setIncludeDate("Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"include_date")));
            this.setContactPerson(XMLHandler.getTagValue((Node)entrynode, (String)"contact_person"));
            this.setContactPhone(XMLHandler.getTagValue((Node)entrynode, (String)"contact_phone"));
            this.setComment(XMLHandler.getTagValue((Node)entrynode, (String)"comment"));
            this.setIncludingFiles("Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"include_files")));
            this.setUsingAuthentication("Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"use_auth")));
            this.setUsingSecureAuthentication("Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"use_secure_auth")));
            this.setAuthenticationUser(XMLHandler.getTagValue((Node)entrynode, (String)"auth_user"));
            this.setAuthenticationPassword(Encr.decryptPasswordOptionallyEncrypted((String)XMLHandler.getTagValue((Node)entrynode, (String)"auth_password")));
            this.setOnlySendComment("Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"only_comment")));
            this.setUseHTML("Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"use_HTML")));
            this.setUsePriority("Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"use_Priority")));
            this.setEncoding(XMLHandler.getTagValue((Node)entrynode, (String)"encoding"));
            this.setPriority(XMLHandler.getTagValue((Node)entrynode, (String)"priority"));
            this.setImportance(XMLHandler.getTagValue((Node)entrynode, (String)"importance"));
            this.setSecureConnectionType(XMLHandler.getTagValue((Node)entrynode, (String)"secureconnectiontype"));
            Node ftsnode = XMLHandler.getSubNode((Node)entrynode, (String)"filetypes");
            int nrTypes = XMLHandler.countNodes((Node)ftsnode, (String)"filetype");
            this.allocate(nrTypes);
            for (int i = 0; i < nrTypes; ++i) {
                Node ftnode = XMLHandler.getSubNodeByNr((Node)ftsnode, (String)"filetype", (int)i);
                this.fileType[i] = ResultFile.getType((String)XMLHandler.getNodeValue((Node)ftnode));
            }
            this.setZipFiles("Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"zip_files")));
            this.setZipFilename(XMLHandler.getTagValue((Node)entrynode, (String)"zip_name"));
            this.setReplyToAddresses(XMLHandler.getTagValue((Node)entrynode, (String)"replyToAddresses"));
        }
        catch (KettleException xe) {
            throw new KettleXMLException("Unable to load job entry of type 'mail' from XML node", (Throwable)xe);
        }
    }

    @Override
    public void loadRep(Repository rep, long id_jobentry, List<DatabaseMeta> databases, List<SlaveServer> slaveServers) throws KettleException {
        try {
            super.loadRep(rep, id_jobentry, databases, slaveServers);
            this.server = rep.getJobEntryAttributeString(id_jobentry, "server");
            this.port = rep.getJobEntryAttributeString(id_jobentry, "port");
            this.destination = rep.getJobEntryAttributeString(id_jobentry, "destination");
            this.destinationCc = rep.getJobEntryAttributeString(id_jobentry, "destinationCc");
            this.destinationBCc = rep.getJobEntryAttributeString(id_jobentry, "destinationBCc");
            this.replyAddress = rep.getJobEntryAttributeString(id_jobentry, "replyto");
            this.replyName = rep.getJobEntryAttributeString(id_jobentry, "replytoname");
            this.subject = rep.getJobEntryAttributeString(id_jobentry, "subject");
            this.includeDate = rep.getJobEntryAttributeBoolean(id_jobentry, "include_date");
            this.contactPerson = rep.getJobEntryAttributeString(id_jobentry, "contact_person");
            this.contactPhone = rep.getJobEntryAttributeString(id_jobentry, "contact_phone");
            this.comment = rep.getJobEntryAttributeString(id_jobentry, "comment");
            this.encoding = rep.getJobEntryAttributeString(id_jobentry, "encoding");
            this.priority = rep.getJobEntryAttributeString(id_jobentry, "priority");
            this.importance = rep.getJobEntryAttributeString(id_jobentry, "importance");
            this.includingFiles = rep.getJobEntryAttributeBoolean(id_jobentry, "include_files");
            this.usingAuthentication = rep.getJobEntryAttributeBoolean(id_jobentry, "use_auth");
            this.usingSecureAuthentication = rep.getJobEntryAttributeBoolean(id_jobentry, "use_secure_auth");
            this.authenticationUser = rep.getJobEntryAttributeString(id_jobentry, "auth_user");
            this.authenticationPassword = Encr.decryptPasswordOptionallyEncrypted((String)rep.getJobEntryAttributeString(id_jobentry, "auth_password"));
            this.onlySendComment = rep.getJobEntryAttributeBoolean(id_jobentry, "only_comment");
            this.useHTML = rep.getJobEntryAttributeBoolean(id_jobentry, "use_HTML");
            this.usePriority = rep.getJobEntryAttributeBoolean(id_jobentry, "use_Priority");
            this.secureConnectionType = rep.getJobEntryAttributeString(id_jobentry, "secureconnectiontype");
            int nrTypes = rep.countNrJobEntryAttributes(id_jobentry, "file_type");
            this.allocate(nrTypes);
            for (int i = 0; i < nrTypes; ++i) {
                String typeCode = rep.getJobEntryAttributeString(id_jobentry, i, "file_type");
                this.fileType[i] = ResultFile.getType((String)typeCode);
            }
            this.zipFiles = rep.getJobEntryAttributeBoolean(id_jobentry, "zip_files");
            this.zipFilename = rep.getJobEntryAttributeString(id_jobentry, "zip_name");
            this.replyToAddresses = rep.getJobEntryAttributeString(id_jobentry, "replyToAddresses");
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException("Unable to load job entry of type 'mail' from the repository with id_jobentry=" + id_jobentry, (Throwable)dbe);
        }
    }

    @Override
    public void saveRep(Repository rep, long id_job) throws KettleException {
        try {
            super.saveRep(rep, id_job);
            rep.saveJobEntryAttribute(id_job, this.getID(), "server", this.server);
            rep.saveJobEntryAttribute(id_job, this.getID(), "port", this.port);
            rep.saveJobEntryAttribute(id_job, this.getID(), "destination", this.destination);
            rep.saveJobEntryAttribute(id_job, this.getID(), "destinationCc", this.destinationCc);
            rep.saveJobEntryAttribute(id_job, this.getID(), "destinationBCc", this.destinationBCc);
            rep.saveJobEntryAttribute(id_job, this.getID(), "replyto", this.replyAddress);
            rep.saveJobEntryAttribute(id_job, this.getID(), "replytoname", this.replyName);
            rep.saveJobEntryAttribute(id_job, this.getID(), "subject", this.subject);
            rep.saveJobEntryAttribute(id_job, this.getID(), "include_date", this.includeDate);
            rep.saveJobEntryAttribute(id_job, this.getID(), "contact_person", this.contactPerson);
            rep.saveJobEntryAttribute(id_job, this.getID(), "contact_phone", this.contactPhone);
            rep.saveJobEntryAttribute(id_job, this.getID(), "comment", this.comment);
            rep.saveJobEntryAttribute(id_job, this.getID(), "encoding", this.encoding);
            rep.saveJobEntryAttribute(id_job, this.getID(), "priority", this.priority);
            rep.saveJobEntryAttribute(id_job, this.getID(), "importance", this.importance);
            rep.saveJobEntryAttribute(id_job, this.getID(), "include_files", this.includingFiles);
            rep.saveJobEntryAttribute(id_job, this.getID(), "use_auth", this.usingAuthentication);
            rep.saveJobEntryAttribute(id_job, this.getID(), "use_secure_auth", this.usingSecureAuthentication);
            rep.saveJobEntryAttribute(id_job, this.getID(), "auth_user", this.authenticationUser);
            rep.saveJobEntryAttribute(id_job, this.getID(), "auth_password", Encr.encryptPasswordIfNotUsingVariables((String)this.authenticationPassword));
            rep.saveJobEntryAttribute(id_job, this.getID(), "only_comment", this.onlySendComment);
            rep.saveJobEntryAttribute(id_job, this.getID(), "use_HTML", this.useHTML);
            rep.saveJobEntryAttribute(id_job, this.getID(), "use_Priority", this.usePriority);
            rep.saveJobEntryAttribute(id_job, this.getID(), "secureconnectiontype", this.secureConnectionType);
            if (this.fileType != null) {
                for (int i = 0; i < this.fileType.length; ++i) {
                    rep.saveJobEntryAttribute(id_job, this.getID(), (long)i, "file_type", ResultFile.getTypeCode((int)this.fileType[i]));
                }
            }
            rep.saveJobEntryAttribute(id_job, this.getID(), "zip_files", this.zipFiles);
            rep.saveJobEntryAttribute(id_job, this.getID(), "zip_name", this.zipFilename);
            rep.saveJobEntryAttribute(id_job, this.getID(), "replyToAddresses", this.replyToAddresses);
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException("Unable to save job entry of type 'mail' to the repository for id_job=" + id_job, (Throwable)dbe);
        }
    }

    public void setServer(String s) {
        this.server = s;
    }

    public String getServer() {
        return this.server;
    }

    public void setDestination(String dest) {
        this.destination = dest;
    }

    public void setDestinationCc(String destCc) {
        this.destinationCc = destCc;
    }

    public void setDestinationBCc(String destBCc) {
        this.destinationBCc = destBCc;
    }

    public String getDestination() {
        return this.destination;
    }

    public String getDestinationCc() {
        return this.destinationCc;
    }

    public String getDestinationBCc() {
        return this.destinationBCc;
    }

    public void setReplyAddress(String reply) {
        this.replyAddress = reply;
    }

    public String getReplyAddress() {
        return this.replyAddress;
    }

    public void setReplyName(String replyname) {
        this.replyName = replyname;
    }

    public String getReplyName() {
        return this.replyName;
    }

    public void setSubject(String subj) {
        this.subject = subj;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setIncludeDate(boolean incl) {
        this.includeDate = incl;
    }

    public boolean getIncludeDate() {
        return this.includeDate;
    }

    public void setContactPerson(String person) {
        this.contactPerson = person;
    }

    public String getContactPerson() {
        return this.contactPerson;
    }

    public void setContactPhone(String phone) {
        this.contactPhone = phone;
    }

    public String getContactPhone() {
        return this.contactPhone;
    }

    public void setComment(String comm) {
        this.comment = comm;
    }

    public String getComment() {
        return this.comment;
    }

    public int[] getFileType() {
        return this.fileType;
    }

    public void setFileType(int[] fileType) {
        this.fileType = fileType;
    }

    public boolean isIncludingFiles() {
        return this.includingFiles;
    }

    public void setIncludingFiles(boolean includeFiles) {
        this.includingFiles = includeFiles;
    }

    public String getZipFilename() {
        return this.zipFilename;
    }

    public void setZipFilename(String zipFilename) {
        this.zipFilename = zipFilename;
    }

    public boolean isZipFiles() {
        return this.zipFiles;
    }

    public void setZipFiles(boolean zipFiles) {
        this.zipFiles = zipFiles;
    }

    public String getAuthenticationPassword() {
        return this.authenticationPassword;
    }

    public void setAuthenticationPassword(String authenticationPassword) {
        this.authenticationPassword = authenticationPassword;
    }

    public String getAuthenticationUser() {
        return this.authenticationUser;
    }

    public void setAuthenticationUser(String authenticationUser) {
        this.authenticationUser = authenticationUser;
    }

    public boolean isUsingAuthentication() {
        return this.usingAuthentication;
    }

    public void setUsingAuthentication(boolean usingAuthentication) {
        this.usingAuthentication = usingAuthentication;
    }

    public boolean isOnlySendComment() {
        return this.onlySendComment;
    }

    public void setOnlySendComment(boolean onlySendComment) {
        this.onlySendComment = onlySendComment;
    }

    public boolean isUseHTML() {
        return this.useHTML;
    }

    public void setUseHTML(boolean useHTML) {
        this.useHTML = useHTML;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public String getSecureConnectionType() {
        return this.secureConnectionType;
    }

    public void setSecureConnectionType(String secureConnectionType) {
        this.secureConnectionType = secureConnectionType;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setReplyToAddresses(String replyToAddresses) {
        this.replyToAddresses = replyToAddresses;
    }

    public String getReplyToAddresses() {
        return this.replyToAddresses;
    }

    public void setUsePriority(boolean usePriority) {
        this.usePriority = usePriority;
    }

    public boolean isUsePriority() {
        return this.usePriority;
    }

    public String getPriority() {
        return this.priority;
    }

    public void setImportance(String importance) {
        this.importance = importance;
    }

    public String getImportance() {
        return this.importance;
    }

    public void setPriority(String priority) {
        this.priority = priority;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Result execute(Result result, int nr, Repository rep, Job parentJob) {
        block69: {
            log = LogWriter.getInstance();
            masterZipfile = null;
            props = new Properties();
            if (Const.isEmpty((String)this.server)) {
                log.logError(this.toString(), Messages.getString("JobMail.Error.HostNotSpecified"), new Object[0]);
                result.setNrErrors(1L);
                result.setResult(false);
                return result;
            }
            protocol = "smtp";
            if (this.usingSecureAuthentication) {
                if (this.secureConnectionType.equals("TLS")) {
                    props.put("mail.smtp.starttls.enable", "true");
                } else {
                    protocol = "smtps";
                    props.put("mail.smtps.quitwait", "false");
                }
            }
            props.put("mail." + protocol + ".host", this.environmentSubstitute(this.server));
            if (!Const.isEmpty((String)this.port)) {
                props.put("mail." + protocol + ".port", this.environmentSubstitute(this.port));
            }
            v0 = debug = log.getLogLevel() >= 5;
            if (debug) {
                props.put("mail.debug", "true");
            }
            if (this.usingAuthentication) {
                props.put("mail." + protocol + ".auth", "true");
            }
            session = Session.getInstance((Properties)props);
            session.setDebug(debug);
            try {
                try {
                    msg = new MimeMessage(session);
                    if (this.usePriority) {
                        priority_int = "1";
                        if (this.priority.equals("low")) {
                            priority_int = "3";
                        }
                        if (this.priority.equals("normal")) {
                            priority_int = "2";
                        }
                        msg.setHeader("X-Priority", priority_int);
                        msg.setHeader("Importance", this.importance);
                    }
                    if (Const.isEmpty((String)(sender_address = this.environmentSubstitute(this.replyAddress))) != false) throw new MessagingException(Messages.getString("JobMail.Error.ReplyEmailNotFilled"));
                    sender_name = this.environmentSubstitute(this.replyName);
                    if (!Const.isEmpty((String)sender_name)) {
                        sender_address = sender_name + '<' + sender_address + '>';
                    }
                    msg.setFrom((Address)new InternetAddress(sender_address));
                    reply_to_address = this.environmentSubstitute(this.replyToAddresses);
                    if (!Const.isEmpty((String)reply_to_address)) {
                        reply_Address_List = this.environmentSubstitute(reply_to_address).split(" ");
                        address = new InternetAddress[reply_Address_List.length];
                        for (i = 0; i < reply_Address_List.length; ++i) {
                            address[i] = new InternetAddress(reply_Address_List[i]);
                        }
                        msg.setReplyTo((Address[])address);
                    }
                    destinations = this.environmentSubstitute(this.destination).split(" ");
                    address = new InternetAddress[destinations.length];
                    for (i = 0; i < destinations.length; ++i) {
                        address[i] = new InternetAddress(destinations[i]);
                    }
                    msg.setRecipients(Message.RecipientType.TO, (Address[])address);
                    if (!Const.isEmpty((String)this.destinationCc)) {
                        destinationsCc = this.environmentSubstitute(this.destinationCc).split(" ");
                        addressCc = new InternetAddress[destinationsCc.length];
                        for (i = 0; i < destinationsCc.length; ++i) {
                            addressCc[i] = new InternetAddress(destinationsCc[i]);
                        }
                        msg.setRecipients(Message.RecipientType.CC, (Address[])addressCc);
                    }
                    if (!Const.isEmpty((String)this.destinationBCc)) {
                        destinationsBCc = this.environmentSubstitute(this.destinationBCc).split(" ");
                        addressBCc = new InternetAddress[destinationsBCc.length];
                        for (i = 0; i < destinationsBCc.length; ++i) {
                            addressBCc[i] = new InternetAddress(destinationsBCc[i]);
                        }
                        msg.setRecipients(Message.RecipientType.BCC, (Address[])addressBCc);
                    }
                    if (!Const.isEmpty((String)(realSubject = this.environmentSubstitute(this.subject)))) {
                        msg.setSubject(realSubject);
                    }
                    msg.setSentDate(new Date());
                    messageText = new StringBuffer();
                    if (this.comment != null) {
                        messageText.append(this.environmentSubstitute(this.comment)).append(Const.CR).append(Const.CR);
                    }
                    if (!this.onlySendComment) {
                        messageText.append(Messages.getString("JobMail.Log.Comment.Job")).append(Const.CR);
                        messageText.append("-----").append(Const.CR);
                        messageText.append(Messages.getString("JobMail.Log.Comment.JobName") + "    : ").append(parentJob.getJobMeta().getName()).append(Const.CR);
                        messageText.append(Messages.getString("JobMail.Log.Comment.JobDirectory") + "  : ").append(parentJob.getJobMeta().getDirectory()).append(Const.CR);
                        messageText.append(Messages.getString("JobMail.Log.Comment.JobEntry") + "   : ").append(this.getName()).append(Const.CR);
                        messageText.append(Const.CR);
                    }
                    if (this.includeDate) {
                        messageText.append(Const.CR).append(Messages.getString("JobMail.Log.Comment.MsgDate") + ": ").append(XMLHandler.date2string((Date)new Date())).append(Const.CR).append(Const.CR);
                    }
                    if (!this.onlySendComment && result != null) {
                        messageText.append(Messages.getString("JobMail.Log.Comment.PreviousResult") + ":").append(Const.CR);
                        messageText.append("-----------------").append(Const.CR);
                        messageText.append(Messages.getString("JobMail.Log.Comment.JobEntryNr") + "         : ").append(result.getEntryNr()).append(Const.CR);
                        messageText.append(Messages.getString("JobMail.Log.Comment.Errors") + "               : ").append(result.getNrErrors()).append(Const.CR);
                        messageText.append(Messages.getString("JobMail.Log.Comment.LinesRead") + "           : ").append(result.getNrLinesRead()).append(Const.CR);
                        messageText.append(Messages.getString("JobMail.Log.Comment.LinesWritten") + "        : ").append(result.getNrLinesWritten()).append(Const.CR);
                        messageText.append(Messages.getString("JobMail.Log.Comment.LinesInput") + "          : ").append(result.getNrLinesInput()).append(Const.CR);
                        messageText.append(Messages.getString("JobMail.Log.Comment.LinesOutput") + "         : ").append(result.getNrLinesOutput()).append(Const.CR);
                        messageText.append(Messages.getString("JobMail.Log.Comment.LinesUpdated") + "        : ").append(result.getNrLinesUpdated()).append(Const.CR);
                        messageText.append(Messages.getString("JobMail.Log.Comment.LinesRejected") + "       : ").append(result.getNrLinesRejected()).append(Const.CR);
                        messageText.append(Messages.getString("JobMail.Log.Comment.Status") + "  : ").append(result.getExitStatus()).append(Const.CR);
                        messageText.append(Messages.getString("JobMail.Log.Comment.Result") + "               : ").append(result.getResult()).append(Const.CR);
                        messageText.append(Const.CR);
                    }
                    if (!(this.onlySendComment || Const.isEmpty((String)this.environmentSubstitute(this.contactPerson)) && Const.isEmpty((String)this.environmentSubstitute(this.contactPhone)))) {
                        messageText.append(Messages.getString("JobMail.Log.Comment.ContactInfo") + " :").append(Const.CR);
                        messageText.append("---------------------").append(Const.CR);
                        messageText.append(Messages.getString("JobMail.Log.Comment.PersonToContact") + " : ").append(this.environmentSubstitute(this.contactPerson)).append(Const.CR);
                        messageText.append(Messages.getString("JobMail.Log.Comment.Tel") + "  : ").append(this.environmentSubstitute(this.contactPhone)).append(Const.CR);
                        messageText.append(Const.CR);
                    }
                    if (!this.onlySendComment && (jobTracker = parentJob.getJobTracker()) != null) {
                        messageText.append(Messages.getString("JobMail.Log.Comment.PathToJobentry") + ":").append(Const.CR);
                        messageText.append("------------------------").append(Const.CR);
                        this.addBacktracking(jobTracker, messageText);
                    }
                    parts = new MimeMultipart();
                    part1 = new MimeBodyPart();
                    if (this.useHTML) {
                        if (!Const.isEmpty((String)this.getEncoding())) {
                            part1.setContent((Object)messageText.toString(), "text/html; charset=" + this.getEncoding());
                        } else {
                            part1.setContent((Object)messageText.toString(), "text/html; charset=ISO-8859-1");
                        }
                    } else {
                        part1.setText(messageText.toString());
                    }
                    parts.addBodyPart((BodyPart)part1);
                    if (this.includingFiles && result != null && (resultFiles = result.getResultFilesList()) != null && !resultFiles.isEmpty()) {
                        block70: {
                            if (!this.zipFiles) {
                                i$ = resultFiles.iterator();
                                break block69;
                            }
                            masterZipfile = new File(System.getProperty("java.io.tmpdir") + Const.FILE_SEPARATOR + this.environmentSubstitute(this.zipFilename));
                            zipOutputStream = null;
                            try {
                                try {
                                    zipOutputStream = new ZipOutputStream(new FileOutputStream(masterZipfile));
                                    for (ResultFile resultFile : resultFiles) {
                                        found = false;
                                        for (i = 0; i < this.fileType.length; ++i) {
                                            if (this.fileType[i] != resultFile.getType()) continue;
                                            found = true;
                                        }
                                        if (!found) continue;
                                        file = resultFile.getFile();
                                        zipEntry = new ZipEntry(file.getName().getBaseName());
                                        zipOutputStream.putNextEntry(zipEntry);
                                        inputStream = new BufferedInputStream(KettleVFS.getInputStream((FileObject)file));
                                        while ((c = inputStream.read()) >= 0) {
                                            zipOutputStream.write(c);
                                        }
                                        inputStream.close();
                                        zipOutputStream.closeEntry();
                                        log.logBasic(this.toString(), "Added file '" + file.getName().getURI() + "' to the mail message in a zip archive.", new Object[0]);
                                    }
                                    var30_53 = null;
                                    if (zipOutputStream == null) break block70;
                                }
                                catch (Exception e) {
                                    log.logError(this.toString(), "Error zipping attachement files into file [" + masterZipfile.getPath() + "] : " + e.toString(), new Object[0]);
                                    log.logError(this.toString(), Const.getStackTracker((Throwable)e), new Object[0]);
                                    result.setNrErrors(1L);
                                    var30_54 = null;
                                    if (zipOutputStream != null) {
                                        try {
                                            zipOutputStream.finish();
                                            zipOutputStream.close();
                                        }
                                        catch (IOException e) {
                                            log.logError(this.toString(), "Unable to close attachement zip file archive : " + e.toString(), new Object[0]);
                                            log.logError(this.toString(), Const.getStackTracker((Throwable)e), new Object[0]);
                                            result.setNrErrors(1L);
                                        }
                                    }
                                    break block70;
                                }
                            }
                            catch (Throwable var29_59) {
                                var30_55 = null;
                                if (zipOutputStream == null) throw var29_59;
                                ** try [egrp 4[TRYBLOCK] [4 : 2562->2575)] { 
lbl205:
                                // 1 sources

                                zipOutputStream.finish();
                                zipOutputStream.close();
                                throw var29_59;
lbl208:
                                // 1 sources

                                catch (IOException e) {
                                    log.logError(this.toString(), "Unable to close attachement zip file archive : " + e.toString(), new Object[0]);
                                    log.logError(this.toString(), Const.getStackTracker((Throwable)e), new Object[0]);
                                    result.setNrErrors(1L);
                                }
                                throw var29_59;
                            }
                            ** try [egrp 4[TRYBLOCK] [4 : 2562->2575)] { 
lbl215:
                            // 1 sources

                            zipOutputStream.finish();
                            zipOutputStream.close();
lbl218:
                            // 1 sources

                            catch (IOException e) {
                                log.logError(this.toString(), "Unable to close attachement zip file archive : " + e.toString(), new Object[0]);
                                log.logError(this.toString(), Const.getStackTracker((Throwable)e), new Object[0]);
                                result.setNrErrors(1L);
                            }
                        }
                        if (result.getNrErrors() == 0L) {
                            files = new MimeBodyPart();
                            fds = new FileDataSource(masterZipfile);
                            files.setDataHandler(new DataHandler((DataSource)fds));
                            files.setFileName(fds.getName());
                            parts.addBodyPart((BodyPart)files);
                        }
                    }
                    while (true) {
                        block73: {
                            msg.setContent((Multipart)parts);
                            transport = null;
                            try {
                                transport = session.getTransport(protocol);
                                if (this.usingAuthentication) {
                                    if (!Const.isEmpty((String)this.port)) {
                                        transport.connect(this.environmentSubstitute(Const.NVL((String)this.server, (String)"")), Integer.parseInt(this.environmentSubstitute(Const.NVL((String)this.port, (String)""))), this.environmentSubstitute(Const.NVL((String)this.authenticationUser, (String)"")), this.environmentSubstitute(Const.NVL((String)this.authenticationPassword, (String)"")));
                                    } else {
                                        transport.connect(this.environmentSubstitute(Const.NVL((String)this.server, (String)"")), this.environmentSubstitute(Const.NVL((String)this.authenticationUser, (String)"")), this.environmentSubstitute(Const.NVL((String)this.authenticationPassword, (String)"")));
                                    }
                                } else {
                                    transport.connect();
                                }
                                transport.sendMessage((Message)msg, msg.getAllRecipients());
                                var33_60 = null;
                                if (transport == null) break block73;
                            }
                            catch (Throwable var32_62) {
                                var33_61 = null;
                                if (transport == null) throw var32_62;
                                transport.close();
                                throw var32_62;
                            }
                            transport.close();
                        }
                        var35_63 = null;
                        if (masterZipfile != null && masterZipfile.exists()) {
                            masterZipfile.delete();
                        }
                        break;
                    }
                }
                catch (IOException e) {
                    log.logError(this.toString(), "Problem while sending message: " + e.toString(), new Object[0]);
                    result.setNrErrors(1L);
                    var35_64 = null;
                    if (masterZipfile != null && masterZipfile.exists()) {
                        masterZipfile.delete();
                    }
                }
                catch (MessagingException mex) {
                    log.logError(this.toString(), "Problem while sending message: " + mex.toString(), new Object[0]);
                    result.setNrErrors(1L);
                    ex = mex;
                    do {
                        if (!(ex instanceof SendFailedException)) continue;
                        sfex = (SendFailedException)ex;
                        invalid = sfex.getInvalidAddresses();
                        if (invalid != null) {
                            log.logError(this.toString(), "    ** Invalid Addresses", new Object[0]);
                            for (i = 0; i < invalid.length; ++i) {
                                log.logError(this.toString(), "         " + invalid[i], new Object[0]);
                                result.setNrErrors(1L);
                            }
                        }
                        if ((validUnsent = sfex.getValidUnsentAddresses()) != null) {
                            log.logError(this.toString(), "    ** ValidUnsent Addresses", new Object[0]);
                            for (i = 0; i < validUnsent.length; ++i) {
                                log.logError(this.toString(), "         " + validUnsent[i], new Object[0]);
                                result.setNrErrors(1L);
                            }
                        }
                        if ((validSent = sfex.getValidSentAddresses()) == null) continue;
                        for (i = 0; i < validSent.length; ++i) {
                            log.logError(this.toString(), "         " + validSent[i], new Object[0]);
                            result.setNrErrors(1L);
                        }
                    } while ((ex = ex instanceof MessagingException != false ? ex.getNextException() : null) != null);
                    var35_65 = null;
                    if (masterZipfile != null && masterZipfile.exists()) {
                        masterZipfile.delete();
                    }
                }
            }
            catch (Throwable var34_67) {
                var35_66 = null;
                if (masterZipfile == null) throw var34_67;
                if (masterZipfile.exists() == false) throw var34_67;
                masterZipfile.delete();
                throw var34_67;
            }
            if (result.getNrErrors() > 0L) {
                result.setResult(false);
                return result;
            }
            result.setResult(true);
            return result;
        }
        while (true) {
            if (!i$.hasNext()) ** continue;
            resultFile = (ResultFile)i$.next();
            file = resultFile.getFile();
            if (file == null || !file.exists()) ** continue;
            found = false;
            for (i = 0; i < this.fileType.length; ++i) {
                if (this.fileType[i] != resultFile.getType()) continue;
                found = true;
            }
            if (!found) ** continue;
            files = new MimeBodyPart();
            fds = new URLDataSource(file.getURL());
            files.setDataHandler(new DataHandler((DataSource)fds));
            files.setFileName(file.getName().getBaseName());
            parts.addBodyPart((BodyPart)files);
            log.logBasic(this.toString(), "Added file '" + fds.getName() + "' to the mail message.", new Object[0]);
        }
    }

    private void addBacktracking(JobTracker jobTracker, StringBuffer messageText) {
        this.addBacktracking(jobTracker, messageText, 0);
    }

    private void addBacktracking(JobTracker jobTracker, StringBuffer messageText, int level) {
        int nr = jobTracker.nrJobTrackers();
        messageText.append(Const.rightPad((String)" ", (int)(level * 2)));
        messageText.append(Const.NVL((String)jobTracker.getJobName(), (String)"-"));
        JobEntryResult jer = jobTracker.getJobEntryResult();
        if (jer != null) {
            messageText.append(" : ");
            if (jer.getJobEntry() != null && jer.getJobEntry().getName() != null) {
                messageText.append(" : ");
                messageText.append(jer.getJobEntry().getName());
            }
            if (jer.getResult() != null) {
                messageText.append(" : ");
                messageText.append("[" + jer.getResult().toString() + "]");
            }
            if (jer.getReason() != null) {
                messageText.append(" : ");
                messageText.append(jer.getReason());
            }
            if (jer.getComment() != null) {
                messageText.append(" : ");
                messageText.append(jer.getComment());
            }
            if (jer.getLogDate() != null) {
                messageText.append(" (");
                messageText.append(XMLHandler.date2string((Date)jer.getLogDate()));
                messageText.append(')');
            }
        }
        messageText.append(Const.CR);
        for (int i = 0; i < nr; ++i) {
            JobTracker jt = jobTracker.getJobTracker(i);
            this.addBacktracking(jt, messageText, level + 1);
        }
    }

    @Override
    public boolean evaluates() {
        return true;
    }

    @Override
    public boolean isUnconditional() {
        return true;
    }

    public boolean isUsingSecureAuthentication() {
        return this.usingSecureAuthentication;
    }

    public void setUsingSecureAuthentication(boolean usingSecureAuthentication) {
        this.usingSecureAuthentication = usingSecureAuthentication;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    @Override
    public List<ResourceReference> getResourceDependencies(JobMeta jobMeta) {
        List<ResourceReference> references = super.getResourceDependencies(jobMeta);
        String realServername = jobMeta.environmentSubstitute(this.server);
        ResourceReference reference = new ResourceReference(this);
        reference.getEntries().add(new ResourceEntry(realServername, ResourceEntry.ResourceType.SERVER));
        references.add(reference);
        return references;
    }

    @Override
    public void check(List<CheckResultInterface> remarks, JobMeta jobMeta) {
        JobEntryValidatorUtils.andValidator().validate(this, "server", remarks, AndValidator.putValidators(JobEntryValidatorUtils.notBlankValidator()));
        JobEntryValidatorUtils.andValidator().validate(this, "replyAddress", remarks, AndValidator.putValidators(JobEntryValidatorUtils.notBlankValidator(), JobEntryValidatorUtils.emailValidator()));
        JobEntryValidatorUtils.andValidator().validate(this, "destination", remarks, AndValidator.putValidators(JobEntryValidatorUtils.notBlankValidator()));
        if (this.usingAuthentication) {
            JobEntryValidatorUtils.andValidator().validate(this, "authenticationUser", remarks, AndValidator.putValidators(JobEntryValidatorUtils.notBlankValidator()));
            JobEntryValidatorUtils.andValidator().validate(this, "authenticationPassword", remarks, AndValidator.putValidators(JobEntryValidatorUtils.notNullValidator()));
        }
        JobEntryValidatorUtils.andValidator().validate(this, "port", remarks, AndValidator.putValidators(JobEntryValidatorUtils.integerValidator()));
    }
}

