/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.impl.synccontext.named;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.SyncContext;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.internal.impl.synccontext.named.NameMapper;
import org.eclipse.aether.metadata.Metadata;
import org.eclipse.aether.named.NamedLock;
import org.eclipse.aether.named.NamedLockFactory;
import org.eclipse.aether.named.support.FileSystemFriendly;
import org.eclipse.aether.util.ConfigUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NamedLockFactoryAdapter {
    public static final String TIME_KEY = "aether.syncContext.named.time";
    public static final long DEFAULT_TIME = 30L;
    public static final String TIME_UNIT_KEY = "aether.syncContext.named.time.unit";
    public static final TimeUnit DEFAULT_TIME_UNIT = TimeUnit.SECONDS;
    private final NameMapper nameMapper;
    private final NamedLockFactory namedLockFactory;

    public NamedLockFactoryAdapter(NameMapper nameMapper, NamedLockFactory namedLockFactory) {
        this.nameMapper = Objects.requireNonNull(nameMapper);
        this.namedLockFactory = Objects.requireNonNull(namedLockFactory);
        if (this.namedLockFactory instanceof FileSystemFriendly && !(this.nameMapper instanceof FileSystemFriendly)) {
            throw new IllegalArgumentException("Misconfiguration: FS friendly lock factory requires FS friendly name mapper");
        }
    }

    public SyncContext newInstance(RepositorySystemSession session2, boolean shared2) {
        return new AdaptedLockSyncContext(session2, shared2, this.nameMapper, this.namedLockFactory);
    }

    public void shutdown() {
        this.namedLockFactory.shutdown();
    }

    private static class AdaptedLockSyncContext
    implements SyncContext {
        private static final Logger LOGGER = LoggerFactory.getLogger(AdaptedLockSyncContext.class);
        private final RepositorySystemSession session;
        private final boolean shared;
        private final NameMapper lockNaming;
        private final NamedLockFactory namedLockFactory;
        private final long time;
        private final TimeUnit timeUnit;
        private final Deque<NamedLock> locks;

        private AdaptedLockSyncContext(RepositorySystemSession session2, boolean shared2, NameMapper lockNaming, NamedLockFactory namedLockFactory) {
            this.session = session2;
            this.shared = shared2;
            this.lockNaming = lockNaming;
            this.namedLockFactory = namedLockFactory;
            this.time = this.getTime(session2);
            this.timeUnit = this.getTimeUnit(session2);
            this.locks = new ArrayDeque<NamedLock>();
            if (this.time < 0L) {
                throw new IllegalArgumentException("time cannot be negative");
            }
        }

        private long getTime(RepositorySystemSession session2) {
            return ConfigUtils.getLong(session2, 30L, NamedLockFactoryAdapter.TIME_KEY);
        }

        private TimeUnit getTimeUnit(RepositorySystemSession session2) {
            return TimeUnit.valueOf(ConfigUtils.getString(session2, DEFAULT_TIME_UNIT.name(), NamedLockFactoryAdapter.TIME_UNIT_KEY));
        }

        @Override
        public void acquire(Collection<? extends Artifact> artifacts, Collection<? extends Metadata> metadatas) {
            Collection<String> keys2 = this.lockNaming.nameLocks(this.session, artifacts, metadatas);
            if (keys2.isEmpty()) {
                return;
            }
            LOGGER.trace("Need {} {} lock(s) for {}", keys2.size(), this.shared ? "read" : "write", keys2);
            int acquiredLockCount = 0;
            for (String key2 : keys2) {
                NamedLock namedLock = this.namedLockFactory.getLock(key2);
                try {
                    LOGGER.trace("Acquiring {} lock for '{}'", (Object)(this.shared ? "read" : "write"), (Object)key2);
                    boolean locked = this.shared ? namedLock.lockShared(this.time, this.timeUnit) : namedLock.lockExclusively(this.time, this.timeUnit);
                    if (!locked) {
                        LOGGER.trace("Failed to acquire {} lock for '{}'", (Object)(this.shared ? "read" : "write"), (Object)key2);
                        namedLock.close();
                        throw new IllegalStateException("Could not acquire " + (this.shared ? "read" : "write") + " lock for '" + namedLock.name() + "'");
                    }
                    this.locks.push(namedLock);
                    ++acquiredLockCount;
                }
                catch (InterruptedException e2) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException(e2);
                }
            }
            LOGGER.trace("Total locks acquired: {}", (Object)acquiredLockCount);
        }

        @Override
        public void close() {
            if (this.locks.isEmpty()) {
                return;
            }
            int released = 0;
            while (!this.locks.isEmpty()) {
                NamedLock namedLock = this.locks.pop();
                Throwable throwable = null;
                try {
                    LOGGER.trace("Releasing {} lock for '{}'", (Object)(this.shared ? "read" : "write"), (Object)namedLock.name());
                    namedLock.unlock();
                    ++released;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (namedLock == null) continue;
                    if (throwable != null) {
                        try {
                            namedLock.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    namedLock.close();
                }
            }
            LOGGER.trace("Total locks released: {}", (Object)released);
        }
    }
}

