/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import javax.xml.stream.XMLStreamException;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Nation;
import net.sf.freecol.common.model.NationOptions;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.networking.AttributeMessage;
import net.sf.freecol.common.networking.ChangeSet;
import net.sf.freecol.common.networking.Message;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.model.ServerGame;
import net.sf.freecol.server.model.ServerPlayer;

public class SetAvailableMessage
extends AttributeMessage {
    public static final String TAG = "setAvailable";
    private static final String NATION_TAG = "nation";
    private static final String STATE_TAG = "state";

    public SetAvailableMessage(Nation nation, NationOptions.NationState state) {
        super(TAG, NATION_TAG, nation.getId(), STATE_TAG, state.toString());
    }

    public SetAvailableMessage(Game game, FreeColXMLReader xr) throws XMLStreamException {
        super(TAG, xr, NATION_TAG, STATE_TAG);
    }

    @Override
    public Message.MessagePriority getPriority() {
        return Message.MessagePriority.NORMAL;
    }

    @Override
    public void clientHandler(FreeColClient freeColClient) {
        Game game = freeColClient.getGame();
        Specification spec = game.getSpecification();
        Nation nation = this.getNation(spec);
        NationOptions.NationState nationState = this.getNationState();
        this.pgc(freeColClient).setAvailableHandler(nation, nationState);
    }

    @Override
    public ChangeSet serverHandler(FreeColServer freeColServer, ServerPlayer serverPlayer) {
        if (serverPlayer == null) {
            logger.warning("setAvailable from unknown player");
        }
        ServerGame game = freeColServer.getGame();
        Specification spec = game.getSpecification();
        Nation nation = this.getNation(spec);
        NationOptions.NationState state = this.getNationState();
        return this.pgc(freeColServer).setAvailable(serverPlayer, nation, state);
    }

    public Nation getNation(Specification spec) {
        return spec.getNation(this.getStringAttribute(NATION_TAG));
    }

    public NationOptions.NationState getNationState() {
        return Enum.valueOf(NationOptions.NationState.class, this.getStringAttribute(STATE_TAG));
    }
}

