/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.search.ui;

import java.awt.FlowLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import org.netbeans.api.annotations.common.NullUnknown;
import org.netbeans.api.search.SearchScopeOptions;
import org.netbeans.api.search.ui.ComponentController;
import org.netbeans.api.search.ui.FileNameController;
import org.netbeans.modules.search.BasicSearchProvider;
import org.netbeans.modules.search.IgnoreListPanel;
import org.netbeans.modules.search.PatternSandbox;
import org.netbeans.modules.search.ui.CheckBoxWithButtonPanel;
import org.netbeans.modules.search.ui.FormLayoutHelper;
import org.netbeans.modules.search.ui.UiUtils;

public final class ScopeOptionsController
extends ComponentController<JPanel> {
    private FileNameController fileNameComboBox;
    private boolean replacing;
    protected JPanel ignoreListOptionPanel;
    private JButton btnEditIgnoreList;
    protected JCheckBox chkUseIgnoreList;
    private JCheckBox chkFileNameRegex;
    private JButton btnTestFileNamePattern;
    private JCheckBox chkArchives;
    private JCheckBox chkGenerated;
    private ItemListener checkBoxListener;
    private JPanel fileNameComponent;

    ScopeOptionsController(JPanel jPanel, FileNameController fileNameController, boolean bl) {
        this(jPanel, null, fileNameController, bl);
    }

    ScopeOptionsController(JPanel jPanel, JPanel jPanel2, FileNameController fileNameController, boolean bl) {
        super(jPanel);
        this.fileNameComponent = jPanel2;
        this.fileNameComboBox = fileNameController;
        this.replacing = bl;
        this.init();
    }

    public SearchScopeOptions getSearchScopeOptions() {
        SearchScopeOptions searchScopeOptions = SearchScopeOptions.create();
        if (this.fileNameComboBox != null) {
            searchScopeOptions.setPattern(this.fileNameComboBox.getFileNamePattern());
        }
        searchScopeOptions.setRegexp(this.isFileNameRegExp());
        searchScopeOptions.setSearchInArchives(this.isSearchInArchives());
        searchScopeOptions.setSearchInGenerated(this.isSearchInGenerated());
        if (this.isUseIgnoreList()) {
            searchScopeOptions.addFilter(BasicSearchProvider.getIgnoreListFilter());
        }
        return searchScopeOptions;
    }

    private void init() {
        this.btnTestFileNamePattern = new JButton();
        this.chkFileNameRegex = new JCheckBox();
        this.chkFileNameRegex.setToolTipText(UiUtils.getText("BasicSearchForm.chkFileNameRegex.tooltip"));
        if (!this.replacing) {
            this.chkArchives = new JCheckBox();
            this.chkGenerated = new JCheckBox();
        }
        this.chkUseIgnoreList = new JCheckBox();
        this.btnEditIgnoreList = new JButton();
        this.checkBoxListener = new CheckBoxListener();
        ((JPanel)this.component).setLayout(new FlowLayout(3, 0, 0));
        this.setMnemonics();
        this.initIgnoreListControlComponents();
        this.initScopeOptionsRow(this.replacing);
        this.initInteraction();
    }

    private void initIgnoreListControlComponents() {
        this.ignoreListOptionPanel = new CheckBoxWithButtonPanel(this.chkUseIgnoreList, this.btnEditIgnoreList);
    }

    private void initScopeOptionsRow(boolean bl) {
        CheckBoxWithButtonPanel checkBoxWithButtonPanel = new CheckBoxWithButtonPanel(this.chkFileNameRegex, this.btnTestFileNamePattern);
        if (this.fileNameComponent != null) {
            this.fileNameComponent.setLayout(new FlowLayout(3, 0, 0));
            this.fileNameComponent.add(this.ignoreListOptionPanel);
            this.fileNameComponent.add(checkBoxWithButtonPanel);
            if (!bl) {
                ((JPanel)this.component).add(this.chkArchives);
                ((JPanel)this.component).add(this.chkGenerated);
            }
        } else {
            JPanel jPanel = new JPanel();
            if (bl) {
                jPanel.setLayout(new FlowLayout(3, 0, 0));
                jPanel.add(this.ignoreListOptionPanel);
                jPanel.add(checkBoxWithButtonPanel);
                jPanel.setMaximumSize(jPanel.getMinimumSize());
            } else {
                FormLayoutHelper formLayoutHelper = new FormLayoutHelper(jPanel, FormLayoutHelper.DEFAULT_COLUMN, FormLayoutHelper.DEFAULT_COLUMN);
                formLayoutHelper.addRow(this.chkArchives, this.chkGenerated);
                formLayoutHelper.addRow(this.ignoreListOptionPanel, new CheckBoxWithButtonPanel(this.chkFileNameRegex, this.btnTestFileNamePattern));
                jPanel.setMaximumSize(jPanel.getMinimumSize());
            }
            ((JPanel)this.component).add(jPanel);
        }
    }

    private void initInteraction() {
        this.btnTestFileNamePattern.addActionListener(actionEvent -> this.openPathPatternSandbox());
        this.btnEditIgnoreList.addActionListener(actionEvent -> IgnoreListPanel.openDialog(this.btnEditIgnoreList));
        if (!this.replacing) {
            this.chkArchives.addItemListener(this.checkBoxListener);
            this.chkGenerated.addItemListener(this.checkBoxListener);
        }
        this.chkUseIgnoreList.addItemListener(this.checkBoxListener);
        if (this.fileNameComboBox != null) {
            this.chkFileNameRegex.addActionListener(actionEvent -> this.fileNameComboBox.setRegularExpression(this.chkFileNameRegex.isSelected()));
        } else {
            this.chkFileNameRegex.addItemListener(this.checkBoxListener);
        }
    }

    private void openPathPatternSandbox() {
        PatternSandbox.openDialog(new PatternSandbox.PathPatternSandbox(((JComboBox)this.fileNameComboBox.getComponent()).getSelectedItem() == null ? "" : this.fileNameComboBox.getFileNamePattern()){

            @Override
            protected void onApply(String string) {
                if (string.isEmpty()) {
                    if (!ScopeOptionsController.this.fileNameComboBox.isAllFilesInfoDisplayed()) {
                        ((JComboBox)ScopeOptionsController.this.fileNameComboBox.getComponent()).setSelectedItem(string);
                        ScopeOptionsController.this.fileNameComboBox.displayAllFilesInfo();
                    }
                } else {
                    if (ScopeOptionsController.this.fileNameComboBox.isAllFilesInfoDisplayed()) {
                        ScopeOptionsController.this.fileNameComboBox.hideAllFilesInfo();
                    }
                    ((JComboBox)ScopeOptionsController.this.fileNameComboBox.getComponent()).setSelectedItem(string);
                }
            }
        }, this.btnTestFileNamePattern);
    }

    private void setMnemonics() {
        UiUtils.lclz(this.chkFileNameRegex, "BasicSearchForm.chkFileNameRegex.text");
        this.btnTestFileNamePattern.setText(UiUtils.getHtmlLink("BasicSearchForm.btnTestFileNamePattern.text"));
        this.btnEditIgnoreList.setText(UiUtils.getHtmlLink("BasicSearchForm.btnEditIgnoreList.text"));
        UiUtils.lclz(this.chkUseIgnoreList, "BasicSearchForm.chkUseIgnoreList.text");
        if (!this.replacing) {
            UiUtils.lclz(this.chkArchives, "BasicSearchForm.chkArchives.text");
            UiUtils.lclz(this.chkGenerated, "BasicSearchForm.chkGenerated.text");
        }
    }

    public boolean isSearchInArchives() {
        return this.isOn(this.chkArchives);
    }

    public boolean isSearchInGenerated() {
        return this.isOn(this.chkGenerated);
    }

    public boolean isUseIgnoreList() {
        return this.isOn(this.chkUseIgnoreList);
    }

    public boolean isFileNameRegExp() {
        return this.isOn(this.chkFileNameRegex);
    }

    private boolean isOn(JCheckBox jCheckBox) {
        return jCheckBox != null && jCheckBox.isEnabled() && jCheckBox.isSelected();
    }

    public void setSearchInArchives(boolean bl) {
        if (this.chkArchives == null) {
            if (bl) {
                throw new IllegalArgumentException("Searching in archives not allowed when replacing");
            }
        } else {
            this.chkArchives.setSelected(bl);
        }
    }

    public void setSearchInGenerated(boolean bl) {
        if (this.chkGenerated == null) {
            if (bl) {
                throw new IllegalArgumentException("Searching in generated sources not allowed when replacing");
            }
        } else {
            this.chkGenerated.setSelected(bl);
        }
    }

    public void setUseIgnoreList(boolean bl) {
        this.chkUseIgnoreList.setSelected(bl);
    }

    public void setFileNameRegexp(boolean bl) {
        this.chkFileNameRegex.setSelected(bl);
    }

    @NullUnknown
    public JPanel getFileNameComponent() {
        return this.fileNameComponent;
    }

    private final class CheckBoxListener
    implements ItemListener {
        private CheckBoxListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            ScopeOptionsController.this.fireChange();
        }
    }
}

