#include "shapes.inc"

#ifndef (Length)	#declare Length = 5 #end	// Approx. length of strand
#ifndef (NumSegs)	#declare NumSegs = 30  #end  // Number of segments to use
#ifndef (Radius)	#declare Radius = 0.05  #end	// Radius of strand

#declare Start = <0, 0, 0>	// Starting point
#ifndef (XY_Angle)	#declare XY_Angle = 130 #end

#ifndef (Flex)		#declare Flex = 0.075 #end 	// Degree of flexibility (0-1)

#declare SegLength = Length/NumSegs
#declare Sign = 1

#declare Ball = 1

union
{
#declare Loop = 0
#while (Loop < NumSegs)
	#declare End = Start + <SegLength * cos(radians(XY_Angle - 90)),
				SegLength * sin(radians(XY_Angle - 90)),
				0>
	#declare Temp = XY_Angle / 2
	#if ( (XY_Angle - Temp) > 0 ) #declare Sign = 1
	#else #declare Sign = -1
	#end
	//#debug concat("XY_Angle: ", str(XY_Angle, 0, 1), " Temp: ",
	//	str(Temp, 0, 1)," Sign: ", str(Sign, 0, 1), " MaxFlex: ",
	//	str(Flex * 180, 0, 1)," \n")
	#if ( abs(XY_Angle - Temp) > (Flex * 180))
		#declare XY_Angle = XY_Angle - (Sign * Flex * 180)
		//#debug "abs(XY_Angle - Temp) > (Flex * 180)\n"
	#else	#declare XY_Angle = Temp
		//#debug "XY_Angle = Temp\n"
	#end

	cylinder { Start, End, Radius }
	#ifdef (Ball) sphere { End, Radius } #end

	#declare Start = End
	#declare Loop = Loop + 1
#end
}
