//               Thank you for looking at my source code.

// All work is new and origional. The animation was created in PovRay
// for Windows. It was compiled to an MPEG format with CMPEG. 
// All work was done for the first round in the IRTC Animation 
// Competition. 

// I have dabbled in POV for a while but this is my first entry in the
// IRTC. I am a student of Computer Science at the University of Victoria
// with an interest in Computer Graphics. I am also an Improvisational
// Actor, a juggler, unicyclist, a clown, and a competative chess player.

//                             Enough talk.

// Here's how it works. A clock variable goes from 0 to the total number of sequences 
// There is a SWITCH CASE statement for each of the clock variables. A variable called
// "Current_Clock" is set to "Clock - Sequence#" so CurrentClock will run from 0-1 as
// expected.
//
//  THIS ALLOWS ME TO USE ONE FILE TO COMPILE AND CHANGE DISPLAY SETTINGS TO
//  The Range may be extended or contracted to make sequences faster or slower.
//
//  NOTE: The first set of values are the default values: 
//        they are used for reference and debugging. 
//        The Switch Statement follows the default values. 
//
//
// Use these standard command line settings to create an animation
// Initial_Clock=0 Final_Clock=26 initial_frame=0 final_frame=1000 Output_File_Name=frog.tga
// It is possible to make 3,000 frames that will compress to 3 megs 
// but it makes the animation too slow

// These set of values are the defaults. 
#declare eye_height = 1     // Height of the eyes
#declare eye_rotation = 0   // 0 = closed
#declare eye_rotation = 90  // 90 = open
#declare eye_endx = 0       // Eyeball tranlate for ending
#declare eye_endy = 0       // Eyeball tranlate for ending
#declare tongue_x = 0       // Tongue tranlate for ending
#declare tongue_y = 0       // Tongue tranlate for ending
#declare tongue_z = 0.1     // Tongue tranlate for ending

#declare camera_rotation = 0
#declare tail_length = 2
#declare MouthAppear = 1    // 0.85 is visible
#declare PondOn=1           // Show the pond boolean

#declare b4camera_tx =0     // Before rotating
#declare b4camera_ty =0
#declare b4camera_tz = 0

#declare aftercamera_tx =0  // After Rotating
#declare aftercamera_ty =0
#declare aftercamera_tz = 0

///////////////////////////////////////////////////
//              Frog Declarations                //
///////////////////////////////////////////////////

#declare hip_thickness = 0.4   
#declare knee_thickness = 0.2
#declare thigh_length = 1.5
#declare shin_length = -1.75
#declare foot_length = -0.5 
#declare fleg_length = -1   

#declare hip_rx = 0            // Hip rotations
#declare hip_ry = 0
#declare hip_rz = 20
#declare hip_tx =-0.85
#declare hip_ty =-0.5
#declare hip_tz =0.5

#declare knee_rx = 20            // Knee rotations
#declare knee_ry = 45
#declare knee_rz = 0
#declare knee_tx =0
#declare knee_ty =1.5
#declare knee_tz =0

#declare foot_rx = 90            // Foot rotations
#declare foot_ry = 0
#declare foot_rz = 0
#declare foot_tx =0
#declare foot_ty =shin_length
#declare foot_tz =0

#declare fleg_rx = 0            // Foot rotations
#declare fleg_ry = 0
#declare fleg_rz = 0
#declare fleg_tx =1
#declare fleg_ty =0
#declare fleg_tz =-0.1

#switch (clock)
///////////////////////////////////////////////
// Everything depends on the clock variable  //
///////////////////////////////////////////////

#range (0,1) // EGG.
#declare Current_Clock = clock- 0

#declare eye_height = 1*Current_Clock
#declare eye_rotation = 0
#declare camera_rotation = 0
#declare MouthAppear = 0.55
#declare PondOn=0

#declare b4camera_tx = 0
#declare b4camera_ty = 0
#declare b4camera_tz = 0
#declare aftercamera_tx = 0
#declare aftercamera_ty = 0
#declare aftercamera_tz = 0

#declare hip_thickness = 0.4
#declare knee_thickness = 0.2
#declare thigh_length = 0.1
#declare shin_length = 0.1
#declare foot_length = 0.1
#declare fleg_length = 0.1

#declare hip_rx = 0            // Hip rotations
#declare hip_ry = 0
#declare hip_rz = 20
#declare hip_tx =0
#declare hip_ty =0
#declare hip_tz =0

#declare knee_rx = 20            // Knee rotations
#declare knee_ry = 45
#declare knee_rz = 0
#declare knee_tx =0
#declare knee_ty =0
#declare knee_tz =0

#declare foot_rx = 90            // Foot rotations
#declare foot_ry = 0
#declare foot_rz = 0
#declare foot_tx =0
#declare foot_ty =shin_length
#declare foot_tz =0

#declare fleg_rx = 0            // Foot rotations
#declare fleg_ry = 0
#declare fleg_rz = 0
#declare fleg_tx =0
#declare fleg_ty =0
#declare fleg_tz =0

#break

#range (1,2) //Make Mouth
#declare Current_Clock = clock - 1
#declare eye_height = 1
#declare eye_rotation = 0
#declare camera_rotation = 0
#declare MouthAppear = 1*Current_Clock
#declare PondOn=0

#declare b4camera_tx = 0
#declare b4camera_ty = 0
#declare b4camera_tz = 0
#declare aftercamera_tx = 0
#declare aftercamera_ty = 0
#declare aftercamera_tz = 0

#declare hip_thickness = 0.4
#declare knee_thickness = 0.2
#declare thigh_length = 0.1
#declare shin_length = 0.1
#declare foot_length = 0.1
#declare fleg_length = 0.1

#declare hip_rx = 0            // Hip rotations
#declare hip_ry = 0
#declare hip_rz = 20
#declare hip_tx =0
#declare hip_ty =0
#declare hip_tz =0

#declare knee_rx = 20            // Knee rotations
#declare knee_ry = 45
#declare knee_rz = 0
#declare knee_tx =0
#declare knee_ty =0
#declare knee_tz =0

#declare foot_rx = 90            // Foot rotations
#declare foot_ry = 0
#declare foot_rz = 0
#declare foot_tx =0
#declare foot_ty =shin_length
#declare foot_tz =0

#declare fleg_rx = 0            // Foot rotations
#declare fleg_ry = 0
#declare fleg_rz = 0
#declare fleg_tx =0
#declare fleg_ty =0
#declare fleg_tz =0

#break

#range (2,3) //Open Eyes
#declare Current_Clock = clock- 2
#declare eye_height = 1
#declare eye_rotation = 90*Current_Clock
#declare camera_rotation = 0
#declare MouthAppear = 1
#declare PondOn=0

#declare b4camera_tx = 0
#declare b4camera_ty = 0
#declare b4camera_tz = 0
#declare aftercamera_tx = 0
#declare aftercamera_ty = 0
#declare aftercamera_tz = 0

#declare hip_thickness = 0.4
#declare knee_thickness = 0.2
#declare thigh_length = 0.1
#declare shin_length = 0.1
#declare foot_length = 0.1
#declare fleg_length = 0.1

#declare hip_rx = 0            // Hip rotations
#declare hip_ry = 0
#declare hip_rz = 20
#declare hip_tx =0
#declare hip_ty =0
#declare hip_tz =0

#declare knee_rx = 20            // Knee rotations
#declare knee_ry = 45
#declare knee_rz = 0
#declare knee_tx =0
#declare knee_ty =0
#declare knee_tz =0

#declare foot_rx = 90            // Foot rotations
#declare foot_ry = 0
#declare foot_rz = 0
#declare foot_tx =0
#declare foot_ty =shin_length
#declare foot_tz =0

#declare fleg_rx = 0            // Foot rotations
#declare fleg_ry = 0
#declare fleg_rz = 0
#declare fleg_tx =0
#declare fleg_ty =0
#declare fleg_tz =0

    #break

#range (3,4) // Pause
#declare Current_Clock = clock- 3
#declare eye_height = 1
#declare eye_rotation = 90
#declare camera_rotation = 0
#declare MouthAppear = 1
#declare PondOn=0

#declare b4camera_tx = 0
#declare b4camera_ty = 0
#declare b4camera_tz = 0
#declare aftercamera_tx = 0
#declare aftercamera_ty = 0
#declare aftercamera_tz = 0

#declare hip_thickness = 0.67889
#declare knee_thickness = 0.2
#declare thigh_length = -1
#declare shin_length = -0.5
#declare foot_length = 0.001 
#declare fleg_length = -0.1  

#declare hip_rx = (-90)-20            // Hip rotations
#declare hip_ry = 0
#declare hip_rz = 0
#declare hip_tx =0
#declare hip_ty =0
#declare hip_tz = 0.9

#declare knee_rx = 40            // Knee rotations
#declare knee_ry = 0
#declare knee_rz = 0
#declare knee_tx =0
#declare knee_ty =thigh_length
#declare knee_tz =0

#declare foot_rx = 0            // Foot rotations
#declare foot_ry = 0
#declare foot_rz = 0
#declare foot_tx =0
#declare foot_ty =shin_length
#declare foot_tz =0

#declare fleg_rx = 0            // Foot rotations
#declare fleg_ry = 0
#declare fleg_rz = 0
#declare fleg_tx =0
#declare fleg_ty =0
#declare fleg_tz =0

#break

#range (4,5) // ROTATE TO SIDE VIEW WHILE TRANSLATING ALONG Z

#declare Current_Clock = clock- 4
#declare eye_height = 1
#declare eye_rotation = 90
#declare camera_rotation = 60*Current_Clock
#declare MouthAppear = 1
#declare PondOn=0

#declare b4camera_tx = 0
#declare b4camera_ty = 0
#declare b4camera_tz = -1 * (Current_Clock)
#declare aftercamera_tx = 0
#declare aftercamera_ty = 0
#declare aftercamera_tz = 0

#declare hip_thickness = 0.5
#declare knee_thickness = 0.2
#declare thigh_length = -1
#declare shin_length = -0.5
#declare foot_length = 0.001
#declare fleg_length = -0.1 

#declare hip_rx = (-70)-(40*Current_Clock)           // Hip rotations
#declare hip_ry = 0
#declare hip_rz = 0
#declare hip_tx =0
#declare hip_ty =0
#declare hip_tz = 0.9

#declare knee_rx = 40            // Knee rotations
#declare knee_ry = 0
#declare knee_rz = 0
#declare knee_tx =0
#declare knee_ty =thigh_length
#declare knee_tz =0

#declare foot_rx = 40*Current_Clock            // Foot rotations
#declare foot_ry = 0
#declare foot_rz = 0
#declare foot_tx =0
#declare foot_ty =shin_length
#declare foot_tz =0

#declare fleg_rx = 0            // Foot rotations
#declare fleg_ry = 0
#declare fleg_rz = 0
#declare fleg_tx =0
#declare fleg_ty =0
#declare fleg_tz =0

#break

#range (5,6) // TAIL UP
#declare Current_Clock = clock- 5

#declare eye_height = 1
#declare eye_rotation = 90
#declare camera_rotation = 60
#declare MouthAppear = 1
#declare PondOn=0

#declare b4camera_tx = 0
#declare b4camera_ty = 0
#declare b4camera_tz = -1
#declare aftercamera_tx = 0
#declare aftercamera_ty = 0
#declare aftercamera_tz = 0

#declare hip_thickness = 0.5
#declare knee_thickness = 0.2
#declare thigh_length = -1
#declare shin_length = -0.5
#declare foot_length = 0.001
#declare fleg_length = -0.1 

#declare hip_rx = (-70)-(40*(1-Current_Clock))           // Hip rotations
#declare hip_ry = 0
#declare hip_rz = 0
#declare hip_tx =0
#declare hip_ty =0
#declare hip_tz = 0.9

#declare knee_rx = (40)-(80 * Current_Clock)            // Knee rotations
#declare knee_ry = 0
#declare knee_rz = 0
#declare knee_tx =0
#declare knee_ty =thigh_length
#declare knee_tz =0

#declare foot_rx = 0            // Foot rotations
#declare foot_ry = 0
#declare foot_rz = 0
#declare foot_tx =0
#declare foot_ty =shin_length
#declare foot_tz =0

#declare fleg_rx = 0            // Foot rotations
#declare fleg_ry = 0
#declare fleg_rz = 0
#declare fleg_tx =0
#declare fleg_ty =0
#declare fleg_tz =0

#break

#range (6,7) // TAIL DOWN
#declare Current_Clock = clock- 6
#declare eye_height = 1
#declare eye_rotation = 90
#declare camera_rotation = 60
#declare MouthAppear = 1
#declare PondOn=0

#declare b4camera_tx = 0
#declare b4camera_ty = 0
#declare b4camera_tz = -1
#declare aftercamera_tx = 0
#declare aftercamera_ty = 0
#declare aftercamera_tz = 0

#declare hip_thickness = 0.5
#declare knee_thickness = 0.2
#declare thigh_length = -1
#declare shin_length = -0.5    
#declare foot_length = 0.001   
#declare fleg_length = -0.1    

#declare hip_rx = (-70)-(40*Current_Clock)           // Hip rotations
#declare hip_ry = 0
#declare hip_rz = 0
#declare hip_tx =0
#declare hip_ty =0
#declare hip_tz = 0.9

#declare knee_rx = (40)-(80 * (1-Current_Clock))            // Knee rotations
#declare knee_ry = 0
#declare knee_rz = 0
#declare knee_tx =0
#declare knee_ty =thigh_length
#declare knee_tz =0

#declare foot_rx = 40*Current_Clock            // Foot rotations
#declare foot_ry = 0
#declare foot_rz = 0
#declare foot_tx =0
#declare foot_ty =shin_length
#declare foot_tz =0

#declare fleg_rx = 0            // Foot rotations
#declare fleg_ry = 0
#declare fleg_rz = 0
#declare fleg_tx =0
#declare fleg_ty =0
#declare fleg_tz =0

#break

#range (7,8) // TAIL up
#declare Current_Clock = clock- 7

#declare eye_height = 1
#declare eye_rotation = 90
#declare camera_rotation = 60
#declare MouthAppear = 1
#declare PondOn=0

#declare b4camera_tx = 0
#declare b4camera_ty = 0
#declare b4camera_tz = -1
#declare aftercamera_tx = 0
#declare aftercamera_ty = 0
#declare aftercamera_tz = 0

#declare hip_thickness = 0.5
#declare knee_thickness = 0.2
#declare thigh_length = -1
#declare shin_length = -0.5  
#declare foot_length = 0.001 
#declare fleg_length = -0.1  

#declare hip_rx = (-70)-(40*(1-Current_Clock))           // Hip rotations
#declare hip_ry = 0
#declare hip_rz = 0
#declare hip_tx =0
#declare hip_ty =0
#declare hip_tz = 0.9

#declare knee_rx = (40)-(80 * Current_Clock)            // Knee rotations
#declare knee_ry = 0
#declare knee_rz = 0
#declare knee_tx =0
#declare knee_ty =thigh_length
#declare knee_tz =0

#declare foot_rx = 0            // Foot rotations
#declare foot_ry = 0
#declare foot_rz = 0
#declare foot_tx =0
#declare foot_ty =shin_length
#declare foot_tz =0

#declare fleg_rx = 0            // Foot rotations
#declare fleg_ry = 0
#declare fleg_rz = 0
#declare fleg_tx =0
#declare fleg_ty =0
#declare fleg_tz =0

#break

#range (8,9) // TRANSFORM TAIL BREAK INTO LEGS (Extended)
#declare Current_Clock = clock- 8

#declare eye_height = 1
#declare eye_rotation = 90
#declare camera_rotation = 60
#declare MouthAppear = 1
#declare PondOn=0

#declare b4camera_tx = 0
#declare b4camera_ty = 0
#declare b4camera_tz = -1
#declare aftercamera_tx = 0
#declare aftercamera_ty = 0
#declare aftercamera_tz = 0

#declare hip_thickness = 0.5 - (0.1*Current_Clock)
#declare knee_thickness = 0.2
#declare thigh_length = -1
#declare shin_length = -0.5 - (1*Current_Clock)    
#declare foot_length = 0.001 - (0.5*Current_Clock) 
#declare fleg_length = -0.1  

#declare hip_rx = -70-(20*Current_Clock)           // Hip rotations (-90)
#declare hip_ry = 170*Current_Clock
#declare hip_rz = 0
#declare hip_tx =0.85*Current_Clock
#declare hip_ty =0
#declare hip_tz = 0.9-(0.2*Current_Clock)// Rest at 0.7

#declare knee_rx = -40 * (1 - Current_Clock)            // Knee rotations (-40)
#declare knee_ry = 0
#declare knee_rz = -160*Current_Clock
#declare knee_tx =0
#declare knee_ty =thigh_length
#declare knee_tz =0

#declare foot_rx = (-40)+130*Current_Clock            // Foot rotations
#declare foot_ry = 66
#declare foot_rz = 0
#declare foot_tx =0
#declare foot_ty =shin_length
#declare foot_tz =0

#declare fleg_rx = 0            // Foot rotations
#declare fleg_ry = 0
#declare fleg_rz = 0
#declare fleg_tx =0
#declare fleg_ty =0
#declare fleg_tz =0

#break

#range (9,10) // Retracted
#declare Current_Clock = clock- 9

#declare eye_height = 1
#declare eye_rotation = 90
#declare camera_rotation = 60
#declare MouthAppear = 1
#declare PondOn=0

#declare b4camera_tx = 0
#declare b4camera_ty = 0
#declare b4camera_tz = -1
#declare aftercamera_tx = 0
#declare aftercamera_ty = 0
#declare aftercamera_tz = 0

#declare hip_thickness = 0.4
#declare knee_thickness = 0.2
#declare thigh_length = -1
#declare shin_length = -1.5
#declare foot_length = -0.5
#declare fleg_length = -0.1

#declare hip_rx = -90           // Hip rotations (-90)
#declare hip_ry = 170 * (1 - Current_Clock)
#declare hip_rz = 0
#declare hip_tx =0.85
#declare hip_ty =0
#declare hip_tz = 0.7

#declare knee_rx = 0  // Knee rotations
#declare knee_ry = 0
#declare knee_rz = -160 * (1 - Current_Clock)
#declare knee_tx =0
#declare knee_ty =thigh_length
#declare knee_tz =0

#declare foot_rx = 90            // Foot rotations
#declare foot_ry = 66 * (1 - Current_Clock)
#declare foot_rz = 0
#declare foot_tx =0
#declare foot_ty =shin_length
#declare foot_tz =0

#declare fleg_rx = 0            // Foot rotations
#declare fleg_ry = 0
#declare fleg_rz = 0
#declare fleg_tx =0
#declare fleg_ty =0
#declare fleg_tz =0

#break

#range (10,11) // EXTEND
#declare Current_Clock = clock- 10

#declare eye_height = 1
#declare eye_rotation = 90
#declare camera_rotation = 60
#declare MouthAppear = 1
#declare PondOn=0

#declare b4camera_tx = 0
#declare b4camera_ty = 0
#declare b4camera_tz = -1
#declare aftercamera_tx = 0
#declare aftercamera_ty = 0
#declare aftercamera_tz = 0

#declare hip_thickness = 0.4
#declare knee_thickness = 0.2
#declare thigh_length = -1
#declare shin_length = -1.5
#declare foot_length = -0.5
#declare fleg_length = -0.1

#declare hip_rx = -90           // Hip rotations (-90)
#declare hip_ry = 170 * (Current_Clock)
#declare hip_rz = 0
#declare hip_tx =0.85
#declare hip_ty =0
#declare hip_tz = 0.7

#declare knee_rx = 0  // Knee rotations
#declare knee_ry = 0
#declare knee_rz = -160 * (Current_Clock)
#declare knee_tx =0
#declare knee_ty =thigh_length
#declare knee_tz =0

#declare foot_rx = 90            // Foot rotations
#declare foot_ry = 66 * (Current_Clock)
#declare foot_rz = 0
#declare foot_tx =0
#declare foot_ty =shin_length
#declare foot_tz =0

#declare fleg_rx = 0            // Foot rotations
#declare fleg_ry = 0
#declare fleg_rz = 0
#declare fleg_tx =0
#declare fleg_ty =0
#declare fleg_tz =0

    #break

#range (11,12) // GROW FRONT LEGS WHILE RETRACTING
#declare Current_Clock = clock- 11

#declare eye_height = 1
#declare eye_rotation = 90
#declare camera_rotation = 60
#declare MouthAppear = 1
#declare PondOn=0

#declare b4camera_tx = 0
#declare b4camera_ty = 0
#declare b4camera_tz = -1
#declare aftercamera_tx = 0
#declare aftercamera_ty = 0
#declare aftercamera_tz = 0

#declare hip_thickness = 0.4
#declare knee_thickness = 0.2
#declare thigh_length = -1
#declare shin_length = -1.5
#declare foot_length = -0.5
#declare fleg_length = -0.1

#declare hip_rx = -90           // Hip rotations (-90)
#declare hip_ry = 170 * (1 - Current_Clock)
#declare hip_rz = 0
#declare hip_tx =0.85
#declare hip_ty =0
#declare hip_tz = 0.7

#declare knee_rx = 0  // Knee rotations
#declare knee_ry = 0
#declare knee_rz = -160 * (1 - Current_Clock)
#declare knee_tx =0
#declare knee_ty =thigh_length
#declare knee_tz =0

#declare foot_rx = 90            // Foot rotations
#declare foot_ry = 66 * (1 - Current_Clock)
#declare foot_rz = 0
#declare foot_tx =0
#declare foot_ty =shin_length
#declare foot_tz =0

#declare fleg_rx = 0            // Foot rotations
#declare fleg_ry = 0
#declare fleg_rz = 0
#declare fleg_tx =0
#declare fleg_ty =0
#declare fleg_tz =0

#break

#range (12,13) // EXTEND ALL
#declare Current_Clock = clock- 12

#declare eye_height = 1
#declare eye_rotation = 90
#declare camera_rotation = 60
#declare MouthAppear = 1
#declare PondOn=0

#declare b4camera_tx = 0
#declare b4camera_ty = 0
#declare b4camera_tz = -1
#declare aftercamera_tx = 0
#declare aftercamera_ty = 0
#declare aftercamera_tz = 0

#declare hip_thickness = 0.4
#declare knee_thickness = 0.2
#declare thigh_length = -1
#declare shin_length = -1.5
#declare foot_length = -0.5
#declare fleg_length = -0.8

#declare hip_rx = -90           // Hip rotations (-90)
#declare hip_ry = 170 * (Current_Clock)
#declare hip_rz = 0
#declare hip_tx =0.85
#declare hip_ty =0
#declare hip_tz = 0.7

#declare knee_rx = 0  // Knee rotations
#declare knee_ry = 0
#declare knee_rz = -160 * (Current_Clock)
#declare knee_tx =0
#declare knee_ty =thigh_length
#declare knee_tz =0

#declare foot_rx = 90            // Foot rotations
#declare foot_ry = 66 * (Current_Clock)
#declare foot_rz = 0
#declare foot_tx =0
#declare foot_ty =shin_length
#declare foot_tz =0

#declare fleg_rx = 90            // Foot rotations
#declare fleg_ry = -140+(110 * Current_Clock)
#declare fleg_rz = 0
#declare fleg_tx =Current_Clock
#declare fleg_ty =-0.25*Current_Clock
#declare fleg_tz =0

#break

#range (13,14) // RETRACT ALL
#declare Current_Clock = clock- 13

#declare eye_height = 1
#declare eye_rotation = 90
#declare camera_rotation = 60
#declare MouthAppear = 1
#declare PondOn=0

#declare b4camera_tx = 0
#declare b4camera_ty = 0
#declare b4camera_tz = -1
#declare aftercamera_tx = 0
#declare aftercamera_ty = 0
#declare aftercamera_tz = 0

#declare hip_thickness = 0.4
#declare knee_thickness = 0.2
#declare thigh_length = -1
#declare shin_length = -1.5
#declare foot_length = -0.5
#declare fleg_length = -0.8

#declare hip_rx = -90           // Hip rotations (-90)
#declare hip_ry = 170 * (1 - Current_Clock)
#declare hip_rz = 0
#declare hip_tx =0.85
#declare hip_ty =0
#declare hip_tz = 0.7

#declare knee_rx = 0  // Knee rotations
#declare knee_ry = 0
#declare knee_rz = -160 * (1 - Current_Clock)
#declare knee_tx =0
#declare knee_ty =thigh_length
#declare knee_tz =0

#declare foot_rx = 90            // Foot rotations
#declare foot_ry = 66 * (1 - Current_Clock)
#declare foot_rz = 0
#declare foot_tx =0
#declare foot_ty =shin_length
#declare foot_tz =0

#declare fleg_rx = 90            // Foot rotations
#declare fleg_ry = -30-(80 * Current_Clock)
#declare fleg_rz = 0
#declare fleg_tx =1
#declare fleg_ty =-0.25
#declare fleg_tz =0

#break

#range (14,15) // EXTEND ALL
#declare Current_Clock = clock- 14

#declare eye_height = 1
#declare eye_rotation = 90
#declare camera_rotation = 60
#declare MouthAppear = 1
#declare PondOn=0

#declare b4camera_tx = 0
#declare b4camera_ty = 0
#declare b4camera_tz = -1
#declare aftercamera_tx = 0
#declare aftercamera_ty = 0
#declare aftercamera_tz = 0

#declare hip_thickness = 0.4
#declare knee_thickness = 0.2
#declare thigh_length = -1
#declare shin_length = -1.5
#declare foot_length = -0.5
#declare fleg_length = -0.8

#declare hip_rx = -90           // Hip rotations (-90)
#declare hip_ry = 170 * (Current_Clock)
#declare hip_rz = 0
#declare hip_tx =0.85
#declare hip_ty =0
#declare hip_tz = 0.7

#declare knee_rx = 0  // Knee rotations
#declare knee_ry = 0
#declare knee_rz = -160 * (Current_Clock)
#declare knee_tx =0
#declare knee_ty =thigh_length
#declare knee_tz =0

#declare foot_rx = 90            // Foot rotations
#declare foot_ry = 66 * (Current_Clock)
#declare foot_rz = 0
#declare foot_tx =0
#declare foot_ty =shin_length
#declare foot_tz =0

#declare fleg_rx = 90            // Foot rotations
#declare fleg_ry = -110+(80 * Current_Clock)
#declare fleg_rz = 0
#declare fleg_tx =1
#declare fleg_ty =-0.25
#declare fleg_tz =0

#break

#range (15,16) // GO TO SITTING POSITION WHILE CAMERA ROTATES
#declare Current_Clock = clock- 15

#declare eye_height = 1
#declare eye_rotation = 90
#declare camera_rotation = 60
#declare MouthAppear = 1
#declare PondOn=0

#declare b4camera_tx = 0
#declare b4camera_ty = 0
#declare b4camera_tz = -1
#declare aftercamera_tx = 0
#declare aftercamera_ty = 0
#declare aftercamera_tz = 0

#declare hip_thickness = 0.4
#declare knee_thickness = 0.2
#declare thigh_length = -1
#declare shin_length = -1.5
#declare foot_length = -0.5
#declare fleg_length = -0.8

#declare hip_rx = -90           // Hip rotations (-90)
#declare hip_ry = 170 * (1 - Current_Clock)
#declare hip_rz = 0
#declare hip_tx =0.85
#declare hip_ty =0
#declare hip_tz = 0.7

#declare knee_rx = 0  // Knee rotations
#declare knee_ry = 0
#declare knee_rz = -160 * (1 - Current_Clock)
#declare knee_tx =0
#declare knee_ty =thigh_length
#declare knee_tz =0

#declare foot_rx = 90            // Foot rotations
#declare foot_ry = 66 * (1 - Current_Clock)
#declare foot_rz = 0
#declare foot_tx =0
#declare foot_ty =shin_length
#declare foot_tz =0

#declare fleg_rx = 90            // Foot rotations
#declare fleg_ry = -30-(80 * Current_Clock)
#declare fleg_rz = 0
#declare fleg_tx =1
#declare fleg_ty =-0.25
#declare fleg_tz =0

#break

#range (16,17)
#declare Current_Clock = clock - 16

#declare eye_height = 1
#declare eye_rotation = 90
#declare camera_rotation = 60
#declare MouthAppear = 1
#declare PondOn=0

#declare b4camera_tx = 0
#declare b4camera_ty = 0
#declare b4camera_tz = -1
#declare aftercamera_tx = 0
#declare aftercamera_ty = 0
#declare aftercamera_tz = 0

#declare hip_thickness = 0.4
#declare knee_thickness = 0.2
#declare thigh_length = -1
#declare shin_length = -1.5
#declare foot_length = -0.5
#declare fleg_length = -0.8

#declare hip_rx = -90 - (90 * Current_Clock)           // Hip rotations (-90)
#declare hip_ry = 180 * (Current_Clock)
#declare hip_rz = -30 * (Current_Clock)
#declare hip_tx =1//0.85
#declare hip_ty =0
#declare hip_tz = 0.7

#declare knee_rx = 0  // Knee rotations
#declare knee_ry = 0
#declare knee_rz = -140 * (Current_Clock)
#declare knee_tx =0
#declare knee_ty =thigh_length
#declare knee_tz =0

#declare foot_rx = 90 - (20 * Current_Clock)            // Foot rotations
#declare foot_ry = 0
#declare foot_rz = 0
#declare foot_tx =0
#declare foot_ty =shin_length
#declare foot_tz =0

#declare fleg_rx = 90-(70 * Current_Clock)            // Foot rotations
#declare fleg_ry = -110+(80 * Current_Clock)
#declare fleg_rz = 0
#declare fleg_tx =1
#declare fleg_ty =-0.25
#declare fleg_tz =0

#break

#range (17,18) // CAMERA MOVES BACK, SHOW WEEDS AND WATER
#declare Current_Clock = clock - 17

#declare eye_height = 1
#declare eye_rotation = 90
#declare camera_rotation = 60 - (60 * Current_Clock)
#declare MouthAppear = 1
#declare PondOn=0

#declare b4camera_tx = 0
#declare b4camera_ty = 0
#declare b4camera_tz = -1+(3 * Current_Clock)
#declare aftercamera_tx = 0
#declare aftercamera_ty = 0
#declare aftercamera_tz = 0

#declare hip_thickness = 0.4
#declare knee_thickness = 0.2
#declare thigh_length = -1
#declare shin_length = -1.5
#declare foot_length = -0.5
#declare fleg_length = -0.8

#declare hip_rx = -180           // Hip rotations (-90)
#declare hip_ry = 180
#declare hip_rz = -30
#declare hip_tx =1//0.85
#declare hip_ty =0
#declare hip_tz = 0.7

#declare knee_rx = 0  // Knee rotations
#declare knee_ry = 0
#declare knee_rz = -140
#declare knee_tx =0
#declare knee_ty =thigh_length
#declare knee_tz =0

#declare foot_rx = 70            // Foot rotations
#declare foot_ry = 0
#declare foot_rz = 0
#declare foot_tx =0
#declare foot_ty =shin_length
#declare foot_tz =0

#declare fleg_rx = 20            // Foot rotations
#declare fleg_ry = -30
#declare fleg_rz = 0
#declare fleg_tx =1
#declare fleg_ty =-0.25
#declare fleg_tz =0

#break

#range (18,19) // EYES UP
#declare Current_Clock = clock - 18

#declare eye_height = 1
#declare eye_rotation = 90
#declare camera_rotation = 0
#declare MouthAppear = 1
#declare PondOn=1

#declare eye_endx = 0.2*Current_Clock
#declare eye_endy = 0.2*Current_Clock

#declare b4camera_tx = 0
#declare b4camera_ty = 2*Current_Clock
#declare b4camera_tz = 2-(5 * Current_Clock)
#declare aftercamera_tx = 0
#declare aftercamera_ty = 0
#declare aftercamera_tz = 0

#declare hip_thickness = 0.4
#declare knee_thickness = 0.2
#declare thigh_length = -1
#declare shin_length = -1.5
#declare foot_length = -0.5
#declare fleg_length = -0.8

#declare hip_rx = -180           // Hip rotations (-90)
#declare hip_ry = 180
#declare hip_rz = -30
#declare hip_tx =1//0.85
#declare hip_ty =0
#declare hip_tz = 0.7

#declare knee_rx = 0  // Knee rotations
#declare knee_ry = 0
#declare knee_rz = -140
#declare knee_tx =0
#declare knee_ty =thigh_length
#declare knee_tz =0

#declare foot_rx = 70            // Foot rotations
#declare foot_ry = 0
#declare foot_rz = 0
#declare foot_tx =0
#declare foot_ty =shin_length
#declare foot_tz =0

#declare fleg_rx = 20            // Foot rotations
#declare fleg_ry = -30
#declare fleg_rz = 0
#declare fleg_tx =1
#declare fleg_ty =-0.25
#declare fleg_tz =0

#break

#range (19,20) // EYES TRACK
#declare Current_Clock = clock- 19

#declare eye_height = 1
#declare eye_rotation = 90
#declare eye_endx = 0.2-(0.4*Current_Clock)
#declare eye_endy = 0.2
#declare camera_rotation = 0
#declare MouthAppear = 1
#declare PondOn=1

#declare b4camera_tx = 0
#declare b4camera_ty = 2
#declare b4camera_tz = -3
#declare aftercamera_tx = 0
#declare aftercamera_ty = 0
#declare aftercamera_tz = 0

#declare hip_thickness = 0.4
#declare knee_thickness = 0.2
#declare thigh_length = -1
#declare shin_length = -1.5
#declare foot_length = -0.5
#declare fleg_length = -0.8

#declare hip_rx = -180           // Hip rotations (-90)
#declare hip_ry = 180
#declare hip_rz = -30
#declare hip_tx =1
#declare hip_ty =0
#declare hip_tz = 0.7

#declare knee_rx = 0  // Knee rotations
#declare knee_ry = 0
#declare knee_rz = -140
#declare knee_tx =0
#declare knee_ty =thigh_length
#declare knee_tz =0

#declare foot_rx = 70            // Foot rotations
#declare foot_ry = 0
#declare foot_rz = 0
#declare foot_tx =0
#declare foot_ty =shin_length
#declare foot_tz =0

#declare fleg_rx = 20            // Foot rotations
#declare fleg_ry = -30
#declare fleg_rz = 0
#declare fleg_tx =1
#declare fleg_ty =-0.25
#declare fleg_tz =0

#break

#range (20,20.5) // TONGUE OUT
#declare Current_Clock = (clock- 20) * 2

#declare eye_height = 1
#declare eye_rotation = 90
#declare eye_endx = -0.2
#declare eye_endy = 0.2

#declare tongue_x = -2*Current_Clock
#declare tongue_y = 2.5*Current_Clock
#declare tongue_z = -3*Current_Clock

#declare camera_rotation = 0
#declare MouthAppear = 1
#declare PondOn=1

#declare b4camera_tx = 0
#declare b4camera_ty = 2
#declare b4camera_tz = -3
#declare aftercamera_tx = 0
#declare aftercamera_ty = 0
#declare aftercamera_tz = 0

#declare hip_thickness = 0.4
#declare knee_thickness = 0.2
#declare thigh_length = -1
#declare shin_length = -1.5
#declare foot_length = -0.5
#declare fleg_length = -0.8

#declare hip_rx = -180           // Hip rotations (-90)
#declare hip_ry = 180
#declare hip_rz = -30
#declare hip_tx =1
#declare hip_ty =0
#declare hip_tz = 0.7

#declare knee_rx = 0  // Knee rotations
#declare knee_ry = 0
#declare knee_rz = -140
#declare knee_tx =0
#declare knee_ty =thigh_length
#declare knee_tz =0

#declare foot_rx = 70            // Foot rotations
#declare foot_ry = 0
#declare foot_rz = 0
#declare foot_tx =0
#declare foot_ty =shin_length
#declare foot_tz =0

#declare fleg_rx = 20            // Foot rotations
#declare fleg_ry = -30
#declare fleg_rz = 0
#declare fleg_tx =1
#declare fleg_ty =-0.25
#declare fleg_tz =0

#break

#range (20.5,21) // TONGUE IN, EYES CENTER
#declare Current_Clock = (clock- 20.5) * 2

#declare eye_height = 1
#declare eye_rotation = 90 * (1 - Current_Clock)
#declare eye_endx = -0.2 * (1 - Current_Clock)
#declare eye_endy = 0.2 - (0.1 * Current_Clock)

#declare tongue_x = -2*(1 - Current_Clock)
#declare tongue_y = 2.5*(1 - Current_Clock)
#declare tongue_z = -3*(1 - Current_Clock)

#declare camera_rotation = 0
#declare MouthAppear = 1
#declare PondOn=1

#declare b4camera_tx = 0
#declare b4camera_ty = 2
#declare b4camera_tz = -3
#declare aftercamera_tx = 0
#declare aftercamera_ty = 0
#declare aftercamera_tz = 0

#declare hip_thickness = 0.4
#declare knee_thickness = 0.2
#declare thigh_length = -1
#declare shin_length = -1.5
#declare foot_length = -0.5
#declare fleg_length = -0.8

#declare hip_rx = -180           // Hip rotations (-90)
#declare hip_ry = 180
#declare hip_rz = -30
#declare hip_tx =1
#declare hip_ty =0
#declare hip_tz = 0.7

#declare knee_rx = 0  // Knee rotations
#declare knee_ry = 0
#declare knee_rz = -140
#declare knee_tx =0
#declare knee_ty =thigh_length
#declare knee_tz =0

#declare foot_rx = 70            // Foot rotations
#declare foot_ry = 0
#declare foot_rz = 0
#declare foot_tx =0
#declare foot_ty =shin_length
#declare foot_tz =0

#declare fleg_rx = 20            // Foot rotations
#declare fleg_ry = -30
#declare fleg_rz = 0
#declare fleg_tx =1
#declare fleg_ty =-0.25
#declare fleg_tz =0
    #break

#range (21,22) // TONGUE IN, EYES CENTER
#declare Current_Clock = clock- 21

#declare eye_height = 1
#declare eye_rotation = 90 * (Current_Clock)
#declare eye_endx = 0
#declare eye_endy = 0.1

#declare camera_rotation = 0
#declare MouthAppear = 1
#declare PondOn=1

#declare b4camera_tx = 0
#declare b4camera_ty = 2
#declare b4camera_tz = -3
#declare aftercamera_tx = 0
#declare aftercamera_ty = 0
#declare aftercamera_tz = 0

#declare hip_thickness = 0.4
#declare knee_thickness = 0.2
#declare thigh_length = -1
#declare shin_length = -1.5
#declare foot_length = -0.5
#declare fleg_length = -0.8

#declare hip_rx = -180           // Hip rotations (-90)
#declare hip_ry = 180
#declare hip_rz = -30
#declare hip_tx =1
#declare hip_ty =0
#declare hip_tz = 0.7

#declare knee_rx = 0  // Knee rotations
#declare knee_ry = 0
#declare knee_rz = -140
#declare knee_tx =0
#declare knee_ty =thigh_length
#declare knee_tz =0

#declare foot_rx = 70            // Foot rotations
#declare foot_ry = 0
#declare foot_rz = 0
#declare foot_tx =0
#declare foot_ty =shin_length
#declare foot_tz =0

#declare fleg_rx = 20            // Foot rotations
#declare fleg_ry = -30
#declare fleg_rz = 0
#declare fleg_tx =1
#declare fleg_ty =-0.25
#declare fleg_tz =0

#break

#range (22,23) // EYES CLOSED
#declare Current_Clock = clock- 22

#declare eye_height = 1
#declare eye_rotation = 90
#declare eye_endx = 0
#declare eye_endy = 0.1

#declare camera_rotation = 0
#declare MouthAppear = 1
#declare PondOn=1

#declare b4camera_tx = 0
#declare b4camera_ty = 2
#declare b4camera_tz = -3
#declare aftercamera_tx = 0
#declare aftercamera_ty = 0
#declare aftercamera_tz = 0

#declare hip_thickness = 0.4
#declare knee_thickness = 0.2
#declare thigh_length = -1
#declare shin_length = -1.5
#declare foot_length = -0.5
#declare fleg_length = -0.8

#declare hip_rx = -180           // Hip rotations (-90)
#declare hip_ry = 180
#declare hip_rz = -30
#declare hip_tx =1
#declare hip_ty =0
#declare hip_tz = 0.7

#declare knee_rx = 0  // Knee rotations
#declare knee_ry = 0
#declare knee_rz = -140
#declare knee_tx =0
#declare knee_ty =thigh_length
#declare knee_tz =0

#declare foot_rx = 70            // Foot rotations
#declare foot_ry = 0
#declare foot_rz = 0
#declare foot_tx =0
#declare foot_ty =shin_length
#declare foot_tz =0

#declare fleg_rx = 20            // Foot rotations
#declare fleg_ry = -30
#declare fleg_rz = 0
#declare fleg_tx =1
#declare fleg_ty =-0.25
#declare fleg_tz =0

#break

#range (23,23.5) // EYES OPEN (BLINK)
#declare Current_Clock = (clock- 23)*2

#declare eye_height = 1
#declare eye_rotation = 90
#declare eye_endx = 0
#declare eye_endy = 0.1

// camera position <0.0 , 1.0 ,-7.0>

#declare tongue_x = 0
#declare tongue_y = 1 * Current_Clock
#declare tongue_z = -7 * Current_Clock

#declare camera_rotation = 0
#declare MouthAppear = 1
#declare PondOn=1

#declare b4camera_tx = 0
#declare b4camera_ty = 2
#declare b4camera_tz = -3
#declare aftercamera_tx = 0
#declare aftercamera_ty = 0
#declare aftercamera_tz = 0

#declare hip_thickness = 0.4
#declare knee_thickness = 0.2
#declare thigh_length = -1
#declare shin_length = -1.5
#declare foot_length = -0.5
#declare fleg_length = -0.8

#declare hip_rx = -180           // Hip rotations (-90)
#declare hip_ry = 180
#declare hip_rz = -30
#declare hip_tx =1
#declare hip_ty =0
#declare hip_tz = 0.7

#declare knee_rx = 0  // Knee rotations
#declare knee_ry = 0
#declare knee_rz = -140
#declare knee_tx =0
#declare knee_ty =thigh_length
#declare knee_tz =0

#declare foot_rx = 70            // Foot rotations
#declare foot_ry = 0
#declare foot_rz = 0
#declare foot_tx =0
#declare foot_ty =shin_length
#declare foot_tz =0

#declare fleg_rx = 20            // Foot rotations
#declare fleg_ry = -30
#declare fleg_rz = 0
#declare fleg_tx =1
#declare fleg_ty =-0.25
#declare fleg_tz =0

#break

#range (23.5,24) // TONGUE OUT (TO CAMERA)
#declare Current_Clock = (clock- 23.5)*2

#declare eye_height = 1
#declare eye_rotation = 90
#declare eye_endx = 0
#declare eye_endy = 0.1

// camera position <0.0 , 1.0 ,-7.0>

#declare tongue_x = 0
#declare tongue_y = 1 
#declare tongue_z = -7

#declare camera_rotation = 0
#declare MouthAppear = 1
#declare PondOn=1

#declare b4camera_tx = 0
#declare b4camera_ty = 2
#declare b4camera_tz = -3
#declare aftercamera_tx = 0
#declare aftercamera_ty = 0
#declare aftercamera_tz = 0

#declare hip_thickness = 0.4
#declare knee_thickness = 0.2
#declare thigh_length = -1
#declare shin_length = -1.5
#declare foot_length = -0.5
#declare fleg_length = -0.8

#declare hip_rx = -180           // Hip rotations (-90)
#declare hip_ry = 180
#declare hip_rz = -30
#declare hip_tx =1
#declare hip_ty =0
#declare hip_tz = 0.7

#declare knee_rx = 0  // Knee rotations
#declare knee_ry = 0
#declare knee_rz = -140
#declare knee_tx =0
#declare knee_ty =thigh_length
#declare knee_tz =0

#declare foot_rx = 70            // Foot rotations
#declare foot_ry = 0
#declare foot_rz = 0
#declare foot_tx =0
#declare foot_ty =shin_length
#declare foot_tz =0

#declare fleg_rx = 20            // Foot rotations
#declare fleg_ry = -30
#declare fleg_rz = 0
#declare fleg_tx =1
#declare fleg_ty =-0.25
#declare fleg_tz =0

#break

#range (24,25) // CAMERA SUCKED INTO MOUTH OF FROG, THE END
#declare Current_Clock = clock- 24

#declare eye_height = 1
#declare eye_rotation = 90
#declare eye_endx = 0
#declare eye_endy = 0.1

// camera position <0.0 , 1.0 ,-7.0>

#declare tongue_x = 0
#declare tongue_y = 1 * (1 - Current_Clock)
#declare tongue_z = -7 * (1 - Current_Clock)

#declare camera_rotation = 0
#declare MouthAppear = 1
#declare PondOn=1

#declare b4camera_tx = 0
#declare b4camera_ty = 2
#declare b4camera_tz = -3
#declare aftercamera_tx = 0
#declare aftercamera_ty = -2.2 * Current_Clock 
#declare aftercamera_tz = 6.7 * Current_Clock

#declare hip_thickness = 0.4
#declare knee_thickness = 0.2
#declare thigh_length = -1
#declare shin_length = -1.5
#declare foot_length = -0.5
#declare fleg_length = -0.8

#declare hip_rx = -180           // Hip rotations (-90)
#declare hip_ry = 180
#declare hip_rz = -30
#declare hip_tx =1
#declare hip_ty =0
#declare hip_tz = 0.7

#declare knee_rx = 0  // Knee rotations
#declare knee_ry = 0
#declare knee_rz = -140
#declare knee_tx =0
#declare knee_ty =thigh_length
#declare knee_tz =0

#declare foot_rx = 70            // Foot rotations
#declare foot_ry = 0
#declare foot_rz = 0
#declare foot_tx =0
#declare foot_ty =shin_length
#declare foot_tz =0

#declare fleg_rx = 20            // Foot rotations
#declare fleg_ry = -30
#declare fleg_rz = 0
#declare fleg_tx =1
#declare fleg_ty =-0.25
#declare fleg_tz =0

#break

#range (25,26) // CAMERA SUCKED INTO MOUTH OF FROG, THE END
#declare Current_Clock = clock- 24

#declare eye_height = 1
#declare eye_rotation = 90
#declare eye_endx = 0
#declare eye_endy = 0.1

// camera position <0.0 , 1.0 ,-7.0>

#declare camera_rotation = 0
#declare MouthAppear = 1
#declare PondOn=1

#declare b4camera_tx = 0
#declare b4camera_ty = 2
#declare b4camera_tz = -3
#declare aftercamera_tx = 0
#declare aftercamera_ty = -2.2
#declare aftercamera_tz = 6.7 

#declare hip_thickness = 0.4
#declare knee_thickness = 0.2
#declare thigh_length = -1
#declare shin_length = -1.5
#declare foot_length = -0.5
#declare fleg_length = -0.8

#declare hip_rx = -180           // Hip rotations (-90)
#declare hip_ry = 180
#declare hip_rz = -30
#declare hip_tx =1
#declare hip_ty =0
#declare hip_tz = 0.7

#declare knee_rx = 0  // Knee rotations
#declare knee_ry = 0
#declare knee_rz = -140
#declare knee_tx =0
#declare knee_ty =thigh_length
#declare knee_tz =0

#declare foot_rx = 70            // Foot rotations
#declare foot_ry = 0
#declare foot_rz = 0
#declare foot_tx =0
#declare foot_ty =shin_length
#declare foot_tz =0

#declare fleg_rx = 20            // Foot rotations
#declare fleg_ry = -30
#declare fleg_rz = 0
#declare fleg_tx =1
#declare fleg_ty =-0.25
#declare fleg_tz =0

#break


      #else
#end


//////////////////////////////////////////////////////////////////
// The values will be defined based on : the #switch statement  //
// and the value of clock at the time. Now that the values have //
// been defined we can model the objects by including/appending //
// the FrogObj.inc objects!                                     //
//////////////////////////////////////////////////////////////////
//OBJECT SCENE
#include "FrogObj.inc"
