
// Glenn's Environment POV-Ray Object File
// This file does not render.  #include "AFEnviron.inc" in another .pov file
// created 8-Mar-98  updated 9-Mar-98
// copyright 1998 Glenn McCarter

// A flat plane world, with clouds in sky, fog,
// and a Sun definition
// Intended scale is English system (inches), ground is +Z
// Origin in the middle of the ground plane


//===============================================
//             Textures
//===============================================

#declare EarthTex =
	texture {
		pigment {
			bozo
			color_map
			{
		[ 0.1  color rgb<.4,.4,.4> ]
		[ 0.3  color rgb<.9,.9,.6> ]
		[ 0.5  color rgb<.5,.4,.2> ]
		[ 0.7  color rgb<.1,.5,.2> ]
		[ 1.0  color rgb<.4,.4,.4> ]
			} // color_map
			scale 50000
			turbulence .02
		}
		normal { bumps .13 scale 400 }
		finish { ambient .15 diffuse .7 specular .2 roughness .05 }
	}
#declare CloudTex =
	texture {
		pigment {
			bozo
			color_map
			{
/*
		[ 0.1  color rgbt<.8,.8,.8,.3> ]
		[ 0.3  color rgbt<.96,.96,.96,.6> ]
		[ 0.5  color rgbt<.5,.5,.5,1.0> ]
		[ 1.0  color rgbt<.4,.4,.4,1.0> ]
*/
		[ 0.1  color rgbt<.4,.4,.4,1.0> ]
		[ 0.4  color rgbt<.5,.5,.5,1.0> ]
		[ 0.7  color rgbt<.96,.96,.96,.6> ]
		[ 1.0  color rgbt<.8,.8,.8,.3> ]

			} // color_map
			scale 10000
			turbulence .5
		}
		normal { bumps .13 scale 400 }
		finish { ambient .15 diffuse .7 specular .2 roughness .05 }
	}


//===============================================
//             Lighting
//===============================================

//object {StdBulb60Watt translate <-4*Feet,-18*Feet,14*Feet> }
//object {StdBulb60Watt translate <-40*Feet,12*Feet,14*Feet> }
#declare Sun =
  light_source {
 	  <0,0,0>
//   	colour rgb <5.0, 4.0, 3.0> // blindingly bright
//   	colour rgb <3.7, 2.8, 2.0> // pretty darn bright
   	colour rgb <1.5, 1.2, .9> // fairly bright
//   	colour rgb <1, .8, .6> // rather dimmish
//		area_light <.2*Miles,0,0>,<0,.2*Miles,0> 3, 3
	}



//===============================================
//             Environment
//===============================================

background { color rgb <0.2, 0.4, 0.8> } // light blue
//background { color rgb <0.0, 0.0, 0.0> } // black
//#include "skies.inc"
//sky_sphere { S_Cloud5 rotate <90,0,0> }

sky_sphere {
    pigment {
      gradient z
      color_map {
        [ 0.5  color rgb<.99,.99,.99> ]
        [ 0.6  color rgb<.22,.22,.75> ]
      }
      scale 2
      translate -1
    }
  }

//object { O_Cloud1 rotate <90,0,0> }
//object {GroundPlaneWhite translate z*-0}

//#include "World.inc"

#declare NearbyMountains =
	height_field {
		png "MountHF1.png"
		rotate x*90 // set up for RH coordinate system
		translate <-.5,.5,-0.005> //center on origin // sink it below local area
//		translate <-.5,.5,0> //center on origin
		scale <18000,18000,800> // finally, scale it up
//		texture { GreenGrass } // test
//		texture { EarthTex }
// NOTE: because of scaling, center region is about 8 below zero
	}

#declare Plain =
	difference {
		plane {
			z,0
			texture { EarthTex }
		}
		object { NearbyMountains // depression for water
			rotate x*180
			translate <2000*Feet,0,10*Feet>
			texture { GreenGrass }
		}
/*
		cylinder {
			<0,0,-44*Feet>,<0,0,44*Feet>,555*Feet
			translate <1500*Feet,0,0>
			texture { EarthTex }
		}
*/
	}
object { Plain }
#declare WaterBelow =
	plane {
		z,-18
		texture {
			pigment { color rgbf<.4,.7,1.0,.6> }
			normal { bumps .2 scale 30 }
			finish { ambient .1 specular 1 roughness .02 reflection .2 }
		}
	}
object { WaterBelow }


#declare Clouds =
	plane {
		-z,0
		texture { CloudTex }
	}
object { Clouds translate 3000*Feet }

#ifndef (NoFog) #declare NoFog=0 #end
#if (NoFog=0)
fog {
	fog_type 1 // general fog adds distance
//		distance 12000*Feet
		distance 22000*Feet
		color rgbt<.980,.980,.998,.06> // transmittance (lower trans dulls out sky)
		turbulence .001
	}
#end

