
// Glenn's Cranes POV-Ray Object File
// This file does not render.  #include "Cranes.inc" in another .pov file
// created 17-Mar-98  updated 19-Mar-98
// copyright 1998 Glenn McCarter

// Various cranes and cranelike objects
// Intended scale is English system (inches)
//
// Crane1 front is +X, extends into -X

//===============================================
//             Textures
//===============================================

#declare CBodyTex =
	texture {
		pigment { color rgb<.60,.60,.84> }
		normal { bumps .1 scale 30 }
		finish { ambient .1 diffuse .7 specular 1.0 roughness .01 }
	}

//===============================================
//             Objects
//===============================================

//---------------- Crane 1 - steamshovel type ------------
#declare StabilizerRod =
	union {
		cylinder { //casing
			<0,0,12>,<0,0,24>,6
			texture { SteelTex }
		}
		cylinder { //piston
			<0,0,0>,<0,0,13>,4
			texture { BrightMetal }
		}
		cylinder { //back
			<0,0,0>,<0,0,34>,3
			texture { BrightMetal }
			translate <14,0,0>
		}
	}
#declare StabFoot =
	union {
		object { StabilizerRod rotate y*45 }
		box { // foot
			<-9,-6,0>,<9,6,4>
			texture { DullMetal }
		}
		cylinder {
			<0,0,0>,<0,0,12>,4.2
			texture { CBodyTex }
			translate <12,0,15>
		}
	}
#declare CraneBase =
	union {
	difference {
		union {
			box {
				<-6*Feet,-8*Feet,4>,<6*Feet,8*Feet,3*Feet>
			}
			cylinder { // track
				<-6*Feet,-8*Feet,20>,<-6*Feet,8*Feet,20>,16
			}
			cylinder { // front track
				<6*Feet,-8*Feet,20>,<6*Feet,8*Feet,20>,16
			}
			cylinder { // pivot
				<0,0,3*Feet>,<0,0,4*Feet>,26
			}
			texture { SteelTex }
		} // end union
		box { // cutout
			<-11*Feet,-9*Feet,0>,<11*Feet,9*Feet,28>
			texture { SteelTex }
		}
	} // end difference
	object { StabFoot rotate z*30  translate <-6*Feet,-7*Feet,0> }
	object { StabFoot rotate z*-30 translate <-6*Feet, 7*Feet,0> }
	object { StabFoot rotate z*150  translate < 6*Feet,-7*Feet,0> }
	object { StabFoot rotate z*-150 translate < 6*Feet, 7*Feet,0> }
	} // end union

#declare CEngine =
	union {
		difference {
			sphere {
				<0,0,0>,11
				scale <6,1,1>
				texture { CBodyTex }
				clipped_by { box{<-5*Feet,-30,-30>,<5*Feet,30,30>}}
			}
			cylinder {
				<-8*Feet,0,0>,<8*Feet,0,0>,4.5
				texture { FlatBlack }
			}
		} // end difference
		torus { // end ring
			4,.7
			texture { ChromeTex }
			rotate z*90
			scale <1.6,1,1>
			translate <-4.8*Feet,0,0>
		}
		torus { // end ring
			4,.7
			texture { ChromeTex }
			rotate z*90
			scale <1.6,1,1>
			translate <4.8*Feet,0,0>
		}
		sphere { // center blocker
			<0,0,0>,10
			texture { FlatBlack }
		}
	} // end union

#declare Boom =
	union {
		box {
			<0,-10,-10>,<80*Feet,10,10>
			texture { Grey50Paint }
			translate <0,16,0>
		}
		box {
			<0,-10,-10>,<80*Feet,10,10>
			texture { Grey50Paint }
			translate <0,-16,0>
		}
	}
#declare BackBoom =
	box {
		<0,-10,-10>,<18*Feet,10,10>
		texture { Grey50Paint }
	}
#declare Cab =
	union {
		box { // main
			<-6*Feet,-6*Feet,0>,<6*Feet,6*Feet,7*Feet>
			texture { SteelTex }
		}
		box { // roof
			<-6.7*Feet,-6.7*Feet,6.95*Feet>,<6.7*Feet,6.7*Feet,7.2*Feet>
			texture { SteelTex }
		}
		box { // smallroofbox
			<-2*Feet,-2*Feet,7*Feet>,<5*Feet,-6*Feet,8.3*Feet>
			texture { SteelTex }
		}
		box { // windshield
			<-1*Feet,-6.1*Feet,3.5*Feet>,<6.1*Feet,6.1*Feet,5.9*Feet>
			texture { GBlueGlass }
		}
		object { BackBoom rotate y*-110 translate <-4*Feet,0,7*Feet> }
		translate <0,0,4*Feet>
	}
#declare Cable =
	cylinder {
		<0,0,0>,<0,0,62*Feet>,.58
		texture { BlackPaint }
	}

//---------------- Crane 2 - loading dock A-frame type ------------
