
// Glenn's Hangar POV-Ray Object File
// This file does not render.  #include "Hangar.inc" in another .pov file
// created 15-Mar-98  updated 5-Apr-98
// copyright 1998 Glenn McCarter

// A futuristic hangar
// Intended scale is English system (inches), floor is +Z
// Origin in the middle of the floor, North wall at +X
// NOTE: lighting is contained in "HangarLights.inc"


//===============================================
//             Textures
//===============================================

#declare MainWhite = color rgb<1.6,1.6,1.3>
#declare CrackWhite = color rgb<1.2,1.13,1.05>
#declare JustClear = color rgbt<1,1,1,1>

#declare FloorTex =
	texture {
		pigment {
			gradient y
			color_map {
				[ 0.06 color CrackWhite ]
				[ 0.06 color MainWhite ]
				[ 0.50 color MainWhite ]
				[ 0.50 color CrackWhite ]
				[ 0.52 color CrackWhite ]
				[ 0.52 color MainWhite ]
			}
			translate y*20
			scale 60
		}
		normal { bumps .1 scale 33 }
		finish { ambient .34 specular .7 roughness .005 }
	}
	texture {
		pigment {
			gradient y
			color_map {
				[ 0.06 color CrackWhite ]
				[ 0.06 color JustClear ]
				[ 0.50 color JustClear ]
				[ 0.50 color CrackWhite ]
				[ 0.52 color CrackWhite ]
				[ 0.52 color JustClear ]
			}
			translate y*20
			scale 60
			rotate z*90
		}
		normal { bumps .1 scale 33 }
		finish { ambient .34 specular .7 roughness .005 }
	}
#declare WallTex =
	texture {
		pigment { color rgb<.92,.94,1> }
		normal { bumps .1 scale 33 }
		finish { ambient .22 specular .7 roughness .005 }
	}
#declare ColumnTex =
	texture {
		pigment { color rgb<1,1,.94> }
		normal { bumps .1 scale 33 }
		finish { ambient .22 specular .7 roughness .005 }
	}
#declare GlossyBlack =
	texture {
		pigment { color rgb<.05,.05,.12> }
		normal { bumps .05 scale 3 }
		finish { ambient .03 specular .95 roughness .002 }
	}
#declare OuterSkinTex =
	texture {
		pigment { color rgb<.48,.40,.44> }
		normal { bumps .1 scale 4 }
		finish { ambient .1 diffuse .7 specular .3 roughness .12 }
	}


//===============================================
//             Objects
//===============================================

#declare HangarWidth = 100*Feet
#declare HW = HangarWidth
#declare HangarLength = 140*Feet
#declare HL = HangarLength
#declare HangarHeight = 50*Feet
#declare HH = HangarHeight

#declare Floor =
	box {
		<-HL/2,-HW/2,-6>,<HL/2,HW/2,0>
		texture { FloorTex }
	}
#declare Ceiling =
	union {
		box {
			<-HL/2,-HW/2,0>,<HL/2,HW/2,6>
			texture { FloorTex }
		}
		box { // top outer cover
			<-HL/2,-HW/2,5>,<HL/2,HW/2,9>
			texture { OuterSkinTex }
		}
	}
#declare NorthWall =
	box {
		<0,-HW/2,0>,<6,HW/2,HH>
		texture { WallTex }
	}

//Thanks to Jamie Vives for the material map technique used here.
#declare NWallTex =
texture {
	material_map{
		gif "QuikWall1.gif"
		texture { Grey30Paint }
		texture { Grey50Paint }
		texture { WallTex scale 1/HW }
		texture { Grey80Paint }
		texture { WhitePaint }
		texture { Grey50Paint }
		texture { Grey30Paint }
	}
}

#declare BetterNorthWall =
	height_field {
		gif "QuikWall1.gif"
		smooth
		rotate -90*x
		texture { NWallTex }      // maping the material_map on to the height_field
		rotate <90,0,90>
		translate <0,-0.5,0>
		scale <-200*Feet,HW,HH>
 }

#declare SouthWall =
	box {
		<-6,-HW/2,0>,<0,HW/2,HH>
		texture { WallTex }
	}
#declare EastWall =
	box {
		<-HL/2,-6,0>,<HL/2,0,HH>
		texture { WallTex }
	}
#declare WestWall =
	union {
		box {
			<-HL/2,0,0>,<HL/2,36,HH>
			texture { WallTex }
		}
	} // end union
#declare BetterWestWall =
	union {
		difference { // cutout doorway
			height_field {
				gif "QuikWall1.gif"
				smooth
				rotate -90*x
				texture { NWallTex }      // maping the material_map on to the height_field
				rotate <90,0,90>
				translate <0,-0.5,0> // now standing on X=0 plane, extending into +/-Y
				rotate z*90
				scale <HL,-200*Feet,HH>
		 }
			box { // doorway
				<-2*Feet,-16,0>,<2*Feet,16,7*Feet>
				translate <HL/2-12*Feet,0,0>
				texture { WhitePaint }
			}
		} // end difference
	} // end union

#declare HugeWindowCutout =
	box {
		<-HL/2+10*Feet,-8,10*Feet>,<HL/2-60*Feet,2,HH-10*Feet>
		texture { WallTex }
	}
#declare SmallWindowCutout =
	box {
		<-10*Feet,-8,-5*Feet>,<10*Feet,2,5*Feet>
		texture { WallTex }
	}

#declare BetterEastWall =
	difference {
		box {
			<-HL/2,-6,0>,<HL/2,0,HH>
			texture { WallTex }
		}
		object { SmallWindowCutout translate <-45*Feet,0,23*Feet> }
	} // end difference

#declare BigColumn =
	union {
		difference { // cutout door
			cylinder { // main
				<0,0,0>,<0,0,HH>,5*Feet
				texture { ColumnTex }
			}
			box {
				<-1.8*Feet,-6*Feet,0>,<1.8*Feet,0,7*Feet>
				texture { WallTex }
			}
		} // end difference
		box { // vert rib
			<-3,-6.1*Feet,0>,<3,6.1*Feet,HH>
			rotate z*45
			texture { WallTex }
		}
		box { // vert rib
			<-3,-6.1*Feet,0>,<3,6.1*Feet,HH>
			rotate z*-45
			texture { WallTex }
		}
		cylinder { // roof
			<0,0,0>,<0,0,6>,6.2*Feet
			texture { WallTex }
			translate <0,0,7.6*Feet>
		}
	}

#declare SimpleHangar = // simple room
	union {
		object { Floor }
		object { Ceiling translate <0,0,HH> }
		object { NorthWall translate <HL/2,0,0> }
		object { SouthWall translate <-HL/2,0,0> }
		object { EastWall translate <0,-HW/2,0> }
		object { WestWall translate <0,HW/2,0> }
	}

#declare BetterHangar = // more detailed
	union {
		object { Floor }
		object { Ceiling translate <0,0,HH> }
		object { NorthWall translate <HL/2,0,0> }
		object { SouthWall translate <-HL/2,0,0> }
		object { BetterEastWall translate <0,-HW/2,0> }
		object { WestWall translate <0,HW/2,0> }
	}

#declare BigHangar = // two adjacent rooms
	union {
		object { Floor }
		object { Floor translate <HL*2/3,HW,0> }
		object { Ceiling translate <0,0,HH> }
		object { Ceiling translate <HL*2/3,HW,HH> }
		object { BetterNorthWall translate <HL/2,0,0> }
		object { NorthWall translate <HL/2+HL*2/3,HW,0> }
		object { SouthWall translate <-HL/2,0,0> }
		object { BetterEastWall translate <0,-HW/2,0> }
		object { BetterEastWall translate <HL+4,HW/2,0> }
		object { BetterWestWall translate <-HL*1/3,HW/2,0> }
		object { BetterWestWall translate <HL*2/3,HW/2+HW,0> }
		object { BigColumn rotate z*23 translate <HL/2-HL*1/3,HW/2,0> } // near
		object { BigColumn translate <HL*2/3,HW/2+HW*7/8,0> } // far room
	}

//#declare Hangar = object { BetterHangar }
#declare Hangar = object { BigHangar }
