
// Glenn's POV-Ray Animation File - Air Freight Scene 0C, "InterTitles"
// created 10-Apr-98
// last update 10-Apr-98
// copyright 1998 Glenn McCarter

#include "GIncludeRH.inc"
#include "AFTextures.inc"
//#include "GRuler.inc"
#declare NoFog=1
//#declare Sclock = 1.0 // 0 to 1.0


#version 3.0
global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.0
  hf_gray_16 off
  irid_wavelength <0.25,0.18,0.14>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 5
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}


//===============================================
//             Variables
//===============================================


//===============================================
//             Cameras
//===============================================

#declare SignPoint = <0,0,48>

#declare Render_Cam =
	camera {
  perspective
  direction <0.0,     1.0,  0.0>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
	angle 50
	location SignPoint-<5*Feet,0,0>
  look_at SignPoint
}

#declare Special_Cam =
  camera {
  direction <0.0,     1.0,  0.0>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
    angle 50
//    direction z*50
//	location <40*Feet,-90*Feet,6*Feet>
//	look_at <71*Feet,0,5*Feet>
  }

camera { // special cameras declared in GCamerasRH.inc
//  Special_Cam
  Render_Cam
  }

//===============================================
//             Textures
//===============================================



//===============================================
//             Lighting
//===============================================

//object {StdBulb60Watt translate <-4*Feet,-18*Feet,14*Feet> }
object {FadeBulb60Watt translate <-40*Feet,12*Feet,14*Feet> }



//===============================================
//             Environment
//===============================================

//#include "AFEnviron.inc"
//object { Sun rotate <0,0,40> translate <-20000*Miles,7000*Miles,24000*Miles> }
//#include "City.inc"
//object { City translate <2*Miles,0,0> }
//object { GroundPlaneWhite }


//===============================================
//             Objects
//===============================================

#declare SignBackground =
	box {
		<0,0,0>,<1,6*Feet,4*Feet>
		translate <0.2,-3*Feet,-2*Feet>
		texture { FlatBlack }
//		texture { WhitePaint }
	}
#declare Lettering1 =
	text {
		ttf "c:\Windows\Fonts\TIMES.TTF",
		"\"Sky Train\"",
		.05,     // THICKNESS_FLOAT
		0.06*x       //OFFSET_VECTOR
//		texture { WhitePaint }
		texture { AmbientWhite }
		scale <4,3.7,1>
		rotate <90,0,-90>
		translate <0,0,0>
	}
#declare Sign =
	union {
		object { SignBackground translate <0,0,0>}
		object { Lettering1 translate <-.1,10,0> } //SkyTrain
	}


//===============================================
//             Object Placement
//===============================================

object { Sign translate SignPoint }

