
// Glenn's POV-Ray Animation File - Air Freight Scene 3b, "The Liftoff 2"
// created 6-Mar-98
// last update 28-Mar-98
// copyright 1998 Glenn McCarter

#include "GIncludeRH.inc"
#include "AFTextures.inc"
//#include "GRuler.inc"
#declare NoFog = 0
//#declare Sclock = .83// 0 to 1.0


#version 3.0
global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.0
  hf_gray_16 off
  irid_wavelength <0.25,0.18,0.14>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 5
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}


//===============================================
//             Variables
//===============================================


//===============================================
//             Cameras
//===============================================

#declare Render_Cam =
	camera {
  perspective
  direction <0.0,     1.0,  0.0>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
	angle 45
  location <75*Feet, -20*Feet, 6*Feet-Sclock*3>
  look_at <(Sclock/3+1)*48*Feet, -0*Feet, (6*Feet+Sclock*2*Feet)>
}

#declare Special_Cam =
  camera {
  direction <0.0,     1.0,  0.0>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
    angle 50
//    direction z*50
//  location <275*Feet, -180*Feet, 816*Feet> // helicopter view
//  look_at <48*Feet, -0*Feet, 6*Feet>
  location <65*Feet, -15*Feet, 16*Feet> // cab view
  look_at <55*Feet, -0*Feet, 6*Feet>
//  location <43*Feet, -18*Feet, 7.5*Feet> // front engine view at 0.5
//  look_at <54*Feet, -9*Feet, 6*Feet>
//  location <49*Feet, -18*Feet, 9*Feet> // front engine side view at 0.5
//  look_at <54*Feet, -9*Feet, 6*Feet>
//  location <25*Feet, -18*Feet, 9*Feet> // rear engine view at 0.5
//  look_at <38*Feet, -6*Feet, 6*Feet>
  }

camera { // special cameras declared in GCamerasRH.inc
//  Special_Cam
  Render_Cam
  }

//===============================================
//             Textures
//===============================================



//===============================================
//             Lighting
//===============================================

object {FadeBulb60Watt translate <-4*Feet,-18*Feet,14*Feet> }
object {FadeBulb100Watt translate <40*Feet,40*Feet,24*Feet> }
//object {StdBulb100Watt translate <270*Feet,-200*Feet,124*Feet> }

// create a point "spotlight" (conical directed) light source
light_source
{
  0*x                     // light's position (translated below)
  color rgb <1,1,1>       // light's color
  spotlight               // this kind of light source
  translate <80*Feet, -11*Feet, 50*Feet> // <x y z> position of light
  point_at <40*Feet, 0*Feet, 0>      // direction of spotlight
  radius 45                // hotspot (inner, in degrees)
  tightness 30            // tightness of falloff (1...100) lower is softer, higher is tighter
  falloff 68               // intensity falloff radius (outer, in degrees)
}


//===============================================
//             Environment
//===============================================

#include "AFEnviron.inc"
object { Sun rotate <0,0,40> translate <-20000*Miles,7000*Miles,24000*Miles> }
#include "Buildings.inc"
#include "AFBuildings.inc"

//===============================================
//             Objects
//===============================================

#include "Container.inc"
#include "Truck1.inc"
//#include "OldTruck.inc"

#declare LoadedTrailer =
	union {
		object { Trailer }
		object { Base translate <-16*Feet,0,6*Feet+4.5> }
		object { Lid translate <-16*Feet,0,7*Feet-7> }
	}

#declare MovingTruck =
	union {
		object { LoadedTrailer translate <0,0,2*Feet> }
		object { Tractor rotate z*(Sclock*-24) translate <0,0,2*Feet> }
	}
/*
#include "OldCab.pov"
#include "OldCabWshield.pov"
#declare OldCabAssy =
	union {
		object { OldCab texture { BodyTex } }
		object { WindShield texture { AFGoldGlass } }
		rotate <90,0,0>
		scale <60,60,60>
		translate <60,0,40>
	}
#declare MovingOldCab =
	union {
		object { LoadedTrailer translate <0,0,2*Feet> }
		object { OldCabAssy rotate z*(Sclock*-24) translate <0,0,2*Feet> }
	}
*/
//===============================================
//             Object Placement
//===============================================

//object { LoadedTrailer translate <46*Feet+(Sclock*Sclock*16*Feet),0,2*Feet> }
//object { Tractor rotate z*(Sclock*-24) translate <46*Feet+(Sclock*Sclock*16*Feet),0,2*Feet> }
//object { CraneBase rotate z*150 translate x*74*Feet }

object { MovingTruck translate y*100*Feet rotate z*-Sclock*Sclock*20 translate <46*Feet,-100*Feet,0> }
//object { MovingOldCab translate y*100*Feet rotate z*-Sclock*Sclock*20 translate <46*Feet,-100*Feet,0> }

object { Bldg1 rotate z*12 translate <130*Feet,80*Feet,0> }
object { Bldg2 rotate z*12 translate <150*Feet,-50*Feet,0> }
object { Bldg2 rotate z*12 translate <220*Feet,-20*Feet,0> }
object { SmokeStack translate <300*Feet,200*Feet,0> }
object { SmokeStack translate <380*Feet,150*Feet,0> }
object { Bldg2 rotate z*102 translate <300*Feet,120*Feet,0> }
object { Fence rotate z*-75 translate <180*Feet,50*Feet,0> }
object { Fence rotate z*-145 translate <50*Feet,180*Feet,0> }
object { DBldg3 scale <1,1,1> rotate z*0 translate <-500*Feet,380*Feet,0> }
object { Bldg1 rotate z*12 translate <-130*Feet,280*Feet,0> }
object { TallPole translate <-90*Feet,230*Feet,0> }
object { TallPole translate <-160*Feet,150*Feet,-20*Feet> }
// reflections:
object { Bldg1 rotate z*12 translate <75*Feet,-90*Feet,0> }
object { TallPole translate <90*Feet,-130*Feet,0> }
object { TallPole translate <-60*Feet,-100*Feet,0> }
object { Bldg2 rotate z*-32 translate <-175*Feet,-160*Feet,0> }
object { Bldg1 rotate z*-26 translate <-130*Feet,-240*Feet,0> }
object { DBldg2 rotate z*-32 translate <-85*Feet,-330*Feet,0> }

