
// Glenn's POV-Ray Animation File - Air Freight Scene 4b, "The Express"
// created 8-Mar-98
// last update 8-Mar-98
// copyright 1998 Glenn McCarter

#include "GIncludeRH.inc"
#include "AFTextures.inc"
//#include "GRuler.inc"
#declare NoFog = 0
//#declare Sclock = 0.0 // 0 to 1.0


#version 3.0
global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.0
  hf_gray_16 off
  irid_wavelength <0.25,0.18,0.14>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 5
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}


//===============================================
//             Variables
//===============================================


//===============================================
//             Cameras
//===============================================

// flyers: 240 feet/sec = 163 mph, 4 sec shot
#declare FlyPoint = <(Sclock*176*Feet*4)+528*Feet,1,8*Feet>

#declare Render_Cam =
	camera {
  perspective
  direction <0.0,     1.0,  0.0>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
	angle 45
  location FlyPoint-<180*Feet,-1,-10*Feet>
  look_at FlyPoint

}

#declare Special_Cam =
  camera {
  direction <0.0,     1.0,  0.0>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
    angle 50
//    direction z*50
//  location <-120*Feet, -120*Feet, 60*Feet>
//  location <-1200*Feet, -1200*Feet, 600*Feet>
//  location <-12*Miles, -12*Miles, 6*Miles>
//  location <-120*Miles, -120*Miles, 60*Miles>
//  location <-140*Miles, -140*Miles, 80*Miles>
//  look_at <0, 0, 100*Feet>
//  location FlyPoint-<60*Feet,-1,-10*Feet>
  location FlyPoint-<1200*Feet, 1200*Feet, -600*Feet>
  look_at FlyPoint

  }

camera { // special cameras declared in GCamerasRH.inc
//  Special_Cam
  Render_Cam
  }

//===============================================
//             Textures
//===============================================



//===============================================
//             Lighting
//===============================================

//object {FadeBulb60Watt translate <-4*Feet,-18*Feet,14*Feet> }
//object {FadeBulb60Watt translate <-40*Feet,12*Feet,14*Feet> }
//object {StdBulb100Watt translate <-40*Feet,12*Feet,14*Feet> }


//===============================================
//             Environment
//===============================================

#include "AFEnviron.inc"
object { NearbyMountains rotate z*185 translate <500*Feet,700*Feet,0> texture { EarthTex } }
object { NearbyMountains translate <500*Feet,-700*Feet,0>  texture { EarthTex } }

object { Sun rotate <0,0,40> translate <-20000*Miles,7000*Miles,24000*Miles> }
#include "AFCity.inc"
object { City translate <2*Miles,0,0> }

//===============================================
//             Objects
//===============================================

#include "Container.inc"
#include "Truck1.inc"
#include "Cargo.inc"

#declare LoadedTrailer =
	union {
		object { Trailer }
		object { Base translate <-16*Feet,0,6*Feet+4.5> }
		object { Lid translate <-16*Feet,0,7*Feet-7> }
	}

#declare CrateTruck =
	union {
		object { LoadedTrailer translate <0,0,2*Feet> }
		object { Tractor translate <0,0,2*Feet> }
	}
#declare EmptyTruck =
	union {
		object { Trailer translate <0,0,2*Feet> }
		object { Tractor translate <0,0,2*Feet> }
	}
#declare CargoTruck =
	union {
		object { Trailer translate <0,0,2*Feet> }
		object { Tractor translate <0,0,2*Feet> }
		object { BarrelsWithStraps translate <-10*Feet,0,8*Feet+4> }
		object { TubeGroup3 translate <-35*Feet,-44,8*Feet+4> }
	}


//===============================================
//             Object Placement
//===============================================

object { CargoTruck translate <0,-4990*Feet,0> rotate -z*((1-Sclock)*11) translate <1232*Feet,5000*Feet,0> }
object { CrateTruck translate <40*Feet,-5030*Feet,0> rotate -z*((1-Sclock)*11) translate <1232*Feet,5000*Feet,2*Feet> }

