
// Glenn's POV-Ray Animation File - Air Freight Scene 5c, "Lower In - special extension"
// created 29-Mar-98
// last update 29-Mar-98
// copyright 1998 Glenn McCarter

#include "GIncludeRH.inc"
#include "AFTextures.inc"
//#include "GRuler.inc"
#declare NoFog = 0
//#declare Sclock = 1.0 // 0 to 1.0


#version 3.0
global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.0
  hf_gray_16 off
  irid_wavelength <0.25,0.18,0.14>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 5
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}


//===============================================
//             Variables
//===============================================

//#declare LookPoint = <6*Feet+Sclock*2*3*Feet,0,9*Feet> // from 5b, 2 seconds
#declare LookPoint = <12*Feet+Sclock*1*3*Feet,0,9*Feet> // 1 second

//===============================================
//             Cameras
//===============================================


#declare Render_Cam =
	camera {
  perspective
  direction <0.0,     1.0,  0.0>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
	angle 45
  location <-38*Feet, 58*Feet, 70*Feet>
  look_at LookPoint
}

#declare Special_Cam =
  camera {
  direction <0.0,     1.0,  0.0>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
    angle 50
//    direction z*50
//  location <-120*Feet, -120*Feet, 60*Feet>
//  look_at <0,0,0>
  location <-38*Feet, 58*Feet, 70*Feet>
  look_at LookPoint
  }

camera { // special cameras declared in GCamerasRH.inc
  Render_Cam
//  Special_Cam
  }

//===============================================
//             Textures
//===============================================

#declare StreetTex =
	texture {
		pigment {
			gradient y
			color_map {
				[ 0.0 color rgb<.35,.35,.35> ]
				[ 0.1 color rgb<.35,.35,.35> ]
				[ 0.1 color rgb<.5,.5,.57> ]
				[ 1.0 color rgb<.5,.5,.57> ]
			}
			translate y*-12
			scale 10*Feet
		}
		normal { bumps .3 scale 4 }
		finish { ambient .4 specular .6 roughness .06 }
	}
#declare PaveTex =
	texture {
		pigment { color rgb<.2,.2,.28> }
		normal { bumps .4 scale 2 }
		finish { ambient .25 specular .6 roughness .06 }
	}

//===============================================
//             Lighting
//===============================================

//object {FadeBulb60Watt translate <-4*Feet,-18*Feet,14*Feet> }
//object {FadeBulb60Watt translate <-40*Feet,12*Feet,14*Feet> }



//===============================================
//             Environment
//===============================================

#include "AFEnviron.inc"
object { Sun rotate <0,0,40> translate <-20000*Miles,7000*Miles,24000*Miles> }
#include "AFCity.inc"
object { City translate <50*Feet,-50*Feet,-22> }
#declare DockSide =
	box {
		<-400*Feet,-400*Feet,-4>,<400*Feet,400*Feet,0.2>
		texture { StreetTex }
	}
object { DockSide translate <0,0,.2> }
#declare CityStreet =
	box {
		<-400*Feet,-34*Feet,-4>,<400*Feet,34*Feet,0.2>
		texture { PaveTex }
	}
object { CityStreet translate <0,0,.25> }

//===============================================
//             Objects
//===============================================

#include "Container.inc"
#include "GantryCrane.inc"
#include "Truck1.inc"
#include "Cargo.inc"
#include "SkyTrain.inc"

#declare Traverse =
	difference {
		box {
			<-3*Feet,-13*Feet,-66>,<3*Feet,13*Feet,66>
			texture { BrightMetal scale .1 }
		}
		box {
			<-2*Feet,-11*Feet,-76>,<2*Feet,11*Feet,-46>
			texture { DullMetal }
		}
	}
#declare Cable =
	cylinder {
		<0,0,0>,<0,0,22*Feet>,1.58
		texture { BlackPaint }
	}
#declare MagClamp =
	cylinder {
		<0,0,0>,<0,0,12>,12
		texture { BrightMetal }
	}
#declare CableGroup =
	union {
		object { Traverse translate <0,0,49*Feet> }
		object { MagClamp translate <0,8*Feet,28*Feet> }
		object { MagClamp translate <0,-8*Feet,28*Feet> }
		object { Cable translate <0,8*Feet-9,28*Feet> }
		object { Cable translate <0,8*Feet+9,28*Feet> }
		object { Cable translate <-7,8*Feet,28*Feet> }
		object { Cable translate <0,-8*Feet-9,28*Feet> }
		object { Cable translate <0,-8*Feet+9,28*Feet> }
		object { Cable translate <-7,-8*Feet,28*Feet> }
	}

#declare LStep =
	box {
		<0,-13,0>,<6,13,1>
		texture { BrightMetal }
	}
#declare LSideRail =
	box {
		<0,-.8,0>,<11*Feet,.8,6>
		texture { WhitePaint }
	}
#declare LBase =
	box {
		<0,-22,2>,<38,22,8>
		texture { WhitePaint }
	}
#declare LadderRiser =
	union {
		object { LSideRail translate <0, 13,0> }
		object { LSideRail translate <0,-13,0> }
		object { LStep rotate y*30 translate <12,0,0> }
		object { LStep rotate y*30 translate <24,0,0> }
		object { LStep rotate y*30 translate <36,0,0> }
		object { LStep rotate y*30 translate <48,0,0> }
		object { LStep rotate y*30 translate <60,0,0> }
		object { LStep rotate y*30 translate <72,0,0> }
		object { LStep rotate y*30 translate <84,0,0> }
		object { LStep rotate y*30 translate <96,0,0> }
		object { LStep rotate y*30 translate <108,0,0> }
		object { LStep rotate y*30 translate <120,0,0> }
	}
#declare LadderAssy =
	union {
		object { LadderRiser rotate y*-60 }
//		object { LBase translate <-8,0,0> }
	}

#declare CargoTruck =
	union {
		object { Trailer translate <0,0,2*Feet> }
		object { Tractor translate <0,0,2*Feet> }
		object { BarrelsWithStraps translate <-10*Feet,0,8*Feet+4> }
		object { TubeGroup3 translate <-35*Feet,-44,8*Feet+4> }
	}

#declare EmptyTruck =
	union {
		object { Trailer translate <0,0,2*Feet> }
		object { Tractor translate <0,0,2*Feet> }
	}


//===============================================
//             Object Placement
//===============================================

object { EmptyTruck rotate z*13 translate <62*Feet,35*Feet,0> }
object { GantryCrane translate <12*Feet,0,0> }
object { LoadingTrain scale 2 translate <-160*Feet,0,3*Feet> }
object { LadderAssy rotate z*-90 translate <8*Feet,15*Feet,0> }
object { Pallet translate <-12*Feet,0,7*Feet> } // inside
object { BarrelGroup translate <-12*Feet,0,7*Feet+5> } // inside
object { TubeGroup3 translate <-8*Feet,-4*Feet,7*Feet> } // inside
object { Pallet rotate z*6 translate <17*Feet,29*Feet,2> }
object { BarrelGroup rotate z*6 translate <17*Feet,29*Feet,7> }

//object { ContainerAssy rotate z*0 translate <12*Feet,0,21*Feet-Sclock*3*Feet> } // from 5b
object { ContainerAssy rotate z*0 translate <12*Feet,0,18*Feet-Sclock*1.5*Feet> }

//object { CableGroup translate <12*Feet,0,3*Feet-Sclock*3*Feet> } // from 5b
object { CableGroup translate <12*Feet,0,0*Feet-Sclock*1.5*Feet> }
