
// Glenn's Tiny Body POV-Ray Object File
// This file does not render.  #include "TinyBody.inc" in another .pov file
// created 12-Apr-98  updated 12-Apr-98
// copyright 1998 Glenn McCarter

// Bodies for tiny people (TinyPeople.inc)
// Intended scale is English system (inches)
//
// People stands at origin, looking towards -X




//===============================================
//             Variable Declarations
//===============================================

#ifndef ( Pose )
// Pose Angles ( in order )
#declare HPan     = 32   // head, positive = towards his left
#declare HTiltFwd = 15   // head forward tilt
#declare HCock    = 0    // head right/left tilt, positive = to the left
#declare TTwist   = 0    // torso twist, positive = right hip fwd
#declare HipTude  = 0    // hip attitude, positive = right hip up
#declare RWCock   = 0    // wrist side-to-side (golf)
#declare RWAng    = 0    // wrist angle
#declare RETwist  = 20   // twists the hand, positive = palms up
#declare REAng    = 70  // elbow
#declare RAFwd    = 43   // total arm
#declare RARot    = 12   // claps hands
#declare RAOut    = 12   // opens underarm
#declare RAFwd2   = 0    // total arm
#declare RARot2   = 0    // claps hands
#declare RKnee    = 0
#declare RLTwist  = 0    // leg twist
#declare RLAng    = 0    // leg angle
#declare RLOut    = 5    // spread eagle
#declare LWCock   = 20   // wrist side-to-side (golf)
#declare LWAng    = 0    // wrist angle
#declare LETwist  = 140  // twists the hand, positive = palms up
#declare LEAng    = 36   // elbow
#declare LAFwd    = 12   // total arm
#declare LARot    = 12   // claps hands
#declare LAOut    = 70    // opens underarm
#declare LAFwd2   = 0    // total arm
#declare LARot2   = -20  // claps hands
#declare LKnee    = 0
#declare LLTwist  = 0    // leg twist
#declare LLAng    = 0    // leg angle fwd
#declare LLOut    = 5    // spread eagle

// RightHand Pose Angles ( in order )
#end


//===============================================
//             Textures
//===============================================

#declare SkinTex =
	texture {
		pigment { color rgb<.9,.8,.5> }
		finish { ambient .12 specular .1 roughness .1 }
	}
#declare HairTex =
	texture {
		pigment {
			gradient x
			color_map {
				[ 0.0  color rgbt<0.3,0.15,0.05,.2> ]
				[ 0.5  color rgbt<0.1,0.04,0.04,.6> ]
				[ 1.0  color rgbt<0.3,0.15,0.05,.2> ]
			}
			turbulence .8
			scale <.15,.15,.15>
		}
		normal { granite .6 scale <.5,.5,.5> }
		finish { ambient .2 specular .1 roughness .05 }
	}

#declare ShoeTex =
	texture {
		pigment { color rgb<.5,.4,.3> }
		finish { ambient .08 specular .9 roughness .01 }
	}

//===============================================
//             Objects
//===============================================

#declare MHead =
	union {
		sphere { // main
			<0,0,0>,4.5
			scale <.9,.7,1>
			texture { SkinTex }
		}
		sphere { // hair1
			<0,0,0>,4.5
			scale <.9,.8,1>
			translate <.5,0,.4>
			texture { HairTex }
		}
		sphere { // hair2
			<0,0,0>,4.5
			scale <.9,.8,1>
			clipped_by{box{<-5,-5,2.6>,<5,5,11>}}
			translate <-.5,0,.4>
			texture { HairTex }
		}
		sphere { // nose
			<0,0,0>,1
			scale <1,.3,1>
			translate <-4,0,.6>
			texture { SkinTex }
		}
		cylinder { // neck
			<0,0,-8>,<0,0,0>,2.5
			texture { SkinTex }
		}
		object { SunGlasses translate <-4,0,1> }
		translate <0,0,7>
	} // end union

#declare TorsoHalf =
	union {
		sphere { // upper shoulders
			<0,0,0>,9
			scale <.4,1,.4>
		}
		cylinder { //torso
			<0,0,0>,<0,0,-14>,9
			scale <.4,1,1>
		}
		sphere { // lower end
			<0,0,0>,9
			scale <.4,1,.3>
			translate <0,0,-14>
		}
		rotate <10,0,0>
		clipped_by { box {<-6,0,6>,<6,-12,-30>}}
	}

#declare Torso = //center where neck/shoulder join each other
	union {
		object { TorsoHalf }
		object { TorsoHalf transform InverseY }
	}
#declare LHand = // points straight down
	sphere {
		<0,0,0>,3.5
		scale <.3,.5,1>
		translate <0,0,-3> // center at wrist
		texture { SkinTex }
	}
/*
//	object { LeftHand
	object { LeftHandWithGunFiring
			rotate <0,-90,0> // point downwards
			rotate <0,LWCock,LWAng> // wrist angles
			translate <-0.0,0.6,-1.6> // drop down, move to touch sleeve
		}
*/
#declare LLowerArm =
	union {
		object { LHand }
			cone { //lower sleeve except cuff
				<0,0,2>,1.82,<0,0,11>,2.2
				rotate <0,0,0>
				translate <0,0,0>
			}
		difference {
			cylinder { //lower sleeve outer
				<0,0,0>,<0,0,2.1>,1.9
				rotate <0,0,0>
				translate <0,0,0>
			}
			cylinder { //lower sleeve inner
				<0,0,-.1>,<0,0,6>,1.85
				rotate <0,0,0>
				translate <0,0,0>
			}
		} // end difference
		sphere { // elbow joint
			<0,0,11>,2.2
			rotate <0,0,0>
			translate <0,0,>
		}
		translate <0,0,-11> // origin at elbow
	}

#declare LeftArm = //origin at shoulder
	union {
		object { LLowerArm rotate <0,0,LETwist> rotate <0,LEAng,0> }
		sphere { // elbow end
			<0,0,0>,2.2
		}
		cone { //upper arm
			<0,0,0>,2.2,<0,0,11>,2.5
			rotate <0,0,0>
		}
		sphere { //shoulder end
			<0,0,11>,2.5
		}
		translate <0,0,-11> // origin at shoulder
	}

#declare RHand = // points straight down
	object { LHand }
/*
	object { RightHand
		rotate <0,-90,0> // point downwards
		translate <0.0,-0.6,-1.0> // drop down, move to touch sleeve
	}
*/
#declare RLowerArm =
	union {
		object { RHand }
		difference {
			cone { //lower sleeve outer
				<0,0,0>,1.9,<0,0,11>,2.2
				rotate <0,0,0>
				translate <0,0,0>
			}
			cylinder { //lower sleeve inner
				<0,0,-.1>,<0,0,6>,1.8
				rotate <0,0,0>
				translate <0,0,0>
			}
		} // end difference
		sphere { // elbow joint
			<0,0,11>,2.2
			rotate <0,0,0>
			translate <0,0,>
		}
		translate <0,0,-11> // origin at elbow
	}

#declare RightArm = //origin at shoulder
	union {
		object { RLowerArm rotate <0,0,-RETwist> rotate <0,REAng,0> }
		sphere { // elbow end
			<0,0,0>,2.2
		}
		cone { //upper arm
			<0,0,0>,2.2,<0,0,11>,2.5
			rotate <0,0,0>
		}
		sphere { //shoulder end
			<0,0,11>,2.5
		}
		translate <0,0,-11> // origin at shoulder
	}

#declare RLowerLeg =
	union {
		sphere { // knee end
			<0,0,17>,2.5
		}
		cone { // lower leg
			<0,0,0>,2.0,<0,0,17>,2.5
			rotate <0,0,0>
		}
		sphere { // shoe
			<0,0,0>,4.5
			scale <1,.6,.3>
			translate <-3.5,0,0>
			texture { ShoeTex }
		}
		translate <0,0,-17> // origin at knee
	}

#declare LLowerLeg =
	union {
		sphere { // knee end
			<0,0,17>,2.5
		}
		cone { // lower leg
			<0,0,0>,2.0,<0,0,17>,2.5
			rotate <0,0,0>
		}
		sphere { // shoe
			<0,0,0>,4.5
			scale <1,.6,.3>
			translate <-3.5,0,0>
			texture { ShoeTex }
		}
		translate <0,0,-17> // origin at knee
	}

#declare RightLeg = // origin at pelvis joint
	union {
		object { RLowerLeg rotate <0,0,-RLTwist> rotate <0,-RKnee,0> }
		sphere { // knee end
			<0,0,0>,2.5
		}
		cone { // upper leg
			<0,0,0>,2.5,<0,0,18>,3.5
			rotate <0,0,0>
		}
		sphere { // pelvis end
			<0,0,18>,3.5
		}
		translate <0,0,-18> // origin at pelvis joint
	}

#declare LeftLeg = // origin at pelvis joint
	union {
		object { LLowerLeg rotate <0,0,-LLTwist> rotate <0,-LKnee,0> }
		sphere { // knee end
			<0,0,0>,2.5
		}
		cone { // upper leg
			<0,0,0>,2.5,<0,0,18>,3.5
			rotate <0,0,0>
		}
		sphere { // pelvis end
			<0,0,18>,3.5
		}
		translate <0,0,-18> // origin at pelvis joint
	}
/*
#declare Hips =
	union {
		sphere { // top of cyl
			<0,0,0>,5
			scale <.8,1,.4>
			translate <0,0,8>
		}
		cylinder { // main part
			<0,0,0>,<0,0,8>,5
			scale <.8,1,1>
			translate <0,0,0>
		}
		sphere { // bottom of cyl
			<0,0,0>,5
			scale <.8,1,.4>
			translate <0,0,0>
		}
		sphere { // butt cheek RH
			<0,0,0>,5
			scale <1,.8,1>
			translate <0,-2,0>
		}
		sphere { // butt cheek LH
			<0,0,0>,5
			scale <1,.8,1>
			translate <0,2,0>
		}
	} // end union
*/
#declare LowerTorso =
	union {
//		object { Hips translate <-3,0,0> }
		object { LeftLeg
			rotate <-LLOut,0,0>
			translate <0,-3,0>
		}
		object { RightLeg
			rotate <RLOut,0,0>
			translate <0,3,0>
		}
	} // end union

