
// Glenn's TinyFlyers POV-Ray Object File
// This file does not render.  #include "TinyFlyers.inc" in another .pov file
// created 12-Apr-98  updated 12-Apr-98
// copyright 1998 Glenn McCarter

// Various flying vehicles, very undetailed
// Intended scale is English system (inches)
//
// extends into +X

//===============================================
//             Textures
//===============================================

#declare WBodyTex =
	texture {
		pigment { color rgb<.60,.60,.84> }
		normal { bumps .1 scale 30 }
		finish { ambient .1 diffuse .7 specular 1.0 roughness .01 }
	}
#declare VBodyTex =
	texture {
		pigment { color rgb<.94,.94,.84> }
		normal { bumps .1 scale 30 }
		finish { ambient .1 diffuse .7 specular 1.0 roughness .01 }
	}

//===============================================
//             Objects
//===============================================

#declare CylEngine =
	sphere {
		<0,0,0>,56
		scale <1,.4,.3>
		texture { WhitePaint }
	}
		
#declare CylFlyer =
	union {
		cylinder { // main
			<0,0,0>,<30*Feet,0,0>,3*Feet
			texture { WhitePaint }
		}
		sphere {
			<0,0,0>,3*Feet
			scale <3,1,1>
			texture { WhitePaint }
		}
		sphere {
			<0,0,0>,3*Feet
			scale <3,1,1>
			translate <30*Feet,0,0>
			texture { WhitePaint }
		}
		object { CylEngine translate <1*Feet,6*Feet,-2*Feet> }
		object { CylEngine translate <1*Feet,-6*Feet,-2*Feet> }
		object { CylEngine translate <22*Feet,6*Feet,-2*Feet> }
		object { CylEngine translate <22*Feet,-6*Feet,-2*Feet> }
	}

#declare VFlyer =
	union {
		cone {
			<0,0,0>,8,<26*Feet,0,0>,9*Feet
			scale <1,1,.1>
			texture { WhitePaint }
		}
		sphere {
			<0,0,0>,78
			scale <1,.3,.2>
			translate <13*Feet,6*Feet,0>
			texture { WhitePaint }
		}
		sphere {
			<0,0,0>,78
			scale <1,.3,.2>
			translate <13*Feet,-6*Feet,0>
			texture { WhitePaint }
		}
	}
