//#declare Detail_level=2
#include "ll_commn.inc"
#include "ll_brick.inc"

//  Nazrat Durand, 1997 02 23
//  A couple of imaginary blocks to add 120 degree corners
//

#declare tall2x2a = union { #declare XW=2   #declare ZW=2  #include "Makeangl.inc" }
#declare tall2x4a = union { #declare XW=4   #declare ZW=2  #include "Makeangl.inc" }
///////////////////////////////////////////////////////////////////////

#declare WedgeR = difference {
  prism {
    linear_sweep
    linear_spline
    0,           // height 1
    tall,         // height 2
    4            // TOTAL_NUMBER_OF_POINTS,
    < 0, 0>, < 1.6, 0> ,
    < 1.6 * sin (60/180*pi), -1.6 * cos (60/180*pi)>,
    < 0, 0>
  }
  prism {
    linear_sweep
    linear_spline
    -1,
    tall - wall,
    4          // number of points
    < 0, +wall>, < 1.6, +wall> ,
    < 1.6 * sin (60/180*pi), -1.6 * cos (60/180*pi) +wall>,
    < 0, +wall>
  }
}
///////////////////////////////////////////////////////////////////////

#declare WedgeL = difference {
  prism {
    linear_sweep
    linear_spline
    0,           // height 1
    tall,         // height 2
    4            // TOTAL_NUMBER_OF_POINTS,
    < 0, 0>, < 1.6, 0> ,
    < 1.6 * sin (60/180*pi), 1.6 * cos (60/180*pi)>,
    < 0, 0>
  }
  prism {
    linear_sweep
    linear_spline
    -1,
    tall - wall,
    4          // number of points
    < 0, -wall>, < 1.6, -wall> ,
    < 1.6 * sin (60/180*pi), 1.6 * cos (60/180*pi) -wall>,
    < 0, -wall>
  }
}
///////////////////////////////////////////////////////////////////////

#declare Wedge = difference {
  prism {
    linear_sweep
    linear_spline
    0,           // height 1
    tall,        // height 2
    4            // TOTAL_NUMBER_OF_POINTS,
    < 0, 0>, < 1.6, 0> ,
    < 1.6 * sin (60/180*pi), -1.6 * cos (60/180*pi)>,
    < 0, 0>
  }
  prism {
    linear_sweep
    linear_spline
    -1,
    tall - wall,
    5          // number of points
    < -1, 1>, <1.6 - wall, 0>
    < (1.6 - wall) * cos (30/180*pi), -( 1.6 - wall) * sin (30/180*pi)>,
    <-1, -1>, < -1, 1>
  }
}

///////////////////////////////////////////////////////////////////////
#declare AngleOne = union
{
  object { tall2x2a }
  object { WedgeR }
  object { WedgeL
    translate < 0, 0, 1.6 >
  }
}
///////////////////////////////////////////////////////////////////////

#declare AngleTwo = union
{
  object { tall2x2a }
  object { tall2x2a
    rotate < 0, 120, 0>
  }
  object { Wedge }
}
///////////////////////////////////////////////////////////////////////
#declare AngleThree =  union
{
  object { tall2x2a }
  object { tall2x2a
    rotate < 0, 120, 0>
  }
  object { Wedge }
  object { tall2x2a
    rotate < 0, -30, 0>
    translate <0, 0, 1.6>
  }
  object { Wedge
    rotate < 0, -30, 0 >
    translate <0, 0, 1.6>
  }
}
///////////////////////////////////////////////////////////////////////
#declare AngleFourLeft = union
{
  object { tall2x4a
    rotate < 0, 90, 0 >
    translate < 0, 0, wide*2>
  }

  object { tall2x2a
    translate < -wide*2, 0, 0 >
    rotate < 0, -60, 0 >
  }
  difference {
    prism {
      linear_sweep
      linear_spline
      0,           // height 1
      tall,         // height 2
      4            // TOTAL_NUMBER_OF_POINTS,
      < 0, 0>, < 0, 1.6> ,
      < -1.6 * sin (60/180*pi), 1.6 * cos (60/180*pi)>,
      < 0, 0>
    }
    prism {
      linear_sweep
      linear_spline
      -1,
      tall - wall,
      4          // number of points
      < +wall, -wall>, < +wall, 1.6 > ,
      < -1.6 * sin (60/180*pi) - wall, 1.6 * cos (60/180*pi) - wall>,
      < +wall, -wall>
    }
  }

  difference {
    difference {
      box {
        < 0, 0, -wall>          // low corner
        < wide*2, tall, wide*2 >  // high corner
      }
      box {
        < -wall, -wall, -wide >    // low corner
        < wide*2-wall, tall-wall, wide*2-wall >   // high corner
      }
      rotate < 0, 120, 0 >
    }
    box {
      < wall, -wall, -wide*2+wall >
      < wide*3, tall-wall, wide >
    }
  }
}

///////////////////////////////////////////////////////////////////////
#declare AngleFourRight = union
{
  object { tall2x4a
    rotate < 0, 90, 0 >
    translate < -wide*2, 0, wide*2>
  }

  object { tall2x2a
    rotate < 0, 60, 0 >
  }
  difference {
    prism {
      linear_sweep
      linear_spline
      0,           // height 1
      tall,         // height 2
      4            // TOTAL_NUMBER_OF_POINTS,
      < 0, 0>, < 0, 1.6> ,
      < 1.6 * sin (60/180*pi), 1.6 * cos (60/180*pi)>,
      < 0, 0>
    }
    prism {
      linear_sweep
      linear_spline
      -1,
      tall - wall,
      4          // number of points
      < -wall, -wall>, < +wall, 1.6 > ,
      < 1.6 * sin (60/180*pi) + wall, 1.6 * cos (60/180*pi) - wall>,
      < -wall, -wall>
    }
  }

  difference {
    difference {
      box {
        < -wall, 0, 0 >               // low corner
        < wide*2, tall, wide*2 >  // high corner
      }
      box {
        < -wide, -wall, -wall >    // low corner
        < wide*2-wall, tall-wall, wide*2-wall >   // high corner
      }
      rotate < 0, 150, 0 >
    }
    box {
      < -wide*2, -wall, -wide*2 >
      < 0, tall-wall, 0 >
    }
  }
}

///////////////////////////////////////////////////////////////////////
