/* measurements (in centimeters) */
#declare eps= 0.001
#declare flat = 0.32
#declare tall = (3*flat)
#declare baseplate = (flat/2)
#declare wide =   0.8
#declare rod = flat/2

#declare wall = 0.125

#declare stud_height= 0.16
#declare stud_radius= 0.24
#declare stud_tech_radius = (flat/2)

#declare cyl_base_rad= 0.3256
#declare cyl_base_height= 0.213

#declare tech_hole_height= (tall - wide/2)
#declare tech_hole_depth= (stud_height/2)

#declare column_inner_radius= stud_radius
#declare column_outer_radius= 0.32
#declare column_finish_radius= ((column_outer_radius-column_inner_radius)/2)

#declare thin_column_outer_radius= 0.16

#declare axle_radius= 0.16
#declare axle_length= 0.64
#declare axle_vertical_offset= 0.14

#declare tech_hole_inner_rad= stud_radius
#declare tech_hole_outer_rad= (stud_radius+0.02)
#declare tech_axle_height= 0.08
#declare tech_axle_width= (tech_hole_inner_rad - 0.02)
#declare tech_geartooth_height= (wide-(2*tech_hole_outer_rad))
#declare tech_gear_8_rad= (tech_hole_outer_rad)
#declare tech_gear_16_rad= (tech_hole_outer_rad+(wide/2))
#declare tech_gear_24_rad= (tech_hole_outer_rad+wide)
#declare tech_gear_40_rad= (tech_hole_outer_rad+(wide*2))

#declare edge= 0.025
#declare mf_edge= 0.05

#declare logo_r= 0.01

#declare grispace= ((wide - (3*wall))/2)

#declare arm_length= (1.2*wide)

#declare control_socket_radius= (flat)
#declare control_lever_radius=   (stud_height/2)
#declare control_lever_length=  ((2*wide) - (1.5*control_lever_radius))

#declare ramp_lower_height= 0.20
#declare ramp_inner_height= (ramp_lower_height-edge-0.07071*(wall-edge))

#declare clip_spacing= (flat/2)
#declare clip_inner_spacing= ((wide - (0.8*flat))/2)
#declare clip_height= (wide - (wall/2))

#declare clip_offset= ((wide - flat)/2)

#declare head_finish= 0.09

#declare hip_height= (3.5 * flat)
#declare thigh_rad= ((wide/2)   - (5*wall/12))
#declare airtank_rad= 0.3

#declare side_thickness=  ((wide/2) - stud_radius)
#declare tree_slab_height= ((14*flat)/19)
#declare tree_branch_gap= ((11*flat)/16)
#declare tree_branch_size= (1.5*tree_branch_gap)

#declare thin_antenna_radius= (flat/3)