#version 3.1;

global_settings { assumed_gamma 2.2 }

#include "colors.inc"

#declare Start = 0;
#declare numFrames = 970;
#declare frameCounter = Start - 90 + (numFrames- Start)*clock;

#declare camLoc = array[numFrames]
#declare camLook = array[numFrames]
#include "camLoc.inc"
#include "camLook.inc"

camera {
  location camLoc[frameCounter+89]
  look_at camLook[frameCounter+89]
}

light_source { <-10, 20, -10> color red 1 green 1 blue 1 }

#declare numDominos = 5200;

#declare xPos = array[numDominos]
#declare zPos = array[numDominos]
#declare domEq = array[numDominos]
#declare theta = array[numDominos]
#declare domColor = array[numDominos]
#declare angles = array[14] {
  6,18,30,35.5,45.5,53.5,56.5,61.5,64.5,66,67.5,68.5,69.5,70
}


#include "domEq.inc"
#include "theta.inc"
#include "xPos.inc"
#include "zPos.inc"
#include "domColor.inc"

#declare Ball =
  sphere {
    <-.315, 0, 0>, 0.20
    texture {
      pigment {
        color Gray75
      }
      finish {
        ambient 0.4
        specular 0.6
      }
    }
  }

#declare i=0;
#while (i < numDominos)

#switch (mod(domEq[i],7))
  #case (0)
    #declare domTop =
      box{
        <-0.125, 0.500, -0.250>,<0.125, 1.000, 0.250>
    }
  #break
  #case (3)
    #declare domTop = difference {
      box{
        <-0.125, 0.500, -0.250>,<0.125, 1.000, 0.250>
      }
      #object{
        Ball
        translate <0.000, 0.750 , 0.000>
      }
    }
  #break
  #case (2)
    #declare domTop = difference {
      box{
        <-0.125, 0.500, -0.250>,<0.125, 1.000, 0.250>
      }
      #object{
        Ball
        translate <0.000, 0.900 , -0.150>
      }
      #object{
        Ball
        translate <0.000, 0.600 , 0.150>
      }
    }
  #break
  #case (1)
    #declare domTop = difference {
      box{
        <-0.125, 0.500, -0.250>,<0.125, 1.000, 0.250>
      }
      #object{
        Ball
        translate <0.000, 0.750 , 0.000>
      }
      #object{
        Ball
        translate <0.000, 0.900 , -0.150>
      }
      #object{
        Ball
        translate <0.000, 0.600 , 0.150>
      }
    }
  #break
  #case (4)
    #declare domTop = difference {
      box{
        <-0.125, 0.500, -0.250>,<0.125, 1.000, 0.250>
      }
      #object{
        Ball
        translate <0.000, 0.900 , -0.150>
      }
      #object{
        Ball
        translate <0.000, 0.900 , 0.150>
      }
      #object{
        Ball
        translate <0.000, 0.600 , -0.150>
      }
      #object{
        Ball
        translate <0.000, 0.600 , 0.150>
      }
    }
  #break
  #case (5)
    #declare domTop = difference {
      box{
        <-0.125, 0.500, -0.250>,<0.125, 1.000, 0.250>
      }
      #object{
        Ball
        translate <0.000, 0.900 , -0.150>
      }
      #object{
        Ball
        translate <0.000, 0.900 , 0.150>
      }
      #object{
        Ball
        translate <0.000, 0.750 , 0.000>
      }
      #object{
        Ball
        translate <0.000, 0.600 , -0.150>
      }
      #object{
        Ball
        translate <0.000, 0.600 , 0.150>
      }
    }
  #break
  #case (6)
    #declare domTop = difference {
      box{
        <-0.125, 0.500, -0.250>,<0.125, 1.000, 0.250>
      }
      #object{
        Ball
        translate <0.000, 0.900 , -0.150>
      }
      #object{
        Ball
        translate <0.000, 0.900 , 0.000>
      }
      #object{
        Ball
        translate <0.000, 0.900 , 0.150>
      }
      #object{
        Ball
        translate <0.000, 0.750 , -0.150>
      }
      #object{
        Ball
        translate <0.000, 0.750 , 0.000>
      }
      #object{
        Ball
        translate <0.000, 0.750 , 0.150>
      }
      #object{
        Ball
        translate <0.000, 0.600 , -0.150>
      }
      #object{
        Ball
        translate <0.000, 0.600 , 0.000>
      }
      #object{
        Ball
        translate <0.000, 0.600 , 0.150>
      }
    }
  #break
#end

#switch (mod(domEq[i],6))
  #case (4)
    #declare domBottom =
      box{
        <-0.125, 0.500, -0.250>,<0.125, 0.000, 0.250>
    }
  #break
  #case (0)
    #declare domBottom = difference {
      box{
        <-0.125, 0.500, -0.250>,<0.125, 0.000, 0.250>
      }
      #object{
        Ball
        translate <0.000, 0.250 , 0.000>
      }
    }
  #break
  #case (2)
    #declare domBottom = difference {
      box{
        <-0.125, 0.500, -0.250>,<0.125, 0.000, 0.250>
      }
      #object{
        Ball
        translate <0.000, 0.400 , -0.150>
      }
      #object{
        Ball
        translate <0.000, 0.100 , 0.150>
      }
    }
  #break
  #case (3)
    #declare domBottom = difference {
      box{
        <-0.125, 0.500, -0.250>,<0.125, 0.000, 0.250>
      }
      #object{
        Ball
        translate <0.000, 0.250 , 0.000>
      }
      #object{
        Ball
        translate <0.000, 0.400 , -0.150>
      }
      #object{
        Ball
        translate <0.000, 0.100 , 0.150>
      }
    }
  #break
  #case (1)
    #declare domBottom = difference {
      box{
        <-0.125, 0.500, -0.250>,<0.125, 0.000, 0.250>
      }
      #object{
        Ball
        translate <0.000, 0.400 , -0.150>
      }
      #object{
        Ball
        translate <0.000, 0.400 , 0.150>
      }
      #object{
        Ball
        translate <0.000, 0.100 , -0.150>
      }
      #object{
        Ball
        translate <0.000, 0.100 , 0.150>
      }
    }
  #break
  #case (5)
    #declare domBottom = difference {
      box{
        <-0.125, 0.500, -0.250>,<0.125, 0.000, 0.250>
      }
      #object{
        Ball
        translate <0.000, 0.400 , -0.150>
      }
      #object{
        Ball
        translate <0.000, 0.400 , 0.150>
      }
      #object{
        Ball
        translate <0.000, 0.250 , 0.000>
      }
      #object{
        Ball
        translate <0.000, 0.100 , -0.150>
      }
      #object{
        Ball
        translate <0.000, 0.100 , 0.150>
      }
    }
  #break
#end

#declare Domino = union {
  #object {
    domTop
  }
  #object {
    domBottom
  }
}

  #declare domMultiplier = domEq[i] * 3 + 11;
  #if (domMultiplier >= frameCounter)
    #if (domMultiplier < frameCounter + 14)
      #declare domFallPosition = 13 + frameCounter - (domMultiplier);
    #else
      #declare domFallPosition = -1;
    #end
  #else
    #declare domFallPosition = 13;
  #end

  #object {
    Domino
      texture {
        pigment {
          color domColor[i]
        }
        finish {
          ambient 0.45
          diffuse 0.8
          phong 1.0
        }
      }
    translate -x * 0.125
    #if (domFallPosition > -1)
      rotate -z * angles[domFallPosition]
    #end
    rotate y * theta[i]
    translate <xPos[i] + 0.125, 0, zPos[i]>
  }
#declare i = i + 1;
#end

plane {
  y, 0.0
  pigment {color White}
  finish {ambient .2}
}
