
#declare front_wheel =
intersection{
    superellipsoid {
        <1, 0.25>
        scale <0.45,0.45,0.2>
        translate <0.0, 0.45, 1.5>
        texture {wheel_rubber}
        }
    cone {<0.0,0.45,1.5> 0.2 <0.0,0.45,1.71> 0.25 inverse
        texture {wheel_colour}
        }
    }


#declare rear_wheel =
intersection{
    superellipsoid {
        <1, 0.25>
        scale <0.45,0.45,0.25>
        translate <0.0, 0.45, 1.45>
        texture {wheel_rubber}
        }
    cone {<0.0,0.45,1.5> 0.2 <0.0,0.45,1.71> 0.25 inverse
        texture {wheel_colour}
        }
    }


#declare front_suspension =
union{
    union{
        cylinder{<0.0,0.3,-1.3><0.0,0.3,1.3> 0.03}
        cylinder{<0.0,0.45,-1.3><0.0,0.45,1.3> 0.03}

        cylinder{<0.2,0.7,0.0><0.0,0.3,-1.3> 0.03}
        cylinder{<0.2,0.7,0.0><0.0,0.3,1.3> 0.03}

        cylinder{<0.0,0.6,-1.3><0.5,0.6,0> 0.03}
        cylinder{<0.0,0.6,-1.3><-0.5,0.6,0> 0.03}
        cylinder{<0.0,0.6,1.3><0.5,0.6,0> 0.03}
        cylinder{<0.0,0.6,1.3><-0.5,0.6,0> 0.03}
        texture{black_parts}
        }
    union{
        cylinder{<0.0,0.45,1.25><0.0,0.45,1.3> 0.23}
        cylinder{<0.0,0.45,-1.25><0.0,0.45,-1.3> 0.23}
        texture{dark_metal}
        }
    }

#declare front_wing =
union{
    union {
        cylinder {<0.0,0.0,0.0><0.0,1.0,0.0>1.0
        scale <0.2,0.3,0.04> translate <-1.0,0.17,-0.16>}
        cylinder {<0.0,0.0,0.0><0.0,1.0,0.0>1.0
        scale <0.2,0.3,0.04> translate <-1.0,0.17,0.16>}
        texture{black_parts}
        }

    box {<-1.3,0.17,-1.27><-0.75,0.2,1.27>texture{black_parts}}

    intersection {
        union {
            box {<-1.35,0.16,-1.29><-0.47,0.5,-1.26>}
            box {<-1.35,0.16,1.26><-0.47,0.5,1.29>}
            }
        plane {y, 0 rotate z*20 translate <-1.35,0.3,0.0>}
        texture {parts_colour}
        }
    }

#declare driver_unit =
union{
    intersection{
        cone {<0.0,0.0,0.0> 1.6 <0.0,1.0,0.0>1.0
            scale <0.9,0.12,0.30> translate <2.2,0.79,0.0> texture {parts_colour}}
        plane {y, 0.87 texture{dull_black}}
        }
    cylinder {<0.0,0.0,0.0><1.0,0.0,0.0>1.0
         scale <0.1,0.52,0.27> rotate z*8 translate <2.145,0.86,0.0>
        texture{dull_black}}

    union{
    cylinder {<1.8,0.7,0.0><1.9,1.0,0.0>0.23}
    sphere {<1.9,1.0,0.0>0.23}
    texture{helmet_colour}
    }
    intersection {
        cylinder {<1.8,0.7,0.0><2.0,1.3,0.0>0.24}
        box {<1.6,0.92,-0.3><1.9,1.07,0.3>}
        texture{black_parts}}
    }

#declare car_rear =
union{
    box {<2.6,0.17,-1.2><4.5,0.6,1.2>texture{body_colour}}
    box {<4.5,0.17,-1.2><4.55,0.6,1.2>texture{dull_black}}
    box {<4.5,0.6,-0.97><4.55,0.9,0.97>texture{dull_black}}
    }
#declare rear_wing =
union{
    union{
        box {<4.4,0.45,-0.98><4.8,1.3,-0.95>}
        box {<4.4,0.45,0.95><4.8,1.3,0.98>}
        texture{parts_colour}
        }
    union{
        box {<-0.4,-0.03,-0.97><0.0,0.0,0.97> rotate z*0 translate <4.8,0.71,0.0> }
        box {<-0.4,-0.03,-0.97><0.0,0.0,0.97> rotate z*7 translate <4.8,1.0,0.0> }
        box {<-0.4,-0.03,-0.97><0.0,0.0,0.97> rotate z*14 translate <4.8,1.3,0.0> }
        texture{black_parts}
    }
}


#declare Full_car = union{
object{car_body texture {body_colour}}
object{front_wing}
object{front_wheel}
object{front_wheel rotate <0,180,0>}
object{front_suspension}
object{driver_unit}
object{car_rear}
object{rear_wing}
object{rear_wheel translate x*4.15}
object{rear_wheel rotate <0,180,0> translate x*4.15 }

rotate <0,90,0>
scale 18
}
