//CHECK AND DECLARE DEFAULT VALUES
#declare inches = 25.4
#declare feet = inches*12
#declare mm = 1
#declare cm = 10
#declare metre = 1000

#declare R_inner_curve = 5.5*inches
#declare R_standard_curve = 11.625*inches
#declare R_outer_curve = 17.75*inches
#declare R_outer_outer_curve = 23.875*inches
#declare Length_D = 13.75*inches
#declare Length_C = 6.875*inches
#declare Length_B = 3.4375*inches
#declare Length_A = 3.0625*inches


#ifndef (Trackplot) #declare Trackplot = off #end

#ifndef (TIME_LOCATE) #declare TIME_LOCATE = off #end

#ifndef (DIST_LOCATE) #declare DIST_LOCATE = off #end

#ifndef (INPUT_CLOCK) #declare INPUT_CLOCK = 0 #end

#ifndef (INPUT_DISTANCE) #declare INPUT_DISTANCE = 0 #end

#ifndef (seg_gap) #declare seg_gap = 0.05*inches #end   //small gap between joins

#ifndef (seg_high) #declare seg_high = 8 #end   //hight of track

#ifndef (t_width) #declare t_width = 3.0625*inches #end  //half full width of track

#ifndef (s_length) #declare s_length = Length_D #end  //length of straight

#ifndef (s_skew) #declare s_skew = 0 #end //amount of skew on straight

#ifndef (c_angle) #declare c_angle = 45.0 #end   //angle of corner in degrees

#ifndef (c_strength) #declare c_strength = R_standard_curve #end  //radius of corner to center of track

#ifndef (T_POS) #declare T_POS = <0.0,0.0,0.0> #end  //start position of next segment

#ifndef (T_ANG) #declare T_ANG = <0.0,0.0,0.0> #end    //start rotation of next segment


#ifndef (L_DIST) #declare L_DIST = 0 #end             // created in "loop.inc" for location calc. (distance down length of track)

#ifndef (L_TOT_LENGTH) #declare L_TOT_LENGTH = 0 #end   // cumulative track length

#ifndef (L_ANG) #declare L_ANG = <0,0,0> #end           // calculated location rotation

#ifndef (L_OFF) #declare L_OFF = 0 #end                // x offset acrros track, 0 is centre

#ifndef (L_POS) #declare L_POS = <L_OFF,seg_high,0> #end            // calculated location coords

#ifndef (TRACK_TIME) #declare TRACK_TIME = 0 #end

#ifndef (TIME_COUNTER) #declare TIME_COUNTER = 0 #end

#ifndef (TRACK_DISTANCE) #declare TRACK_DISTANCE = 0 #end

#ifndef (DISTANCE_COUNTER) #declare DISTANCE_COUNTER = 0 #end

#ifndef (RunOnce) #declare RunOnce = off #end

#ifndef (FIRST_LAP) #declare FIRST_LAP = true #end

#ifndef (SPEED1) #declare SPEED1 = 0 #end

#ifndef (SPEED2) #declare SPEED2 = 0 #end

#declare c_strength = abs(c_strength)*(c_angle / abs(c_angle)) //make c_strength same sign as c_angle
