
#declare START_SPEED = SPEED1*MAX_SPEED
#declare END_SPEED = SPEED2*MAX_SPEED

#declare SEG_LENGTH = s_length    // distance along track in mm

#declare TOTAL_SEG_TIME = SEG_LENGTH/(0.5*(START_SPEED+END_SPEED))  //result is in number of frames per seg.




#if (RunOnce != on)

    #if (TIME_LOCATE = on)
        #if (TRACK_TIME < TIME_COUNTER+TOTAL_SEG_TIME)
            #if (TRACK_TIME >= TIME_COUNTER)
                #declare CLOCK_POS = (TRACK_TIME - TIME_COUNTER)/TOTAL_SEG_TIME
                #declare CURRENT_AVG_SPEED = 0.5*(START_SPEED+(START_SPEED - ((START_SPEED-END_SPEED)*CLOCK_POS)))
                #declare SEG_POS = (CLOCK_POS*TOTAL_SEG_TIME*CURRENT_AVG_SPEED)/SEG_LENGTH
                #declare L_POS = (vrotate(<L_OFF,seg_high,s_length*SEG_POS>,T_ANG))+T_POS
                #declare L_ANG = T_ANG

                #declare CALCULATED_CLOCK_DISTANCE = DISTANCE_COUNTER+(SEG_LENGTH*SEG_POS)
                #declare CURRENT_SPEED = START_SPEED - ((START_SPEED-END_SPEED)*CLOCK_POS)
                #end
            #end
        #end

    #if (DIST_LOCATE = on)
        #if (TRACK_DISTANCE < DISTANCE_COUNTER+SEG_LENGTH)
            #if (TRACK_DISTANCE >= DISTANCE_COUNTER)
                #declare SEG_POS = (TRACK_DISTANCE - DISTANCE_COUNTER)/SEG_LENGTH
                #declare L_POS = (vrotate(<L_OFF,seg_high,s_length*SEG_POS>,T_ANG))+T_POS
                #declare L_ANG = T_ANG



                #end
            #end
        #end

    #declare T_POS = (vrotate(<0,0,s_length>,T_ANG))+T_POS
    #declare T_ANG = T_ANG
    #end



#declare TIME_COUNTER = (TIME_COUNTER+TOTAL_SEG_TIME)

#declare DISTANCE_COUNTER = (DISTANCE_COUNTER+SEG_LENGTH)


#declare SPEED1 = SPEED2
