// File Copyright (C) Aaron Gage.  Please see README file for details.

#declare Terminals =
union {
	union
		{
		#declare Loop = 0
		#while (Loop < 8)
		superellipsoid
			{
			<0.2, 0.2>
			scale <0.25, 0.1, 0.075>
			translate z*0.625
			rotate y*Loop*45
			}
		#declare Loop = Loop + 1
		#end
		cylinder { <0, -0.05, 0>, <0, -0.15, 0>, 0.61 }
		scale <1, 1.5, 1>
		translate x*-1
		}
	difference {
		//cylinder { <0, -0.15, 0>, <0, 0.3, 0>, 0.5 }
		superellipsoid { <1, 0.15> rotate x*90 scale <0.51, 0.1, 0.51> }
		cylinder { <0, 0, 0>, <0, 0.5, 0>, 0.275 }
		scale <1, 2, 1>
		translate y*-0.1
		translate x*1
		}
	pigment { color Silver }
	//finish { ambient 0.3 reflection 0.4 }
	finish { ambient 0.3 }
}

#declare Battery = difference {
	superellipsoid
	   {
	   <0.15, 0.15>
	   }
	plane { y*1, -0.5 }
	plane { y*-1, -0.5 }
	pigment { color White*0.85 }
	finish { ambient 0.3 }

	scale <0.5, 1.25, 0.5*0.6>
}

#declare NineVolt = union {
	object { Battery
		texture {
			pigment {
				gradient y
				color_map
					{
					[0 color White*0.1]
                                        [0.7 color White*0.1]
                                        [0.71 color Copper*0.75]
                                        [1.0 color Copper*0.75]
                                        }
                                translate y*-0.5
                                scale 1.25
				}
			finish { Shiny ambient 0.3 }
			}
		}
	object { Terminals scale 0.25 translate y*0.675 }
	finish { ambient 0.45 }
}
