// File Copyright (C) Aaron Gage.  Please see README file for details.

#declare FurTex = texture
{
   pigment { color Brown }
   finish { ambient 0.6 }
   normal { bumps scale <0.1, 10, 0.1> }
}

#declare Head = union
{
  sphere { 0, 1 }	//head
  superellipsoid { <0.5, 0.5> scale 0.25 // snout
	translate <0, -0.25, -1>
	}
  torus { 0.25, 0.2 rotate x*90 translate <-0.25, 0.9, 0> } // ear
  torus { 0.25, 0.2 rotate x*90 translate <0.25, 0.9, 0> } // ear
  sphere { <0, -0.25, -1.35>, 0.1 pigment { color Black } } // nose

  sphere { <-0.175, 0.25, -0.85>, 0.15 pigment { color Black } } // eye
  sphere { <0.175, 0.25, -0.85>, 0.15 pigment { color Black } } // eye

  pigment { color Brown } finish { ambient 0.5 }

}

#declare Body = union
{
   superellipsoid { <0.75, 0.5> } // body

   superellipsoid { <0.9, 0.5> scale <0.3, 0.3, 0.75> //leg
	translate <-0.3, -0.9, -0.5> }
   superellipsoid { <0.9, 0.5> scale <0.3, 0.3, 0.75> //leg
	translate <0.3, -0.9, -0.5> }

   superellipsoid { <0.9, 0.5> scale <0.3, 0.3, 0.75> //arm
	translate <-0.75, 0.25, -0.5> }
   superellipsoid { <0.9, 0.5> scale <0.3, 0.3, 0.75> //arm
	translate <0.75, 0.25, -0.5> }

  //pigment { color Brown } finish { ambient 0.5 }
  texture { FurTex }

}

#declare Blaster = union
{
   cylinder { x*-1.25, x*1.25, 0.25 }
   cone { x*-1.25, 0.25, x*-1.5, 0.35}
   torus { 0.2, 0.05 rotate x*90 translate <-0.5 + 0.25, -0.25, 0> }

   cylinder { <-0.5 + 0.25, 0.25, 0>, <0 + 0.25, 0.25, 0>, 0.05 }

   cylinder { <-0.5 + 0.25, 0.4, 0>, <0 + 0.25, 0.4, 0>, 0.1 }

   pigment { color Green } finish { ambient 0.4 }
}

#declare Teddy =
union {
	object { Head translate y*1.33 }
	object { Body }

	object { Blaster rotate z*-35 translate z*-1 }

	translate y*1
}
