// File Copyright (C) Aaron Gage.  Please see README file for details.

#include "colors.inc"

//camera { location <0, 2, -6> look_at 0 }
camera { location <-4, 2, -4> look_at 0 }

light_source { <-100, 100, -100> color White }

background { color White*0.25 }

#declare Shaft = union
{
   cylinder { z*-3, z*3, 0.25 }
   cylinder { z*-3, z*-2.8, 0.35 }
   cylinder { z*3, z*2.8, 0.35 }

   cylinder { z*-3, z*3, 0.1 translate y*0.25 }
   cylinder { z*-3, z*3, 0.1 translate y*0.25 rotate z*45 }
   cylinder { z*-3, z*3, 0.1 translate y*0.25 rotate z*90 }
   cylinder { z*-3, z*3, 0.1 translate y*0.25 rotate z*135 }
   cylinder { z*-3, z*3, 0.1 translate y*0.25 rotate z*-45 }
   cylinder { z*-3, z*3, 0.1 translate y*0.25 rotate z*-90 }
   cylinder { z*-3, z*3, 0.1 translate y*0.25 rotate z*-135 }
   cylinder { z*-3, z*3, 0.1 translate y*0.25 rotate z*180 }
   scale <2, 2, 1>

   pigment { color Red } finish { ambient 0.4 }
}

#declare Cup = difference
{
   sphere { 0, 1 }
   sphere { z*-0.35, 1.25 }
   plane { z*1, 0 }
   pigment { color rgbt <0.75, 0.1, 0.25, 0.5> }
   finish { Dull ambient 0.4 }
}

#declare Dart = union
{
object { Shaft }
object { Cup translate z*-3.9 }
}
