// File Copyright (C) Aaron Gage.  Please see README file for details.

#declare FlatTexture =
	texture {
		pigment { color rgbft <0.2, 0.6, 0.2, 0.2, 0.6> }
		finish { specular 0 reflection 0 diffuse 0 refraction 0
			 ambient 1 }
		}

#declare BendTexture =
	texture {
		pigment { color rgbft <0.2, 0.6, 0.2, 0.2, 0.6> }
		finish { specular 0 reflection 0 diffuse 0 refraction 1.0
			 ambient 1 ior 1.25}
		//normal { gradient y scale 0.1}
		}

#declare Overlay1 =
union {
	intersection {
		plane { z*-1, 0 }
		box { <0.7, 0.45, -0.1>, <-0.7, -0.7, 0.1> }
		texture {
			gradient y
			ramp_wave
			texture_map
				{
				[0 FlatTexture]
				[0.93 FlatTexture]
				[0.95 BendTexture]
			[1 BendTexture ]
			}
		scale 0.05
			}
	}
#if ((clock < 0.2) | (clock < 0.6 & clock >= 0.4) |
	(clock >= 0.8) )
	text { ttf "crystal.ttf", "Searching ...", 0.1, 0
		pigment { color White }
		finish { diffuse 0 specular 0 ambient 1 }
		translate x*-3.75
		scale 0.075
		translate <-0.2, 0.3, -0.1>
		no_shadow	
	}
#else
        text { ttf "crystal.ttf", "Searching ..._", 0.1, 0
                pigment { color White }
                finish { diffuse 0 specular 0 ambient 1 }
                translate x*-3.75
                scale 0.075
                translate <-0.2, 0.3, -0.1>
                no_shadow
        }
#end
	translate z*1
	scale <1.125, 1.125, 1>
}

#declare Overlay4 =
union {
        intersection {
                plane { z*-1, 0 }
                box { <0.7, 0.45, -0.1>, <-0.7, -0.7, 0.1> }
                texture {
                        gradient y
                        ramp_wave
                        texture_map
                                {
                                [0 FlatTexture]
                                [0.93 FlatTexture]
                                [0.95 BendTexture]
                        [1 BendTexture ]
                        }
                scale 0.05
                        }
        }
        text { ttf "crystal.ttf", "Battery for Ultimate Weapon", 0.1, 0
                pigment { color White }
                finish { diffuse 0 specular 0 ambient 1 }
                translate x*-4.4
                scale 0.0725
                translate <-0.2, 0.3, -0.1>
                no_shadow
        }
        text { ttf "crystal.ttf", "Almost in Reach!_", 0.1, 0
                pigment { color White }
                finish { diffuse 0 specular 0 ambient 1 }
                translate x*-6.75
                scale 0.075
                translate <0.2, -0.4, -0.1>
                no_shadow
        }
union {
        box { <-0.0925 + 0.09, -0.0475 - 0.04, -0.005>,
                <-0.08 + 0.09, 0.0475, 0.005>
                pigment { color White }
                finish { diffuse 0 specular 0 ambient 1 }
                no_shadow
                }
        box { <0.0925 + 0.09, -0.0475 - 0.04, -0.005>,
                <0.08 + 0.09, 0.0475, 0.005>
                pigment { color White }
                finish { diffuse 0 specular 0 ambient 1 }
                no_shadow
                }
        box { <-0.0925 + 0.09, 0.0475, -0.005>,
                <0.0925 + 0.09, 0.06, 0.005>
                pigment { color White }
                finish { diffuse 0 specular 0 ambient 1 }
                no_shadow
                }
        box { <-0.0925 + 0.09, -0.0475 - 0.04, -0.005>,
                <0.0925 + 0.09, -0.06 - 0.04, 0.005>
                pigment { color White }
                finish { diffuse 0 specular 0 ambient 1 }
                no_shadow
                }
	scale 1.5
}

        translate z*1
        scale <1.125, 1.125, 1>
}


#declare Overlay2 =
union {
        intersection {
                plane { z*-1, 0 }
                box { <0.7, 0.45, -0.1>, <-0.7, -0.7, 0.1> }
                texture {
                        gradient y
                        ramp_wave
                        texture_map
                                {
                                [0 FlatTexture]
                                [0.93 FlatTexture]
                                [0.95 BendTexture]
                        [1 BendTexture ]
                        }
                scale 0.05
                        }
        }

        box { <-0.0925 - 0.375*(1 - Clock3 + Clock4),
		-0.0475 - .225*(1 - Clock3 + Clock4), -0.005>,
		<-0.08 - 0.375*(1 - Clock3 + Clock4),
		0.0475 + .225*(1 - Clock3 + Clock4), 0.005>
                pigment { color White }
                finish { diffuse 0 specular 0 ambient 1 }
                no_shadow
                }
        box { <0.0925 + 0.375*(1 - Clock3 + Clock4),
		-0.0475 - .225*(1 - Clock3 + Clock4), -0.005>,
		<0.08 + 0.375*(1 - Clock3 + Clock4),
		0.0475 + .225*(1 - Clock3 + Clock4), 0.005>
                pigment { color White }
                finish { diffuse 0 specular 0 ambient 1 }
                no_shadow
                }
        box { <-0.0925 - 0.375*(1 - Clock3 + Clock4),
		0.0475 + .225*(1 - Clock3 + Clock4), -0.005>,
		<0.0925 + 0.375*(1 - Clock3 + Clock4),
		0.06 + .225*(1 - Clock3 + Clock4), 0.005>
                pigment { color White }
                finish { diffuse 0 specular 0 ambient 1 }
                no_shadow
                }
        box { <-0.0925 - 0.375*(1 - Clock3 + Clock4),
		-0.0475 - .225*(1 - Clock3 + Clock4), -0.005>,
		<0.0925 + 0.375*(1 - Clock3 + Clock4),
		-0.06 - .225*(1 - Clock3 + Clock4), 0.005>
                pigment { color White }
                finish { diffuse 0 specular 0 ambient 1 }
                no_shadow
                }

        text { ttf "crystal.ttf", "Zoom", 0.1, 0
                pigment { color White }
                finish { diffuse 0 specular 0 ambient 1 }
                translate x*-3.75
                scale 0.075
                translate <0.2, -0.4, -0.1>
                no_shadow
        }


#if ((clock < 0.2) | (clock < 0.6 & clock >= 0.4) |
	(clock >= 0.8) )
        text { ttf "crystal.ttf", "Searching ..._", 0.1, 0
                pigment { color White }
                finish { diffuse 0 specular 0 ambient 1 }
                translate x*-3.75
                scale 0.075
                translate <-0.2, 0.3, -0.1>
                no_shadow
		}
#else
        text { ttf "crystal.ttf", "Searching ...", 0.1, 0
                pigment { color White }
                finish { diffuse 0 specular 0 ambient 1 }
                translate x*-3.75
                scale 0.075
                translate <-0.2, 0.3, -0.1>
                no_shadow
                }
#end

        translate z*1
        scale <1.125, 1.125, 1>
}

#declare Overlay3 =
union {
        intersection {
                plane { z*-1, 0 }
                box { <0.7, 0.45, -0.1>, <-0.7, -0.7, 0.1> }
                texture {
                        gradient y
                        ramp_wave
                        texture_map
                                {
                                [0 FlatTexture]
                                [0.93 FlatTexture]
                                [0.95 BendTexture]
                        [1 BendTexture ]
                        }
                scale 0.05
                        }
        }
#if ((clock < 0.2) | (clock < 0.6 & clock >= 0.4) |
        (clock >= 0.8) )

        box { <-0.0925 + 0.09, -0.0475, -0.005>,
                <-0.08 + 0.09, 0.0475, 0.005>
                pigment { color White }
                finish { diffuse 0 specular 0 ambient 1 }
                no_shadow
                }
        box { <0.0925 + 0.09, -0.0475, -0.005>,
                <0.08 + 0.09, 0.0475, 0.005>
                pigment { color White }
                finish { diffuse 0 specular 0 ambient 1 }
                no_shadow
                }
        box { <-0.0925 + 0.09, 0.0475, -0.005>,
                <0.0925 + 0.09, 0.06, 0.005>
                pigment { color White }
                finish { diffuse 0 specular 0 ambient 1 }
                no_shadow
                }
        box { <-0.0925 + 0.09, -0.0475, -0.005>,
                <0.0925 + 0.09, -0.06, 0.005>
                pigment { color White }
                finish { diffuse 0 specular 0 ambient 1 }
                no_shadow
                }
#end

        text { ttf "crystal.ttf", "Zoom", 0.1, 0
                pigment { color White }
                finish { diffuse 0 specular 0 ambient 1 }
                translate x*-3.75
                scale 0.075
                translate <0.2, -0.4, -0.1>
                no_shadow
        }
/*
#if ((clock < 0.2) | (clock < 0.6 & clock >= 0.4) |
        (clock >= 0.8) )
        text { ttf "crystal.ttf", "Searching ...", 0.1, 0
                pigment { color White }
                finish { diffuse 0 specular 0 ambient 1 }
                translate x*-3.75
                scale 0.075
                translate <-0.2, 0.3, -0.1>
                no_shadow
                }
#else
        text { ttf "crystal.ttf", "Searching ..._", 0.1, 0
                pigment { color White }
                finish { diffuse 0 specular 0 ambient 1 }
                translate x*-3.75
                scale 0.075
                translate <-0.2, 0.3, -0.1>
                no_shadow
                }
#end
*/

        text { ttf "crystal.ttf", "Battery Found.", 0.1, 0
                pigment { color White }
                finish { diffuse 0 specular 0 ambient 1 }
                translate x*-3.75
                scale 0.075
                translate <-0.2, 0.3, -0.1>
                no_shadow
                }


	object { NineVolt scale 0.20
		rotate y*360*clock
		rotate x*-25
		translate <-0.25, 0, -0.1> no_shadow }

        translate z*1
        scale <1.125, 1.125, 1>
}
