#ifndef (CHAINTOP)
#declare CHAINTOP=10
#end
#ifndef (CHAINBOTTOM)
#declare CHAINBOTTOM=0
#end
#ifndef (CHAINTEX)
#declare CHAINTEX=T_Gold_3C
#end

#declare Half_Torus = difference {
    torus { 4, 1 rotate -90*x }
    box { <-5, -5, -1>, <5, 0, 1> }
  }

#declare Flip_It_Over = 180*x

#declare Torus_Translate = 8  // twice the major radius

#declare Chain_Segment = cylinder { <0, 4, 0>, <0, -4, 0>, 1 }

#declare Link = union {
  object { Half_Torus translate y*Torus_Translate/2 }
  object { Half_Torus rotate Flip_It_Over translate -y*Torus_Translate/2 }
  object { Chain_Segment translate x*Torus_Translate/2 }
  object { Chain_Segment translate -x*Torus_Translate/2 }
  texture { CHAINTEX }
}

#declare Link_Translate = Torus_Translate*2-2*y

#declare Link_Pair = union {
  object { Link }
  object { Link translate y*Link_Translate rotate y*90 }
}

#declare CHAIN = union {
#declare I=CHAINBOTTOM
#while (I<CHAINTOP)
  object { Link_Pair rotate <0,15*sin(rand(R1)*2*pi),0> scale .1 translate  y*I }
#declare I=I+(2*Link_Translate.y)*.1
#end
}
