
// POV file by Andrew Cherry

#declare c=clock
#declare QUICK=0

#debug "\n+----------------------------------------------+\n"
#debug concat("| ANIMATION SEQUENCE IS",str((clock*100),6,2)," PERCENT FINISHED |                 <-- AC")
#debug "\n+----------------------------------------------+\n"
#if (clock>0) #debug concat("\nTIME REMAINING: ",str(((1/clock)-1),6,1)," x E-TIME\n\n") #end

#declare R1=seed(666)

#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions
#include "CONSTS.INC"
#include "GLASS.INC"
#include "SKIES.INC"
#include "METALS.INC"
#include "SHAPES.INC"   // These aren't normally necessary
#include "SHAPES2.INC"
#include "SHAPESQ.INC"
#include "STONES.INC"
#include "STONES2.INC"
#include "WOODMAPS.INC"
#include "WOODS.INC"

#declare CAMLOC = <30 , 45, 20>

camera {
  location  CAMLOC
  look_at   <5, 5, 50>
}

light_source { CAMLOC color rgb .75 }
light_source { y*.1 color rgb .1 }
light_source { <0,24,0> color rgb .2 }

//-----------------------------------------------------------------------------------------------------------------------------
#include "player.inc"

background { color red 0.1 green 0.3 blue 0.8 }

#include "TABLE.INC"
#object {TABLE translate <0,0,0>}

// BALLS ON MAIN TABLE

#declare RANDBALLROT=0
#declare RANDBALLROT=1

#include "PoolBalls.inc"

#declare RACK = union {
/* Row #1 */
object { BALL1 }
/* Row #2 */
object { BALL10 translate <1, 0, 1.732>*1.125 }
object { BALL3 translate <-1, 0, 1.732>*1.125 }
/* Row #3 */
object { BALL9 translate <2, 0, 3.464>*1.125 }
object { BALL8 translate <0, 0, 3.464>*1.125 }
object { BALL11 translate <-2, 0, 3.464>*1.125 }
/* Row #4 */
object { BALL7 translate <-3, 0, 5.196>*1.125 }
object { BALL12 translate <-1, 0, 5.196>*1.125 }
object { BALL2 translate <1, 0, 5.196>*1.125 }
object { BALL13 translate <3, 0, 5.196>*1.125 }
/* Row #5 */
object { BALL4 translate <-4.0, 0.0, 6.928>*1.125 }
object { BALL15 translate <-2.0, 0.0, 6.928>*1.125 }
object { BALL6 translate <0.0, 0.0, 6.928>*1.125 }
object { BALL14 translate <2.0, 0.0, 6.928>*1.125 }
object { BALL5 translate <4, 0, 6.928>*1.125 }
}
//#object {BALL0 translate < 0, 0, 30> }
#object {RACK rotate <0,180,0> translate < 0, 0,-30>}

// EXPLODING CUE BALL ON MAIN TABLE

      #declare explode_clock = ((c - .25) * 4 / 3)*3
      #declare explode_object = object {BALL0 translate < 0, 0, 30> }
      #declare object_centre = <0, 1.125, 30>
      #declare object_size = <3, 3, 3>
      #declare object_hollow = false
      #declare particle_object = sphere {<0,0,0>, .75}
      #declare particle_res = <4, 4, 4>
      #declare particle_texture = texture {
         pigment {color White}
         finish {BALLFIN}
         normal {bumps 2 scale .1}
         }
      #declare exp_location = <0, 0, 31.125>
      #declare exp_strength = 8
      #declare exp_spin = 1
      #declare exp_seed = 87632
      #declare exp_turb = 1
      #declare exp_gravity = 9.8
      #declare scale_turb = .5
      #declare rotate_turb = 1
      #declare vel_turb = .3
      #declare dir_turb = .4
      #declare spin_turb = .3

      #declare ground_plane = true
      #declare ground_dist = 0
      #declare ground_reflection = .25
      #declare max_bounces = 3

      #include "Explode.inc"

