
// ==== Standard POV-Ray Includes ====
#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions
#local clocka=clock
#local hyllym=0; //-1 to 1
#local sukuli=.5; //0 to 1
#local hiuskul=20; //-45 to 45
#local vasenkasikul=cos((clocka*90)*pi/180)*10; //10 to -10 10 edes 
#local oikeakasikul=cos((clocka*90+180)*pi/180)*10; //10 to -10 -10 takana 
#local jalkakul=array[6]
#local jalkakul[1]=cos((clocka*90)*pi/180)*5;
#local jalkakul[2]=cos((clocka*90+72)*pi/180)*5;
#local jalkakul[3]=cos((clocka*90+144)*pi/180)*5;
#local jalkakul[4]=cos((clocka*90+216)*pi/180)*5;
#local jalkakul[5]=cos((clocka*90+288)*pi/180)*5;
#local jalkapit=array[6]
#local jalkapit[1]=1;
#local jalkapit[2]=1; //5-clocka;
#local jalkapit[3]=1; //5-clocka;
#local jalkapit[4]=1; //5-clocka;
#local jalkapit[5]=1;
#local mpie=0
camera
{
  location  <-20.0 , 5.0 ,-40>
  look_at   <0.0 , -10.0 , 0.0>
  }

// create a regular point light source
light_source
{
  0*x // light's position (translated below)
  color red 1.0  green 1.0  blue 1.0  // light's color
  translate <-20, 20, -20>
}
plane {y,-30 pigment {Green}}

// Set a color of the background (sky)
background { color red 0.1 green 0.3 blue 0.8 }


union {

#declare iho=texture {pigment
{gradient z pigment_map {
[0.0 Flesh]
[0.8 Flesh]
[0.85 granite pigment_map {[0.0 Brown] [0.5 Flesh]} scale .1]
[.95 Brown]
[1 Brown]
}
scale 10
translate <0,0,-6.5>
}
//finish {metallic phong 1}
}
#declare paita=texture {
pigment {Blue}
normal {gradient z normal_map {
[0.0 ripples 1 scale 1/6]
[1.0 ripples 0 scale 1/6]
}
scale 6}}
#declare housu=texture {pigment {Gray50}}
blob {
cylinder {<0,0,0>,<0,1,0>,1,2 texture {iho}}
sphere {<0,0,0>,5,3 scale <1,1.3,1> translate <0,5.5,0> texture {iho}}
cylinder {<0,5.5,0>,<0,3.5,-5>,1,2 texture {iho}} 
sphere {<-1,6,-1.7>,1.5,-3 texture {iho}}  
sphere {<1,6,-1.7>,1.5,-3 texture {iho}} 
cylinder {<0,0,0>,<0,0,-2>,1,-2 scale <1.5,sukuli,1> translate <0,3,0> pigment {Red}}

sphere {<-1,7,-1.7>,.5,3 texture {iho}}
sphere {<1,7,-1.7>,.5,3 texture {iho}}                                         

cylinder {<-4,0,0>,<4,0,0>,1,2 texture {paita}}                                         

sphere {<0,0,0>,8,3 scale <1,1.5,.6> translate <0,-8.5,0> texture {paita}}
sphere {<0,0,0>,6,3 scale <1,1,.6> translate <0,-11.5+hyllym,-3> texture {paita}}
sphere {<0,0,0>,3,3 scale <1,1,.6> translate <-2,-6.5+hyllym,-2> texture {paita}}
sphere {<0,0,0>,3,3 scale <1,1,.6> translate <2,-6.5+hyllym,-2> texture {paita}}
}



sphere {<0,0,0>,1 hollow
pigment {rgbf <1,1,1,1>}
interior {
media {
scattering { 2, rgb <1,0,0> extinction 1 } 
emission rgb <1,1,1>
density {spherical density_map {
[0.0 rgb <1,1,1>]
[0.5 rgb <0,0,1>]
}
}

}
}
translate <1,6,-1.7>
}


sphere {<0,0,0> ,1 hollow
pigment {rgbf <1,1,1,1>}
interior {
media {
scattering { 2, rgb <1,0,0> extinction 1 } 
emission rgb <1,1,1>
density {spherical density_map {
[0.0 rgb <1,1,1>]
[0.5 rgb <0,0,1>]
}
}
}
}
translate <-1,6,-1.7>
}


union {
#declare yy=1;
#while (yy<13)
#declare kk=0;
#while (kk<3)
#declare rr=yy+kk - int((yy+kk)/3)*3;
#switch (rr)
#case (0)
#declare xx=-1;
#declare zz=-.1;
#break
#case (1)
#declare xx=0;
#declare zz=0;
#break
#case (2)
#declare xx=1;
#declare zz=.1;
#break
#end
#declare rr=yy+kk+1 - int((yy+kk+1)/3)*3;
#switch (rr)
#case (0)
#declare xxx=-1;
#declare zzz=-.1;
#break
#case (1)
#declare xxx=0;
#declare zzz=0;
#break
#case (2)
#declare xxx=1;
#declare zzz=-.1;
#break
#end
#declare jak=yy/5+1;
cylinder {<xx/jak,yy,zz/jak>,<xxx/jak,yy+1,zzz/jak>,.35/jak}
sphere {<xx/jak,yy,zz/jak>,.35/jak}
#declare kk=kk+1;
#end
#declare yy=yy+1;
#end
#declare kk=0;
#while (kk<360)
cylinder {<0,0,0>,<-1.5,0,-.6>,.2 rotate <0,0,kk> translate <-.8,1,-.1>}
cylinder {<0,0,0>,<-1.5,0,-.6>,.2 rotate <0,0,kk+10> translate <0,1,0>}
cylinder {<0,0,0>,<-1.5,0,-.6>,.2 rotate <0,0,kk+20> translate <.8,1,.1>}
#declare kk=kk+30;
#end
pigment {rgbf <.8,.5,.3,.3>}
finish {phong 1}
translate <0,-1,0>
rotate <180,0,0>
rotate <0,180,0>
rotate <0,0,hiuskul>
translate <0,5.5,3.1>
}
#local zz=0;
#local yy=0;


merge {
#local ke=0;
#while (ke<10)
#local ezz=zz;
#local eyy=yy;
#local zz=zz+sin((180+ke*oikeakasikul)*pi/180);
#local yy=yy+cos((180+ke*oikeakasikul)*pi/180);
union {
sphere {<0,yy,zz>,.5}
cylinder {<0,yy,zz>,<0,eyy,ezz>,.5}
pigment {rgbf <ke/10,ke/10,1,ke/10>}
}
#local ke=ke+1;
#end
rotate <0,0,-30>
interior {ior 1.5}
translate <-4,0,0>
}
#local zz=0;
#local yy=0;
merge {
#local ke=0;
#while (ke<10)
#local ezz=zz;
#local eyy=yy;
#local zz=zz+sin((180+ke*vasenkasikul)*pi/180);
#local yy=yy+cos((180+ke*vasenkasikul)*pi/180);
union {
sphere {<0,yy,zz>,.5}
cylinder {<0,yy,zz>,<0,eyy,ezz>,.5}
pigment {rgbf <ke/10,ke/10,1,ke/10>}
}
#local ke=ke+1;
#end
rotate <0,0,30>
interior {ior 1.5}
translate <4,0,0>
}

#local jalnum=1;
#while (jalnum<5.5)
#local zz=0;
#local yy=0;

merge {
#local ke=0;
#while (ke<20)
#local ezz=zz;
#local eyy=yy;
#local zz=zz+sin((180+ke*jalkakul[jalnum])*pi/180);
#local yy=yy+cos((180+ke*jalkakul[jalnum])*pi/180);
#if (yy<mpie) 
#local mpie=yy;
#end
union {
sphere {<0,yy,zz>,.8}
cylinder {<0,yy,zz>,<0,eyy,ezz>,.8}
pigment {rgbf <ke/10,ke/10,1,ke/10>}
}
#local ke=ke+jalkapit[jalnum];
#end
rotate <0,0,0>
interior {ior 1.5}
translate <(jalnum-2.5)*2,-10,0>
}
#local jalnum=jalnum+1;
#end
translate <0,-20,0>
translate <0,-mpie,0>
} 