
// ==== Standard POV-Ray Includes ====
#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions
#local clocka=clock;

camera
{
  location  <0.0 , 10.0 ,-30.0>
  look_at   <0.0 , 10.0 , -5.0>
}


// Set a color of the background (sky)
background { color red 0.1 green 0.3 blue 0.8 }

light_source
{
  0*x // light's position (translated below)
  color red 1.0  green 1.0  blue 1.0  // light's color
  translate <-20, -40, -20>
}

light_source
{
  0*x // light's position (translated below)
  color red 1.0  green 1.0  blue 1.0  // light's color
  translate <-20, 40, -20>
}


union {
union {
#declare ots=texture {pigment {rgb <.2,.2,.2>} normal {dents 1 scale .5} finish {phong .5}}
#declare omah=texture {pigment {rgb <.9,.9,.85>} normal {bumps .2} finish {ambient .3}}
difference {
sphere {<0,0,0>,3 scale <1.5,1,2>}
torus {3,.6 scale <1.5,1,2> translate <0,-.7,0>}
torus {3,.3 rotate <0,0,90> scale <1.5,1,2>}
plane {y,-.6}
texture {ots}
}

union {
#local zz=-3.3;
#while (zz<3)
#local zz=zz+.4;
#local lev=4.3-pow(zz,2)/2;
torus {lev*.9,.6 rotate <90,0,0> scale <1,.4,1> translate <0,-lev/5-.2,zz*2>}
/*sphere {<-lev,-1,zz*2>,.4}
sphere {<lev,-1,zz*2>,.4}*/
#end
texture {omah}
}

union {
difference {
sphere {<0,0,0>,3 scale <1.5,1,2>}
torus {3,.6 scale <1.5,1,2> translate <0,-.7,0>}
torus {3,.3 rotate <0,0,90> scale <1.5,1,2>}
plane {y,-.6}
texture {ots}
}
union {
#local zz=-3.3;
#while (zz<3)
#local zz=zz+.4;
#local lev=4.3-pow(zz,2)/2;
torus {lev*.9,.6 rotate <90,0,0> scale <1,.4,1> translate <0,-lev/5-.2,zz*2>}
/*sphere {<-lev,-1,zz*2>,.4}
sphere {<lev,-1,zz*2>,.4}*/
#end
texture {omah}
}
scale <.6,1,1/2>
scale .7
translate <0,0,-6>
}


}


#local pihkul=45;//saksienkulma
#local pihku2=0;//vasenoikea
#local pihku3=0;//ylosalas
#local pihku4=0;//ympari

#local jkul=array [7][4]
#local ervo=1;
#while (ervo<4)
#local kehko=(ervo*120+clocka)*pi/180;
#local jkul[ervo][1]=(90-sin(kehko)*45); //0 on suoraan yls 90 vasen 180 alas
#if (jkul[ervo][1]>90)
#local jkul[ervo][1]=90;
#end
#local jkul[ervo][1]=jkul[ervo][1]*pi/180;
#local jkul[ervo][2]=170*pi/180;
#local jkul[ervo][3]=-70+cos(kehko)*10+ervo*25; //cos(kehko)*15+
#local ervo=ervo+1;
#end

#local ervo=4;
#while (ervo<7)
#local kehko=(ervo*120+clocka)*pi/180;
#local jkul[ervo][1]=(90-sin(kehko)*45); //0 on suoraan yls 90 vasen 180 alas
#if (jkul[ervo][1]>90)
#local jkul[ervo][1]=90;
#end
#local jkul[ervo][1]=jkul[ervo][1]*pi/180;
#local jkul[ervo][2]=170*pi/180;
#local jkul[ervo][3]=-(-70+cos(kehko)*10+(ervo-3)*25); //cos(kehko)*15+
#local ervo=ervo+1;
#end


#local matal=0;
#local ahki=1;
#while (ahki<4)
union {
cylinder {<-1.5,0,0>,<-1.5-sin(jkul[ahki][1])*4,cos(jkul[ahki][1])*4,0>,.2}
sphere {<-1.5-sin(jkul[ahki][1])*4,cos(jkul[ahki][1])*4,0>,.2}
cylinder {<-1.5-sin(jkul[ahki][1])*4,cos(jkul[ahki][1])*4,0>,<-1.5-sin(jkul[ahki][1])*4-sin(jkul[ahki][2])*4,cos(jkul[ahki][1])*4+cos(jkul[ahki][2])*4,0>,.2}
union {
cylinder {<0,0.4,0>,<0,0,0>.25 pigment {White}}
sphere {<0,0,0>,.4 scale <1,1,2> translate <0,.25,.5> rotate <0,225,0> pigment {White}}
translate <-1.5-sin(jkul[ahki][1])*4-sin(jkul[ahki][2])*4,cos(jkul[ahki][1])*4+cos(jkul[ahki][2])*4,0>
}
texture {
gradient x texture_map {
[0.0 ots]
[1.0 pigment {Yellow}]
}
scale 5
translate <8.5,0,0>
}

rotate <0,jkul[ahki][3],0>
translate <0,0,-6>
#if ((cos(jkul[ahki][1])*4+cos(jkul[ahki][2])*4)<matal)
#local matal=(cos(jkul[ahki][1])*3+cos(jkul[ahki][2])*4);
#end
#declare ahki=ahki+1;
}
#end

#local ahki=4;
#while (ahki<7)
union {
cylinder {<1.5,0,0>,<1.5+sin(jkul[ahki][1])*4,cos(jkul[ahki][1])*4,0>,.2}
sphere {<1.5+sin(jkul[ahki][1])*4,cos(jkul[ahki][1])*4,0>,.2}
cylinder {<1.5+sin(jkul[ahki][1])*4,cos(jkul[ahki][1])*4,0>,<1.5+sin(jkul[ahki][1])*4+sin(jkul[ahki][2])*4,cos(jkul[ahki][1])*4+cos(jkul[ahki][2])*4,0>,.2}
union {
cylinder {<0,0.4,0>,<0,0,0>.25 pigment {White}}
sphere {<0,0,0>,.4 scale <1,1,2> translate <0,.25,.5> rotate <0,-225,0> pigment {White}}
translate <1.5+sin(jkul[ahki][1])*4+sin(jkul[ahki][2])*4,cos(jkul[ahki][1])*4+cos(jkul[ahki][2])*4,0>
}
texture {
gradient x texture_map {
[0.0 ots]
[1.0 pigment {Yellow}]
}
scale 5
translate <-8.5,0,0>
}
rotate <0,jkul[ahki][3],0>
translate <0,0,-6>
#if ((cos(jkul[ahki][1])*4+cos(jkul[ahki][2])*4)<matal)
#local matal=(cos(jkul[ahki][1])*4+cos(jkul[ahki][2])*4);
#end
#declare ahki=ahki+1;
}
#end


union {
sphere {<0,0,0>,2 scale <1,1,1.5> texture {ots}}
sphere {<0,0,0>,1 translate <-1,.5,-2> pigment {brick rgbf <.2,.2,.2,.5>,rgbf <1,1,0,.5> scale .1}}
sphere {<0,0,0>,1 translate <1,.5,-2> pigment {brick rgbf <.2,.2,.2,.5>,rgbf <1,1,0,.5> scale .1}}

light_source
{
  0*x // light's position (translated below)
  color red 1  green 1  blue 1  // light's color
translate <-1.3,.5,-2.2>
}

light_source
{
  0*x // light's position (translated below)
  color red 1  green 1  blue 1  // light's color
translate <1.3,.5,-2.2>
}

union {
difference {
torus {1,.2}
plane {x,0}
translate <0,0,-1>
rotate <0,-pihkul,0>
translate <0,0,-1.5>
}
difference {
torus {1,.2}
plane {-x,0}
translate <0,0,-1>
rotate <0,pihkul,0>
translate <0,0,-1.5>
}
sphere {<0,0,-1.5>,.2}
cylinder {<0,0,2>,<0,0,-1.5>,.2}
texture {gradient z texture_map {
[0 ots]
[1.0 pigment {Yellow}]
}
scale 4
}
translate <0,0,-2>
rotate <pihku3,pihku2,pihku4>
translate <0,0,-2.5>
}
scale .8
translate <0,1,-7.5>
}

translate <0,-matal,0>
//translate <0,0,-clocka/60>
#local clocka=clock;
rotate <clocka,0,clocka>
#local sca=1;
#local sca2=1;
#if (clocka>81)
#local sca=1/((clocka-80));
#local sca2=(clocka-78)/4;
#end
scale <sca2,sca2,sca>
translate <0,clocka/4,clocka/2>
}
































#local clocka=(clock-45)*20;




union {
union {
#declare ots=texture {pigment {rgb <.2,.2,.2>} normal {dents 1 scale .5} finish {phong .5}}
#declare omah=texture {pigment {rgb <.9,.9,.85>} normal {bumps .2} finish {ambient .3}}
difference {
sphere {<0,0,0>,3 scale <1.5,1,2>}
torus {3,.6 scale <1.5,1,2> translate <0,-.7,0>}
torus {3,.3 rotate <0,0,90> scale <1.5,1,2>}
plane {y,-.6}
texture {ots}
}

union {
#local zz=-3.3;
#while (zz<3)
#local zz=zz+.4;
#local lev=4.3-pow(zz,2)/2;
torus {lev*.9,.6 rotate <90,0,0> scale <1,.4,1> translate <0,-lev/5-.2,zz*2>}
/*sphere {<-lev,-1,zz*2>,.4}
sphere {<lev,-1,zz*2>,.4}*/
#end
texture {omah}
}

union {
difference {
sphere {<0,0,0>,3 scale <1.5,1,2>}
torus {3,.6 scale <1.5,1,2> translate <0,-.7,0>}
torus {3,.3 rotate <0,0,90> scale <1.5,1,2>}
plane {y,-.6}
texture {ots}
}
union {
#local zz=-3.3;
#while (zz<3)
#local zz=zz+.4;
#local lev=4.3-pow(zz,2)/2;
torus {lev*.9,.6 rotate <90,0,0> scale <1,.4,1> translate <0,-lev/5-.2,zz*2>}
/*sphere {<-lev,-1,zz*2>,.4}
sphere {<lev,-1,zz*2>,.4}*/
#end
texture {omah}
}
scale <.6,1,1/2>
scale .7
translate <0,0,-6>
}


}


#local pihkul=45;//saksienkulma
#local pihku2=0;//vasenoikea
#local pihku3=0;//ylosalas
#local pihku4=0;//ympari

#local jkul=array [7][4]
#local ervo=1;
#while (ervo<4)
#local kehko=(ervo*120+clocka)*pi/180;
#local jkul[ervo][1]=(90-sin(kehko)*45); //0 on suoraan yls 90 vasen 180 alas
#if (jkul[ervo][1]>90)
#local jkul[ervo][1]=90;
#end
#local jkul[ervo][1]=jkul[ervo][1]*pi/180;
#local jkul[ervo][2]=170*pi/180;
#local jkul[ervo][3]=-70+cos(kehko)*10+ervo*25; //cos(kehko)*15+
#local ervo=ervo+1;
#end

#local ervo=4;
#while (ervo<7)
#local kehko=(ervo*120+clocka)*pi/180;
#local jkul[ervo][1]=(90-sin(kehko)*45); //0 on suoraan yls 90 vasen 180 alas
#if (jkul[ervo][1]>90)
#local jkul[ervo][1]=90;
#end
#local jkul[ervo][1]=jkul[ervo][1]*pi/180;
#local jkul[ervo][2]=170*pi/180;
#local jkul[ervo][3]=-(-70+cos(kehko)*10+(ervo-3)*25); //cos(kehko)*15+
#local ervo=ervo+1;
#end


#local matal=0;
#local ahki=1;
#while (ahki<4)
union {
cylinder {<-1.5,0,0>,<-1.5-sin(jkul[ahki][1])*4,cos(jkul[ahki][1])*4,0>,.2}
sphere {<-1.5-sin(jkul[ahki][1])*4,cos(jkul[ahki][1])*4,0>,.2}
cylinder {<-1.5-sin(jkul[ahki][1])*4,cos(jkul[ahki][1])*4,0>,<-1.5-sin(jkul[ahki][1])*4-sin(jkul[ahki][2])*4,cos(jkul[ahki][1])*4+cos(jkul[ahki][2])*4,0>,.2}
union {
cylinder {<0,0.4,0>,<0,0,0>.25 pigment {White}}
sphere {<0,0,0>,.4 scale <1,1,2> translate <0,.25,.5> rotate <0,225,0> pigment {White}}
translate <-1.5-sin(jkul[ahki][1])*4-sin(jkul[ahki][2])*4,cos(jkul[ahki][1])*4+cos(jkul[ahki][2])*4,0>
}
texture {
gradient x texture_map {
[0.0 ots]
[1.0 pigment {Yellow}]
}
scale 5
translate <8.5,0,0>
}

rotate <0,jkul[ahki][3],0>
translate <0,0,-6>
#if ((cos(jkul[ahki][1])*4+cos(jkul[ahki][2])*4)<matal)
#local matal=(cos(jkul[ahki][1])*3+cos(jkul[ahki][2])*4);
#end
#declare ahki=ahki+1;
}
#end

#local ahki=4;
#while (ahki<7)
union {
cylinder {<1.5,0,0>,<1.5+sin(jkul[ahki][1])*4,cos(jkul[ahki][1])*4,0>,.2}
sphere {<1.5+sin(jkul[ahki][1])*4,cos(jkul[ahki][1])*4,0>,.2}
cylinder {<1.5+sin(jkul[ahki][1])*4,cos(jkul[ahki][1])*4,0>,<1.5+sin(jkul[ahki][1])*4+sin(jkul[ahki][2])*4,cos(jkul[ahki][1])*4+cos(jkul[ahki][2])*4,0>,.2}
union {
cylinder {<0,0.4,0>,<0,0,0>.25 pigment {White}}
sphere {<0,0,0>,.4 scale <1,1,2> translate <0,.25,.5> rotate <0,-225,0> pigment {White}}
translate <1.5+sin(jkul[ahki][1])*4+sin(jkul[ahki][2])*4,cos(jkul[ahki][1])*4+cos(jkul[ahki][2])*4,0>
}
texture {
gradient x texture_map {
[0.0 ots]
[1.0 pigment {Yellow}]
}
scale 5
translate <-8.5,0,0>
}
rotate <0,jkul[ahki][3],0>
translate <0,0,-6>
#if ((cos(jkul[ahki][1])*4+cos(jkul[ahki][2])*4)<matal)
#local matal=(cos(jkul[ahki][1])*4+cos(jkul[ahki][2])*4);
#end
#declare ahki=ahki+1;
}
#end


union {
sphere {<0,0,0>,2 scale <1,1,1.5> texture {ots}}
sphere {<0,0,0>,1 translate <-1,.5,-2> pigment {brick rgbf <.2,.2,.2,.5>,rgbf <1,1,0,.5> scale .1}}
sphere {<0,0,0>,1 translate <1,.5,-2> pigment {brick rgbf <.2,.2,.2,.5>,rgbf <1,1,0,.5> scale .1}}

light_source
{
  0*x // light's position (translated below)
  color red 1  green 1  blue 1  // light's color
translate <-1.3,.5,-2.2>
}

light_source
{
  0*x // light's position (translated below)
  color red 1  green 1  blue 1  // light's color
translate <1.3,.5,-2.2>
}

union {
difference {
torus {1,.2}
plane {x,0}
translate <0,0,-1>
rotate <0,-pihkul,0>
translate <0,0,-1.5>
}
difference {
torus {1,.2}
plane {-x,0}
translate <0,0,-1>
rotate <0,pihkul,0>
translate <0,0,-1.5>
}
sphere {<0,0,-1.5>,.2}
cylinder {<0,0,2>,<0,0,-1.5>,.2}
texture {gradient z texture_map {
[0 ots]
[1.0 pigment {Yellow}]
}
scale 4
}
translate <0,0,-2>
rotate <pihku3,pihku2,pihku4>
translate <0,0,-2.5>
}
scale .8
translate <0,1,-7.5>
}

translate <0,-matal,0>
rotate <0,90,0>
translate <-clocka/60,0,0>
/*#local clocka=clock;
rotate <clocka,0,clocka>
#local sca=1;
#local sca2=1;
#if (clocka>81)
#local sca=1/((clocka-80));
#local sca2=(clocka-78)/4;
#end
scale <sca2,sca2,sca>
translate <0,clocka/4,clocka/2>
*/
}



















plane {-z,-46 pigment {brick}}
plane {y, 0 pigment {Jade} finish {reflection .4}}
