
// ==== Standard POV-Ray Includes ====
#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions

camera
{
  location  <-4.0 , 4.7 ,-5.0>
  look_at   <0.0 , 2.3 , 0.0>
}
//
/*light_source
{
  0*x // light's position (translated below)
  color red 1.0  green 1.0  blue 1.0  // light's color
  translate <-20, 40, -20>
}
global_settings {
#max_trace_level 100
}
*/
light_source
{
  0*x // light's position (translated below)
  color rgb 1.0  // light's color
  // <widthVector> <heightVector> nLightsWide mLightsHigh
  area_light
  <8, 0, 0> <0, 0, 8> // lights spread out across this distance (x * z)
  4, 4                // total number of lights in grid (4x*4z = 16 lights)
  adaptive 0          // 0,1,2,3... 
  jitter              // adds random softening of light
  translate <-20, 40, -20>   // <x y z> position of light
}


plane {y,0 pigment {Green}}
background {rgb <0,.5,1>}



#declare robo=union {
#local tel=0;


#local tela=union {
cylinder {<-2,0,0>,<2,0,0>,.5}
cylinder {<-2.1,0,0>,<2.1,0,0>,.2}
#local keke=0;
#while (keke<180)
box {<-2,-.6,-.1>,<2,.6,.1> rotate <keke,0,0>}
#local keke=keke + 45;
#end
pigment {Gray40}
}

object {tela rotate <tel,0,0> translate <0,.55,0>}
object {tela rotate <tel+10,0,0> translate <0,.55,-1.5>}
object {tela rotate <tel+20,0,0> translate <0,.55,1.5>}
#local suoj=union {
#difference {
union {
torus {.7,.1 rotate <0,0,90> translate <-2.1,.5,-1.5>}
torus {.7,.1 rotate <0,0,90> translate <2.1,.5,-1.5>}
#difference {
cylinder {<-2.1,.5,-1.5>,<2.1,.5,-1.5>,.8}
cylinder {<-2.2,.5,-1.5>,<2.2,.5,-1.5>,.6}
}
}
plane {y,.5}
plane {-z,1.5}
}
cylinder {<-2.1,.5,-2.2>,<2.1,.5,-2.2>,.1 }
sphere {<-2.1,.5,-2.2>,.1}
sphere {<2.1,.5,-2.2>,.1}

pigment {White}
finish {phong .4}
}

object {suoj translate <0,.1,0>}
object {suoj translate <0,.1,0> rotate <0,180,0>}
union {
box {<-2.1,1.2,-1.5>,<2.1,1.4,1.5> }
cylinder {<-2.1,1.3,-1.5>,<-2.1,1.3,1.5>,.1}
cylinder {<2.1,1.3,-1.5>,<2.1,1.3,1.5>,.1}

box {<-.7,1.3,-1>,<.7,4,1>}
box {<-1,1.3,-.7>,<1,4,.7>}
cylinder {<-.7,1.3,-.7>,<-.7,4,-.7>,.3}
cylinder {<.7,1.3,-.7>,<.7,4,-.7>,.3}
cylinder {<-.7,1.3,.7>,<-.7,4,.7>,.3}
cylinder {<.7,1.3,.7>,<.7,4,.7>,.3}


#difference {
box {<-1.2,1.3,-1.2>,<1.2,1.6,1.2>}
cylinder {<-1.2,1.6,-1.2>,<1.2,1.6,-1.2>,.2}
cylinder {<-1.2,1.6,-1.2>,<1.2,1.6,-1.2>,.2 rotate <0,90,0>}
cylinder {<-1.2,1.6,-1.2>,<1.2,1.6,-1.2>,.2 rotate <0,180,0>}
cylinder {<-1.2,1.6,-1.2>,<1.2,1.6,-1.2>,.2 rotate <0,-90,0>}
sphere {<-1.2,1.6,-1.2>,.2}
sphere {<-1.2,1.6,-1.2>,.2 rotate <0,90,0>}
sphere {<-1.2,1.6,-1.2>,.2 rotate <0,-90,0>}
sphere {<-1.2,1.6,-1.2>,.2 rotate <0,180,0>}
}
#difference {
cylinder {<-1.5,3.5,-1.5>,<-1.5,3.5,1.5>,.5}
cylinder {<-1.5,3.5,-1.6>,<-1.5,3.5,1.4>,.4}
}
torus {.45,.05 rotate <90,0,0> translate <-1.5,3.5,-1.5>}
torus {.45,.05 rotate <90,0,0> translate <-1.5,3.5,1.5>}
cylinder {<-1.5,3.5,1.5>,<-1.5,3.5,1.55>,.45}
#difference {
cylinder {<1.5,3.5,-1.5>,<1.5,3.5,1.5>,.5}
cylinder {<1.5,3.5,-1.6>,<1.5,3.5,1.4>,.4}
}
torus {.45,.05 rotate <90,0,0> translate <1.5,3.5,-1.5>}
torus {.45,.05 rotate <90,0,0> translate <1.5,3.5,1.5>}
cylinder {<1.5,3.5,1.5>,<1.5,3.5,1.55>,.45}

box {<-1.9,4,-1>,<-1.9,5,1>}
box {<1.9,4.1,-1.1>,<-1.9,4.9,1.1>}
box {<2,4.1,-1>,<-2,4.9,1>}
cylinder {<1.9,4.9,-1>,<-1.9,4.9,-1>,.1}
cylinder {<1.9,4.9,1>,<-1.9,4.9,1>,.1}
cylinder {<-1.9,4.9,1>,<-1.9,4.9,-1>,.1}
cylinder {<1.9,4.9,1>,<1.9,4.9,-1>,.1}

cylinder {<1.9,4.1,-1>,<-1.9,4.1,-1>,.1}
cylinder {<1.9,4.1,1>,<-1.9,4.1,1>,.1}
cylinder {<-1.9,4.1,1>,<-1.9,4.1,-1>,.1}
cylinder {<1.9,4.1,1>,<1.9,4.1,-1>,.1}

cylinder {<-1.9,4.1,-1>,<-1.9,4.9,-1>,.1}
cylinder {<1.9,4.1,-1>,<-1.9,4.9,-1>,.1}
cylinder {<-1.9,4.1,-1>,<1.9,4.9,-1>,.1}
cylinder {<1.9,4.1,-1>,<1.9,4.9,-1>,.1}

sphere {<1.9,4.1,-1>,.1}
sphere {<-1.9,4.1,-1>,.1}
sphere {<1.9,4.1,1>,.1}
sphere {<-1.9,4.1,1>,.1}

sphere {<1.9,4.9,-1>,.1}
sphere {<-1.9,4.9,-1>,.1}
sphere {<1.9,4.9,1>,.1}
sphere {<-1.9,4.9,1>,.1}

pigment {White}
finish {phong .4}
}

difference {
merge {
cone {<-1,4.5,-1>,.2,<-1,4.5,-2>,.1 }
sphere {<-1,4.5,-2>,.2}
cone {<1,4.5,-1>,.2,<1,4.5,-2>,.1 }
sphere {<1,4.5,-2>,.2}

}
cone {<-1,4.5,-1>,.15,<-1,4.5,-2>,0 }
cone {<1,4.5,-1>,.15,<1,4.5,-2>,0 }
pigment {rgbf <1,0,0,1>}
normal {hexagon .2}
interior {ior 1.55}
}


cylinder {<-1.5,3.5,0>,<-1.5,3.5,-200>,.4 
hollow
pigment {rgbf <1,1,1,1>}

interior {
media {
emission rgb <1,.5,.5>
}
}
}


cylinder {<1.5,3.5,0>,<1.5,3.5,-200>,.4 
hollow
pigment {rgbf <1,1,1,1>}

interior {
media {
emission rgb <1,.5,.5>
}
}
}

}





/*
cylinder {<1.5,3.5,0>,<1.5,3.5,-200>,.4 
hollow
pigment {rgbf <1,1,1,1>}

interior {
media {
scattering { 2, rgb <1,0,0> extinction 1 } 
emission rgb <1,1,1>
density {spherical density_map {
[0.0 rgb <1,1,1>]
[0.5 rgb <1,0,0>]
}
}
}
}


}
*/
