
// ==== Standard POV-Ray Includes ====
#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions
#switch (clock)
#range (0,1)
#declare clocka=clock;
#break
#range (1,2)
#declare clocka=1
#break
#end

#switch (clock)
#range (0,1.25)
#declare kirka=1;
#break
#range (1.25,2)
#declare kirka=(1.5-clock)*4
#break
#end
#include "shaknap2.inc"
#include "blobfont.inc"

global_settings {ambient_light kirka}

camera
{
  location  <0.0 , 3+clocka ,-8-clocka*8.0>
  look_at   <0.0 , clocka*4 , 0.0>
}

light_source
{
  0*x // light's position (translated below)
  color red kirka  green kirka  blue pow(kirka,2)  // light's color
  translate <-20, 40, -20>
}

union {
object {vsotilas translate <-2-clocka*5,0,-3+clocka*3>}
object {vsotilas rotate <0,0,clocka*-45> translate <-2-clocka*5,clocka*1.7,-2+clocka*2>}
object {vsotilas rotate <0,0,clocka*45> translate <-2-clocka*4,-1.7*clocka,-1+clocka>}
object {vsotilas rotate <0,0,clocka*-225> translate <-2-clocka*2.2,-.8*clocka,0>}
object {vsotilas rotate <0,0,clocka*225> translate <-2-clocka*3.6,2.5*clocka,1-clocka>}

object {vtorni translate <-3,-1.7*clocka,-3+clocka*3>}
object {vkuningas translate <-3,0.4*clocka,1-clocka>}
object {vtorni translate <-3+clocka*2.3,-1.7*clocka,4-clocka*4>}
object {vkuningatar translate <-3+clocka*2.3,0.4*clocka,0>}
object {vlahetti rotate <0,0,90*clocka> translate <-3+clocka*2,0.2,-1+clocka>}

object {vhevonen translate <-3+clocka*4,.2*clocka,-2+clocka*2>}
object {vhevonen translate <-3+clocka*4,-1.7*clocka,3-clocka*3>}
object {vsotilas rotate <0,0,-90*clocka> translate <-2+3.7*clocka,1.6*clocka,2-clocka*2>}
object {vsotilas rotate <0,0,-90*clocka> translate <-2+3.7*clocka,0,3-clocka*3>}
object {vsotilas rotate <0,0,-90*clocka> translate <-2+3.7*clocka,-1.6*clocka,4-clocka*4>}

object {msotilas rotate <0,0,-50*clocka> translate <3+clocka,1*clocka,-3+clocka*3>}
object {msotilas rotate <0,0,50*clocka> translate <3+clocka*3.5,1*clocka,-2+clocka*2>}
object {mkuningatar rotate <0,0,60*clocka> translate <4+clocka*1.6,-.3*clocka,0>}
object {msotilas rotate <0,0,50*clocka> translate <3+clocka*1.7,-1.8*clocka,-1+clocka*1>}
object {msotilas rotate <0,0,-50*clocka> translate <3+clocka*2.2,-1.8*clocka,0>}

object {msotilas rotate <0,0,-50*clocka> translate <3+clocka*4,1*clocka,1-clocka>}
object {msotilas rotate <0,0,50*clocka> translate <3+clocka*6.5,1*clocka,2-clocka*2>}
object {mkuningas rotate <0,0,60*clocka> translate <4+clocka*4.6,-.3*clocka,1-clocka>}
object {msotilas rotate <0,0,50*clocka> translate <3+clocka*4.7,-1.8*clocka,3-clocka*3>}
object {msotilas rotate <0,0,-50*clocka> translate <3+clocka*5.2,-1.8*clocka,4-clocka*4>}
translate <-clocka,clocka*8>
}

box {<-3.5,0,-3.5>,<4.5,-.5,4.5> pigment {checker Black,White translate <-.5,0,-.5>}}

object {vlahetti translate <-3,0,2>}

object {mlahetti translate <4,0,-1>}
object {mlahetti translate <4,0,2>}

object {mhevonen translate <4,0,-2>}
object {mhevonen translate <4,0,3>}

object {mtorni translate <4,0,-3>}
object {mtorni translate <4,0,4>}

union {
object {bb translate <-1.5,0,0>}
object {yy translate <1.5,0,0>}
scale .4
translate <0,4.6,0>
}

union {
object {mm translate <0,0,0>}
object {aa translate <3,0,0>}
object {tt translate <6,0,0>}
object {tt translate <9,0,0>}
object {ii translate <12,0,0>}

object {rr translate <18,0,0>}
object {aa translate <21,0,0>}
object {ii translate <24,0,0>}
object {tt translate <27,0,0>}
object {oo translate <30,0,0>}
object {hh translate <33,0,0>}
object {aa translate <36,0,0>}
object {rr translate <39,0,0>}
object {jj translate <42,0,0>}
object {uu translate <45,0,0>}
scale .4
translate <-8.7,2.4,0>
}



plane {y,-.5 pigment {Green}}

// 3D curved FINITE (no CSG) surface created from a mesh of triangles

sphere {<0,0,0>,10 scale <2,.4,1> translate <-3,-.8,17> pigment {Green}}
bicubic_patch
{
  type 1 // patch_type (0..1)
  flatness 0.1 // flatness value
  u_steps 3 // # of triangles to subdivide (1-5)
  v_steps 3 // # of triangles to subdivide (1-5)
  <-20, 0, 10> <-10, 0, 5> <10, 0, 5> <20, 0, 10>
  <-25, 0, 20> <-10, 20, 20> <10, 30, 20> <25, 1, 20>
  <-25, 0, 30> <-10, 22, 30> <10, 40, 30> <25, 2, 30>
  <-20, 0, 40> <-10, 0, 45> <10, 0, 45> <20, 0, 40>
pigment {Green}
translate <20,-.5,50>
}

bicubic_patch
{
  type 1 // patch_type (0..1)
  flatness 0.1 // flatness value
  u_steps 3 // # of triangles to subdivide (1-5)
  v_steps 3 // # of triangles to subdivide (1-5)
  <-20, 0, 10> <-10, 0, 5> <10, 0, 5> <20, 0, 10>
  <-25, 0, 20> <-10, 20, 20> <10, 30, 20> <25, 1, 20>
  <-25, 0, 30> <-10, 22, 30> <10, 0, 30> <25, 2, 30>
  <-20, 0, 40> <-10, 0, 45> <10, 0, 45> <20, 0, 40>
pigment {Green}
scale <4,2,2>
translate <-70,-.5,160>
}


bicubic_patch
{
  type 1 // patch_type (0..1)
  flatness 0.1 // flatness value
  u_steps 3 // # of triangles to subdivide (1-5)
  v_steps 3 // # of triangles to subdivide (1-5)
  <-20, 0, 10> <-10, 0, 5> <10, 0, 5> <20, 0, 10>
  <-25, 0, 20> <-10, 10, 20> <10, 2, 20> <25, 1, 20>
  <-25, 0, 30> <-10, 10, 30> <10, 10, 30> <25, 2, 30>
  <-20, 0, 40> <-10, 0, 45> <10, 0, 45> <20, 0, 40>
pigment {Green}
scale .2
translate <-3,-.5,-14>
}

sky_sphere {pigment {gradient y color_map {[0.0 White*kirka] [1 Blue*kirka]}}}
