
// ==== Standard POV-Ray Includes ====
#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions
#include "shaknap.inc"
#include "stones.inc"
#include "aukuk.inc"
#include "skies.inc"

#declare clocka=clock;
#switch (clocka)
#range (-180,-75)
#declare kirk=(clocka+90)/15;
#break
#range (-75,75)
#declare kirk=1;
#break
#range (75,180)
#declare kirk=-(clocka-90)/15;
#break
#end
global_settings {ambient_light kirk}
#declare aur=clocka;

sky_sphere { pigment {gradient y color_map {
[0.0 White*kirk]
[0.7 Blue*kirk]
}}
}

camera
{
  location  <-13.0 , 4.0 ,2.0>
  look_at   <0.0 , 2.1 , 0.0>
}


light_source
{
  0*x // light's position (translated below)
  color rgb <1,1,1>*kirk
  translate <-10, 10, -10>
}

light_source
{
  0*x // light's position (translated below)
  color rgb <1,1,1>*kirk
looks_like {sphere {<0,0,0>,5 pigment {Yellow} finish {ambient 1}}}
translate <300, 0, 0>
rotate <0,aur,0>
rotate <0,0,30>
}


box {<-4,0,-4>,<4,-1,4> texture {ruutu}}
difference {
union {
cylinder {<-4,-1,-4>,<4,-1,-4>,1}
cylinder {<-4,-1,4>,<4,-1,4>,1}
cylinder {<-4,-1,4>,<-4,-1,-4>,1}
cylinder {<4,-1,4>,<4,-1,-4>,1}
sphere {<-4,-1,-4>,1}
sphere {<4,-1,-4>,1}
sphere {<-4,-1,4>,1}
sphere {<4,-1,4>,1}
}
plane {y,-1}
texture {T_Stone23}
}

#switch (clocka)
#range (-180,-40)
#declare esp=0;
#break
#range (-40,-20)
#declare esp=(clocka+40)/20;
#break
#range (-30,180)
#declare esp=1;
#break
#end

#switch (clocka)
#range (-180,30)
#declare espa=0;
#break
#range (30,60)
#declare espa=(clocka-30)/10;
#break
#range (60,180)
#declare espa=1;
#break
#end

object {vsotilas translate <1.5,0,0.5>}
object {vsotilas translate <3.5,0,1.5>}
object {vsotilas translate <2.5,0,1.5>}


object {msotilas translate <-6.1,-.5,2>}
object {msotilas translate <-6,-.5,1>}
object {msotilas translate <1,-.5,6>}
object {msotilas translate <2,-.5,6>}
object {msotilas translate <3,-.5,6.1>}
object {mtorni translate <4,-.5,5.8>}
object {mhevonen translate <5,-.5,6>}
object {mlahetti translate <-6.2,-.5,3>}
object {mkuningatar translate <-5.8,-.5,4.3>}
object {mtorni translate <-3,-.5,6>}
object {mhevonen translate <-2,-.5,6.1>}
object {mlahetti translate <-1,-.5,6.4>}
object {msotilas translate <0,-.5,6.5>}
object {msotilas translate <-4,-.5,6>}
object {msotilas translate <-5,-.5,6.3>}

object {vsotilas translate <-1,-.5,-6.1>}
object {vlahetti translate <-2.,-.5,-6>}
object {vlahetti translate <-4,-.5,-6>}
object {vhevonen translate <-3,-.5,-6.2>}

object {vsotilas translate <-6,-.5,-4>}
object {vsotilas translate <-5.6,-.5,-3>}
object {vsotilas translate <-6.2,-.5,-2>}
object {vsotilas translate <-6,-.5,-1>}
object {vhevonen translate <-6.2,-.5,-5>}


object {vtorni translate <3.5,0,-3.5+esp>}
object {vtorni translate <-3.5,0,-3.5>}
object {vkuningatar translate <-2.5,0,-1.5>}
object {vkuningas translate <-.5,0,3.5>}

object {mkuningas translate <.5,0,-2.5>}


difference {
union {
box {<8,-10,-50>,<8.1,100,50> texture {lautapuu}}
box {<7.85,-10,-50>,<8.2,100,50> texture {lautapuu2}}
}
box {<7,2,-10>,<9,16,10> texture {lautapuu2}}
}
box {<8,1.9,-10.5>,<7.7,2.3,10.5> pigment {White}}
box {<8,15.9,-10.5>,<7.7,16.3,10.5> pigment {White}}
box {<8,16.3,-10.5>,<7.7,1.9,-10> pigment {White}}
box {<8,16.3,10.5>,<7.7,1.9,10> pigment {White}}
box {<7.9,2,-10>,<8,16,10> texture {
    pigment { rgbf <0.98, 0.98, 0.98, 0.9> }
normal {bozo .25 scale 1.2}
    finish  {
        ambient 0.1
        diffuse 0.1
        reflection 0
        refraction 0.9
        ior 1.45
        specular 0.8
        roughness 0.0003
        phong 1
        phong_size 400
     }
}}


box {<-800,-10,-50>,<8.1,100,-50> texture {lautapuu}}
box {<-800,-10,50>,<8.1,100,50> texture {lautapuu}}
box {<-7,-.5,-7>,<7,-2,7> texture {poyt}}
box {<8,-10,-500>,<-10,-11,500> texture {vpuu scale 2}}
plane {y,-11 pigment {agate pigment_map {
[0.0 rgbf <0,1.5,0,0>]
[0.3+clocka/400 rgbf <1,1,1,0>]
[0.7+clocka/400 rgbf <1,1,1,0>]
[1.0 rgbf <1,1,1,0>]
}}
normal {granite 1}}



box {<8,7,-12>,<7.8,6,-16> pigment {Gray40}}
box {<8,6,-12>,<7.8,3,-16> pigment {White} normal {waves 1}}

text
{
  ttf             // font type (only TrueType format for now)
  "c:\windows\fonts\ariblk.ttf",  // Microsoft Windows-format TrueType font file name
  "3.4",      // the string to create
  .1,              // the extrusion depth
  0               // inter-character spacing
scale 1.6
rotate <0,90,0>
translate <7.78,4,-12.3>
pigment {Black}
}
/*
#declare ekkl=seed(320);
#declare xx=10;
#while (xx<22)
#declare yy=-15;
#while (yy<15)
object {kukka rotate <0,270,0> rotate <0,aur,0> scale .3 translate <xx+rand(ekkl)*3,6,yy+rand(ekkl)*3>}
#declare yy=yy+7;
#end
#declare xx=xx+5;
#end
*/
union {

cylinder {<0,-10,0>,<0,5,0>,2 pigment {Brown}}

sphere {<0,7.5,0>,9 pigment {agate pigment_map {
[0.0 rgbf <1,1,1,1>]
[0.9 rgbf <1,1,1,1>]
[0.95 rgbf <0,1,0,0>]
[1.0 rgbf <.5,2,.5,0>]
}}}


sphere {<0,7.5,0>,7 pigment {agate pigment_map {
[0.0 rgbf <1,1,1,1>]
[0.7 rgbf <1,1,1,1>]
[0.8 rgbf <1,.6,0,0>]
[1.0 rgbf <1,.6,0,0>]
}
scale 2
}}

translate <45,0,4>
}


union {
union {
sphere {<0,-5,0>,5}
sphere {<0,1,0>,3}
sphere {<0,4,0>,2}
pigment {White}
normal {granite .2}
}
cylinder {<0,5.5,0>,<0,5.6,0>,3 pigment {Gray10}}
cylinder {<0,5.5,0>,<0,7,0>,1 pigment {Gray10}}
cone {<-1,4,0>,1,<-4,4,0>,0 pigment {rgb <1,.5,0>}}
translate <0,10,0>
scale <1,(-clocka+120)/220,1>
translate <0,-10,0>
translate <20,0,-4>
}
