// Persistence of Vision Ray Tracer Scene Description File
// File: CatHand.inc
// Vers: 3
// Desc: An include file that creates an animated hand
//       I modified the "hand" blob example in the POV docs to be animation-ready.
//       (I need *somebody* to toss the paperwad for the Cat! :-) )
// Date: 9/26/98
// Auth: Steve Sloan II

#declare Hand = 
union {
    blob {
        threshold .65
    
        /***************/
        /* Hand "Body" */
        /***************/
        
        sphere { <-.23,-.32,0>,.43, 1 scale <1.95,1.05,.8> }   //palm
        sphere { <+.12,-.41,0>,.43, 1 scale <1.95,1.075,.8> }  //palm
        sphere { <-.23,-.63,0>, .45, .75 scale <1.78, 1.3,1> } //midhand
        sphere { <+.19,-.63,0>, .45, .75 scale <1.78, 1.3,1> } //midhand
        sphere { <-.22,-.73,0>, .45, .85 scale <1.4, 1.25,1> } //heel
        sphere { <+.19,-.73,0>, .45, .85 scale <1.4, 1.25,1> } //heel
        
        /*********/
        /* Pinky */
        /*********/
        
        //lower pinky
        cylinder {
            0, <0,.56,-.05>, .26, 1
            rotate -pinky_angle*x
            translate <-.65,-.28,0>
        }
        //upper pinky
        cylinder {
            0, <0, .4,-.25>, .26, 1
            rotate -pinky_angle*x
            translate <0,.56,-.05>
            rotate -pinky_angle*x
            translate <-.65,-.28,0>
        }
    
        //counteract pinky palm bulge
        sphere { <-.65,-.28,0>, .26, -1 }
        //counteract pinky knuckle bulge
        sphere { <0,.56,-.05>, .26, -1 rotate -pinky_angle*x translate <-.65,-.28,0> }
    
        /********/
        /* Ring */
        /********/
        
        //lower ring
        cylinder {
            0, <0,.72,-.05>, .26, 1
            rotate -ring_angle*x
            translate <-.3,-.28,0>
        }
        //upper ring
        cylinder {
            0, <0, .46,-.25>, .26, 1
            rotate -ring_angle*x
            translate <0,.72,-.05>
            rotate -ring_angle*x
            translate <-.3,-.28,0>
        }
    
        //counteract ring palm bulge
        sphere { <-.3,-.28,0>, .26, -1 }
        //counteract ring knuckle bulge
        sphere {
            <0,.72,-.05>, .26, -1
            rotate -ring_angle*x
            translate <-.3,-.28,0>
        }
    
        /**********/
        /* Middle */
        /**********/
        
        //lower middle
        cylinder {
            0, <0, .77,-.05>, .26, 1
            rotate -middle_angle*x
            translate <.05,-.28,0>
        }
        //upper middle
        cylinder {
            0, <0,.46,-.25>, .26, 1
            rotate -middle_angle*x
            translate <0,.77,-.05>
            rotate -middle_angle*x
            translate <.05,-.28,0>
        }
    
        //counteract middle palm bulge
        sphere { <.05,-.28,0>, .26, -1 }
        //counteract middle knuckle bulge
        sphere {
            <0,.77,-.05>, .26, -1
            rotate -middle_angle*x
            translate <.05,-.28,0>
        }
    
        /*********/
        /* Index */
        /*********/
        
        //lower index
        cylinder {
            0, <0, .912, -.05>, .26, 1
            rotate -index_angle*x
            translate <.4,-.4,0>
        }
        //upper index
        cylinder {
            0, <0, .338, -.25>, .26, 1
            rotate -index_angle*x
            translate <0, .912, -.05>
            rotate -index_angle*x
            translate <.4,-.4,0>
        }
    
        //counteract index palm bulge
        sphere { <.4,-.4,0>, .26, -1 }
        //counteract index knuckle bulge
        sphere {
            <0, .912, -.05>, .26, -1
            rotate -index_angle*x
            translate <.4,-.4,0>
        }
    
        /*******/
        /* Arm */
        /*******/
        
//        cylinder { 0, -4*y, 1, 1 scale <1, 1, 0.5> translate -1.5*y translate 0.1*z }
        cylinder { 0, -4*y, 1, 1 scale <1, 1, 0.6> translate -1.5*y translate 0.1*z }
//        sphere { 0, 1, 1 scale <1.5, 3.5, 1.2> translate -5.5*y translate 0.1*z }
        sphere { 0, 1, 1 scale <1.5, 4, 1.2> translate -5.5*y translate 0.1*z }
    }
    blob {
        threshold .65
    
        /***************/
        /* Hand "Body" */
        /***************/
        
        sphere { <-.23,-.32,0>,.43, 1 scale <1.95,1.05,.8> }   //palm
        sphere { <+.12,-.41,0>,.43, 1 scale <1.95,1.075,.8> }  //palm
        sphere { <-.23,-.63,0>, .45, .75 scale <1.78, 1.3,1> } //midhand
        sphere { <+.19,-.63,0>, .45, .75 scale <1.78, 1.3,1> } //midhand
        sphere { <-.22,-.73,0>, .45, .85 scale <1.4, 1.25,1> } //heel
        sphere { <+.19,-.73,0>, .45, .85 scale <1.4, 1.25,1> } //heel

        /*********/
        /* Thumb */
        /*********/
        
        //lower thumb
        cylinder {
            0, <.44, .27, -.05>, .25, 1
            rotate thumb_hor_angle*y
            rotate thumb_angle*z
            translate <.41, -.95,0>
        }
        //upper thumb
        cylinder {
            0, <.35, .28, -.25>, .25, 1
            rotate thumb_angle*z
            translate <.44, .27, -.05>
            rotate thumb_angle*z
            rotate thumb_hor_angle*y
            translate <.41, -.95,0>
        }
    
        //counteract thumb heel bulge
        sphere {
            <0,-.25,0>, .25, -.89
            rotate thumb_hor_angle*y
            translate <.41, -.95,0>
        }
        //counteract thumb knuckle bulge
        sphere {
            <.44, .27, -.05>, .25, -1
            rotate thumb_hor_angle*y
            rotate thumb_angle*z
            translate <.41, -.95,0>
        }
    
        /*******/
        /* Arm */
        /*******/
        
//        cylinder { 0, -4*y, 1, 1 scale <1, 1, 0.5> translate -1.5*y translate 0.1*z }
        cylinder { 0, -4*y, 1, 1 scale <1, 1, 0.6> translate -1.5*y translate 0.1*z }
//        sphere { 0, 1, 1 scale <1.5, 3.5, 1.2> translate -5.5*y translate 0.1*z }
        sphere { 0, 1, 1 scale <1.5, 4, 1.2> translate -5.5*y translate 0.1*z }
    }
    scale 3
    scale in
    pigment { Flesh }
}

#declare Arm =
union {
    object { Hand translate  12.3*in*y }
    cylinder { -3*in*x, 3*in*x, 0.1*in pigment { color Red } }
    no_shadow
}

