// Persistence of Vision Ray Tracer Scene Description File
// File: CatJump.inc
// Vers: 3.1
// Desc: A scene file showing a cat jumping for a paperwad
// Date: 10/13/98
// Auth: Steve Sloan II

#include "colors.inc"
#include "textures.inc"
#include "catmacro.inc"

/**************/
/* Create Cat */
/**************/

/* Define the control points of the body */
/* The points are: muzzle, head center, shoulder, mid-back, rump, and guide point */

#declare Bodyx =    array[6]{    1,    0,    0, 0,     0,    0 }
#declare Bodyy =    array[6]{ 0.57, 2.47,    0, 0,     0,    0 }
#declare Bodyz =    array[6]{ 6.84, 4.82, 2.69, 0, -5.37,   -9 }

#declare Bodyxrad = array[6]{ 0.5, 0.5, 2.24, 2,  2.24, 2.24 }
#declare Bodyyrad = array[6]{ 0.5, 0.5, 2.24, 2,  2.24, 2.24 }

/* Define the control points of the tail */
/* The points are: control point, base of tail, end of tail, */
/*     control point (Only change the last two points) */
/* Tail is about 9 in long */

// SineWaveClock(2*cat_clock)
//#declare Tailx   = array[4]{   0,   0,    5 - 10*SineWaveClock(2*cat_clock),
//                             15  - 30*SineWaveClock(2*cat_clock) }
#declare Tailx   = array[4]{   0,   0,    5,  15 }
#declare Taily   = array[4]{   0,   0,    7,   5 }
#declare Tailz   = array[4]{   3,   0,    4,  10 }

#declare Tailrad = array[4]{ 0.9, 0.6, 0.45, 0.45 }

/* Jaw */
#declare JawAngle = 0;

/* Ears */
#declare Ear1Rot = 0;
#declare Ear2Rot = 0;
//#declare Ear1Height = 1 - clock;
//#declare Ear2Height = 1 - clock;
#declare Ear1Height = 1;
#declare Ear2Height = 1;

/* Eyes */
#declare LEyeOpen = 1;
#declare REyeOpen = 1;

/* Left Arm */
#declare LArmAngle = -10;
#declare LForearmAngle = 0;
#declare LFrontPawAngle = 0;

/* Right Arm */
#declare RArmAngle = -10;
#declare RForearmAngle = 0;
#declare RFrontPawAngle = 0;

/* Head position */
#declare HeadYaw  =  0;

#declare cat_scene_runtime = 4*s;

#switch (cat_action)

    /*************************************/
    /* Cat sits and watches the paperwad */
    /*************************************/
    
    #case (CatWatch)
        /* Left Leg */
        #declare LThighAngle   =   30;
        #declare LHeelAngle    = -150;
        #declare LHindPawAngle =  -50;
        
        /* Right Leg */
        #declare RThighAngle   =   30;
        #declare RHeelAngle    = -150;
        #declare RHindPawAngle =  -50;

        /* Head position */
        #declare HeadRoll  =  0;

        #switch (cat_clock)
            /* Catching and throwing the paperwad (first hand) */
            #range (0, throw_time)
                #declare HeadYaw   = 45;
                #declare HeadAngle = 30;
            #break;
            
            /* Flying paperwad */
            #range (throw_time, catch_time)
                #declare current_clock = (cat_clock - throw_time) /
                                         (catch_time - throw_time);
                #declare HeadYaw   = 45 - 90*current_clock;
                #declare HeadAngle = 30 + 20*SineWaveClock(current_clock);
            #break;
            
            /* Throwing the paperwad (other hand) */
            #range (catch_time, throw2_time)
                #declare HeadYaw   = -45;
                #declare HeadAngle = 30;
            #break;
            
            /* Flying paperwad the other way */
            #range (throw2_time, catch2_time)
                #declare current_clock = (cat_clock - throw2_time) /
                                         (catch2_time - throw2_time);
                #declare HeadYaw   = 90*current_clock - 45;
                #declare HeadAngle = 30 + 20*SineWaveClock(current_clock);
            #break;
            
            #range (catch2_time, scene_runtime)
                #declare HeadYaw   = 45;
                #declare HeadAngle = 30;
            #break;            
        #end
    
        #include "cat.inc"
    
        #declare JumpingCat = 
        object {
            Cat
            rotate -10*x
            translate 5*in*y
        }    
    #break // end of CatWatch

    /***********************************/
    /* Cat tries to catch the paperwad */
    /***********************************/
    
    #case (CatMiss)
        /* Left Leg */
        #declare LThighAngle   =   30*(1 - cat_clock);
        #declare LHeelAngle    = -150 + 120*cat_clock;
        #declare LHindPawAngle =  -40*(1 - cat_clock);
        
        /* Right Leg */
        #declare RThighAngle   =   30*(1 - cat_clock);
        #declare RHeelAngle    = -150 + 120*cat_clock;
        #declare RHindPawAngle =  -40*(1 - cat_clock);
        
        /* Head position */
        #declare HeadAngle = 30;
        #declare HeadRoll  =  0;
    

        #switch (cat_clock)
            /* Catching and throwing the paperwad (first hand) */
            #range (0,  catch_time)
                #declare current_clock = cat_clock / catch_time;
                #declare HeadYaw   = 0;
                #declare HeadAngle = 30;
                #declare cat_speed = <0, 120, 30>; 
            #break;
            
            /* Throwing the paperwad (other hand) */
            #range (catch_time, scene_runtime)
                #declare current_clock = (cat_clock - catch_time) /
                                         (scene_runtime - catch_time);
                #declare HeadYaw   = 0;
                #declare HeadAngle = 30;
                #declare cat_speed = <0, 120, 30>; 
            #break;            
        #end
    
        #include "cat.inc"
    
        #declare JumpingCat = 
        object {
            Cat
//            rotate -30*SineWaveClock(cat_clock)*x
            rotate -10*x
            rotate 5*y
            translate projectile(cat_speed, current_clock)
            #if (cat_clock < catch_time) rotate 5*y #end
            translate 5*in*y
        }    
    #break // end of CatMiss
#end
