// Persistence of Vision Ray Tracer Scene Description File
// File: CatLand.pov
// Vers: 3.1
// Desc: A scene file showing the cat, with the paperwad finally caught
// Date: 10/15/98
// Auth: Steve Sloan II

#include "colors.inc"
#include "textures.inc"
#include "catmacro.inc"

/*********/
/* Units */
/*********/

// Length
#declare inch   = 1;
#declare in     = inch;
#declare inches = inch;
#declare feet   = 12*inch;
#declare foot   = 12*inch;
#declare ft     = 12*inch;
#declare meters = 39.37*inch;

// Time
#declare s         =    1;
#declare sec       =    s;
#declare minute    = 60*s;

// Physical Constants
#declare gravconst =  9.8*meters; // m/s^2
		
sky_sphere { pigment { color SkyBlue } }

#if (clock < 0.5)
    camera {
        location < 2*ft, 16*in,  8*ft>
        look_at  <    0,     0,  7*ft>
    }
    #declare light_factor = 1;
#else
    camera {
        location < (2 + 10*(2*clock - 1))*ft, 16*in,  8*ft>
        look_at  <    0,     0,  7*ft>
    }
    #declare light_factor = (1 - (2*clock - 1));
#end

/**********/
/* Lights */
/**********/

// (Light colors came from figure 14.2 of Bill
//   Fleming's 3D PHOTOREALISM TOOLKIT, at
//   http://www.wiley.com/compbooks/fleming/)

// Light on center of ceiling
//light_source { <      0,   7.5*ft,    0> color rgb <.973, .918, .918>*light_factor }

// Lamps
light_source { <   7*ft,     3*ft,  -ft> color rgb <.973, .918, .918>*light_factor }
light_source { <   7*ft,     3*ft, 8*ft> color rgb <.973, .918, .918>*light_factor }

// Sunlight through Windows
light_source { <7000*ft, 14000*ft,    0> color White*2*light_factor }

/**************/
/* Create Cat */
/**************/

/* Define the control points of the body */
/* The points are: muzzle, head center, shoulder, mid-back, rump, and guide point */
//#declare Bodyx =    array[6]{    0,    0,    0, 0,     0,    0 }
//#declare Bodyy =    array[6]{ 0.57, 2.47,    0, 0,     0,    0 }
//#declare Bodyz =    array[6]{ 6.84, 4.82, 2.69, 0, -5.37,   -9 }
#declare Bodyx =    array[6]{     0,  0,    0, 0,     0,    0 }
#declare Bodyy =    array[6]{    -2, -1,    0, 0,     0,    0 }
#declare Bodyz =    array[6]{  7.84,  6, 2.69, 0, -5.37,   -9 }

#declare Bodyxrad = array[6]{ 0.5, 0.5, 2.24, 2,  2.24, 2.24 }
#declare Bodyyrad = array[6]{ 0.5, 0.5, 2.24, 2,  2.24, 2.24 }

/* Define the control points of the tail */
/* The points are: control point, base of tail, end of tail, */
/*     control point (Only change the last two points) */
/* Tail is about 9 in long */
//#declare Tailx   = array[4]{   0,   0,    5,  15 }
//#declare Taily   = array[4]{   0,   0,    7,   5 }
//#declare Tailz   = array[4]{   3,   0,    4,  10 }

#declare Tailx   = array[4]{ 0, 0,   5,  10 }
#declare Taily   = array[4]{ 0, 0,   0,   0 }
#declare Tailz   = array[4]{ 3, 0, -10, -15 }

#declare Tailrad = array[4]{ 0.9, 0.6, 0.45, 0.45 }

#declare body_clock = 4*clock;

#declare HeadAngle = -45 - 20*SineWaveClock(body_clock);
#declare HeadRoll  =   0;
#declare HeadYaw   =  20*SineWaveClock(body_clock);

/* Jaw */
#declare JawAngle = SineWaveClock(body_clock);

/* Ears */
#declare Ear1Rot = 1;
#declare Ear2Rot = 1;
#declare Ear1Height = 0;
#declare Ear2Height = 0;

/* Eyes */
#declare LEyeOpen = 1;
#declare REyeOpen = 1;

/* Left Arm */
#declare LArmAngle = 20*SineWaveClock(body_clock);
#declare LForearmAngle = 20*(1 - SineWaveClock(body_clock));
#declare LFrontPawAngle = 20*SineWaveClock(body_clock);

/* Right Arm */
#declare RArmAngle = 20*(1 - SineWaveClock(body_clock));
#declare RForearmAngle = 20*SineWaveClock(body_clock);
#declare RFrontPawAngle = 20*(1 - SineWaveClock(body_clock));

/* Left Leg */
#declare LThighAngle = 20*(1 - SineWaveClock(body_clock));
#declare LHeelAngle = 20*SineWaveClock(body_clock);
#declare LHindPawAngle = 20*(1 - SineWaveClock(body_clock));

/* Right Leg */
#declare RThighAngle = 20*(1 - SineWaveClock(body_clock));
#declare RHeelAngle = 20*SineWaveClock(body_clock);
#declare RHindPawAngle = 20*(1 - SineWaveClock(body_clock));

#include "cat.inc"
#include "catobjs.inc"
union {
    object {
        Cat rotate 180*z
        translate 2.25*in*y
    }
    object { Paperwad translate 5*in*y }
    rotate 10*SineWaveClock(body_clock)*z
    translate 7*ft*z
}

/**************/
/* Test Floor */
/**************/

//plane { y, 0 pigment { color White } }

/**************/
/* Room Scene */
/**************/

#include "catscen2.inc"

