/*******************/
/* Common Textures */
/*******************/

#declare CatSceneWood =
texture {
    pigment {
        wood
        color_map {
            [ 0.0     rgbft <0.3, 0.1, 0.05, 0.0, 0.0> ]
            [ 0.1     rgbft <0.3, 0.1, 0.05, 0.0, 0.0> ]
            [ 0.9     rgbft <0.25, 0.07, 0.038, 0.0, 0.0> ]
            [ 1.0     rgbft <0.25, 0.07, 0.038, 0.0, 0.0> ]
        }
        turbulence 0.05
        scale  <0.075, 0.075, 1.0>
    }
}

#declare PaperwadTexture = 
texture {
    pigment { color White }
    normal { crackle 1 scale 0.5 } // Best so far
    finish { specular 0.5 roughness 0.15 }
}

/************/
/* Paperwad */
/************/

#declare Paperwad =
blob {
    threshold .65
    sphere { 0, 1, 1 scale 2.275 } // Main "wad"

    #declare R1 = seed(0);
    #declare R2 = seed(1);
    #declare R3 = seed(2);
    #declare R4 = seed(3);

    // Add some bumps
//    #declare bumpct = 0;
//    #while (bumpct < 15)
//        sphere {
//            0, 1, 1 scale 2.275
//            scale 0.5*rand(R1)
//            translate 0.8*rand(R2)*y
//            rotate 180*rand(R3)*x
//            rotate 360*rand(R4)*y
//        }
//        #declare bumpct = bumpct + 1;
//    #end

    texture { PaperwadTexture }
    scale 0.75*in
}

#declare Paperwad =
sphere { 0, 1 texture { PaperwadTexture } scale 0.75*in }

/**********/
/* Carpet */
/**********/

#declare Carpet =
plane {
    y, 0
    pigment { color rgb <0.65, 0.50, 0.39> }
//    finish { specular 0.5 roughness 0.15 }
    finish { specular 0.5 roughness 0.5 }
//    normal { bumps 1.0 scale  0.1 } // Doesn't animate right
}

/*******************/
/* Venetian Blinds */
/*******************/

#declare SingleBlind =
box {
    <-35.5, -1, -0.05>, <35.5, 1, 0.05>
    rotate -30*x
    pigment { color White }
}

#declare VenetianBlinds =
union {
    #declare BlindCount = 0;
    #while (BlindCount < 21)
        object { SingleBlind translate (2*BlindCount - 8)*y }
        #declare BlindCount = BlindCount + 1;
    #end
}

/****************************/
/* Fireplace and brick wall */
/****************************/

// Texturing came from a comp.graphics.rendering.raytracing
//     post by US (russtric@primenet.com)

#declare FireplaceTexture =
texture {
    pigment {
        brick  Gray75, White
        brick_size <8.5,2.75,4>
        mortar 0.5
    }
    normal {
        brick normal {bumps 0.3 turbulence .5}, normal{granite 0.2}
        brick_size <8.5,2.75,4>
        mortar 0.5
    }
}

#declare BlindsTexture =
texture {
    pigment {
        gradient y
        color_map {
            [ 0.0 White ]
            [ 0.8 White ]
            [ 0.8 color rgbt <1, 1, 1, 1> ]
            [ 1.0 color rgbt <1, 1, 1, 1> ]
        }
    }
    normal { gradient y }
    translate -100*y
}

#declare SingleBlindTexture =
texture {
    pigment {
        gradient y
        color_map {
            [ 0.0  White ]
            [ 0.5  color rgbf <1, 1, 1, 0.25> ]
            [ 1.0  White ]
        }
    }
    normal {
        gradient y
        slope_map {
            [0.0 <0,  1>]
            [0.5 <1, -1>]
            [1.0 <0,  0>]
        }
    }
    translate -10*y
    scale 0.95
}

#declare BlindsTexture2 =
texture {
    gradient y
    texture_map {
        [0.0  SingleBlindTexture ]
        [0.95 SingleBlindTexture ]
        [0.95 pigment { color White } finish { ambient 1 }]
        [1.0  pigment { color White } finish { ambient 1 }]
    }
    translate -100*y
}

// Fireplace mostly modeled with Moray

#declare UpperCubeandWall =
union {
    box { // Cube2
        <-1, -1, -1>, <1, 1, 1>
        scale <36.0, 72.0, 20>
        translate  -20*z
        translate  <0.0, 72.0, 13.25>
        translate -30*x
    }
    box { <-150, -24, 0>, <150, 90, -10> }
}
#declare InsideFireplace =
union {
    box { // Door
        <-1, -1, -1>, <1, 1, 1>
        scale <18.0, 15.0, 8.0>
        translate  <0.0, 15.0, 10.0>
        translate -30*x
    }
    box { // Cube4
        <-1, -1, -1>, <1, 1, 1>
        scale <32.0, 72.0, 15.0>
        translate  <0.0, 72.0, -5.75>
        translate -30*x
    }
    box { // Window1
        -1, 1
        scale <36.0, 21.0, 72.0>
        translate  <81.0, 47.0, 0.0>
        translate -30*x
    }
    box { // Window2
        -1, 1
        scale <36.0, 21.0, 72.0>
        translate  <-81.0, 47.0, 0.0>
        translate -30*x
    }
    box { // Doorway
        <-18, 0, 0>, <18, 80, 12>
        translate <115, -12, 0>
        texture { CatSceneWood }
    }
}
#declare UpperCube =
difference {
    object { UpperCubeandWall }
    object { InsideFireplace }
    translate  13.25*y
}

#declare Fireplace =
union { // Fireplace
    union {
        box { // Cube001
            <-1, 0, -1>, <1, 14.625, 1>
            scale <36.0, 1, 15.0>
            translate  <0.0, 0.0, 15.0>
            translate -30*x
        }
        object { UpperCube }
        texture { FireplaceTexture }
    }
    object { VenetianBlinds translate  <  51, 47, -3> }
    object { VenetianBlinds translate  <-111, 47, -3> }
    // Door stuff
    union {
        // Doorknob
        sphere {
            0, 1 scale 2
            translate <-14, 34, 2>
            texture { Tinny_Brass }
        }
        box { // Doorway
            <-18, 0, 0.5>, <18, 80, -12>
            texture { CatSceneWood }
        }
        union {
            box { <   18,  0, -1>, <20.5, 82.5, 1> }
            box { <-20.5,  0, -1>, < -18, 82.5, 1> }
            box { <-20.5, 80, -1>, <20.5, 82.5, 1> }
            pigment { color White }
        }
        translate 115*x
    }
    scale in
}

/***************/
/* Other Walls */
/***************/

#declare WallTexture =
texture {
    pigment { color White }
    normal {
        gradient x
        slope_map {
            [0    <1,  0>]   // start at top, with flat slope
            [0.85 <1, -1>]   // still at top, and slope down
            [0.9  <0,  0>]   // At bottom, with flat slope
            [0.95 <0,  1>]   // At bottom, and slope up
            [1    <1,  0>]   // finish at top, with flat slope
        }
        scale 8*in
        translate -50*ft*x
    }
}

#declare CeilingTexture =
texture {
    pigment { color White }
    normal { granite }
}

#declare Wall =
box { <-8, 0, 0>*ft, <8, 8.5, -0.5>*ft texture { WallTexture } }

#declare Long_Wall =
box { <-13, 0, 0>*ft, <13, 8.5, -0.5>*ft texture { WallTexture } }

#declare Ceiling =
box { <-8, 0, -13>*ft, <8, 1, 13>*ft texture { CeilingTexture } }


/****************/
/* Coffee Table */
/****************/

#declare Base1Round1 =
intersection {
    cylinder { // Base1Round1Main
        <0,0,1>, <0,0,0>, 1
        translate  0.5*y
    }
    plane { // Base1Round1Clip
        z,0 scale 0.1 rotate 90.0*x
    }
    scale <2.0, 2.0, 3.0>
    rotate -90.0*y
    translate  <1.5, 0.0, 8.5>
}
#declare Base1 =
union {
    box { // Base1Main
        <-1, -1, -1>, <1, 1, 1>
        scale <1.5, 1.5, 8.5>
        translate  1.5*y
    }
    object { Base1Round1 }
    object { // Base1Round2->Base1Round1
        Base1Round1
        translate  -17.0*z
    }
}
#declare Leg1 =
union {
    object { Base1 }
    cylinder { // Leg1Leg1
        <0,0,1>, <0,0,0>, 1
        scale <1.25, 1.25, 15.5>
        rotate -90.0*x
        translate  5.75*z
    }
    cylinder { // Leg1Leg2
        <0,0,1>, <0,0,0>, 1
        scale <1.25, 1.25, 15.5>
        rotate -90.0*x
        translate  -5.75*z
    }
    translate  19.5*x
}
#declare Leaf1 =
intersection {
    box { // Leaf1Main
        <-1, -1, -1>, <1, 1, 1>
        scale <27.0, 0.75, 4.45>
        translate  <0.0, 0.75, 4.55>
    }
    plane { // Leaf1Clip1
        z,0
        rotate 45.0*y
        translate  <27.0, 0.0, 5.5>
    }
    plane { // Leaf1Clip2
        z,0
        rotate -45.0*y
        translate  <-27.0, 0.0, 5.5>
    }
    texture { CatSceneWood }
    rotate 90.0*x
    translate  <0.0, 15.5, 10.0>
}

#declare TopSeam =
difference {
    box { // TopSceneOuter
        <-1, -1, -1>, <1, 1, 1>
        scale <24.5, 0.1, 7.5>
        translate  0.1*y
    }
    box { // TopSceneInner
        <-1, -1, -1>, <1, 1, 1>
        scale <24.4, 0.2, 7.4>
        translate  0.1*y
    }
    translate  1.4*y
}
#declare Top =
difference {
    box { // TopMain
        <-1, -1, -1>, <1, 1, 1>
        scale <27.0, 0.75, 10.0>
        translate  0.75*y
    }
    object { TopSeam }
    translate  15.5*y
}
#declare CoffeeTable =
union { // CoffeeTable
    object { Top }
    object { Leg1 }
    object { Leg1 translate  -39.0*x }
    object { Leaf1 }
    object { Leaf1 scale <1.0, 1.0, -1.0> }
    box { // Bottom
      <-1, -1, -1>, <1, 1, 1>
      scale <19.5, 0.5, 3.0>
      translate  1.5*y
    }
    box { // TopUnderneath
      <-1, -1, -1>, <1, 1, 1>
      scale <22.0, 1.5, 8.0>
      translate  14.0*y
    }
    texture { CatSceneWood }
    rotate 90*y
}


/*****************************/
/* TV, Stand, VCR, Speakers, */
/* and Videotapes            */
/*****************************/

// Textures

#declare BlackTexture =
texture { pigment { color rgb <0.1, 0.1, 0.1> } }

#declare BlackGlassTexture =
texture {
    pigment { color rgb <0.1, 0.1, 0.1> }
    finish { ambient 0.1 phong 0.5 }
}

#declare VCRTexture =
texture {
    pigment {
        image_map { gif   "C:\Include\vcrfront.gif" }
        scale  2.01
        translate    <-1.005, -1.005, 0.0>
    }
}

#declare VideotapeTexture =
texture {
    pigment {
        gradient y
        pigment_map {
            [0.0 color rgb <0.0, 0.0, 0.0> ]
            [0.2 color rgb <0.0, 0.0, 0.0> ]
            [0.2
               gradient x
               color_map {
                  [ 0.0     rgbft <0.0, 0.0, 0.0, 0.0, 0.0> ]
                  [ 0.15    rgbft <0.0, 0.0, 0.0, 0.0, 0.0> ]
                  [ 0.15    rgbft <1.0, 1.0, 1.0, 0.0, 0.0> ]
                  [ 0.95    rgbft <1.0, 1.0, 1.0, 0.0, 0.0> ]
                  [ 0.95    rgbft <0.0, 0.0, 0.0, 0.0, 0.0> ]
                  [ 1.0     rgbft <0.0, 0.0, 0.0, 0.0, 0.0> ]
               }
            ]
            [0.8
               gradient x
               color_map {
                  [ 0.0     rgbft <0.0, 0.0, 0.0, 0.0, 0.0> ]
                  [ 0.15    rgbft <0.0, 0.0, 0.0, 0.0, 0.0> ]
                  [ 0.15    rgbft <1.0, 1.0, 1.0, 0.0, 0.0> ]
                  [ 0.95    rgbft <1.0, 1.0, 1.0, 0.0, 0.0> ]
                  [ 0.95    rgbft <0.0, 0.0, 0.0, 0.0, 0.0> ]
                  [ 1.0     rgbft <0.0, 0.0, 0.0, 0.0, 0.0> ]
               }
            ]
            [0.8 color rgb <0.0, 0.0, 0.0> ]
            [1.0 color rgb <0.0, 0.0, 0.0> ]
        }
        scale  2.0
        translate    <-1.0, -1.0, 0.0>
    }
}

#declare WhiteTexture =
texture { pigment { color rgb <1.0, 1.0, 1.0> } }

#declare T_Wood15 =
texture {
    pigment {
         bozo
         color_map {
            [ 0.0     rgbft <0.3528, 0.217, 0.0546, 0.0, 0.0> ]
            [ 0.25    rgbft <0.4248, 0.26, 0.072, 0.0, 0.0> ]
            [ 0.4     rgbft <0.2735, 0.1665, 0.045, 0.0, 0.0> ]
            [ 0.5     rgbft <0.3024, 0.186, 0.045, 0.0, 0.0> ]
            [ 0.7     rgbft <0.2236, 0.1288, 0.0408, 0.0, 0.0> ]
            [ 0.98    rgbft <0.2124, 0.13, 0.0344, 0.0, 0.0> ]
            [ 1.0     rgbft <0.3528, 0.217, 0.0546, 0.0, 0.0> ]
         }
         turbulence 0.04
         scale  <0.05, 0.05, 1.0>
    }
}
texture {
    pigment {
        wood
        color_map {
            [ 0.0     rgbft <0.404, 0.21, 0.078, 0.2, 0.0> ]
            [ 0.25    rgbft <0.431, 0.225, 0.09, 0.8, 0.0> ]
            [ 0.4     rgbft <0.447, 0.233, 0.09, 0.2, 0.0> ]
            [ 0.5     rgbft <0.404, 0.21, 0.075, 0.6, 0.0> ]
            [ 0.7     rgbft <0.459, 0.222, 0.102, 0.2, 0.0> ]
            [ 0.98    rgbft <0.431, 0.225, 0.086, 0.4, 0.0> ]
            [ 1.0     rgbft <0.404, 0.21, 0.078, 0.1, 0.0> ]
        }
        turbulence 0.04
        scale  <0.2, 0.2, 1.0>
        rotate    <358.0, 2.0, 0.0>
    }
}

#declare BlackMeshTexture =
texture { pigment { color rgbt <0.1, 0.1, 0.1, 0.5> } }

// Completed Videotape
#declare Videotape = union {
  box { // VidetapeMain
    <-1, -1, -1>, <1, 1, 1>
    scale <3.75, 0.5, 1.875>
    translate  <0.0, 0.5, -0.125>
  }
  box { // VidetapeMain2
    <-1, -1, -1>, <1, 1, 1>
    texture {
      VideotapeTexture
    }
    scale <3.5, 0.5, 1.0>
    translate  <0.0, 0.5, 1.0>
  }
  cylinder { // VidetapeCyl1
    <0,0,1>, <0,0,0>, 1
    scale <0.25, 0.25, 1.0>
    rotate -90.0*x
    translate  <3.5, 0.0, 1.75>
  }
  cylinder { // VidetapeCyl2
    <0,0,1>, <0,0,0>, 1
    scale <0.25, 0.25, 1.0>
    rotate -90.0*x
    translate  <-3.5, 0.0, 1.75>
  }
  texture {
    BlackTexture
  }
  translate  12.3*x
}
#declare VideotapeStack = union {
  object { Videotape }
  object { // Videotape1->Videotape
    Videotape
    rotate -1.0*y
    translate  1.0*y
  }
  object { // Videotape2->Videotape
    Videotape
    translate  2.0*y
  }
  object { // Videotape3->Videotape
    Videotape
    rotate 1.0*y
    translate  3.0*y
  }
  object { // Videotape4->Videotape
    Videotape
    translate  4.0*y
  }
  translate  5.75*z
}
#declare VideotapeBunch1 = union {
  object { VideotapeStack }
  object { // VideotapeStack1->VideotapeStack
    VideotapeStack
    translate  -4.1*z
  }
  object { // VideotapeStack2->VideotapeStack
    VideotapeStack
    translate  -8.2*z
  }
  object { // VideotapeStack3->VideotapeStack
    VideotapeStack
    translate  -12.3*z
  }
  translate  16.0*y
}
#declare SpeakerCorner1 = intersection {
  cylinder { // SpeakerCorner1Cyl1
    <0,0,1>, <0,0,0>, 1
    scale <0.75, 0.75, 1.5>
    rotate -90.0*y
    translate  0.75*y
  }
  cylinder { // SpeakerCorner1Cyl2
    <0,0,1>, <0,0,0>, 1
    scale <0.75, 0.75, 1.5>
    rotate -90.0*x
    translate  -0.75*x
  }
  translate  <6.5, 0.0, 4.0>
}
#declare SpeakerCorner2 = intersection {
  cylinder { // SpeakerCorner2Cyl1
    <0,0,1>, <0,0,0>, 1
    scale <0.75, 0.75, 1.5>
    rotate -90.0*y
    translate  0.75*y
  }
  cylinder { // SpeakerCorner2Cyl2
    <0,0,1>, <0,0,0>, 1
    scale <0.75, 0.75, 1.5>
    rotate -90.0*x
    translate  -0.75*x
  }
  scale <-1.0, 1.0, 1.0>
  translate  <-6.5, 0.0, 4.0>
}
#declare SpeakerCorner3 = intersection {
  cylinder { // SpeakerCorner3Cyl1
    <0,0,1>, <0,0,0>, 1
    scale <0.75, 0.75, 1.5>
    rotate -90.0*y
    translate  0.75*y
  }
  cylinder { // SpeakerCorner3Cyl2
    <0,0,1>, <0,0,0>, 1
    scale <0.75, 0.75, 1.5>
    rotate -90.0*x
    translate  -0.75*x
  }
  scale <1.0, -1.0, 1.0>
  translate  <6.5, 25.0, 4.0>
}
#declare SpeakerCorner4 = intersection {
  cylinder { // SpeakerCorner4Cyl1
    <0,0,1>, <0,0,0>, 1
    scale <0.75, 0.75, 1.5>
    rotate -90.0*y
    translate  0.75*y
  }
  cylinder { // SpeakerCorner4Cyl2
    <0,0,1>, <0,0,0>, 1
    scale <0.75, 0.75, 1.5>
    rotate -90.0*x
    translate  -0.75*x
  }
  scale <-1.0, -1.0, 1.0>
  translate  <-6.5, 25.0, 4.0>
}
#declare SpeakerFront = union {
  box { // SpeakerFrontCubeFront
    <-1, -1, -1>, <1, 1, 1>
    scale <5.75, 11.75, 0.375>
    translate  <0.0, 12.5, 4.375>
  }
  cylinder { // SpeakerCyl1
    <0,0,1>, <0,0,0>, 1
    scale <0.75, 0.75, 11.5>
    rotate -90.0*y
    translate  <5.75, 0.75, 4.0>
  }
  cylinder { // SpeakerCyl2
    <0,0,1>, <0,0,0>, 1
    scale <0.75, 0.75, 11.5>
    rotate -90.0*y
    translate  <5.75, 24.25, 4.0>
  }
  cylinder { // SpeakerCyl3
    <0,0,1>, <0,0,0>, 1
    scale <0.75, 0.75, 23.75>
    rotate -90.0*x
    translate  <5.75, 0.75, 4.0>
  }
  cylinder { // SpeakerCyl4
    <0,0,1>, <0,0,0>, 1
    scale <0.75, 0.75, 23.75>
    rotate -90.0*x
    translate  <-5.75, 0.75, 4.0>
  }
  object { SpeakerCorner1 }
  object { SpeakerCorner2 }
  object { SpeakerCorner3 }
  object { SpeakerCorner4 }
  texture {
    BlackMeshTexture
  }
}
#declare SpeakerFrontInnerPart = difference {
  box { // SpeakerFrontInnerCube
    <-1, -1, -1>, <1, 1, 1>
    texture {
      BlackTexture
    }
    scale <6.25, 12.25, 0.35>
    translate  <0.0, 12.5, -0.4>
  }
  cone { // SpeakerFrontInnerWoofer
    <0,0,0>, 1.0, <0,0,1>, 3.0
    texture {
      WhiteTexture
    }
    scale <1.0, 1.0, 0.375>
    translate  <0.0, 9.0, -0.375>
  }
}
#declare SpeakerTweeter = union {
  box { // SpeakerTweeterCube
    <-1, -1, -1>, <1, 1, 1>
    texture {
      WhiteTexture
    }
    scale <1.5, 1.5, 0.01>
    translate  -0.05*z
  }
  cylinder { // SpeakerTweeterBlack
    <0,0,1>, <0,0,0>, 1
    texture {
      BlackTexture
    }
    scale <1.0, 1.0, 0.02>
    translate  -0.04*z
  }
  translate  18.5*y
}
#declare SpeakerFrontInner = union {
  object { SpeakerFrontInnerPart }
  cylinder { // SpeakerFrontInnerWooferBlack
    <0,0,1>, <0,0,0>, 1
    texture {
      BlackTexture
    }
    scale <1.0, 1.0, 0.1>
    translate  <0.0, 9.0, -0.375>
  }
  object { SpeakerTweeter }
  translate  4.75*z
}

// Completed Speaker
#declare Speaker = union {
  box { // SpeakerMain
    <-1, -1, -1>, <1, 1, 1>
    scale <6.5, 12.5, 4.375>
    translate  <0.0, 12.5, -0.375>
  }
  object { SpeakerFront }
  object { SpeakerFrontInner }
  texture {
    T_Wood15
  }
  translate  30.0*x
}

#declare TVWithoutScreen = difference {
  box { // TVWithoutScreenMain
    <-1, -1, -1>, <1, 1, 1>
    scale <14.5, 11.5, 5.0>
    translate  11.5*y
  }
  box { // TVScreenHole
    <-1, -1, -1>, <1, 1, 1>
    scale <12.75, 9.5, 0.5>
    translate  <0.0, 11.5, 5.0>
  }
  translate  -5.0*z
}
#declare Screen = intersection {
  sphere { // ScreenCurve
    <0,0,0>,1
    scale <21.0, 15.0, 1.0>
  }
  box { // ScreenClip
    <-1, -1, -1>, <1, 1, 1>
    texture {
      BlackGlassTexture
    }
    scale <14.0, 10.0, 1.0>
    translate  1.0*z
  }
  texture {
    BlackGlassTexture
  }
  translate  <0.0, 11.5, -1.0>
}
#declare TVWithScreen = union {
  object { TVWithoutScreen }
  object { Screen }
  translate  <0.0, 1.5, 9.5>
}
#declare TVBase = intersection {
  box { // TVBaseMain
    <-1, -1, -1>, <1, 1, 1>
    scale <12.5, 12.0, 9.0>
    translate  12.0*y
  }
  plane { // TVBaseClip1
    z,0
    rotate -260.0*y
    translate  <12.5, 0.0, -0.5>
  }
  plane { // TVBaseClip2
    z,0
    rotate -100.0*y
    translate  <-12.5, 0.0, -0.5>
  }
  plane { // TVBaseClip3
    z,0
    rotate -100.0*x
    translate  <0.0, 24.0, -0.5>
  }
}

// Completed Television Object
#declare TV = union {
  object { TVWithScreen }
  object { TVBase }
  translate  24.0*y
}
#declare StandHollow = difference {
  box { // StandMain
    <-1, -1, -1>, <1, 1, 1>
    scale <18.0, 12.0, 10.0>
    translate  12.0*y
  }
  box { // StandHole1
    <-1, -1, -1>, <1, 1, 1>
    scale <16.25, 6.0, 10.0>
    translate  <0.0, 8.0, 1.0>
  }
  box { // StandHole2
    <-1, -1, -1>, <1, 1, 1>
    scale <16.25, 3.0, 10.0>
    translate  <0.0, 19.0, 1.0>
  }
}

// Completed Stand
#declare Stand = union {
  object { StandHollow }
  box { // CabinetDoor1
    -1, 1
    scale <7.45, 5.4, 0.5>
    translate  <-8.125, 8.0, 9.5>
  }
  box { // CabinetDoor2
    -1, 1
    scale <7.45, 5.4, 0.5>
    translate  <8.125, 8.0, 9.5>
  }
  box { // VCR
    -1, 1
    texture { VCRTexture }
    scale <7.0, 1.75, 5.75>
    translate  <0.0, 18.0, 3.0>
  }
  object { VideotapeBunch1 }
  object { // VideotapeBunch2->VideotapeBunch1
    VideotapeBunch1
    scale -1.0
    rotate -180.0*x
  }
  object { // VideotapeBunch3->VideotapeBunch1
    VideotapeBunch1
  }
  object { // VideotapeBunch4->VideotapeBunch1
    VideotapeBunch1
    scale -1.0
    rotate -180.0*x
  }
}
#declare TV_and_Stand = union {
  object { TV }
  object { Stand }
  texture { BlackTexture }
}
#declare TVSpeakerCombo =
union { // TVSpeakerCombo
  object { TV_and_Stand }
  object { Speaker }
  object { Speaker translate  -60.0*x }
  rotate <-90.0, -180.0, 0.0>
}

/*****************************/
/* Southern Living Magazines */
/*****************************/

#declare SLMag1Texture =
   texture  // SLMag1Texture
   {
      pigment
      {
         image_map
         {
            gif   "C:\Include\slmag1.gif"
            interpolate 2
         }
         scale  <8.0, 11.0, 1.0>
         rotate -90.0 * x
         translate    <-4.0, 0.0, -5.5>
      }
   }

#declare PageTexture =
   texture  // PageTexture
   {
      pigment
      {
         gradient y
         color_map
         {
            [ 0.0     rgbft <0.0, 0.0, 0.0, 0.0, 0.0> ]
            [ 0.5     rgbft <0.0, 0.0, 0.0, 0.0, 0.0> ]
            [ 0.5     rgbft <1.0, 1.0, 1.0, 0.0, 0.0> ]
            [ 1.0     rgbft <1.0, 1.0, 1.0, 0.0, 0.0> ]
         }
         scale  0.01
         translate -1.0 * y
      }
   }

#declare SLMag2Texture =
   texture  // SLMag2Texture
   {
      pigment
      {
         image_map
         {
            gif   "C:\Include\slmag2.gif"
            interpolate 2
         }
         scale  <8.0, 11.0, 1.0>
         rotate -90.0 * x
         translate    <-4.0, 0.0, -5.5>
      }
   }

#declare SLMag3Texture =
   texture  // SLMag3Texture
   {
      pigment
      {
         image_map
         {
            gif   "C:\Include\slmag3.gif"
            interpolate 2
         }
         scale  <8.0, 11.0, 1.0>
         rotate -90.0 * x
         translate    <-4.0, 0.0, -5.5>
      }
   }

#declare SLMag4Texture =
   texture  // SLMag4Texture
   {
      pigment
      {
         image_map
         {
            gif   "C:\Include\slmag4.gif"
            interpolate 2
         }
         scale  <8.0, 11.0, 1.0>
         rotate -90.0 * x
         translate    <-4.0, 0.0, -5.5>
      }
   }

// Objects
#declare Magazine1CoverMain = union {
  box { // Magazine1CoverMainBox
    <-1, -1, -1>, <1, 1, 1>
    scale <3.75, 0.25, 5.5>
    translate  0.25*x
  }
  cylinder { // Magazine1CoverMainCyl
    <0,0,1>, <0,0,0>, 1
    scale <0.5, 0.25, 11.0>
    translate  <-3.5, 0.0, -5.5>
  }
}
#declare Magazine1CoverCut = union {
  box { // Magazine1CoverCutBox
    <-1, -1, -1>, <1, 1, 1>
    scale <3.8, 0.24, 5.6>
    translate  0.35*x
  }
  cylinder { // Magazine1CoverCutCyl
    <0,0,1>, <0,0,0>, 1
    scale <0.49, 0.24, 11.2>
    translate  <-3.5, 0.0, -5.6>
  }
}
#declare Magazine1Cover = difference {
  object { Magazine1CoverMain }
  object { Magazine1CoverCut }
  translate  0.25*y
}
#declare Magazine1CoverMain1 = union {
  box { // Magazine1CoverMainBox1
    <-1, -1, -1>, <1, 1, 1>
    scale <3.75, 0.24, 5.5>
    translate  0.25*x
  }
  cylinder { // Magazine1CoverMainCyl1
    <0,0,1>, <0,0,0>, 1
    scale <0.49, 0.24, 11.0>
    translate  <-3.5, 0.0, -5.5>
  }
  texture { PageTexture }
  translate  0.25*y
}
#declare Magazine1 = union {
  object { Magazine1Cover }
  object { Magazine1CoverMain1 }
  texture { SLMag4Texture }
}

#declare MagazineStack =
union { // MagazineStack
  object { Magazine1 }
  object { // Magazine2->Magazine1
    Magazine1
    texture { SLMag3Texture }
    rotate -10.0*y
    translate  <2.0, 0.5, 2.0>
  }
  object { // Magazine3->Magazine1
    Magazine1
    texture { SLMag2Texture }
    rotate 5.0*y
    translate  <4.0, 1.0, 0.0>
  }
  object { // Magazine4->Magazine1
    Magazine1
    texture { SLMag1Texture }
    rotate -5.0*y
    translate  <6.0, 1.5, 0.0>
  }
  rotate -5.0*z
}

/***********/
/* Cabinet */
/***********/

#declare DarkGrayTexture = texture { pigment { color rgb <0.3, 0.3, 0.3> } }

#declare CabinetDoor1Body = difference {
  box { // CabinetDoor1BodyFull
    <-1, -1, -1>, <1, 1, 1>
    scale <6.175, 11.55, 1.0>
  }
  box { // CabinetDoor1BodyCut
    <-1, -1, -1>, <1, 1, 1>
    scale <4.875, 10.25, 1.0>
    translate  1.0*z
  }
  translate  <6.375, 0.0, -1.0>
}
#declare CabinetDoor1Decs = union {
  box { // CabinetDoor1Dec1
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 12.0, 0.5>
    rotate -25.440001*z
  }
  box { // CabinetDoor1Dec2
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 12.0, 0.5>
    rotate 25.440001*z
  }
  translate  <6.375, 0.0, -0.8>
}
#declare CabinetDoor1HandlePull = difference {
  box { // CabinetDoor1HandlePullMain
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.75, 0.0625>
  }
  box { // CabinetDoor1HandlePullCut
    <-1, -1, -1>, <1, 1, 1>
    scale <0.625, 0.625, 0.1>
  }
  translate  <0.0, -0.6875, 0.25>
}
#declare CabinetDoor1Handle = union {
  box { // CabinetDoor1HandleBack
    <-1, -1, -1>, <1, 1, 1>
    scale <0.375, 1.75, 0.1>
  }
  box { // CabinetDoor1HandlePost
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1875, 0.1875, 0.375>
  }
  object { CabinetDoor1HandlePull }
  texture {
    DarkGrayTexture
  }
  translate  12.0*x
}
#declare CabinetDoor1 = union {
  object { CabinetDoor1Body }
  object { CabinetDoor1Decs }
  cylinder { // CabinetDoor1Hinge1
    <0,0,1>, <0,0,0>, 1
    texture {
      DarkGrayTexture
    }
    scale <0.2, 0.2, 2.0>
    rotate -90.0*x
    translate  7.5*y
  }
  cylinder { // CabinetDoor1Hinge2
    <0,0,1>, <0,0,0>, 1
    texture {
      DarkGrayTexture
    }
    scale <0.2, 0.2, 2.0>
    rotate 90.0*x
    translate  -7.5*y
  }
  object { CabinetDoor1Handle }
  translate  <-12.75, 17.25, 9.0>
}

#declare CabinetBody = difference {
  box { // CabinetBodyMain
    <-1, -1, -1>, <1, 1, 1>
    scale <15.0, 14.0, 9.0>
    translate  16.5*y
  }
  box { // CabinetBodyCut
    <-1, -1, -1>, <1, 1, 1>
    scale <12.75, 11.75, 9.0>
    translate  <0.0, 17.25, 2.0>
  }
}
#declare Cabinet =
union { // Cabinet
  box { // Leg1
    <-1, -1, -1>, <1, 1, 1>
    scale <1.125, 1.25, 9.0>
    translate  <13.875, 1.25, 0.0>
  }
  box { // Leg2
    <-1, -1, -1>, <1, 1, 1>
    scale <1.125, 1.25, 9.0>
    translate  <-13.875, 1.25, 0.0>
  }
  object { CabinetBody }
  object { CabinetDoor1 }
  object { // CabinetDoor2->CabinetDoor1
    CabinetDoor1
    scale <-1.0, 1.0, 1.0>
  }
  texture { CatSceneWood }
}


