//  Persistance of Vision Raytracer V3.0
//  World definition file.
//
//  Contains 1 lights, 2 textures and 46 primitives.
//
//  This file was generated for POV-Ray V3.0 by
//  Moray V3.01 For Windows (c) 1991-1998 Lutz + Kretzschmar
//

//  Date : 09/25/1998    (25.09.1998)
//

/*
  The text between these two comments is in MorayPOV.INC and is
  automatically included in all POV files that Moray exports.
*/

/* // Scene Comment

This scene was created with Moray For Windows.

*/ // End Scene Comment

global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.9
  hf_gray_16 off
  irid_wavelength <0.247059,0.176471,0.137255>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 0.0
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}

background { color <0.000,0.000,0.000> }

camera {  //  Camera StdCam
  location  <-2.000, -3.000, 3.000>
  direction <0.0,     0.0,  1.8317>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333,  0.0,  0.0>
  look_at   <0.000, 0.000, 0.500>
}

//
// *******  L I G H T S *******
//

light_source {   // Light1
  <0.000, -20.000, 20.000>
  color rgb <1.000, 1.000, 1.000>
}


//
// ********  TEXTURES  *******
//

#include "catteeth2.inc"


//
// ********  REFERENCED OBJECTS  *******
//

#declare LowerFrontTooth1 = object {
  sphere { // LowerFrontTooth1
    <0,0,0>,1
    scale <0.03, 0.03, 0.2>
    rotate -90.0*x
    translate  0.03*z
  }
}
#declare LowerSide1Tooth1 = object {
  sphere { // LowerSide1Tooth1
    <0,0,0>,1
    scale <0.03, 0.03, 0.2>
    rotate -90.0*x
  }
}
#declare LowerSide1Teeth = union {
  object { LowerSide1Tooth1 }
  object { // LowerSide1Tooth2->LowerSide1Tooth1
    LowerSide1Tooth1
    translate  <0.01, 0.0, 0.06>
  }
  object { // LowerSide1Tooth3->LowerSide1Tooth1
    LowerSide1Tooth1
    translate  <0.03, 0.0, 0.12>
  }
  object { // LowerSide1Tooth4->LowerSide1Tooth1
    LowerSide1Tooth1
    translate  <0.05, 0.0, 0.18>
  }
  object { // LowerSide1Tooth5->LowerSide1Tooth1
    LowerSide1Tooth1
    translate  <0.07, 0.0, 0.24>
  }
  object { // LowerSide1Tooth6->LowerSide1Tooth1
    LowerSide1Tooth1
    translate  <0.09, 0.0, 0.3>
  }
  object { // LowerSide1Tooth7->LowerSide1Tooth1
    LowerSide1Tooth1
    translate  <0.125, 0.0, 0.36>
  }
  object { // LowerSide1Tooth8->LowerSide1Tooth1
    LowerSide1Tooth1
    translate  <0.16, 0.0, 0.42>
  }
  object { // LowerSide1Tooth9->LowerSide1Tooth1
    LowerSide1Tooth1
    translate  <0.2, 0.0, 0.48>
  }
  translate  <-0.5, 0.0, 0.22>
}


#declare UpperFrontTooth1 = object {
  sphere { // UpperFrontTooth1
    <0,0,0>,1
    scale <0.05, 0.05, 0.2>
    rotate -90.0*x
    translate  0.02*z
  }
}
#declare UpperSide1Tooth1 = object {
  sphere { // UpperSide1Tooth1
    <0,0,0>,1
    scale <0.05, 0.05, 0.2>
    rotate -90.0*x
    translate  0.1*x
  }
}
#declare UpperSide1Teeth = union {
  object { UpperSide1Tooth1 }
  object { // UpperSide1Tooth2->UpperSide1Tooth1
    UpperSide1Tooth1
    translate  0.1*x
  }
  object { // UpperSide1Tooth3->UpperSide1Tooth1
    UpperSide1Tooth1
    translate  0.2*x
  }
  object { // UpperSide1Tooth4->UpperSide1Tooth1
    UpperSide1Tooth1
    translate  0.3*x
  }
  object { // UpperSide1Tooth5->UpperSide1Tooth1
    UpperSide1Tooth1
    translate  <0.4, 0.0, -0.02>
  }
  object { // UpperSide1Tooth6->UpperSide1Tooth1
    UpperSide1Tooth1
    translate  <0.5, 0.0, -0.05>
  }
  object { // UpperSide1Tooth7->UpperSide1Tooth1
    UpperSide1Tooth1
    translate  <0.6, 0.0, -0.1>
  }
  object { // UpperSide1Tooth8->UpperSide1Tooth1
    UpperSide1Tooth1
    translate  <0.7, 0.0, -0.15>
  }
  object { // UpperSide1Tooth9->UpperSide1Tooth1
    UpperSide1Tooth1
    translate  <0.8, 0.0, -0.2>
  }
  object { // UpperSide1Tooth10->UpperSide1Tooth1
    UpperSide1Tooth1
    translate  <0.9, 0.0, -0.26>
  }
  rotate -90.0*y
  translate  <-0.7, 0.0, 0.05>
}




//
// ********  OBJECTS  *******
//

cylinder { // LowerTeethGuide
  <0,0,1>, <0,0,0>, 1 
  texture {
    WhiteTexture
  }
  scale <0.55, 0.9, 0.3>
  rotate -90.0*x
  translate  1.0*y
}


#declare LowerFrontTeeth = union {
  object { LowerFrontTooth1 }
  object { // LowerFrontTooth2->LowerFrontTooth1
    LowerFrontTooth1
    translate  <0.0625, 0.0, 0.02>
  }
  object { // LowerFrontTooth3->LowerFrontTooth1
    LowerFrontTooth1
    translate  <0.125, 0.0, 0.03>
  }
  object { // LowerFrontTooth4->LowerFrontTooth1
    LowerFrontTooth1
    translate  <0.1875, 0.0, 0.04>
  }
  object { // LowerFrontTooth5->LowerFrontTooth1
    LowerFrontTooth1
    translate  <0.25, 0.0, 0.03>
  }
  object { // LowerFrontTooth6->LowerFrontTooth1
    LowerFrontTooth1
    translate  <0.3125, 0.0, 0.02>
  }
  object { // LowerFrontTooth7->LowerFrontTooth1
    LowerFrontTooth1
    translate  0.375*x
  }
  translate  <-0.19, 0.0, 0.75>
}
#declare LowerTeethUnclipped = union {
  sphere { // LowerFang1
    <0,0,0>,1
    scale <0.03, 0.03, 0.3>
    rotate -90.0*x
    translate  <-0.25, 0.0, 0.75>
  }
  sphere { // LowerFang2
    <0,0,0>,1
    scale <0.03, 0.03, 0.3>
    rotate -90.0*x
    translate  <0.25, 0.0, 0.75>
  }
  object { LowerFrontTeeth }
  object { LowerSide1Teeth }
  object { // LowerSide2Teeth->LowerSide1Teeth
    LowerSide1Teeth
    scale <-1.0, 1.0, 1.0>
  }
  sphere { // Tongue
    <0,0,0>,1
    texture {
      RedTexture
    }
    scale <0.3, 0.1, 0.7>
  }
}
intersection { // LowerTeeth
  object { LowerTeethUnclipped }
  plane { // LowerTeethClip
    z,0
    rotate 90.0*x
    translate  -1.0*y
  }
  texture {
    WhiteTexture
  }
}


#declare UpperFrontTeeth = union {
  object { UpperFrontTooth1 }
  object { // UpperFrontTooth2->UpperFrontTooth1
    UpperFrontTooth1
    translate  <0.1, 0.0, 0.02>
  }
  object { // UpperFrontTooth3->UpperFrontTooth1
    UpperFrontTooth1
    translate  <0.2, 0.0, 0.03>
  }
  object { // UpperFrontTooth4->UpperFrontTooth1
    UpperFrontTooth1
    translate  <0.3, 0.0, 0.03>
  }
  object { // UpperFrontTooth5->UpperFrontTooth1
    UpperFrontTooth1
    translate  <0.4, 0.0, 0.02>
  }
  object { // UpperFrontTooth6->UpperFrontTooth1
    UpperFrontTooth1
    rotate 0.0*x
    translate  0.5*x
  }
  translate  <-0.25, 0.0, 1.1>
}
#declare UpperTeethUnclipped = union {
  sphere { // UpperFang1
    <0,0,0>,1
    scale <0.05, 0.05, 0.5>
    rotate -90.0*x
    translate  <0.35, 0.0, 1.1>
  }
  sphere { // UpperFang2
    <0,0,0>,1
    scale <0.05, 0.05, 0.5>
    rotate -90.0*x
    translate  <-0.35, 0.0, 1.1>
  }
  object { UpperFrontTeeth }
  object { UpperSide1Teeth }
  object { // UpperSide2Teeth->UpperSide1Teeth
    UpperSide1Teeth
    scale -1.0
    rotate <-180.0, -0.0, 0.0>
  }
}
intersection { // UpperTeeth
  object { UpperTeethUnclipped }
  plane { // UpperTeethClip
    z,0
    rotate -90.0*x
  }
  texture {
    WhiteTexture
  }
}


union { // UpperTeethGuide
  box { // Cube1
    <-1, -1, -1>, <1, 1, 1>
    scale <0.6, 0.25, 0.65>
    translate  <0.0, -0.25, 0.65>
  }
  box { // Cube2
    <-1, -1, -1>, <1, 1, 1>
    scale <0.8, 0.25, 0.25>
    translate  <0.0, -0.25, 0.25>
  }
  cylinder { // LowerTeethGuide1
    <0,0,1>, <0,0,0>, 1 
    texture {
      WhiteTexture
    }
    scale <0.75, 1.3, 0.3>
    rotate -90.0*x
    translate  1.0*y
  }
  texture {
    WhiteTexture
  }
  translate  1.0*y
}




