// Persistence of Vision Ray Tracer Scene Description File
// File: CatTitle.pov
// Vers: 3
// Desc: Cat Animation Title
// Date: 9/20/98
// Auth: Steve Sloan II

#version 3.1;

#include "colors.inc"
#include "textures.inc"

global_settings { assumed_gamma 1.0 }

#declare inch   = 1;
#declare in     = inch;
#declare inches = inch;
#declare feet   = 12*inch;
#declare foot   = 12*inch;
#declare ft     = 12*inch;

camera {
    location <0, 0, 10>
    look_at  <0, 0,  0>
}

sky_sphere { pigment { color Black } }

light_source { <0, 0, 10> color White }

#include "catobjs.inc"

#declare cat_gray = color 0.33;

#declare CatPigment =
texture {
    pigment {
        gradient y
        pigment_map {
            [ 0.0 color cat_gray ]
            [ 0.2 color cat_gray ]
            [ 0.3 color White ]
            [ 0.4 color Black ]
            [ 0.6 color Black ]
            [ 0.7 color White ]
            [ 0.8 color cat_gray ]
            [ 1.0 color cat_gray ]
        }
        turbulence 0.2
        scale 0.5
    }
    normal { bumps 0.75 scale 0.1 }
    finish { diffuse 0.5 }
}

// Text
union {
    text {
        ttf "comicbd.ttf", "Chloe", 0.5, 0
        scale <-3, 3, 1>
        translate <4, 1.5, 0>
        texture { CatPigment }
    }
    text {
        ttf "comicbd.ttf", "and the", 0.5, 0
        scale <-1, 1, 1>
        translate <2, 0.5, 0>
        pigment { color Green }
    }
    text {
        ttf "comicbd.ttf", "Paperwad", 0.5, 0
        scale <-2, 2, 1>
        translate <4.5, -1, 0>
        texture { PaperwadTexture }
    }
    text {
        ttf "comicbd.ttf", "by Steve Sloan II", 0.5, 0
        scale <-1, 1, 1>
        translate <4.5, -4, 0>
        pigment { color Green }
    }
}

object {
    Paperwad
    rotate 600*clock*z
    translate -2.5*y
    translate (8 - 16*clock)*x
}

