#include "colors.inc"
#include "glass.inc"
#include "metals.inc"

camera { location <0, 0, -7> look_at 0 }

light_source { <-100, 100, -100> color White }

background { color White*0.05 }

//#declare MaxSets = 3000
//#declare Sides = floor(clock*clock*MaxSets) + 3 + 8 + 1

#declare T1 = texture { pigment { color rgb <0.45, 0.45, 1> }
        finish { specular 0.75 roughness 0.01 ambient 0.5 } }
#declare T2 = texture { pigment { color Green } finish { ambient 0.5 } }
#declare T3 = texture { pigment { color Red } finish { ambient 0.5 } }

//object { PolyParrot rotate y*(clock*4*360 - 90 - 30)
//	rotate z*(50 * sin(2 * 2 * pi * clock))
//	translate x*-3.15 }

union {
	torus { 1, 0.05 rotate x*90 texture { T1 } }
	cylinder { <-1, 0, 0>, <1, 0, 0>, 0.05 texture { T2 } }
	sphere { <-1, 0, 0>, 0.05 texture { T2 } }
	sphere { <1, 0, 0>, 0.05 texture { T2 } }

	rotate y*(clock*4*360 - 90 - 30)
	rotate z*(50 * sin(2 * 2 * pi * clock))
	translate x*-3.15
}

//object { Fraction scale 0.625 translate x*-0.25 }

// 3.141592653589793238462643383279502884197169399375105820974944

//difference {
union {
text { ttf "crystal.ttf",
   "  3.141592653589793238462643383279502884197169399375105820974944"
	0.1, 0 translate <2.8, -0.15, 0> texture { T3 }
	scale 0.625 translate x*-0.25
	translate x*(-17.5*clock) }

text { ttf "timrom.ttf",
   "4 - 4/3 + 4/5 - 4/7 + 4/9 - 4/11 + 4/13 - 4/15 + 4/17 - 4/19 + 4/21 - 4/23 + 4/25 - 4/27 + 4/29 - 4/31 + 4/33 - 4/35 + 4/37 -"
	0.1, 0 translate <8, 4, 0> texture { T3 }
	scale 0.625 translate x*-0.25
	translate x*(-30.5*clock) }
}
//plane { x*1, -2 texture { T_Orange_Glass } }
//}

union {
	union { 
	torus { 1, 0.025 rotate x*90
		texture { T_Orange_Glass finish { ambient 0.75 }} }
	difference {
		torus { 1, 0.026 rotate x*90 }
		plane { y*1, 0 rotate z*-5 }
		plane { y*-1, 0 rotate z*5 }
		plane { x*1, 0 }

		texture { pigment { color rgbt <0.9, 0.9, 0.9, 0> }
			   finish { ambient 0.9 } }

		rotate z*(2*360*clock)
		}
	#if (cos(radians(2 * 360 * clock)) != 0)
        cylinder { <0, 0, 0>, <cos(radians(2*360*clock)), 0, 0>,
		0.025 texture { T_Silver_3D finish { ambient 0.5 } } }
        sphere { <0, 0, 0>, 0.025 texture { T_Silver_3D finish { ambient 0.5 } } }
        sphere { <cos(radians(2*360*clock)), 0, 0>, 0.025 texture { T_Silver_3D finish { ambient 0.5 } } }
	#end

	#if (sin(radians(2 * 360 * clock)) != 0)
        cylinder { <0, 0, 0>, <0, sin(radians(2*360*clock)), 0>,
		0.025 texture { T_Brass_3D finish { ambient 0.5 } } }
        sphere { <0, 0, 0>, 0.025 texture { T_Brass_3D finish { ambient 0.5 } } }
        sphere { <0, sin(radians(2*360*clock)), 0>, 0.025 texture { T_Brass_3D finish { ambient 0.5 } } }
	#end
	translate x*-2
	}

	union {
	#declare Loop = 0
	#while (Loop < 13*clock)
		sphere { <Loop, cos(Loop), 0>, 0.05
			texture { T_Silver_3D finish { ambient 0.5 } } }
		sphere { <Loop, sin(Loop), 0>, 0.05
			texture { T_Brass_3D finish { ambient 0.5 } } }
		#declare Loop = Loop + pi/10
	#end
	#if (clock > 0.4)
		translate x*(-7 * (clock - 0.4)/0.6)
	#end
	}
	translate <-1, -2.45, 0>
}
