#include "colors.inc"
#include "stones.inc"

camera { location <0, 0, -4>
	look_at 0 }

light_source { <-100, 100, -100> color White }

global_settings { max_trace_level 12 }

/*
0.167203
0.275097
*/
background { color White*0.05 }

#declare UnitSide = 1
#declare LongSide = UnitSide/2 + sqrt((UnitSide/2)*(UnitSide/2) + UnitSide*UnitSide)
#declare OddBit = LongSide - UnitSide
#declare Angle = 1080

#declare Segment = 0

#declare Arm =
union {
//blob {
     //threshold 0.85

#declare MasterLoop = 0
#while (MasterLoop < Angle)   // 360 - 720 - 1080
	#declare RotLoop = 0
	#declare StartPoint = <-UnitSide, 0, 0>

	#declare Point = vaxis_rotate(StartPoint, z*-1, mod(MasterLoop, 90))
		#declare InnerLoop = 0
		#while ( InnerLoop < int(MasterLoop/90) )
			#declare Temp = Point.x
			#declare Temp = Temp - OddBit
			#declare Point = <Temp*(OddBit/UnitSide),
					Point.y*(OddBit/UnitSide),
					Point.z*(OddBit/UnitSide)>
			#declare Point = vaxis_rotate(Point, z*-1, 90)
		#declare InnerLoop = InnerLoop + 1
		#end
/*
	#debug concat( str(Point.x, 0, 6), "\n")
	#debug concat( str(Point.y, 0, 6), "\n")
*/

#if (Segment < 10)
difference {
#end
	sphere { 0, UnitSide*(1 - MasterLoop/Angle) //, 1
	    //hollow
	    //texture { pigment { color rgbt <1, 0.99, 1, 0.95> }
			//finish { ambient 0.5 }}
	    //texture { SpheryTexture finish { ambient 0.6 } }
	    //scale 1.5
	    //finish { ambient 0.8 }

	    translate Point
		}

#if (Segment < 10)
	plane { y*1, 0 }
	}
#end

#declare Segment = Segment + 1
#declare MasterLoop = MasterLoop + 10
#end

translate <-0.167203, -0.275097, 0>
    texture { T_Stone17 finish { ambient 0.3 } normal { granite scale 0.1 } }
}

object { Arm }
