//  Mite.inc  by Neil Alexander  1998
//  Dust mite for animation Cosms.pov
// The Mite macro should be fed a clock value between 0 and 1
// The mite completes one walking cycle from 0 to 1
// Over one cycle the mite travels 0.1875 (mite scale) units in the x direction
// The mite should be scaled to 0.01 for 1 unit = 1 inch

/*camera {
  location <3, 1, -1>
  look_at <0, 0.125, 0>
  angle 20
  }  

light_source { <-50, 200, -150> colour rgb 1 }

light_source { <50, -200, -100> colour rgb 0.5 }

union {
  plane { -z, -1}
  plane { y,0}
  texture {
    pigment {checker colour rgb <0,1,1> colour rgb <0,0.75,1>}
    finish {ambient 0.2 diffuse 0.8 }
    scale 0.09375
    }
  translate <-0.1875*clock,0,0>
  } */

#declare Mitecolor = color rgb <0.84,0.86,0.7>;

#declare Member = blob {
  threshold 0.56
  cylinder {0,0.094*x,0.02,1}
  sphere {0,0.016,1}
  sphere {0.093*x,0.02,1}
  sphere {0,1,-2
    scale 0.016
    translate<0.094,-0.001,0>
    }
  
  texture {
    pigment { Mitecolor }
    finish { phong 0.4 phong_size 10 } 
    normal { bumps 0.4 scale 0.01 turbulence 0.5}
    }
  }  // end Member  

#declare Foot = blob {
  threshold 0.56
  sphere {0,0.018,1}
  cylinder {<0.005,0,0>,<0.03,0.01,0>,0.018,1}
  cylinder {<0.04,0.01,0>,<0.062,0.01,0>,0.015,1}
  cylinder {<0.072,0.01,0>,<0.089,0.008,0>,0.012,1}
  cylinder {<0.092,0.007,0>,<0.115,0,0>,0.01,1}
  texture {
    pigment { Mitecolor }
    finish { phong 0.4 phong_size 10 } 
    normal { bumps 0.4 scale 0.01 turbulence 0.5}
    }
  }  // end Foot  

#macro Leg (AAy, AA1, KK)  // y rotation, first bend, cycle 0-1
#declare K = KK;
#while (K>1)   // normalize K
  #declare K = K-1;
  #end
  
// Fixed values
#declare H = 0.103;  // height from foot to joint to bodt
#declare R = 0.094;  // length of first segment
#declare A = 0.094;  // length of second segment
#declare B = 0.203;  // length of third segment
#declare L = 0.125;  // length of stride in direction of mite's travel

// Initial values
#declare Ay = radians(AAy);  
#declare A1 = radians(AA1);
#declare D0 = R + A*cos(A1) + sqrt(B*B - pow((H+A*sin(A1)),2));
#declare D = D0*sin(Ay);  // neg if Ay<0
#declare L0 = D0*cos(Ay);      // neg if abs(Ay)>90
#declare A4 = 0;

#declare K = K*1.5; // 0 to 1 for walk stroke, 
#if (K>1)
  #declare K = (1.5-K)*2; // from 1 to 0 for return stroke, 1/2 the time
  #declare A4 = sin(K*pi)*0.1;
  #end 

// Variable values
#declare Ln = L0 - K*L;     
#declare Ayn = atan2(D,Ln);
#declare Dn = abs(D/sin(Ayn));
#declare En = Dn - R;
#declare Cn = sqrt(H*H + En*En);
#declare A3n = acos((B*B + Cn*Cn - A*A)/(2*B*Cn)) + acos(En/Cn);
#declare An = En - B*cos(A3n);
#declare A1n = acos(An/A);
#declare A2n = A3n + A1n - A4;

#declare Ayn = degrees(Ayn);
#declare A1n = degrees(A1n);
#declare A2n = degrees(A2n);

union { // positioned leg
  union { // A & B
    union { // B
      object { Member
        translate x*0.003
        rotate z*20
        }
      object { Foot
        rotate z*(degrees(A4)-36.5)
        translate 0.097*x
        rotate z*20 // to stay with A
        }
      rotate -z*A2n
      translate x*A
      } // end B
    object { Member }
    rotate z*A1n
    translate x*R
    }  // end A&B
  object { Member
    rotate x*180
    }
  rotate y*Ayn
  translate y*(H+0.002)
  }  // end union
#end  // end macro Leg
      

#macro Mite (pose)   // 0 to 1, walking cycle
union { 
  blob {
    threshold 0.56
    sphere { 0,1,1   // body
      scale <0.75,0.188,0.5>
      translate <-0.125,0.15,0>
      }
    sphere { 0,1,1   // back
      scale <0.375,0.188,0.25>
      translate <-0.094,0.244,0>
      }
    sphere { 0,1,1  // lower ab
      scale <0.188,0.125,0.125>
      translate <-0.219,0.088,0>
      }
    sphere { 0,1,-0.25   // leg cavity
      scale <0.25,0.08,0.09>
      rotate y*-20
      translate <0.094,0.088,-0.188>
      }  
    sphere { 0,1,-0.25   // leg cavity
      scale <0.25,0.08,0.09>
      rotate y*20
      translate <0.094,0.088,0.188>
      }     
    sphere { 0,1,1   // shoulders
      scale <0.125,0.125,0.07>
      translate <0.156,0.15,0.04>
      }
    sphere { 0,1,1   // shoulders
      scale <0.125,0.125,0.07>
      translate <0.156,0.15,-0.04>
      }
    sphere { 0,1,1 // mouth
      scale <0.094,0.094,0.094>
      translate <0.203,0.15,0>
      } 
    sphere { 0,1,-2 // mouth hole
      scale <0.25,0.065,0.075>
      translate <0.21,0.15,0>
      }
    sphere { 0,1,2 // mouth flap upper
      scale <0.06,0.06,0.035>
      rotate <20,-10,0>
      translate <0.265,0.15,-0.028>
      } 
    sphere { 0,1,2 // mouth flap upper
      scale <0.06,0.06,0.035>
      rotate <-20,10,0>
      translate <0.265,0.15,0.028>
      }
    sphere { 0,1,1 // mouth flap lower
      scale <0.06,0.02,0.03>
      rotate <20,-5,-10>
      translate <0.23,0.09,-0.024>
      } 
    sphere { 0,1,1 // mouth flap lower
      scale <0.06,0.02,0.03>
      rotate <-20,5,-10>
      translate <0.23,0.09,0.024>
      }  
    sphere { 0,1,-1 // mouth flap cut-out
      scale <0.04,0.03,0.04>
      translate <0.25,0.119,-0.03>
      } 
    sphere { 0,1,-1 // mouth flap cut-out
      scale <0.04,0.03,0.04>
      translate <0.25,0.119,0.03>
      }
    
    texture { 
      pigment { crackle 
        color_map {
          [0 Mitecolor*0.8]
          [0.062 Mitecolor]
          }           
        scale 0.15 
        turbulence 0.7
        omega 0.6 
        }
      finish { phong 0.4 phong_size 10 } 
      normal { bumps 0.4 
        scale 0.02 
        turbulence 0.5
        }
      }   // end texture
    }     // end blob 
  
  object { Leg(10,30,pose)// R1
    translate <0.156,0,-0.125>
    }
  object { Leg(-10,30,pose+0.5)// L1
    translate <0.156,0,0.125>
    }
  object { Leg(40,40,pose+0.625)// R2
    translate <0.11,0,-0.14>
    }
  object { Leg(-40,40,pose+0.125)// L2
    translate <0.11,0,0.14>
    }  
  object { Leg(70,50,pose+0.25)// R3
    translate <0.062,0,-0.145>
    }
  object { Leg(-70,50,pose+0.75)// L3
    translate <0.062,0,0.145>
    }
  object { Leg(110,40,pose+0.875)// R4
    translate <0.016,0,-0.15>
    }
  object { Leg(-110,40,pose+0.375)// L4
    translate <0.015,0,0.15>
    }
  }  // end union
#end  // end Mite
  
/*object { Mite(clock)
  //translate y*0.188
  //rotate y*90
  //rotate x*90
  } */   

