//boid04 was ideal in smooth collision avoidance swarming.
//bodi05 attempts to make them go somewhere 
//boid08b attempts to make them be "near center, not at center, with x*(1/x)  
//boid08c perfected smooth linear flocking, almost boring. 
//boid08d perfected smooth circual path flocking, almost boring.  
//boid08g had nice obstacle avoidance.  
//boid08h slowed tracking speed to give a bit more variation
//boid08j tried an elliptical path, but too crazy

//boid08p was beautiful applicatoin of just slightly crazy. IRTC candidate

//boid08q was first implementation of constant acceleratoin in this scene, but was too jerky. 

//boid08s was hopelessly jerky. 

//boid08t looked great 
//boid09b looked great, but camera too far away.  Used nonconstant acceleration. 

//boid09c looked great, but one craft dipped into the tower. 
//         these versions also had a problem with too jerky beginning, or crafts disappearing.
//boid09e looked good, with 1/d^0.5 avoid, but one craft dipped into the tower. 
//boid09i  may just do, might slump by good enough for IRTC, pretty nice collision avoidance. 
//         a little ugly in the colors and pixelation of everything: why so ugly?
//        may try once more with a bit tighter flock, bigger text.  
//boid09m may have been good enough.  
//boid09n involves changes to height, upped actoravoid. 

#include "colors.inc"
#include "textures.inc"
#include "stones.inc"
#include "metals.inc"
#include "rocky.inc"
#include "holebody2.inc" 

global_settings { max_trace_level 7 }

#macro pathy(berth,ert)
        berth*<1*cos(-ert/55.888+.001),0.001,sin(-ert/55.888)>//20*<sin(ert/40),0,cos(ert/40)>  //berth28
#end        

#macro Reorient(Axis1,Axis2)
                #local vX1=vnormalize(Axis1);                   //john vansickle
                #local vX2=vnormalize(Axis2);
                #local vY=vnormalize(vcross(vX1,vX2));
                #local vZ1=vnormalize(vcross(vX1,vY));
                #local vZ2=vnormalize(vcross(vX2,vY));
                matrix < vX1.x, vY.x,vZ1.x, vX1.y,vY.y,vZ1.y, vX1.z,vY.z, vZ1.z, 0,0,0 >
                matrix < vX2.x,vX2.y,vX2.z,  vY.x,vY.y, vY.z, vZ2.x,vZ2.y,vZ2.z, 0,0,0 >
              #end
//background {White}



sphere{0, 1000000  hollow
     pigment {bozo                                         
             color_map{
                        [0  red 0.196078 green 0.6 blue 0.8]
                        [.5  red 0.196078 green 0.6 blue 0.8]
                        [1 rgb 1]
                      }
             turbulence .7 octaves 3 lambda 4    
             scale 1000000/24
             translate <20,0,35>*clock*20000
             }  
    finish{ambient 1  diffuse 0}
    scale <1,0.075,1>
    translate   <0, 2000,0>
    //translate <0,-40000,0>
   }
  


height_field{
             pattern 600,600 {                       //was 400
                             hf_gray_16
                             wrinkles
                             pigment_map{                        //was 400
                             [0 rgb 0]
                             [1 rgb 1]   
                                        }                        
                             scale 0.76
                             translate <-0.1*clock,0.16*clock,0>
                             }
             smooth                                
             translate <-.5,-.5,-.5>
             scale <6000,250,6000>
             pigment{Green/3.5+Blue/3.5}
finish{reflection 0.4}
        translate <0,58,0>   
                     }
                      
//torus {32,0.05                     pigment {Black}        translate <0,-20,0>        }


#declare num=36;//36;
               
#declare RRR=seed(29822) ;        
#declare UMAX=10 ;       
#declare VMAX=7 ;                                            

#declare actorp= array[num+1] 

//#declare texty2= array[2]
#declare actorv= array[num+1]
#declare actoravoid= array[num+1] 
#declare actorc= array[num+1]
#declare actora= array[num+1]

 
//initialize    
#declare n=6    ;
#while (n<num)

#declare actorp[n]=13.5*<cos(2*pi*n/(num-6)),sin(2*pi*n/(num-6)),0>+pathy(32,1);
//#declare actorp[n]=11.4*<cos(2*pi*(n)/(num-6)+1.01)+.015,sin(2*pi*(n)/(num-6)+1.01)+.015,.15>+pathy(32,1);
#declare actorv[n]=1.3*vnormalize(actorp[n]-pathy(32,1));
#declare actorc[n]=<sqrt(rand(RRR)),rand(RRR),rand(RRR)>;

#declare actora[n]=actorv[n]/3;
//<0,0,0>;

#declare actoravoid[n]=<0,0,0>;
#declare n=n+1   ;
#end                                    
         
         
         
         
                            
#declare actave=<0,0,0>;      

                      
#declare actorp[0]=pathy(25.5,65);//20*<sin(80/40),0,cos(80/40)>;    was 33
#declare actorv[0]=<0,0,0>;                        

#declare actorp[1]=pathy(25.5,64);//20*<sin(120/40),0,cos(120/40)>;
#declare actorv[1]=<0,0,0>;

#declare actorp[2]=pathy(25.5,130);//20*<sin(170/40),0,cos(170/40)>;
#declare actorv[2]=<0,0,0>;


#declare actorp[3]=pathy(25.5,129);//20*<sin(80/40),0,cos(80/40)>;    was 33
#declare actorv[3]=<0,0,0>;                        

#declare actorp[4]=pathy(25.5,200);//20*<sin(120/40),0,cos(120/40)>;
#declare actorv[4]=<0,0,0>;

#declare actorp[5]=pathy(25.5,199);//20*<sin(170/40),0,cos(170/40)>;
#declare actorv[5]=<0,0,0>;   


#declare tt=0;
//#while(tt<200*clock+65)
#while(tt<350*clock+1)                     

#declare n=0    ;
#while (n<num)
#declare actoravoid[n]=<0,0.0001,0>;
#declare n=n+1   ;
#end                                    
           
                                 
#declare i=6    ;
#while (i<num)

#declare j=6    ;
#while (j<num)

#if (i!=j)
#declare c=vlength(actorp[j]-actorp[i]);
#declare d=vnormalize(actorp[i]-actorp[j]);
#declare actoravoid[j]=actoravoid[j]+0.05*d/pow(c,1); //was 0.031

#else
#end 
#declare j=j+1;
#end  

#declare i=i+1;
#end     

#declare i=0    ;
#while (i<6)

#declare j=6    ;
#while (j<num)

#declare c=vlength(actorp[j]-actorp[i]);
#declare d=vnormalize(actorp[i]-actorp[j]);
#declare actoravoid[j]=actoravoid[j]+0.65*d/pow(c,1); //was 0.16

#declare j=j+1;
#end  
#declare i=i+1;
#end     





#declare actave=pathy(32,tt);


#declare n=6    ;
#while (n<num)
#declare b= vnormalize(-actorp[n]+actave)*(vlength(-actorp[n]+actave));
#declare a= <0,0,0>-60*actoravoid[n]+1*b;
//#declare a= <0,0,0>-80*actoravoid[n]+1*b;
#declare a= 0.7*vnormalize(a)*pow(vlength(a),.4)*(1+0.3*sin(tt/12+1*n));
#declare actora[n]=actora[n]*0.4+0.6*a;
#declare actorv[n]=//vnormalize(
0.80*actorv[n]+0.20*actora[n]
//)
;
#declare actorp[n]=actorp[n]+.38*actorv[n];         

  
#declare n=n+1   ;
#end                          
                      
#declare actorp[0]=pathy(25.5,65);//20*<sin(80/40),0,cos(80/40)>;    was 33
#declare actorv[0]=<0,0,0>;                        

#declare actorp[1]=pathy(25.5,64);
#declare actorv[1]=<0,0,0>;

#declare actorp[2]=pathy(25.5,120);//20*<sin(170/40),0,cos(170/40)>;
#declare actorv[2]=<0,0,0>;


#declare actorp[3]=pathy(25.5,119);//20*<sin(80/40),0,cos(80/40)>;    was 33
#declare actorv[3]=<0,0,0>;                        

#declare actorp[4]=pathy(25.5,200);//20*<sin(120/40),0,cos(120/40)>;
#declare actorv[4]=<0,0,0>;

#declare actorp[5]=pathy(25.5,199);//20*<sin(170/40),0,cos(170/40)>;
#declare actorv[5]=<0,0,0>;             
     
                    
#declare tt=tt+1   ;
#end         
                         
                         
//display                

  
#declare n=6    ;  
#while (n<num)                 


/*
union{
        intersection{              
                        object {rocky}
                        text{ttf "kabelu.ttf" str(n,0,0) 100,0
                                scale 0.525 
                                rotate <0,0,90>
                                translate <.35,-0.2,-5>
                                pigment{Black}
                                finish {ambient 0.2
                                        phong 0.2}
                                        }
                            }      
*/                            
        object{ rocky
                pigment{ color actorc[n]}//Coral}
                finish {ambient 0.3
                        phong 0.4
                        reflection .05
                        //metallic

                        }   
                Reorient(y,actorv[n])
                translate  actorp[n]   
                }
  
#declare n=n+1   ;
#end                
      
      
      
/*
#fopen MyFile2 "c:\pov31\include\boidavoi.txt" write
#declare n=1;
#while(n<num)
#write (MyFile2,n,"\n",vlength (actora[n]),"\n",vlength(actoravoid[n]),"\r","\n")  
#declare n=n+1;               
#end
#fclose Myfile2 
*/
     

#switch (tt) 
  #range (-1,1.1)
   #declare texty="START YOUR ENGINES..."
   #declare pigy=rgb <1,0,0>
   #declare texty2="START"
  #break
  #range (1.21,10.1)
   #declare texty="ENGAGE!" 
   #declare pigy=rgb <0,1,0>/2
   
   #declare texty2="START"
  #break
  #range (10.5,40.1)
   #declare texty="ACCELERATING..."
   #declare texty2="START"
  #break //Fourth case ends


  #range (40.2,80.2)
   #declare texty="FOLLOW RED BALL..." 
   #declare texty2="START"
  #break     
  #range (80.4,150.2)
   #declare texty="AVOID SPECTATOR TOWER!" 
   #declare texty2="START"
  #break  
  
  #range (150.3,190.1)
   #declare texty="SHIP 27 LEADING..."   
   #declare texty2="START"
  #break
                                                   
  #range (190.2,222.1)
   #declare texty="DRINK POV MANGO JUICE!" 
   #declare texty2="FINISH"
  #break  
  #range (222.2,270.1)
   #declare texty="(C) Greg M. Johnson 1999"
   #declare texty2="FINISH"
  #break                   
  #range (270.2,370)
   #declare texty="Entering Final Stretch"
   #declare texty2="FINISH"
  #break
  #else
#declare texty="(C) Greg M. Johnson 1999" 
   #declare texty2="FINISH"
 #end



text {ttf "swz721kr.ttf" texty  .1, 0
 //ttf "ocraext.ttf" "ENGAGE!" .1, 0
    pigment { rgbt <1,0,0,.6>}
    scale 0.15    translate <-1.09,-0.8,2>
    finish { diffuse 0
    ambient rgb <0.9,-0.35,-0.35>}
    Reorient(z,actave-pathy(32,tt-65))
    translate pathy(32,tt-65)//+<-1.5,-1.,0>
    
  }

//text {ttf "ocraext.ttf" "2999 GADGET RACES"  .1, 0
text {ttf "swz721kr.ttf" "2999 GADGET RACES"  .1, 0
 //ttf "ocraext.ttf" "ENGAGE!" .1, 0
    pigment { rgbt <1,0,0,.6>}
    scale 0.18
    translate <-1.09,0.68,2>
    finish { diffuse 0
    ambient rgb <0.9,-0.35,-0.35>}
    Reorient(z,actave-pathy(32,tt-65))
    translate pathy(32,tt-65)//+<-1.5,-1.,0>
    
  }

                            
camera {               
  location pathy(32,tt-65)//actorp[2]+<-0.6,-1.,0.6>// +<0,100,0>
  look_at  actave//pathy(tt-5)
  //angle 25
  angle 60
}                               

light_source{<-20,10000,200>rgb 1.2}
    
//fog { fog_type 2 distance 2000 rgb .7 fog_offset -197 fog_alt 5 }

sphere {actave, .55
        pigment {Red*0.8}
     finish {ambient 0.5}
        }

#declare dome=
union{                                             
difference{
        sphere {0,1.75}
        sphere {0,1.70}
        
        pigment {rgbt <.8,.8,.8,.8>}
        finish {reflection 0.35
                refraction 1.12}
        }
        
       object{WB
               scale 0.08
               translate <0,-.3,0>} 
                                                     
 torus {1.75,0.05
        pigment {Gold}          
        finish {reflection 0.15}
         }                                            
 torus {1.75,0.05
        rotate <90,0,0>
        pigment {Gold}          
        finish {reflection 0.15}
         }                                           
 torus {1.75,0.05
        rotate <0,0,90>
        pigment {Gold}          
        finish {reflection 0.15}
         }
 cone {<0,-1.2,0>,1.25,<0,-1.75,0>,1.6
        pigment {Gold}          
        finish {reflection 0.15}
        }
 cone {<0,-1.75,0>,1.6,<0,-2.15,0>,.75
        pigment {Gold}          
        finish {reflection 0.15}
        }        
         
         
 }       

object {dome
        translate actorp[0]                                             
        }
object {dome
        translate actorp[2]                                             
        }
object {dome
        translate actorp[4]                                             
        }
                          

                         

                          
#declare j=0
#while (j<strlen(texty2))
       
text {ttf "kabelu.ttf" substr(texty2,j+1,1) .1, 0
    pigment { rgb <1,0,0>}
    
    translate <-0.4,0,0>
    scale 4
    translate <0,5,0>
    rotate <0,0,90-180/(strlen(texty2)-1)*j>
    rotate <0,180,0>
    finish { //diffuse 0.5
   ambient 0.5}

    Reorient(z,pathy(32,0)-pathy(32,1))
    translate pathy(32,0)//+<-1.5,-1.,0>
    
  }
#declare j=j+1;
#end

/*
torus{13,.1
        rotate <90,0,0>
        translate  pathy(32,0)
        pigment {Red}
        finish {ambient 0.5}
        Reorient(z,pathy(32,0)-pathy(32,1))
        }                 
*/                   