// Persistence Of Vision raytracer version 3.1

//Animated liquid metal - the last drop

#version 3.0
global_settings { assumed_gamma 2.2 }
#include "colors.inc"
#include "textures.inc"
#include "metals.inc"

//#declare clock=0.95

camera {
    location <-30, 21, -36>
    right <4/3, 0.0, 0.0>
    direction 2*z
    look_at <0, 7, 0>
}


light_source { <10, 20, -30> color White fade_distance 24 fade_power 1}
light_source { <10, 25, 30 > color White fade_distance 14 fade_power 2}
light_source { <-15, 20, -15> color White fade_distance 30 fade_power 2}

//marble floor
plane {y, -6.05 
   texture {
      finish {ambient 0.25 }
      pigment {
         bozo
         turbulence 0.25
         color_map {
            [0.0 1.0 color red 0.9 green 0.75 blue 0.75
                     color red 0.6 green 0.6 blue 0.6 ]
         }
         scale 0.4
      }
   }
}


box{<-8.5,-50,-8.5> <8.5,-6.05,8.5> 
   texture {
      finish {ambient 0.25 }
      pigment {
         bozo
         turbulence 0.25
         color_map {
            [0.0 1.0 color red 0.9 green 0.75 blue 0.75
                     color red 0.6 green 0.6 blue 0.6 ]
         }
         scale 0.4
      }
   }
translate <0,7.5,0>}

// the pool
#declare StrengthVal = 1.0 // (+ or -) strength of component's radiating density
#declare RadiusVal   = 1.0 // (0 < RadiusVal) outer sphere of influence on other components
#declare Poolsize = 1.1

#if (clock<0.5)
blob
{
  // threshold (0.0 < threshold <= StrengthVal) surface falloff threshold #
  threshold 0.6
  sphere { <-0.3,1.5, -0.25>, StrengthVal, RadiusVal scale <Poolsize,1,Poolsize> translate <0,0,Poolsize-7.76-1.7*clock>}
  sphere { <0.3, 1.5, -0.25>, StrengthVal, RadiusVal scale <Poolsize,1,Poolsize> translate <0,0,Poolsize-7.76-1.7*clock>}
  sphere { <-0.3,1.5, 0.3>, StrengthVal, RadiusVal scale <Poolsize,1,Poolsize> translate <0,0,Poolsize-7.76-1.7*clock>}
  sphere { <0.3, 1.5, 0.3>, StrengthVal, RadiusVal scale <Poolsize,1,Poolsize> translate <0,0,Poolsize-7.76-1.7*clock>}
  sphere { <-0.5,1.5, 0>, StrengthVal, RadiusVal scale <Poolsize,1,Poolsize> translate <0,0,Poolsize-7.76-1.7*clock>}
  sphere { <0.5, 1.5, 0>, StrengthVal, RadiusVal scale <Poolsize,1,Poolsize> translate <0,0,Poolsize-7.76-1.7*clock>}
  sphere { <0, 1.5, 0.5>, StrengthVal, RadiusVal scale <Poolsize,1,Poolsize> translate <0,0,Poolsize-7.76-1.7*clock>}
  sphere { <0, 1.5,-0.6>, StrengthVal, RadiusVal scale <Poolsize,1,Poolsize> translate <0,0,Poolsize-7.76-1.7*clock>}
  //sphere { <0, 1.5,-6.7-1.7*mod(clock*135,5)/5>, StrengthVal, RadiusVal scale <1,.7,1>}
  texture {T_Chrome_5E}
}
blob
{
  // threshold (0.0 < threshold <= StrengthVal) surface falloff threshold #
  threshold 0.4
  sphere { <0,1.3-mod(clock*10,5)-3,-8.9>, StrengthVal, RadiusVal }
  texture {T_Chrome_5E}
}
#end
//a drop
#if (clock>=0.5)
blob
{
  // threshold (0.0 < threshold <= StrengthVal) surface falloff threshold #
  threshold 0.4
  sphere { <0,1.3-mod(clock*10,5),-8.9>, StrengthVal, RadiusVal }
  texture {T_Chrome_5E}
}
#end
