#include "colors.inc"
#include "textures.inc"
#include "woods.inc"

//
// The general wood we will use for everything.
//

#declare wood_texture = texture
{
        pigment
        {
                P_WoodGrain4A
                color_map
                {
                        M_Wood4A
                }
                scale 75
                translate <-1.5, 0.3, 1>
                warp
                {
                        black_hole <0.5, 0, 0.5>, 1.25
                        falloff 2
                        strength 2
                        inverse
                        turbulence <0.15, 0.15, 0.15>
                }
                warp
                {
                        black_hole <-1.5, 0, 0.3>, 1.5
                        falloff 2
                        strength 2
                        inverse
                        turbulence <0.75, 0.75, 0.75>
                }
                warp
                {
                        black_hole <1, 0, -0.5>, 1.95
                        falloff 1
                        strength 2
                        inverse
                        turbulence <0.05, 0.05, 0.05>
                }
        }
}

//
// A common 'bit' used everywhere.
//

#declare rubber_stopper = cylinder
{
        <0, 0, 0>, <0, 0.5, 0>, 0.75
        pigment
        {
                Black
        }
        finish
        {
                Dull
        }
}

//
// Define the Top of the tabe
//

#declare flat_desk_top = union
{
        box
        {
                <0, 0, 0>, <150, 3, 70>
        }
        cylinder
        {
                <0, 1.5, 0>, <150, 1.5, 0>, 1.5
        }
        cylinder
        {
                <0, 1.5, 70>, <150, 1.5, 70>, 1.5
        }
        cylinder
        {
                <0, 1.5, 0>, <0, 1.5, 70>, 1.5
        }
        cylinder
        {
                <150, 1.5, 0>, <150, 1.5, 70>, 1.5
        }
        sphere
        {
                <0, 1.5, 0>, 1.5
        }
        sphere
        {
                <0, 1.5, 70>, 1.5
        }
        sphere
        {
                <150, 1.5, 70>, 1.5
        }
        sphere
        {
                <150, 1.5, 0>, 1.5
        }
        texture
        {
                wood_texture
        }
        finish
        {
                reflection 0.13
        }
}

#declare desk_top = object
{
        flat_desk_top
        translate <-75, 70.5, -35>
}

//
// Define the right leg of the table.
//

#declare flat_desk_right_leg = box
{
        <0, 0, 0>, <70, 2, 69>
        texture
        {
                wood_texture
        }
}

#declare desk_right_leg = union
{
        object
        {
                flat_desk_right_leg
                rotate <0, 0, 90>
                translate <74.5, 0.5, -34.5>
        }
        object
        {
                rubber_stopper
                translate <73.5, 0, -33.5>
        }
        object
        {
                rubber_stopper
                translate <73.5, 0, 33.5>
        }
}

//
// Now build the whole draw cabinet thing.
//

#declare flat_desk_draws_back = box
{
        <0, 0, 0>, <66, 2, 46>
        texture
        {
                wood_texture
        }
}

#declare flat_desk_draws_side = box
{
        <0, 0, 0>, <66, 2, 69>
        texture
        {
                wood_texture
        }
}

#declare flat_desk_draws_top = box
{
        <0, 0, 0>, <50, 2, 69>
        texture
        {
                wood_texture
        }
}

#declare flat_desk_draws_front = box
{
        <0, 0, 0>, <21, 2, 45>
        texture
        {
                wood_texture
        }
}

#declare desk_draws = union
{
        object
        {
                flat_desk_draws_back
                rotate <0, 0, 90>
                rotate <0, 90, 0>
                translate <-72.5, 2.5, 32.5>
        }
        object
        {
                flat_desk_draws_side
                rotate <0, 0, 90>
                translate <-72.5, 2.5, -34.5>
        }
        object
        {
                flat_desk_draws_side
                rotate <0, 0, 90>
                translate <-24.5, 2.5, -34.5>
        }
        object
        {
                flat_desk_draws_top
                translate <-74.5, 68.5, -34.5>
        }
        object
        {
                flat_desk_draws_top
                translate <-74.5, 0.5, -34.5>
        }
        object
        {
                flat_desk_draws_front
                rotate <0, 0, 90>
                rotate <0, 90, 0>
                translate <-72, 3, -34.5>
        }
        object
        {
                flat_desk_draws_front
                rotate <0, 0, 90>
                rotate <0, 90, 0>
                translate <-72, 25, -34.5>
        }
        object
        {
                flat_desk_draws_front
                rotate <0, 0, 90>
                rotate <0, 90, 0>
                translate <-72, 47, -34.5>
        }
        object
        {
                rubber_stopper
                translate <-73.5, 0, 33.5>
        }
        object
        {
                rubber_stopper
                translate <-25.5, 0, 33.5>
        }
        object
        {
                rubber_stopper
                translate <-73.5, 0, -33.5>
        }
        object
        {
                rubber_stopper
                translate <-25.5, 0, -33.5>
        }
}

//
// Finally, declare the desk object.
//

#declare desk = union
{
        object
        {
                desk_top
        }
        object
        {
                desk_right_leg
        }
        object
        {
                desk_draws
        }
}
